/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPlatformCustomizer;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.NewRubyProjectWizardIterator;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.SettingsPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class PanelOptionsVisual
extends SettingsPanel
implements ActionListener,
PropertyChangeListener {
    private static boolean lastMainClassCheck = true;
    private PanelConfigureProject panel;
    private boolean valid;
    private JCheckBox createMainCheckBox;
    private JTextField mainClassTextField;
    private JButton manageButton;
    private JComboBox platforms;
    private JLabel rubyPlatformLabel;
    private JCheckBox setAsMainCheckBox;

    public PanelOptionsVisual(PanelConfigureProject panelConfigureProject, int n) {
        this.initComponents();
        Util.preselectWizardPlatform(this.platforms);
        this.panel = panelConfigureProject;
        this.fireChangeEvent();
        PlatformComponentFactory.addPlatformChangeListener((JComboBox)this.platforms, (PlatformComponentFactory.PlatformChangeListener)new PlatformComponentFactory.PlatformChangeListener(){

            public void platformChanged() {
                PanelOptionsVisual.this.fireChangeEvent();
            }
        });
        switch (n) {
            case 0: {
                this.createMainCheckBox.addActionListener(this);
                this.createMainCheckBox.setSelected(lastMainClassCheck);
                this.mainClassTextField.setEnabled(lastMainClassCheck);
                break;
            }
            case 2: {
                this.setAsMainCheckBox.setVisible(true);
                this.createMainCheckBox.setVisible(false);
                this.mainClassTextField.setVisible(false);
            }
        }
        this.mainClassTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                PanelOptionsVisual.this.mainClassChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PanelOptionsVisual.this.mainClassChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                PanelOptionsVisual.this.mainClassChanged();
            }
        });
    }

    public void removeNotify() {
        Util.storeWizardPlatform(this.platforms);
        super.removeNotify();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.createMainCheckBox) {
            lastMainClassCheck = this.createMainCheckBox.isSelected();
            this.mainClassTextField.setEnabled(lastMainClassCheck);
            this.fireChangeEvent();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("roots".equals(propertyChangeEvent.getPropertyName())) {
            this.fireChangeEvent();
        }
        if ("projectName".equals(propertyChangeEvent.getPropertyName())) {
            String string = NewRubyProjectWizardIterator.getPackageName((String)propertyChangeEvent.getNewValue());
            if (!Utilities.isJavaIdentifier((String)string)) {
                string = NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PackageNameSuffix", (Object)string);
            }
            this.mainClassTextField.setText(MessageFormat.format(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_ClassName"), string));
        }
    }

    private void fireChangeEvent() {
        this.panel.fireChangeEvent();
    }

    private void initComponents() {
        this.setAsMainCheckBox = new JCheckBox();
        this.createMainCheckBox = new JCheckBox();
        this.mainClassTextField = new JTextField();
        this.rubyPlatformLabel = new JLabel();
        this.platforms = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.manageButton = new JButton();
        this.setAsMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.setAsMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_setAsMainCheckBox"));
        this.createMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_createMainCheckBox"));
        this.rubyPlatformLabel.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.rubyPlatformLabel, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"RubyPlatformLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"RubyHomeBrowse"));
        this.manageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelOptionsVisual.this.manageButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.setAsMainCheckBox).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.createMainCheckBox).add((Component)this.rubyPlatformLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.platforms, 0, 296, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.manageButton)).add((Component)this.mainClassTextField, -1, 377, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.setAsMainCheckBox).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createMainCheckBox).add((Component)this.mainClassTextField, -2, 21, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.manageButton).add((Component)this.platforms, -2, -1, -2).add((Component)this.rubyPlatformLabel)).addContainerGap(29, Short.MAX_VALUE)));
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_setAsMainCheckBox"));
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSD_setAsMainCheckBox"));
        this.createMainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_createMainCheckBox"));
        this.createMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSD_createMainCheckBox"));
        this.mainClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCN_mainClassTextFiled"));
        this.mainClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCD_mainClassTextFiled"));
        this.rubyPlatformLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"PanelOptionsVisual.rubyPlatformLabel.AccessibleContext.accessibleDescription"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"PanelOptionsVisual.manageButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_PanelOptionsVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_PanelOptionsVisual"));
    }

    private void manageButtonActionPerformed(ActionEvent actionEvent) {
        RubyPlatformCustomizer.manage((JComboBox)this.platforms);
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (PlatformComponentFactory.getPlatform((JComboBox)this.platforms) == null) {
            return false;
        }
        if (this.mainClassTextField.isVisible() && this.mainClassTextField.isEnabled()) {
            if (!this.valid) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"ERROR_IllegalMainClassName"));
            }
            return this.valid;
        }
        return true;
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("setAsMain", (Object)(this.setAsMainCheckBox.isSelected() && this.setAsMainCheckBox.isVisible() ? Boolean.TRUE : Boolean.FALSE));
        wizardDescriptor.putProperty("mainClass", this.createMainCheckBox.isSelected() && this.createMainCheckBox.isVisible() ? this.mainClassTextField.getText() : null);
        wizardDescriptor.putProperty("platform", (Object)PlatformComponentFactory.getPlatform((JComboBox)this.platforms));
    }

    private void mainClassChanged() {
        String string = this.mainClassTextField.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        this.valid = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() != 0 && !string2.equals(" ")) continue;
            this.valid = false;
            break;
        }
        this.fireChangeEvent();
    }
}

