/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPlatformCustomizer;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.SourceRoots;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.MainClassChooser;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.RubyProjectProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CustomizerRun
extends JPanel
implements HelpCtx.Provider {
    private final RubyProject project;
    private final JTextField[] data;
    private final String[] keys;
    private final Map<String, Map<String, String>> configs;
    private final RubyProjectProperties uiProperties;
    private PlatformComponentFactory.PlatformChangeListener platformListener;
    private JComboBox configCombo;
    private JButton configDel;
    private JLabel configLabel;
    private JButton configNew;
    private JPanel configPanel;
    private JSeparator configSep;
    private JButton jButtonMainClass;
    private JButton jButtonWorkingDirectoryBrowse;
    private JLabel jLabelArgs;
    private JLabel jLabelMainClass;
    private JLabel jLabelVMOptions;
    private JLabel jLabelVMOptionsExample;
    private JLabel jLabelWorkingDirectory;
    private JTextField jTextFieldArgs;
    private JTextField jTextFieldMainClass;
    private JTextField jTextVMOptions;
    private JTextField jTextWorkingDirectory;
    private JPanel mainPanel;
    private JButton manageButton;
    private JComboBox platforms;
    private JLabel rakeExampleLabel;
    private JLabel rakeLabel;
    private JTextField rakeTextField;
    private JLabel rubyPlatformLabel;

    public CustomizerRun(RubyProjectProperties rubyProjectProperties) {
        this.uiProperties = rubyProjectProperties;
        this.initComponents();
        this.project = rubyProjectProperties.getProject();
        this.configs = rubyProjectProperties.RUN_CONFIGS;
        this.data = new JTextField[]{this.jTextFieldMainClass, this.jTextFieldArgs, this.jTextVMOptions, this.jTextWorkingDirectory, this.rakeTextField};
        JLabel[] jLabelArray = new JLabel[]{this.jLabelMainClass, this.jLabelArgs, this.jLabelVMOptions, this.jLabelWorkingDirectory, this.rakeLabel};
        this.keys = new String[]{"main.file", "application.args", "run.jvmargs", "work.dir", "rake.args"};
        assert (this.data.length == this.keys.length);
        this.configChanged(rubyProjectProperties.activeConfig);
        this.configCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string;
                String string2 = (String)object;
                if (string2 == null) {
                    string = null;
                } else if (string2.length() > 0) {
                    Map map = (Map)CustomizerRun.this.configs.get(string2);
                    String string3 = string = map != null ? (String)map.get("$label") : null;
                    if (string == null) {
                        string = string2;
                    }
                } else {
                    string = NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.default");
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        for (int i = 0; i < this.data.length; ++i) {
            final JTextField jTextField = this.data[i];
            final String string = this.keys[i];
            final JLabel jLabel = jLabelArray[i];
            jTextField.getDocument().addDocumentListener(new DocumentListener(){
                Font basefont;
                Font boldfont;
                {
                    this.basefont = jLabel.getFont();
                    this.boldfont = this.basefont.deriveFont(1);
                    this.updateFont();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changed();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changed();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                }

                void changed() {
                    String string3;
                    String string2 = (String)CustomizerRun.this.configCombo.getSelectedItem();
                    if (string2.length() == 0) {
                        string2 = null;
                    }
                    if ((string3 = jTextField.getText()) != null && string2 != null && string3.equals(((Map)CustomizerRun.this.configs.get(null)).get(string))) {
                        string3 = null;
                    }
                    ((Map)CustomizerRun.this.configs.get(string2)).put(string, string3);
                    this.updateFont();
                }

                void updateFont() {
                    String string4 = jTextField.getText();
                    String string2 = (String)CustomizerRun.this.configCombo.getSelectedItem();
                    if (string2.length() == 0) {
                        string2 = null;
                    }
                    String string3 = (String)((Map)CustomizerRun.this.configs.get(null)).get(string);
                    jLabel.setFont(string2 != null && !Utilities.compareObjects((Object)(string4 != null ? string4 : ""), (Object)(string3 != null ? string3 : "")) ? this.boldfont : this.basefont);
                }
            });
        }
        this.jButtonMainClass.addActionListener(new MainClassListener(this.project.getSourceRoots(), this.jTextFieldMainClass));
        this.platforms.setSelectedItem(rubyProjectProperties.getPlatform());
    }

    public void addNotify() {
        super.addNotify();
        this.platformListener = new PlatformComponentFactory.PlatformChangeListener(){

            public void platformChanged() {
                CustomizerRun.this.uiProperties.setPlatform((RubyPlatform)CustomizerRun.this.platforms.getSelectedItem());
            }
        };
        PlatformComponentFactory.addPlatformChangeListener((JComboBox)this.platforms, (PlatformComponentFactory.PlatformChangeListener)this.platformListener);
    }

    public void removeNotify() {
        PlatformComponentFactory.removePlatformChangeListener((JComboBox)this.platforms, (PlatformComponentFactory.PlatformChangeListener)this.platformListener);
        super.removeNotify();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    private void initComponents() {
        this.configSep = new JSeparator();
        this.configPanel = new JPanel();
        this.mainPanel = new JPanel();
        this.jLabelMainClass = new JLabel();
        this.jTextFieldMainClass = new JTextField();
        this.jButtonMainClass = new JButton();
        this.jLabelArgs = new JLabel();
        this.jTextFieldArgs = new JTextField();
        this.jLabelWorkingDirectory = new JLabel();
        this.jTextWorkingDirectory = new JTextField();
        this.jButtonWorkingDirectoryBrowse = new JButton();
        this.jLabelVMOptions = new JLabel();
        this.jTextVMOptions = new JTextField();
        this.jLabelVMOptionsExample = new JLabel();
        this.rakeLabel = new JLabel();
        this.rakeTextField = new JTextField();
        this.rakeExampleLabel = new JLabel();
        this.rubyPlatformLabel = new JLabel();
        this.platforms = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.manageButton = new JButton();
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.configDel = new JButton();
        this.configNew = new JButton();
        this.configPanel.setLayout(new GridBagLayout());
        this.jLabelMainClass.setLabelFor(this.jTextFieldMainClass);
        Mnemonics.setLocalizedText((JLabel)this.jLabelMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JButton"));
        this.jLabelArgs.setLabelFor(this.jTextFieldArgs);
        Mnemonics.setLocalizedText((JLabel)this.jLabelArgs, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Args_JLabel"));
        this.jLabelWorkingDirectory.setLabelFor(this.jTextWorkingDirectory);
        Mnemonics.setLocalizedText((JLabel)this.jLabelWorkingDirectory, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonWorkingDirectoryBrowse, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory_Browse"));
        this.jButtonWorkingDirectoryBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.jButtonWorkingDirectoryBrowseActionPerformed(actionEvent);
            }
        });
        this.jLabelVMOptions.setLabelFor(this.jTextVMOptions);
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptions, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptionsExample, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options_Example"));
        this.rakeLabel.setLabelFor(this.rakeTextField);
        Mnemonics.setLocalizedText((JLabel)this.rakeLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RakeArgs"));
        Mnemonics.setLocalizedText((JLabel)this.rakeExampleLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RakeArgsEx"));
        GroupLayout groupLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabelWorkingDirectory).add((Component)this.jLabelArgs).add((Component)this.jLabelMainClass)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jTextFieldMainClass, -1, 485, Short.MAX_VALUE).add(2, (Component)this.jTextFieldArgs, -1, 485, Short.MAX_VALUE).add(2, (Component)this.jTextVMOptions, -1, 485, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jTextWorkingDirectory, -1, 485, Short.MAX_VALUE).addPreferredGap(1)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.rakeTextField, -1, 485, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelVMOptionsExample).addPreferredGap(0, 437, Short.MAX_VALUE)).add((Component)this.rakeExampleLabel)))).add(9, 9, 9).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.jButtonWorkingDirectoryBrowse).add((Component)this.jButtonMainClass))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelVMOptions).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rakeLabel).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabelMainClass).add((Component)this.jButtonMainClass).add((Component)this.jTextFieldMainClass, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabelArgs).add((Component)this.jTextFieldArgs, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabelWorkingDirectory).add((Component)this.jButtonWorkingDirectoryBrowse).add((Component)this.jTextWorkingDirectory, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.jLabelVMOptions).add((Component)this.jTextVMOptions, -2, -1, -2)).add(0, 0, 0).add((Component)this.jLabelVMOptionsExample).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.rakeLabel).add((Component)this.rakeTextField, -2, -1, -2)).add(0, 0, 0).add((Component)this.rakeExampleLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTextFieldMainClass.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.jTextFieldMainClass.AccessibleContext.accessibleName"));
        this.jTextFieldMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jTextFieldMainClass"));
        this.jButtonMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jButtonMainClass"));
        this.jTextFieldArgs.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.jTextFieldArgs.AccessibleContext.accessibleName"));
        this.jTextFieldArgs.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jTextFieldArgs"));
        this.jTextWorkingDirectory.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.jTextWorkingDirectory.AccessibleContext.accessibleName"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/ruby/rubyproject/ui/customizer/Bundle");
        this.jTextWorkingDirectory.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizeRun_Run_Working_Directory"));
        this.jButtonWorkingDirectoryBrowse.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizeRun_Run_Working_Directory_Browse"));
        this.jTextVMOptions.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.jTextVMOptions.AccessibleContext.accessibleName"));
        this.jTextVMOptions.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizeRun_Run_VM_Options"));
        this.jLabelVMOptionsExample.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_CustomizeRun_Run_VM_Options_Example"));
        this.rakeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.rakeLabel.AccessibleContext.accessibleDescription"));
        this.rakeTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.rakeTextField.AccessibleContext.accessibleName"));
        this.rubyPlatformLabel.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.rubyPlatformLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RubyPlatformLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RubyHomeBrowse"));
        this.manageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.manageButtonActionPerformed(actionEvent);
            }
        });
        this.configLabel.setLabelFor(this.configCombo);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configLabel"));
        this.configCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"<default>"}));
        this.configCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.configComboActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configDel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configDelete"));
        this.configDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.configDelActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configNew, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configNew"));
        this.configNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerRun.this.configNewActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.mainPanel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.configPanel, -2, 410, -2).add(1, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.rubyPlatformLabel).add((Component)this.configLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (Component)this.platforms, 0, 452, Short.MAX_VALUE).add(2, (Component)this.configCombo, 0, 452, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.configNew).addPreferredGap(0).add((Component)this.configDel)).add((Component)this.manageButton)).addPreferredGap(0)).add((Component)this.configSep, -1, 711, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.rubyPlatformLabel).add((Component)this.platforms, -2, -1, -2).add((Component)this.manageButton)).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(6, 6, 6).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.configLabel).add((Component)this.configCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.configPanel, -2, -1, -2)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.configDel).add((Component)this.configNew)))).addPreferredGap(0).add((Component)this.configSep, -2, 2, -2).addPreferredGap(0).add((Component)this.mainPanel, -1, -1, Short.MAX_VALUE)));
        this.rubyPlatformLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.rubyPlatformLabel.AccessibleContext.accessibleDescription"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.manageButton.AccessibleContext.accessibleDescription"));
        this.configLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configLabel.AccessibleContext.accessibleDescription"));
        this.configNew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configNew.AccessibleContext.accessibleDescription"));
    }

    private void configDelActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.configCombo.getSelectedItem();
        assert (string != null);
        this.configs.put(string, null);
        this.configChanged(null);
        this.uiProperties.activeConfig = null;
    }

    private void configNewActionPerformed(ActionEvent actionEvent) {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.prompt"), NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        String string = inputLine.getInputText();
        String string2 = string.replaceAll("[^a-zA-Z0-9_.-]", "_");
        if (this.configs.get(string2) != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.input.duplicate", (Object)string2), 2));
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!string.equals(string2)) {
            hashMap.put("$label", string);
        }
        this.configs.put(string2, hashMap);
        this.configChanged(string2);
        this.uiProperties.activeConfig = string2;
    }

    private void configComboActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.configCombo.getSelectedItem();
        if (string.length() == 0) {
            string = null;
        }
        this.configChanged(string);
        this.uiProperties.activeConfig = string;
    }

    private void jButtonWorkingDirectoryBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        String string = this.jTextWorkingDirectory.getText();
        if (string.equals("")) {
            string = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getAbsolutePath();
        }
        jFileChooser.setSelectedFile(new File(string));
        jFileChooser.setDialogTitle(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory_Browse_Title"));
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.jTextWorkingDirectory.setText(file.getAbsolutePath());
        }
    }

    private void manageButtonActionPerformed(ActionEvent actionEvent) {
        RubyPlatformCustomizer.manage((JComboBox)this.platforms);
    }

    private void configChanged(String string) {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("");
        TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){
            Collator coll = Collator.getInstance();

            @Override
            public int compare(String string, String string2) {
                return this.coll.compare(this.label(string), this.label(string2));
            }

            private String label(String string) {
                Map map = (Map)CustomizerRun.this.configs.get(string);
                String string2 = (String)map.get("$label");
                return string2 != null ? string2 : string;
            }
        });
        for (Map.Entry<String, Map<String, String>> object2 : this.configs.entrySet()) {
            String string2 = object2.getKey();
            if (string2 == null || object2.getValue() == null) continue;
            treeSet.add(string2);
        }
        for (String string3 : treeSet) {
            defaultComboBoxModel.addElement(string3);
        }
        this.configCombo.setModel(defaultComboBoxModel);
        this.configCombo.setSelectedItem(string != null ? string : "");
        Map<String, String> map = this.configs.get(string);
        Map<String, String> map2 = this.configs.get(null);
        if (map != null) {
            for (int i = 0; i < this.data.length; ++i) {
                String string4 = (String)map.get(this.keys[i]);
                if (string4 == null) {
                    string4 = map2.get(this.keys[i]);
                }
                this.data[i].setText(string4);
            }
        }
        this.configDel.setEnabled(string != null);
    }

    private class MainClassListener
    implements ActionListener {
        private final JButton okButton;
        private final SourceRoots sourceRoots;
        private final JTextField mainClassTextField;

        MainClassListener(SourceRoots sourceRoots, JTextField jTextField) {
            this.sourceRoots = sourceRoots;
            this.mainClassTextField = jTextField;
            this.okButton = new JButton(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ChooseMainClass_OK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_ChooseMainClass_OK"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            final MainClassChooser mainClassChooser = new MainClassChooser(this.sourceRoots.getRoots());
            Object[] objectArray = new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION};
            mainClassChooser.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (changeEvent.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)changeEvent.getSource()))) {
                        MainClassListener.this.okButton.doClick();
                    } else {
                        MainClassListener.this.okButton.setEnabled(mainClassChooser.getSelectedMainClass() != null);
                    }
                }
            });
            this.okButton.setEnabled(false);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)mainClassChooser, NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ChooseMainClass_Title"), true, objectArray, objectArray[0], 0, null, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == objectArray[0]) {
                this.mainClassTextField.setText(mainClassChooser.getSelectedMainClass());
            }
            dialog.dispose();
        }
    }
}

