/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ruby.rubyproject.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.ui.TreeRootNode;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class SourceNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        RubyProject rubyProject = (RubyProject)project.getLookup().lookup(RubyProject.class);
        assert (rubyProject != null);
        return new SourcesNodeList(rubyProject);
    }

    static class PreselectPropertiesAction
    extends AbstractAction {
        private final Project project;
        private final String nodeName;
        private final String panelName;

        public PreselectPropertiesAction(Project project, String string) {
            this(project, string, null);
        }

        public PreselectPropertiesAction(Project project, String string, String string2) {
            super(NbBundle.getMessage(SourceNodeFactory.class, (String)"LBL_Properties_Action"));
            this.project = project;
            this.nodeName = string;
            this.panelName = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomizerProviderImpl customizerProviderImpl = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
            if (customizerProviderImpl != null) {
                customizerProviderImpl.showCustomizer(this.nodeName, this.panelName);
            }
        }
    }

    private static class PackageViewFilterNode
    extends FilterNode {
        private String nodeName;
        private Project project;
        private Action[] actions;

        public PackageViewFilterNode(SourceGroup sourceGroup, Project project) {
            super((Node)new RootNode(sourceGroup));
            this.project = project;
            this.nodeName = "Sources";
        }

        public Action[] getActions(boolean bl) {
            if (this.actions == null) {
                this.actions = new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(ToolsAction.class), null, new PreselectPropertiesAction(this.project, this.nodeName)};
            }
            return this.actions;
        }
    }

    private static final class RootNode
    extends FilterNode {
        private SourceGroup sourceGroup;

        private RootNode(SourceGroup sourceGroup) {
            super(RootNode.getOriginalNode(sourceGroup));
            this.sourceGroup = sourceGroup;
        }

        private static Node getOriginalNode(SourceGroup sourceGroup) {
            FileObject fileObject = sourceGroup.getRootFolder();
            if (fileObject == null || !fileObject.isValid()) {
                return new AbstractNode(FilterNode.Children.LEAF);
            }
            return new TreeRootNode(sourceGroup);
        }
    }

    private static class SourceGroupKey {
        public final SourceGroup group;
        public final FileObject fileObject;

        SourceGroupKey(SourceGroup sourceGroup) {
            this.group = sourceGroup;
            this.fileObject = sourceGroup.getRootFolder();
        }

        SourceGroupKey(FileObject fileObject) {
            this.group = null;
            this.fileObject = fileObject;
        }

        public int hashCode() {
            return this.fileObject.hashCode();
        }

        public boolean equals(Object object) {
            String string;
            if (!(object instanceof SourceGroupKey)) {
                return false;
            }
            SourceGroupKey sourceGroupKey = (SourceGroupKey)object;
            String string2 = this.group == null ? null : this.group.getDisplayName();
            String string3 = string = sourceGroupKey.group == null ? null : sourceGroupKey.group.getDisplayName();
            return this.fileObject.equals(sourceGroupKey.fileObject) && (string2 == null ? string == null : string2.equals(string));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SourcesNodeList
    implements NodeList<SourceGroupKey>,
    ChangeListener {
        private RubyProject project;
        private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

        public SourcesNodeList(RubyProject rubyProject) {
            this.project = rubyProject;
        }

        public List<SourceGroupKey> keys() {
            FileObject fileObject;
            if (this.project.getProjectDirectory() == null || !this.project.getProjectDirectory().isValid()) {
                return Collections.emptyList();
            }
            Sources sources = this.getSources();
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("ruby");
            ArrayList<SourceGroupKey> arrayList = new ArrayList<SourceGroupKey>(sourceGroupArray.length);
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                arrayList.add(new SourceGroupKey(sourceGroupArray[i]));
            }
            FileObject fileObject2 = RakeSupport.findRakeFile(this.project);
            if (fileObject2 != null && this.project.getProjectDirectory().equals(fileObject2.getParent())) {
                arrayList.add(new SourceGroupKey(fileObject2));
            }
            if ((fileObject = this.project.getProjectDirectory().getFileObject("README")) != null) {
                arrayList.add(new SourceGroupKey(fileObject));
            }
            return arrayList;
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
            SourcesNodeList sourcesNodeList = this;
            synchronized (sourcesNodeList) {
                arrayList.addAll(this.listeners);
            }
            for (ChangeListener changeListener : arrayList) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Node node(SourceGroupKey sourceGroupKey) {
            if (sourceGroupKey.group == null) {
                try {
                    if (RakeSupport.isRakeFile(sourceGroupKey.fileObject)) {
                        return new RakeSupport.RakeNode(sourceGroupKey.fileObject);
                    }
                    DataObject dataObject = DataObject.find((FileObject)sourceGroupKey.fileObject);
                    return new FilterNode(dataObject.getNodeDelegate());
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                }
            }
            return new PackageViewFilterNode(sourceGroupKey.group, this.project);
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SourcesNodeList.this.fireChange();
                }
            });
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }
    }
}

