/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyExecution;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.TestNotifier;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class RakeSupport {
    static final String[] RAKEFILE_NAMES = new String[]{"rakefile", "Rakefile", "rakefile.rb", "Rakefile.rb"};
    private boolean test;
    private Project project;

    public RakeSupport(Project project) {
        this.project = project;
    }

    public void setTest(boolean bl) {
        this.test = bl;
    }

    public static FileObject findRakeFile(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        for (String string : RAKEFILE_NAMES) {
            FileObject fileObject2 = fileObject.getFileObject(string);
            if (fileObject2 == null) continue;
            return fileObject2;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("ruby");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            for (SourceGroup sourceGroup : sourceGroupArray) {
                FileObject fileObject3 = sourceGroup.getRootFolder();
                for (String string : RAKEFILE_NAMES) {
                    FileObject fileObject4 = fileObject3.getFileObject(string);
                    if (fileObject4 == null) continue;
                    return fileObject4;
                }
            }
        }
        return null;
    }

    public static boolean isRakeFile(FileObject fileObject) {
        if (!fileObject.getMIMEType().equals("text/x-ruby")) {
            return false;
        }
        String string = fileObject.getName().toLowerCase();
        if (string.equals("rakefile")) {
            return true;
        }
        String string2 = fileObject.getExt().toLowerCase();
        return string2.equals("rake");
    }

    /*
     * WARNING - void declaration
     */
    public void runRake(File file, FileObject fileObject, String string, FileLocator fileLocator, boolean bl, boolean bl2, String ... stringArray) {
        void var13_15;
        String[] stringArray2;
        PropertyEvaluator propertyEvaluator;
        if (file == null) {
            assert (fileObject != null);
            file = FileUtil.toFile((FileObject)fileObject.getParent());
        }
        if (!RubyPlatform.hasValidRake((Project)this.project, (boolean)bl)) {
            return;
        }
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
        GemManager gemManager = rubyPlatform.getGemManager();
        String string2 = gemManager.getRake();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fileObject != null) {
            arrayList.add("-f");
            arrayList.add(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        }
        if (stringArray != null && stringArray.length > 0) {
            for (String string3 : stringArray) {
                arrayList.add(string3);
            }
        }
        Object var13_13 = null;
        String string4 = null;
        String string5 = null;
        if (this.project != null && (propertyEvaluator = (PropertyEvaluator)this.project.getLookup().lookup(PropertyEvaluator.class)) != null) {
            String string6 = propertyEvaluator.getProperty("source.encoding");
            string4 = propertyEvaluator.getProperty("javac.classpath");
            string5 = propertyEvaluator.getProperty("rake.args");
        }
        if (string5 != null && (stringArray2 = Utilities.parseParameters(string5)) != null) {
            for (String string7 : stringArray2) {
                arrayList.add(string7);
            }
        }
        ExecutionDescriptor executionDescriptor = arrayList.size() > 0 ? new ExecutionDescriptor(rubyPlatform, string, file, string2).additionalArgs(arrayList.toArray(new String[arrayList.size()])) : new ExecutionDescriptor(rubyPlatform, string, file, string2);
        executionDescriptor.allowInput();
        executionDescriptor.classPath(string4);
        executionDescriptor.fileLocator(fileLocator);
        executionDescriptor.addStandardRecognizers();
        if (rubyPlatform.isJRuby()) {
            executionDescriptor.appendJdkToPath(true);
        }
        if (this.test) {
            executionDescriptor.addOutputRecognizer((OutputRecognizer)new TestNotifier(true, true));
        }
        executionDescriptor.addOutputRecognizer((OutputRecognizer)new RakeErrorRecognizer(executionDescriptor, (String)var13_15)).debug(bl2);
        new RubyExecution(executionDescriptor, (String)var13_15).run();
    }

    public static final class RakeNode
    extends FilterNode {
        private Action[] actions;

        public RakeNode(FileObject fileObject) throws DataObjectNotFoundException {
            super(DataObject.find((FileObject)fileObject).getNodeDelegate());
        }

        public Action[] getActions(boolean bl) {
            if (this.actions == null) {
                this.actions = new Action[]{SystemAction.get(OpenAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
            }
            return this.actions;
        }
    }

    private class RakeErrorRecognizer
    extends OutputRecognizer
    implements Runnable {
        private ExecutionDescriptor desc;
        private String charsetName;

        RakeErrorRecognizer(ExecutionDescriptor executionDescriptor, String string) {
            this.desc = executionDescriptor;
            this.charsetName = string;
        }

        public OutputRecognizer.RecognizedOutput processLine(String string) {
            if (string.indexOf("(See full trace by running task with --trace)") != -1) {
                return new OutputRecognizer.ActionText(new String[]{string}, new String[]{NbBundle.getMessage(RakeSupport.class, (String)"RerunRakeWithTrace")}, new Runnable[]{this}, null);
            }
            return null;
        }

        public void run() {
            String[] stringArray = this.desc.getAdditionalArgs();
            if (stringArray != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl = false;
                for (String string : stringArray) {
                    arrayList.add(string);
                    if (!string.equals("--trace")) continue;
                    bl = true;
                }
                if (!bl) {
                    arrayList.add(0, "--trace");
                }
                this.desc.additionalArgs(arrayList.toArray(new String[arrayList.size()]));
            } else {
                this.desc.additionalArgs(new String[]{"--trace"});
            }
            new RubyExecution(this.desc, this.charsetName).run();
        }
    }
}

