/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathSupport {
    private static final String LIBRARY_PREFIX = "${libs.";
    private static final String LIBRARY_SUFFIX = ".classpath}";
    private PropertyEvaluator evaluator;
    private final ReferenceHelper referenceHelper;
    private AntProjectHelper antProjectHelper;
    private Set<String> wellKnownPaths;
    private String antArtifactPrefix;
    private UpdateHelper updateHelper;

    public ClassPathSupport(PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, UpdateHelper updateHelper, String[] stringArray, String string) {
        this.evaluator = propertyEvaluator;
        this.referenceHelper = referenceHelper;
        assert (referenceHelper != null);
        this.antProjectHelper = antProjectHelper;
        this.wellKnownPaths = stringArray == null ? null : new HashSet<String>(Arrays.asList(stringArray));
        this.antArtifactPrefix = string;
        this.updateHelper = updateHelper;
    }

    public Iterator<Item> itemsIterator(String string) {
        return this.itemsList(string).iterator();
    }

    public List<Item> itemsList(String string) {
        String[] stringArray = PropertyUtils.tokenizePath((String)(string == null ? "" : string));
        ArrayList<Item> arrayList = new ArrayList<Item>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            File file;
            Object object;
            Object object2;
            Object object3;
            Item item;
            if (this.isWellKnownPath(stringArray[i])) {
                item = Item.create(stringArray[i]);
            } else if (ClassPathSupport.isLibrary(stringArray[i])) {
                object3 = ClassPathSupport.getLibraryNameFromReference(stringArray[i]);
                assert (object3 != null) : "Not a library reference: " + stringArray[i];
                object2 = this.referenceHelper.findLibrary((String)object3);
                item = object2 == null ? Item.createBroken(1, stringArray[i]) : Item.create(object2, stringArray[i]);
            } else if (this.isAntArtifact(stringArray[i])) {
                object3 = this.referenceHelper.findArtifactAndLocation(stringArray[i]);
                if (object3[0] == null || object3[1] == null) {
                    item = Item.createBroken(2, stringArray[i]);
                } else {
                    File file2;
                    object2 = (AntArtifact)object3[0];
                    object = (URI)object3[1];
                    file = this.antProjectHelper.resolveFile(this.evaluator.evaluate(stringArray[i]));
                    item = file.equals(file2 = new File(object2.getScriptLocation().toURI().resolve((URI)object).normalize())) ? Item.create((AntArtifact)object2, (URI)object, stringArray[i]) : Item.createBroken(2, stringArray[i]);
                }
            } else {
                object3 = this.evaluator.evaluate(stringArray[i]);
                object2 = null;
                if (object3 != null) {
                    object2 = this.antProjectHelper.resolveFile((String)object3);
                }
                item = object2 == null || !object2.exists() ? Item.createBroken((String)object3, stringArray[i]) : Item.create((String)object3, stringArray[i]);
                object2 = null;
                object = item.getSourceReference();
                if (object != null && (object3 = this.evaluator.evaluate((String)object)) != null && !((String)object3).contains("${source.reference.")) {
                    object2 = new File((String)object3);
                }
                file = null;
                object = item.getJavadocReference();
                if (object != null) {
                    object3 = this.evaluator.evaluate((String)object);
                    file = null;
                    if (object3 != null && !((String)object3).contains("${javadoc.reference.")) {
                        file = new File((String)object3);
                    }
                }
                item.setInitialSourceAndJavadoc((File)object2, file);
            }
            arrayList.add(item);
        }
        return arrayList;
    }

    public String[] encodeToStrings(Iterator<Item> iterator) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            String string = null;
            switch (stringArray.getType()) {
                case 0: {
                    Object object;
                    string = stringArray.getReference();
                    if (stringArray.isBroken()) break;
                    if (string == null) {
                        object = stringArray.getFilePath();
                        string = this.referenceHelper.createForeignFileReferenceAsIs((String)object, null);
                        ((Item)stringArray).property = string;
                    }
                    if (stringArray.hasChangedSource()) {
                        if (stringArray.getSourceFilePath() != null) {
                            this.referenceHelper.createExtraForeignFileReferenceAsIs(stringArray.getSourceFilePath(), stringArray.getSourceProperty());
                        } else {
                            object = this.updateHelper.getProperties("nbproject/project.properties");
                            object.remove((Object)stringArray.getSourceProperty());
                            this.updateHelper.putProperties("nbproject/project.properties", (EditableProperties)object);
                        }
                    }
                    if (!stringArray.hasChangedJavadoc()) break;
                    if (stringArray.getJavadocFilePath() != null) {
                        this.referenceHelper.createExtraForeignFileReferenceAsIs(stringArray.getJavadocFilePath(), stringArray.getJavadocProperty());
                        break;
                    }
                    object = this.updateHelper.getProperties("nbproject/project.properties");
                    object.remove((Object)stringArray.getJavadocProperty());
                    this.updateHelper.putProperties("nbproject/project.properties", (EditableProperties)object);
                    break;
                }
                case 1: {
                    string = stringArray.getReference();
                    if (stringArray.isBroken()) break;
                    Object object = stringArray.getLibrary();
                    if (string != null || object == null) break;
                    string = this.getLibraryReference((Item)stringArray);
                    break;
                }
                case 2: {
                    string = stringArray.getReference();
                    if (stringArray.isBroken()) break;
                    AntArtifact antArtifact = stringArray.getArtifact();
                    if (string != null || antArtifact == null) break;
                    string = this.referenceHelper.addReference(stringArray.getArtifact(), stringArray.getArtifactURI());
                    break;
                }
                case 3: {
                    string = stringArray.getReference();
                }
            }
            if (string == null) continue;
            arrayList.add(string);
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = i < arrayList.size() - 1 ? (String)arrayList.get(i) + ":" : (String)arrayList.get(i);
        }
        return stringArray;
    }

    public void updateJarReference(Item item) {
        String string = this.evaluator.evaluate(item.getReference());
        item.object = string;
        String string2 = item.getSourceReference();
        if (string2 != null && (string = this.evaluator.evaluate(string2)) != null && !string.contains("${source.reference.")) {
            item.setSourceFilePath(string);
        }
        if ((string2 = item.getJavadocReference()) != null && (string = this.evaluator.evaluate(string2)) != null && !string.contains("${javadoc.reference.")) {
            item.setJavadocFilePath(string);
        }
    }

    public String getLibraryReference(Item item) {
        if (item.getType() != 1) {
            throw new IllegalArgumentException("Item must be of type LIBRARY");
        }
        return this.referenceHelper.createLibraryReference(item.getLibrary(), "classpath");
    }

    private boolean isWellKnownPath(String string) {
        return this.wellKnownPaths == null ? false : this.wellKnownPaths.contains(string);
    }

    private boolean isAntArtifact(String string) {
        return this.antArtifactPrefix == null ? false : string.startsWith(this.antArtifactPrefix);
    }

    private static boolean isLibrary(String string) {
        return string.startsWith(LIBRARY_PREFIX) && string.endsWith(LIBRARY_SUFFIX);
    }

    public static String getAntPropertyName(String string) {
        if (string != null && string.startsWith("${") && string.endsWith("}")) {
            return string.substring(2, string.length() - 1);
        }
        return string;
    }

    public static String getLibraryNameFromReference(String string) {
        if (!ClassPathSupport.isLibrary(string)) {
            return null;
        }
        return string.substring(LIBRARY_PREFIX.length(), string.lastIndexOf(46));
    }

    public static class Item {
        public static final int TYPE_JAR = 0;
        public static final int TYPE_LIBRARY = 1;
        public static final int TYPE_ARTIFACT = 2;
        public static final int TYPE_CLASSPATH = 3;
        private static final String REF_START = "${file.reference.";
        private static final int REF_START_INDEX = "${file.reference.".length();
        private static final String JAVADOC_START = "${javadoc.reference.";
        private static final String SOURCE_START = "${source.reference.";
        private Object object;
        private URI artifactURI;
        private int type;
        private String property;
        private boolean broken;
        private String sourceFile;
        private String javadocFile;
        private File initialSourceFile;
        private File initialJavadocFile;
        private String libraryName;

        private Item(int n, Object object, String string, boolean bl) {
            this.type = n;
            this.object = object;
            this.property = string;
            this.broken = bl;
        }

        private Item(int n, Object object, String string) {
            this(n, object, string, false);
        }

        private Item(int n, Object object, URI uRI, String string) {
            this(n, object, string, false);
            this.artifactURI = uRI;
        }

        public static Item create(Library library, String string) {
            if (library == null) {
                throw new IllegalArgumentException("library must not be null");
            }
            Item item = new Item(1, library, string);
            item.libraryName = library.getName();
            item.reassignLibraryManager(library.getManager());
            return item;
        }

        public static Item create(AntArtifact antArtifact, URI uRI, String string) {
            if (uRI == null) {
                throw new IllegalArgumentException("artifactURI must not be null");
            }
            if (antArtifact == null) {
                throw new IllegalArgumentException("artifact must not be null");
            }
            return new Item(2, (Object)antArtifact, uRI, string);
        }

        public static Item create(String string, String string2) {
            if (string == null) {
                throw new IllegalArgumentException("path must not be null");
            }
            return new Item(0, string, string2);
        }

        public static Item create(String string) {
            if (string == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            return new Item(3, null, string);
        }

        public static Item createBroken(int n, String string) {
            if (string == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            Item item = new Item(n, null, string, true);
            if (n == 1) {
                Pattern pattern = Pattern.compile("\\$\\{libs\\.([^${}]+)\\.[^${}]+\\}");
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    item.libraryName = matcher.group(1);
                } else assert (false) : string;
            }
            return item;
        }

        public static Item createBroken(String string, String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(0, (Object)string, string2, true);
        }

        public int getType() {
            return this.type;
        }

        public Library getLibrary() {
            if (this.getType() != 1) {
                throw new IllegalArgumentException("Item is not of required type - LIBRARY");
            }
            assert (this.object == null || this.object instanceof Library) : "Invalid object type: " + this.object.getClass().getName() + " instance: " + this.object.toString() + " expected type: Library";
            return (Library)this.object;
        }

        public String getFilePath() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            return (String)this.object;
        }

        public AntArtifact getArtifact() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return (AntArtifact)this.object;
        }

        public URI getArtifactURI() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return this.artifactURI;
        }

        public void reassignLibraryManager(LibraryManager libraryManager) {
            if (this.getType() != 1) {
                throw new IllegalArgumentException(" reassigning only works for type - LIBRARY");
            }
            assert (this.libraryName != null);
            if (this.getLibrary() == null || libraryManager != this.getLibrary().getManager()) {
                Library library = libraryManager.getLibrary(this.libraryName);
                if (library == null) {
                    this.broken = true;
                    this.object = null;
                } else {
                    this.object = library;
                    this.broken = false;
                }
            }
        }

        public String getReference() {
            return this.property;
        }

        public String getSourceReference() {
            if (this.property == null || !this.property.startsWith(REF_START)) {
                return null;
            }
            return SOURCE_START + this.property.substring(REF_START_INDEX);
        }

        public String getSourceProperty() {
            if (this.property == null || !this.property.startsWith(REF_START)) {
                return null;
            }
            String string = this.getSourceReference();
            if (string == null) {
                return null;
            }
            return string.substring(2, string.length() - 1);
        }

        public String getJavadocReference() {
            if (this.property == null || !this.property.startsWith(REF_START)) {
                return null;
            }
            return JAVADOC_START + this.property.substring(REF_START_INDEX);
        }

        public String getJavadocProperty() {
            if (this.property == null || !this.property.startsWith(REF_START)) {
                return null;
            }
            String string = this.getJavadocReference();
            if (string == null) {
                return null;
            }
            return string.substring(2, string.length() - 1);
        }

        public boolean canEdit() {
            if (this.isBroken()) {
                return false;
            }
            if (this.getType() == 0) {
                if (this.property == null) {
                    return true;
                }
                return this.getSourceReference() != null && this.getJavadocReference() != null;
            }
            return this.getType() == 1;
        }

        public String getSourceFilePath() {
            return this.sourceFile;
        }

        public String getJavadocFilePath() {
            return this.javadocFile;
        }

        public void setJavadocFilePath(String string) {
            this.javadocFile = string;
        }

        public void setSourceFilePath(String string) {
            this.sourceFile = string;
        }

        public void setInitialSourceAndJavadoc(File file, File file2) {
            this.initialSourceFile = file;
            this.initialJavadocFile = file2;
            this.sourceFile = file == null ? null : file.getPath();
            this.javadocFile = file2 == null ? null : file2.getPath();
        }

        public boolean hasChangedSource() {
            if (this.initialSourceFile == null != (this.sourceFile == null)) {
                return true;
            }
            if (this.initialSourceFile != null && this.sourceFile != null) {
                return !this.initialSourceFile.getPath().equals(this.sourceFile);
            }
            return true;
        }

        public boolean hasChangedJavadoc() {
            if (this.initialJavadocFile == null != (this.javadocFile == null)) {
                return true;
            }
            if (this.initialJavadocFile != null && this.javadocFile != null) {
                return !this.initialJavadocFile.getPath().equals(this.javadocFile);
            }
            return true;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public int hashCode() {
            int n = this.getType();
            if (this.broken) {
                return 42;
            }
            switch (this.getType()) {
                case 2: {
                    n += this.getArtifact().getType().hashCode();
                    n += this.getArtifact().getScriptLocation().hashCode();
                    n += this.getArtifactURI().hashCode();
                    break;
                }
                case 3: {
                    n += this.property.hashCode();
                    break;
                }
                default: {
                    n += this.object.hashCode();
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Item)) {
                return false;
            }
            Item item = (Item)object;
            if (this.getType() != item.getType()) {
                return false;
            }
            if (this.isBroken() != item.isBroken()) {
                return false;
            }
            if (this.isBroken()) {
                return this.getReference().equals(item.getReference());
            }
            switch (this.getType()) {
                case 2: {
                    if (this.getArtifact().getType() != item.getArtifact().getType()) {
                        return false;
                    }
                    if (!this.getArtifact().getScriptLocation().equals(item.getArtifact().getScriptLocation())) {
                        return false;
                    }
                    return this.getArtifactURI().equals(item.getArtifactURI());
                }
                case 3: {
                    return this.property.equals(item.property);
                }
            }
            return this.object.equals(item.object);
        }
    }
}

