/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public final class J2SEProjectConfigurations {
    J2SEProjectConfigurations() {
    }

    public static void createConfigurationFiles(Project project, String string, final Properties properties, final Properties properties2) throws IOException, IllegalArgumentException {
        if (project == null || string == null || "".equals(string)) {
            throw new IllegalArgumentException();
        }
        final String string2 = string + ".properties";
        final FileObject fileObject = project.getProjectDirectory();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        public void run() throws IOException {
                            J2SEProjectConfigurations.generateConfig(fileObject, "nbproject/configs/" + string2, properties);
                            J2SEProjectConfigurations.generateConfig(fileObject, "nbproject/private/configs/" + string2, properties2);
                        }
                    });
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private static void generateConfig(FileObject fileObject, String string, Properties properties) throws IOException {
        if (properties == null) {
            return;
        }
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
        Properties properties2 = new Properties();
        InputStream inputStream = fileObject2.getInputStream();
        properties2.load(inputStream);
        inputStream.close();
        if (properties2.equals(properties)) {
            return;
        }
        OutputStream outputStream = fileObject2.getOutputStream();
        properties.store(outputStream, null);
        outputStream.close();
    }
}

