/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Vector;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.modules.uml.util.ITaskFinishListener;
import org.netbeans.modules.uml.util.ITaskSupervisor;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class AbstractNBTask
extends Thread
implements Cancellable,
ITaskSupervisor {
    private AggregateProgressHandle progressHandle;
    protected ProgressContributor[] progressContribs;
    protected boolean cancelled = false;
    protected long start;
    protected boolean success = true;
    private InputOutput inputOutput;
    private PrintWriter out;
    private HashMap<String, Object> taskSettings = new HashMap();
    private String timeMsg;
    private int contribCount = -1;
    private int counter = 0;
    private int logLevel = 0;
    private boolean logging = false;
    private boolean finished = false;
    public static final String SETTING_KEY_TASK_NAME = "TASK_NAME";
    public static final String SETTING_KEY_TOTAL_ITEMS = "TOTAL_ITEMS";
    public static final String SETTING_KEY_DISPLAY_OUTPUT = "DISPLAY_OUTPUT";
    private Vector<ITaskFinishListener> listeners = new Vector();

    public AbstractNBTask() {
        this.initialize();
    }

    public AbstractNBTask(ITaskFinishListener iTaskFinishListener) {
        this.initialize();
        this.addListener(iTaskFinishListener);
    }

    public AbstractNBTask(HashMap hashMap) {
        this.taskSettings = hashMap;
        this.initialize();
    }

    public AbstractNBTask(HashMap hashMap, ITaskFinishListener iTaskFinishListener) {
        this.taskSettings = hashMap;
        this.initialize();
        this.addListener(iTaskFinishListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.progressContribs != null && this.progressContribs.length > 0) {
            this.progressHandle = AggregateProgressFactory.createHandle((String)this.getTaskName(), (ProgressContributor[])this.progressContribs, (Cancellable)this, null);
        }
        try {
            this.beginTask();
        }
        catch (Exception exception) {
            this.fail();
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        finally {
            this.finishTask();
            this.progressHandle.finish();
        }
    }

    public boolean cancel() {
        this.cancelled = true;
        return true;
    }

    protected abstract void initTask();

    protected abstract void begin();

    protected abstract void finish();

    protected void beginLog() {
        String string = this.getBundleMessage("MSG_Begin_Processing") + " " + this.getTaskName();
        if (this.getTotalItems() > 0) {
            string = string + ": " + this.getTotalItems() + " " + this.getBundleMessage("MSG_Items");
        }
        this.log(0, string);
        this.log(0);
    }

    protected void finishLog() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.log(0);
        this.log(0, "================================");
        if (this.cancelled) {
            this.log(NbBundle.getMessage(AbstractNBTask.class, (String)"MSG_Report_Cancelled") + " " + NbBundle.getMessage(AbstractNBTask.class, (String)"MSG_TotalTime", (Object)this.timeMsg));
        } else if (this.success) {
            this.log(NbBundle.getMessage(AbstractNBTask.class, (String)"MSG_Report_Successful") + " " + NbBundle.getMessage(AbstractNBTask.class, (String)"MSG_TotalTime", (Object)this.timeMsg));
        } else {
            this.log(NbBundle.getMessage(AbstractNBTask.class, (String)"MSG_Report_Failed") + " " + NbBundle.getMessage(AbstractNBTask.class, (String)"MSG_TotalTime", (Object)this.timeMsg));
        }
    }

    protected void initDefaultSettings() {
        this.taskSettings.put(SETTING_KEY_TASK_NAME, "<" + this.getBundleMessage("MSG_Default_Task_Name") + ">");
        this.taskSettings.put(SETTING_KEY_TOTAL_ITEMS, new Integer(-1));
    }

    public boolean start(int n) {
        return this.start(++this.contribCount, n);
    }

    public boolean start(int n, int n2) {
        if (n < 0 && n > this.progressContribs.length - 1) {
            this.finishTask();
            return false;
        }
        if (n > 0) {
            this.progressContribs[n].finish();
        }
        this.counter = 0;
        this.progressHandle.setDisplayName(this.getTaskName() + ": " + this.progressContribs[n].getTrackingId());
        this.progressContribs[n].start(n2);
        return true;
    }

    public int increment() {
        return ++this.counter;
    }

    public int increment(int n) {
        this.counter += n;
        return this.counter;
    }

    public boolean proceed() {
        return this.proceed(0);
    }

    public boolean proceed(int n) {
        if (this.cancelled || !this.success) {
            this.progressContribs[this.contribCount].finish();
            this.finishTask();
            return false;
        }
        if (this.counter > -1) {
            if (n > 0) {
                this.increment(n);
            }
            this.log(3, "count " + this.counter);
            this.progressContribs[this.contribCount].progress(this.counter);
        }
        return true;
    }

    public void setLogLevel(int n) {
        this.logLevel = n;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean bl) {
        this.logging = bl;
    }

    public void log() {
        this.log("", true);
    }

    public void log(int n) {
        if (this.logLevel < n) {
            return;
        }
        this.log("", true);
    }

    public void log(int n, String string) {
        if (this.logLevel < n) {
            return;
        }
        this.log(string, true);
    }

    public void log(int n, String string, boolean bl) {
        if (this.logLevel < n) {
            return;
        }
        this.log(string, bl);
    }

    public void log(String string) {
        this.log(string, true);
    }

    public void log(String string, boolean bl) {
        if (bl) {
            this.out.println(string);
        } else {
            this.out.print(string);
        }
        this.out.flush();
    }

    public void fail() {
        this.success = false;
    }

    public String getTaskName() {
        return (String)this.getSetting(SETTING_KEY_TASK_NAME);
    }

    public void setTaskName(String string) {
        this.setSetting(SETTING_KEY_TASK_NAME, string);
    }

    public int getTotalItems() {
        Integer n = (Integer)this.getSetting(SETTING_KEY_TOTAL_ITEMS);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public void setTotalItems(int n) {
        this.setSetting(SETTING_KEY_TOTAL_ITEMS, new Integer(n));
    }

    public boolean isDisplayOutput() {
        Boolean bl = (Boolean)this.getSetting(SETTING_KEY_DISPLAY_OUTPUT);
        if (bl == null) {
            return true;
        }
        return bl;
    }

    public void setDisplayOutput(boolean bl) {
        this.setSetting(SETTING_KEY_DISPLAY_OUTPUT, new Boolean(bl));
    }

    public Object getSetting(String string) {
        return this.taskSettings.get(string);
    }

    public void setSetting(String string, Object object) {
        this.taskSettings.put(string, object);
    }

    public void addListener(ITaskFinishListener iTaskFinishListener) {
        if (!this.listeners.contains(iTaskFinishListener)) {
            this.listeners.addElement(iTaskFinishListener);
        }
    }

    public void removeListener(ITaskFinishListener iTaskFinishListener) {
        this.listeners.removeElement(iTaskFinishListener);
    }

    private void initialize() {
        if (this.taskSettings == null) {
            this.initDefaultSettings();
        }
        this.initTask();
        this.initLog();
    }

    private void initLog() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent("output");
        if (topComponent != null && this.isDisplayOutput()) {
            topComponent.open();
            topComponent.requestActive();
            topComponent.toFront();
        }
        this.inputOutput = IOProvider.getDefault().getIO(this.getTaskName() + " " + this.getBundleMessage("MSG_Log"), false);
        try {
            this.inputOutput.getOut().reset();
            this.out = this.inputOutput.getOut();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.isDisplayOutput()) {
            this.inputOutput.select();
            this.inputOutput.setOutputVisible(true);
        }
    }

    private void beginTask() {
        if (this.getTotalItems() > -1) {
            this.progressHandle.start((long)this.getTotalItems());
        } else {
            this.progressHandle.start();
        }
        this.start = System.currentTimeMillis();
        this.beginLog();
        this.begin();
    }

    private void finishTask() {
        this.progressContribs[this.progressContribs.length - 1].finish();
        this.finish();
        long l = (System.currentTimeMillis() - this.start) / 1000L;
        int n = (int)l / 60;
        int n2 = (int)(l - (long)(n * 60));
        this.timeMsg = n == 0 ? n2 + " " + this.getBundleMessage("MSG_Seconds") : n + " " + this.getBundleMessage("MSG_Minutes") + " " + n2 + " " + this.getBundleMessage("MSG_Seconds");
        this.finishLog();
        this.inputOutput.getOut().flush();
        this.inputOutput.getOut().close();
        this.out.close();
        this.notifyTaskFinishListeners();
    }

    private String getBundleMessage(String string) {
        return NbBundle.getMessage(AbstractNBTask.class, (String)string);
    }

    private String getBundleMessage(String string, Object[] objectArray) {
        return NbBundle.getMessage(AbstractNBTask.class, (String)string, (Object[])objectArray);
    }

    private String getBundleMessage(String string, Object object) {
        return NbBundle.getMessage(AbstractNBTask.class, (String)string, (Object)object);
    }

    private String getBundleMessage(String string, Object object, Object object2) {
        return NbBundle.getMessage(AbstractNBTask.class, (String)string, (Object)object, (Object)object2);
    }

    private String getBundleMessage(String string, Object object, Object object2, Object object3) {
        return NbBundle.getMessage(AbstractNBTask.class, (String)string, (Object)object, (Object)object2, (Object)object3);
    }

    private void notifyTaskFinishListeners() {
        for (ITaskFinishListener iTaskFinishListener : this.listeners) {
            iTaskFinishListener.taskFinished();
        }
    }
}

