/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.test.utilities.reports;

import java.io.FileWriter;
import java.io.IOException;
import org.dom4j.Node;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.core.metamodel.common.commonactivities.IActivityNode;
import org.netbeans.modules.uml.core.metamodel.common.commonactivities.IActivityPartition;
import org.netbeans.modules.uml.core.metamodel.common.commonactivities.IMultiFlow;
import org.netbeans.modules.uml.core.metamodel.common.commonstatemachines.IState;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IClass;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IExtend;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IInclude;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IUseCase;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IUseCaseDetail;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IConstraint;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IDependency;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IMultiplicity;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IMultiplicityRange;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IRedefinableElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IReference;
import org.netbeans.modules.uml.core.metamodel.core.foundation.ITaggedValue;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.core.metamodel.dynamics.ICombinedFragment;
import org.netbeans.modules.uml.core.metamodel.dynamics.IInteraction;
import org.netbeans.modules.uml.core.metamodel.dynamics.IInteractionOperand;
import org.netbeans.modules.uml.core.metamodel.dynamics.ILifeline;
import org.netbeans.modules.uml.core.metamodel.dynamics.IMessage;
import org.netbeans.modules.uml.core.metamodel.dynamics.IMessageConnector;
import org.netbeans.modules.uml.core.metamodel.infrastructure.IConnector;
import org.netbeans.modules.uml.core.metamodel.infrastructure.IConnectorEnd;
import org.netbeans.modules.uml.core.metamodel.infrastructure.IPart;
import org.netbeans.modules.uml.core.metamodel.infrastructure.IPort;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAggregation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociationEnd;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAttribute;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IDerivation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IGeneralization;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IImplementation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IInterface;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IOperation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IParameter;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IParameterableElement;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IStructuralFeature;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IUMLBinding;
import org.netbeans.modules.uml.core.metamodel.structure.IArtifact;
import org.netbeans.modules.uml.core.metamodel.structure.IAssociationClass;
import org.netbeans.modules.uml.core.metamodel.structure.IComment;
import org.netbeans.modules.uml.core.metamodel.structure.IComponent;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.metamodel.structure.ISourceFileArtifact;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.ElementLocator;
import org.netbeans.modules.uml.ui.support.applicationmanager.IDiagramCallback;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProduct;
import org.netbeans.modules.uml.ui.support.diagramsupport.ProxyDiagramManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataReporter {
    private static final String PRINT_LINE80 = "================================================================================";
    private static final String PRINT_LINE80EL = "--------------------------------------------------------------------------------";

    public static void projectReport(IProject iProject, String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string + "\\" + string2);
            if (fileWriter != null) {
                DataReporter.reportHeader(fileWriter);
                DataReporter.printReportDetails(fileWriter, iProject);
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void projectReportXMI(IProject iProject, String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string + "\\" + string2);
            if (fileWriter != null) {
                DataReporter.reportHeader(fileWriter);
                DataReporter.printProjectXMIVersionDetails(fileWriter, iProject);
                DataReporter.printReportDetails(fileWriter, iProject);
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void reportHeader(FileWriter fileWriter) {
        DataReporter.reportInformation(fileWriter, "Project");
    }

    protected static void reportInformation(FileWriter fileWriter, String string) {
        DataReporter.printLine(fileWriter, PRINT_LINE80);
        DataReporter.printLine(fileWriter, " BASELINE REPORT");
        DataReporter.printLine(fileWriter, PRINT_LINE80);
        DataReporter.printLine(fileWriter, " VERSION 6.0");
        DataReporter.printLine(fileWriter, string + " Information");
        DataReporter.printLine(fileWriter, PRINT_LINE80);
    }

    protected static void reportComplete(FileWriter fileWriter) {
        DataReporter.printLine(fileWriter, PRINT_LINE80);
        DataReporter.printLine(fileWriter, " REPORT COMPLETE");
        DataReporter.printLine(fileWriter, PRINT_LINE80);
    }

    protected static void elementReport(IElement iElement, String string, String string2, String string3) {
        try {
            FileWriter fileWriter = new FileWriter(string2 + "\\" + string3);
            if (fileWriter != null) {
                DataReporter.reportInformation(fileWriter, string);
                DataReporter.printAllElementDetails(fileWriter, 0, iElement);
                if (string.equals("Class") || string.equals("UseCase") || string.equals("Actor") || string.equals("Interface") || string.equals("DataType") || string.equals("AliasedType") || string.equals("DerivationClassifier")) {
                    IClassifier iClassifier = (IClassifier)iElement;
                    DataReporter.printAllClassifierDetails(fileWriter, 0, iClassifier);
                }
                DataReporter.reportComplete(fileWriter);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void printReportDetails(FileWriter fileWriter, IProject iProject) {
        if (iProject != null && fileWriter != null) {
            DataReporter.printLine(fileWriter, "Project Name: " + iProject.getName());
            DataReporter.printLine(fileWriter, "Project Alias: " + iProject.getAlias());
            DataReporter.printLine(fileWriter, "Project Visibility: ");
            DataReporter.printLine(fileWriter, "Project Documentation: " + iProject.getDocumentation());
            DataReporter.printLine(fileWriter, "Stereotypes: " + iProject.getAppliedStereotypesAsString(false));
            DataReporter.printTaggedValues(fileWriter, 0, iProject);
            DataReporter.printConstraints(fileWriter, 0, iProject);
            DataReporter.printLine(fileWriter, "Project Filename: " + iProject.getFileName());
            DataReporter.printLine(fileWriter, "Project Default Language: " + iProject.getDefaultLanguage());
            DataReporter.printLine(fileWriter, "Project Mode: " + iProject.getMode());
            DataReporter.printInfo(fileWriter, iProject, "Package");
            DataReporter.printInfo(fileWriter, iProject, "Class");
            DataReporter.printInfo(fileWriter, iProject, "Node");
            DataReporter.printInfo(fileWriter, iProject, "Enumeration");
            DataReporter.printInfo(fileWriter, iProject, "DataType");
            DataReporter.printInfo(fileWriter, iProject, "AliasedType");
            DataReporter.printInfo(fileWriter, iProject, "Interface");
            DataReporter.printInfo(fileWriter, iProject, "Artifact");
            DataReporter.printInfo(fileWriter, iProject, "PartFacade");
            DataReporter.printInfo(fileWriter, iProject, "Collaboration");
            DataReporter.printInfo(fileWriter, iProject, "AssociationClass");
            DataReporter.printInfo(fileWriter, iProject, "DerivationClassifier");
            DataReporter.printInfo(fileWriter, iProject, "Interaction");
            DataReporter.printInfo(fileWriter, iProject, "Actor");
            DataReporter.printInfo(fileWriter, iProject, "Lifeline");
            DataReporter.printInfo(fileWriter, iProject, "Message");
            DataReporter.printInfo(fileWriter, iProject, "CombinedFragment");
            DataReporter.printInfo(fileWriter, iProject, "DestroyAction");
            DataReporter.printInfo(fileWriter, iProject, "InvocationNode");
            DataReporter.printInfo(fileWriter, iProject, "MultiFlow");
            DataReporter.printInfo(fileWriter, iProject, "JoinForkNode");
            DataReporter.printInfo(fileWriter, iProject, "ComplexActivityGroup");
            DataReporter.printInfo(fileWriter, iProject, "InitialNode");
            DataReporter.printInfo(fileWriter, iProject, "ActivityFinalNode");
            DataReporter.printInfo(fileWriter, iProject, "FlowFinalNode");
            DataReporter.printInfo(fileWriter, iProject, "ParameterUsageNode");
            DataReporter.printInfo(fileWriter, iProject, "DataStoreNode");
            DataReporter.printInfo(fileWriter, iProject, "SignalNode");
            DataReporter.printInfo(fileWriter, iProject, "ActivityPartition");
            DataReporter.printInfo(fileWriter, iProject, "DecisionMergeNode");
            DataReporter.printInfo(fileWriter, iProject, "UseCase");
            DataReporter.printInfo(fileWriter, iProject, "Include");
            DataReporter.printInfo(fileWriter, iProject, "Extend");
            DataReporter.printInfo(fileWriter, iProject, "State");
            DataReporter.printInfo(fileWriter, iProject, "PseudoState");
            DataReporter.printInfo(fileWriter, iProject, "FinalState");
            DataReporter.printInfo(fileWriter, iProject, "Transition");
            DataReporter.printInfo(fileWriter, iProject, "InitialState");
            DataReporter.printInfo(fileWriter, iProject, "Component");
            DataReporter.printInfo(fileWriter, iProject, "MessageConnector");
            DataReporter.printInfo(fileWriter, iProject, "Comment");
            DataReporter.printInfo(fileWriter, iProject, "Graphic");
            DataReporter.printInfo(fileWriter, iProject, "Association");
            DataReporter.printInfo(fileWriter, iProject, "Aggregation");
            DataReporter.printInfo(fileWriter, iProject, "Generalization");
            DataReporter.printInfo(fileWriter, iProject, "Implementation");
            DataReporter.printInfo(fileWriter, iProject, "Dependency");
            DataReporter.printInfo(fileWriter, iProject, "Realize");
            DataReporter.printInfo(fileWriter, iProject, "Usage");
            DataReporter.printInfo(fileWriter, iProject, "Permission");
            DataReporter.printInfo(fileWriter, iProject, "Abstraction");
            DataReporter.printInfo(fileWriter, iProject, "Derivation");
            DataReporter.reportComplete(fileWriter);
        }
    }

    protected static void printProjectXMIVersionDetails(FileWriter fileWriter, IProject iProject) {
        Node node;
        if (iProject != null && (node = iProject.getNode()) != null) {
            Node node2 = null;
            try {
                node2 = node.selectSingleNode("ancestor::XMI/@xmi.version");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (node2 != null) {
                DataReporter.printLine(fileWriter, "XMI Version: " + node2.getText());
            }
            Node node3 = null;
            try {
                node3 = node.selectSingleNode("ancestor::XMI//XMI.metamodel/@xmi.version");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (node3 != null) {
                DataReporter.printLine(fileWriter, "XMI.metamodel Version: " + node3.getText());
            }
        }
    }

    protected static void printInfo(FileWriter fileWriter, INamespace iNamespace, String string) {
        ElementLocator elementLocator = new ElementLocator();
        ETList<IElement> eTList = elementLocator.findElementsByQuery(iNamespace, "//UML:" + string);
        int n = eTList.getCount();
        if (n > 0) {
            DataReporter.printLine(fileWriter, PRINT_LINE80);
            DataReporter.printLine(fileWriter, "Total " + string + " elements found: " + n);
            DataReporter.printLine(fileWriter, PRINT_LINE80);
        }
        for (int i = 0; i < n; ++i) {
            IElement iElement = eTList.item(i);
            DataReporter.printLine(fileWriter, string + " " + String.valueOf(i + 1));
            DataReporter.printAllElementDetails(fileWriter, 0, iElement);
            if (string.equals("Class") || string.equals("UseCase") || string.equals("Actor") || string.equals("Interface") || string.equals("DataType") || string.equals("AliasedType") || string.equals("DerivationClassifier")) {
                DataReporter.printAllClassifierDetails(fileWriter, 0, (IClassifier)iElement);
            } else if (string.equals("Association") || string.equals("Aggregation")) {
                DataReporter.printAssociationDetails(fileWriter, 0, (IAssociation)iElement);
            } else if (string.equals("Generalization")) {
                DataReporter.printGenLinkDetails(fileWriter, 0, (IGeneralization)iElement);
            } else if (string.equals("Implementation")) {
                DataReporter.printImplementationLinkDetails(fileWriter, 0, (IImplementation)iElement);
            } else if (string.equals("Dependency") || string.equals("Realize") || string.equals("Usage") || string.equals("Permission") || string.equals("Abstraction")) {
                DataReporter.printDependencyDetails(fileWriter, 0, (IDependency)iElement);
            } else if (string.equals("Comment")) {
                DataReporter.printCommentDetails(fileWriter, 0, (IComment)iElement);
            } else if (string.equals("CombinedFragment")) {
                DataReporter.printCfragDetails(fileWriter, 0, (ICombinedFragment)iElement);
            } else if (string.equals("Lifeline")) {
                DataReporter.printLifeLineDetails(fileWriter, 0, (ILifeline)iElement);
            } else if (string.equals("UseCase")) {
                DataReporter.printUseCaseDetails(fileWriter, 0, (IUseCase)iElement);
            } else if (string.equals("State")) {
                DataReporter.printStateDetails(fileWriter, 0, (IState)iElement);
            } else if (string.equals("Message")) {
                DataReporter.printMessageDetails(fileWriter, 0, (IMessage)iElement);
            } else if (string.equals("MessageConnector")) {
                DataReporter.printConnectorDetails(fileWriter, 0, (IMessageConnector)iElement);
            } else if (string.equals("Artifact")) {
                DataReporter.printArtifactDetails(fileWriter, 0, (IArtifact)iElement);
            } else if (string.equals("AssociationClass")) {
                DataReporter.printAssociationClassDetails(fileWriter, 0, (IAssociationClass)iElement);
            } else if (string.equals("MultiFlow")) {
                DataReporter.printMultiFlowDetails(fileWriter, 0, (IMultiFlow)iElement);
            } else if (string.equals("ActivityPartition")) {
                DataReporter.printPartitionDetails(fileWriter, 0, (IActivityPartition)iElement);
            } else if (string.equals("Component")) {
                DataReporter.printComponentDetails(fileWriter, 0, (IComponent)iElement);
            } else if (string.equals("Include")) {
                DataReporter.printIncludeDetails(fileWriter, 0, (IInclude)iElement);
            } else if (string.equals("Extend")) {
                DataReporter.printExtendDetails(fileWriter, 0, (IExtend)iElement);
            } else if (string.equals("Derivation")) {
                DataReporter.printDerivationDetails(fileWriter, 0, (IDerivation)iElement);
            }
            DataReporter.printLine(fileWriter, PRINT_LINE80EL);
        }
    }

    protected static void printAllElementDetails(FileWriter fileWriter, int n, IElement iElement) {
        Object object;
        Object object2;
        INamedElement iNamedElement;
        String string = "";
        ProxyDiagramManager proxyDiagramManager = ProxyDiagramManager.instance();
        INamedElement iNamedElement2 = iNamedElement = iElement instanceof INamedElement ? (INamedElement)iElement : null;
        if (iNamedElement != null) {
            ETList<IProxyDiagram> eTList;
            ETList<IReference> eTList2;
            INamedElement iNamedElement3;
            int n2;
            int n3;
            ETList<IReference> eTList3;
            Object object3;
            int n4;
            int n5;
            DataReporter.printLine(fileWriter, n, "Name: " + iNamedElement.getName());
            DataReporter.printLine(fileWriter, n, "Qual Name: " + iNamedElement.getQualifiedName());
            DataReporter.printLine(fileWriter, n, "Alias: " + iNamedElement.getAlias());
            DataReporter.printVisibility(fileWriter, n, iNamedElement);
            ETList<IElement> eTList4 = iElement.getAssociatedArtifacts();
            if (eTList4 != null && eTList4.getCount() > 0) {
                n5 = eTList4.getCount();
                DataReporter.printLine(fileWriter, n, "Associated Artifact Count:  " + String.valueOf(n5));
                for (n4 = 0; n4 < n5; ++n4) {
                    object3 = (IArtifact)eTList4.item(n4);
                    if (object3 == null) continue;
                    DataReporter.printLine(fileWriter, n + 2, "Associated Artifact  " + String.valueOf(n4 + 1));
                    DataReporter.printLine(fileWriter, n + 4, "File name: " + object3.getFileName());
                }
            }
            if ((eTList3 = iElement.getReferencingReferences()) != null && eTList3.getCount() > 0) {
                n5 = eTList3.getCount();
                DataReporter.printLine(fileWriter, n, "Referencing Element Count:  " + String.valueOf(n5));
                for (n4 = 0; n4 < n5; ++n4) {
                    IReference iReference = eTList3.item(n4);
                    if (iReference == null || (object3 = iReference.getTargets()) == null) continue;
                    n3 = object3.getCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        iNamedElement3 = (INamedElement)object3.item(n2);
                        if (iNamedElement3 == null) continue;
                        DataReporter.printLine(fileWriter, n + 2, "Element " + String.valueOf(n4 + 1));
                        DataReporter.printLine(fileWriter, n + 4, "Name: " + iNamedElement3.getName());
                        DataReporter.printLine(fileWriter, n + 4, "Type: " + iNamedElement3.getElementType());
                    }
                }
            }
            if ((eTList2 = iElement.getReferredReferences()) != null && eTList2.getCount() > 0) {
                n5 = eTList2.getCount();
                DataReporter.printLine(fileWriter, n, "Referred Element Count:  " + n5);
                for (n4 = 0; n4 < n5; ++n4) {
                    IReference iReference = eTList2.item(n4);
                    if (iReference == null || (object3 = iReference.getSources()) == null) continue;
                    n3 = object3.getCount();
                    for (n2 = 0; n2 < n3; ++n2) {
                        iNamedElement3 = (INamedElement)object3.item(n2);
                        if (iNamedElement3 == null) continue;
                        DataReporter.printLine(fileWriter, n + 2, "Element " + (n4 + 1));
                        DataReporter.printLine(fileWriter, n + 4, "Name: " + iNamedElement3.getName());
                        DataReporter.printLine(fileWriter, n + 4, "Type: " + iNamedElement3.getElementType());
                    }
                }
            }
            if ((eTList = proxyDiagramManager.getAssociatedDiagramsForElement(iElement)) != null && eTList.getCount() > 0) {
                n5 = eTList.getCount();
                DataReporter.printLine(fileWriter, n, "Associated Diagram Count:  " + String.valueOf(n5));
                for (n4 = 0; n4 < n5; ++n4) {
                    IProxyDiagram iProxyDiagram = eTList.item(n4);
                    if (iProxyDiagram == null) continue;
                    DataReporter.printLine(fileWriter, n + 2, "Associated Diagram " + String.valueOf(n4 + 1));
                    DataReporter.printLine(fileWriter, n + 4, "Name: " + iProxyDiagram.getName());
                    DataReporter.printLine(fileWriter, n + 4, "Type: " + iProxyDiagram.getDiagramKindName());
                }
            }
            if ((object2 = iNamedElement.getClientDependencies()) != null && object2.getCount() > 0) {
                DataReporter.printLine(fileWriter, n, "Client Dependencies: " + String.valueOf(object2.getCount()));
            }
            if ((object = iNamedElement.getSupplierDependencies()) != null && object.getCount() > 0) {
                DataReporter.printLine(fileWriter, n, "Supplier Dependencies: " + String.valueOf(object.getCount()));
            }
        }
        if (((String)(object2 = iElement.getDocumentation())).length() > 0) {
            DataReporter.printLine(fileWriter, n, "Documention: " + iElement.getDocumentation());
        }
        if (((String)(object = iElement.getAppliedStereotypesAsString(false))).length() > 0) {
            DataReporter.printLine(fileWriter, n, "Stereotype: " + iElement.getAppliedStereotypesAsString(false));
        }
        DataReporter.printTaggedValues(fileWriter, n, iElement);
        DataReporter.printConstraints(fileWriter, n, iElement);
    }

    protected static void printTemplateParameterDetails(FileWriter fileWriter, int n, IClassifier iClassifier) {
        ETList<IParameterableElement> eTList;
        if (iClassifier != null && (eTList = iClassifier.getTemplateParameters()) != null && eTList.getCount() > 0) {
            int n2 = eTList.getCount();
            DataReporter.printLine(fileWriter, n, "Parameter Count: " + String.valueOf(n2));
            for (int i = 0; i < n2; ++i) {
                String string;
                IParameterableElement iParameterableElement = eTList.item(i);
                if (iParameterableElement == null) continue;
                DataReporter.printLine(fileWriter, n, "Parameter " + String.valueOf(i + 1));
                DataReporter.printAllElementDetails(fileWriter, n + 2, iParameterableElement);
                IParameterableElement iParameterableElement2 = iParameterableElement.getDefaultElement();
                if (iParameterableElement2 != null) {
                    DataReporter.printLine(fileWriter, n + 2, "Default Element: " + iParameterableElement2.getName());
                }
                if ((string = iParameterableElement.getTypeConstraint()).length() <= 0) continue;
                DataReporter.printLine(fileWriter, n + 2, "Type Constraint: " + string);
            }
        }
    }

    protected static void printAllClassifierDetails(FileWriter fileWriter, int n, IClassifier iClassifier) {
        ETList<IAssociation> eTList;
        ETList<IDependency> eTList2;
        int n2;
        DataReporter.printLine(fileWriter, n, "Leaf: " + DataReporter.reportBoolean(iClassifier.getIsLeaf()));
        DataReporter.printLine(fileWriter, n, "Transient: " + DataReporter.reportBoolean(iClassifier.getIsTransient()));
        DataReporter.printLine(fileWriter, n, "Abstract: " + DataReporter.reportBoolean(iClassifier.getIsAbstract()));
        IClassifier iClassifier2 = iClassifier;
        DataReporter.printLine(fileWriter, n, "Final: " + DataReporter.reportBoolean(iClassifier2.getIsFinal()));
        ETList<IElement> eTList3 = iClassifier.getSourceFiles();
        if (eTList3 != null) {
            int n3 = eTList3.getCount();
            for (n2 = 0; n2 < n3; ++n2) {
                ISourceFileArtifact iSourceFileArtifact = (ISourceFileArtifact)eTList3.item(n2);
                if (iSourceFileArtifact == null) continue;
                DataReporter.printLine(fileWriter, n, "Source Filename: " + iSourceFileArtifact.getShortName());
                DataReporter.printLine(fileWriter, n, "Source Path: " + iSourceFileArtifact.getSourceFile());
            }
        }
        if ((eTList2 = iClassifier.getClientDependencies()) != null && (n2 = eTList2.getCount()) > 0) {
            for (int i = 0; i < n2; ++i) {
                INamedElement iNamedElement;
                IDependency iDependency = eTList2.item(i);
                if (iDependency == null || (iNamedElement = iDependency.getSupplier()) == null) continue;
                DataReporter.printLine(fileWriter, n, "Dependency " + String.valueOf(i + 1) + ": " + iNamedElement.getFullyQualifiedName(false));
            }
        }
        if ((eTList = iClassifier.getAssociations()) != null) {
            int n4;
            ETList<IGeneralization> eTList4;
            int n5;
            ETList<IImplementation> eTList5;
            IRedefinableElement iRedefinableElement;
            INamedElement iNamedElement;
            Object object;
            int n6 = eTList.getCount();
            if (n6 > 0) {
                for (int i = 0; i < n6; ++i) {
                    IAssociationEnd iAssociationEnd;
                    IAssociation iAssociation = eTList.item(i);
                    if (iAssociation == null || (object = iAssociation.getEnds()) == null || (iAssociationEnd = object.item(0)) == null || (iNamedElement = iAssociationEnd.getType()) == null) continue;
                    if (iNamedElement.getFullyQualifiedName(false).equals(iClassifier.getFullyQualifiedName(false))) {
                        IClassifier iClassifier3;
                        iRedefinableElement = (IAssociationEnd)object.item(1);
                        if (iRedefinableElement == null || (iClassifier3 = iRedefinableElement.getType()) == null) continue;
                        DataReporter.printLine(fileWriter, n, "Association " + String.valueOf(i + 1) + " references: " + iClassifier3.getFullyQualifiedName(false));
                        continue;
                    }
                    DataReporter.printLine(fileWriter, n, "Association " + String.valueOf(i + 1) + " referenced by: " + iNamedElement.getFullyQualifiedName(false));
                }
            }
            if ((eTList5 = iClassifier.getImplementations()) != null && (n5 = eTList5.getCount()) > 0) {
                for (int i = 0; i < n5; ++i) {
                    object = eTList5.item(i);
                    if (object == null || (iNamedElement = object.getSupplier()) == null) continue;
                    DataReporter.printLine(fileWriter, n, "Implements " + String.valueOf(i + 1) + ": " + iNamedElement.getFullyQualifiedName(false));
                }
            }
            if ((eTList4 = iClassifier.getGeneralizations()) != null && (n4 = eTList4.getCount()) > 0) {
                for (int i = 0; i < n4; ++i) {
                    IGeneralization iGeneralization = eTList4.item(i);
                    if (iGeneralization == null || (iRedefinableElement = iGeneralization.getGeneral()) == null) continue;
                    DataReporter.printLine(fileWriter, n, "Extends " + String.valueOf(i + 1) + ": " + iRedefinableElement.getFullyQualifiedName(false));
                }
            }
            DataReporter.printAttributeDetail(fileWriter, n, iClassifier);
            DataReporter.printOperationDetail(fileWriter, n, iClassifier);
            DataReporter.printTemplateParameterDetails(fileWriter, n, iClassifier);
        }
    }

    protected static void printAttributeDetail(FileWriter fileWriter, int n, IClassifier iClassifier) {
        String string = "";
        ETList<IAttribute> eTList = iClassifier.getAttributes();
        int n2 = eTList.getCount();
        if (n2 > 0) {
            DataReporter.printLine(fileWriter, n, "ATTRIBUTES");
            for (int i = 0; i < n2; ++i) {
                IAttribute iAttribute = eTList.item(i);
                DataReporter.printLine(fileWriter, n + 1, "Attribute " + String.valueOf(i + 1));
                DataReporter.printAllElementDetails(fileWriter, n + 2, iAttribute);
                DataReporter.printLine(fileWriter, n + 2, "TypeName: " + iAttribute.getTypeName());
                DataReporter.printLine(fileWriter, n + 2, "Default: " + iAttribute.getDefault2());
                IMultiplicity iMultiplicity = iAttribute.getMultiplicity();
                ETList<IMultiplicityRange> eTList2 = iMultiplicity.getRanges();
                int n3 = eTList2.getCount();
                if (n3 > 0) {
                    for (int j = 0; j < n3; ++j) {
                        IMultiplicityRange iMultiplicityRange = eTList2.item(j);
                        DataReporter.printLine(fileWriter, n + 2, "Attribute Multiplicity" + String.valueOf(j) + ": " + iMultiplicityRange.getLower() + ".." + iMultiplicityRange.getUpper());
                    }
                }
                DataReporter.printLine(fileWriter, n + 2, "Final: " + DataReporter.reportBoolean(iAttribute.getIsFinal()));
                DataReporter.printLine(fileWriter, n + 2, "Static: " + DataReporter.reportBoolean(iAttribute.getIsStatic()));
                DataReporter.printLine(fileWriter, n + 2, "Transient: " + DataReporter.reportBoolean(iAttribute.getIsTransient()));
                DataReporter.printLine(fileWriter, n + 2, "Volatile: " + DataReporter.reportBoolean(iAttribute.getIsVolatile()));
                DataReporter.printClientChangeability(fileWriter, n + 2, iAttribute);
                DataReporter.printLine(fileWriter, n + 2, "Derived: " + DataReporter.reportBoolean(iAttribute.getIsDerived()));
            }
        }
    }

    protected static void printOperationDetail(FileWriter fileWriter, int n, IClassifier iClassifier) {
        String string = "";
        ETList<IOperation> eTList = iClassifier.getOperations();
        int n2 = eTList.getCount();
        if (n2 > 0) {
            DataReporter.printLine(fileWriter, n, "OPERATIONS");
            for (int i = 0; i < n2; ++i) {
                int n3;
                ETList<IClassifier> eTList2;
                int n4;
                ETList<IElement> eTList3;
                IOperation iOperation = eTList.item(i);
                DataReporter.printLine(fileWriter, n + 1, "Operation " + String.valueOf(i + 1));
                DataReporter.printAllElementDetails(fileWriter, n + 2, iOperation);
                DataReporter.printLine(fileWriter, n + 2, "Return Type: " + iOperation.getReturnType2());
                IParameter iParameter = iOperation.getReturnType();
                if (iParameter != null && (eTList3 = iParameter.getMultiplicity().getRanges()).getCount() > 0) {
                    IMultiplicityRange iMultiplicityRange = (IMultiplicityRange)eTList3.item(0);
                    DataReporter.printLine(fileWriter, n + 2, "Return Type Multiplicity: " + iMultiplicityRange.getLower() + ".." + iMultiplicityRange.getUpper());
                }
                eTList3 = iOperation.getParameters();
                int n5 = eTList3.getCount();
                DataReporter.printLine(fileWriter, n + 2, "Param Count:  " + n5);
                if (n5 > 0) {
                    for (int j = 0; j < n5; ++j) {
                        ETList<IMultiplicityRange> eTList4;
                        IParameter iParameter2 = (IParameter)eTList3.item(j);
                        DataReporter.printLine(fileWriter, n + 2, "Param " + String.valueOf(j) + " name: " + iParameter2.getName());
                        DataReporter.printLine(fileWriter, n + 2, "Param " + String.valueOf(j) + " type: " + iParameter2.getTypeName());
                        if (iParameter2.getDefault2().length() > 0) {
                            DataReporter.printLine(fileWriter, n + 2, "Param " + String.valueOf(j) + " default value: " + iParameter2.getDefault2());
                        }
                        if ((n4 = (eTList4 = iParameter2.getMultiplicity().getRanges()).getCount()) <= 0) continue;
                        for (int k = 0; k < n4; ++k) {
                            IMultiplicityRange iMultiplicityRange = eTList4.item(k);
                            DataReporter.printLine(fileWriter, n, "Parameter" + String.valueOf(j) + " Multiplicity" + String.valueOf(k) + ": " + iMultiplicityRange.getLower() + ".." + iMultiplicityRange.getUpper());
                        }
                    }
                }
                if ((eTList2 = iOperation.getRaisedExceptions()) != null && (n3 = eTList2.getCount()) > 0) {
                    DataReporter.printLine(fileWriter, n + 2, "RaisedExceptions Count: " + n3);
                    for (n4 = 0; n4 < n3; ++n4) {
                        IClassifier iClassifier2 = eTList2.item(n4);
                        DataReporter.printLine(fileWriter, n + 4, "Exception " + (n4 + 1));
                        DataReporter.printLine(fileWriter, n + 7, "Classifier: " + iClassifier2.getName());
                        DataReporter.printLine(fileWriter, n + 7, "Type: " + iClassifier2.getElementType());
                    }
                }
                DataReporter.printLine(fileWriter, n + 2, "Abstract: " + DataReporter.reportBoolean(iOperation.getIsAbstract()));
                DataReporter.printLine(fileWriter, n + 2, "Final: " + DataReporter.reportBoolean(iOperation.getIsFinal()));
                DataReporter.printLine(fileWriter, n + 2, "Static: " + DataReporter.reportBoolean(iOperation.getIsStatic()));
                DataReporter.printLine(fileWriter, n + 2, "Native: " + DataReporter.reportBoolean(iOperation.getIsNative()));
                DataReporter.printLine(fileWriter, n + 2, "StrictFTP: " + DataReporter.reportBoolean(iOperation.getIsNative()));
                if (iOperation.getIsSubroutine()) {
                    DataReporter.printLine(fileWriter, n + 2, "Subroutine: " + DataReporter.reportBoolean(iOperation.getIsSubroutine()));
                }
                if (iOperation.getIsProperty()) {
                    DataReporter.printLine(fileWriter, n + 2, "Property: " + DataReporter.reportBoolean(iOperation.getIsProperty()));
                }
                if (iOperation.getIsFriend()) {
                    DataReporter.printLine(fileWriter, n + 2, "Friend: " + DataReporter.reportBoolean(iOperation.getIsFriend()));
                }
                switch (iOperation.getConcurrency()) {
                    case 2: {
                        string = "Concurrent";
                        break;
                    }
                    case 1: {
                        string = "Guarded";
                        break;
                    }
                    case 0: {
                        string = "Sequential";
                    }
                }
                DataReporter.printLine(fileWriter, n + 2, "Concurrency: " + string);
                DataReporter.printLine(fileWriter, n + 2, "Query: " + DataReporter.reportBoolean(iOperation.getIsQuery()));
            }
        }
    }

    protected static void printArtifactDetails(FileWriter fileWriter, int n, IArtifact iArtifact) {
        DataReporter.printLine(fileWriter, n, "File name: " + iArtifact.getFileName());
    }

    protected static void printDerivationDetails(FileWriter fileWriter, int n, IDerivation iDerivation) {
        IDerivation iDerivation2;
        if (iDerivation != null && (iDerivation2 = iDerivation) != null) {
            IClassifier iClassifier;
            IElement iElement;
            int n2;
            ETList<IUMLBinding> eTList = iDerivation.getBindings();
            if (eTList != null && (n2 = eTList.getCount()) > 0) {
                DataReporter.printLine(fileWriter, n, "Binding Count: " + n2);
                for (int i = 0; i < n2; ++i) {
                    IParameterableElement iParameterableElement;
                    IParameterableElement iParameterableElement2;
                    iElement = eTList.item(i);
                    if (iElement == null) continue;
                    DataReporter.printLine(fileWriter, n + 2, "Binding " + String.valueOf(i + 1));
                    if (iElement instanceof IElement) {
                        DataReporter.printAllElementDetails(fileWriter, n + 4, iElement);
                    }
                    if ((iParameterableElement2 = iElement.getFormal()) == null || (iParameterableElement = iParameterableElement2) != null) {
                        // empty if block
                    }
                    if ((iParameterableElement2 = iElement.getActual()) != null && (iParameterableElement = iParameterableElement2) == null) continue;
                }
            }
            if ((iClassifier = iDerivation.getTemplate()) != null) {
                // empty if block
            }
            if ((iElement = iDerivation.getDerivedClassifier()) != null) {
                // empty if block
            }
        }
    }

    protected static void printPartitionDetails(FileWriter fileWriter, int n, IActivityPartition iActivityPartition) {
        ETList<IActivityNode> eTList;
        if (iActivityPartition != null && (eTList = iActivityPartition.getNodeContents()) != null) {
            int n2 = eTList.getCount();
            if (n2 > 0) {
                DataReporter.printLine(fileWriter, n, "Contained Element Count:  " + n2);
            }
            for (int i = 0; i < n2; ++i) {
                INamedElement iNamedElement = eTList.item(i);
                DataReporter.printLine(fileWriter, n + 2, "Contained Element  " + String.valueOf(i + 1));
                if (iNamedElement == null) continue;
                DataReporter.printLine(fileWriter, n + 4, "Name: " + iNamedElement.getName());
                DataReporter.printLine(fileWriter, n + 4, "Type: " + iNamedElement.getElementType());
            }
        }
    }

    protected static void printComponentDetails(FileWriter fileWriter, int n, IComponent iComponent) {
        ETList<IPort> eTList;
        if (iComponent != null && (eTList = iComponent.getExternalInterfaces()) != null) {
            int n2 = eTList.getCount();
            if (n2 > 0) {
                DataReporter.printLine(fileWriter, n, "Port Count:  " + n2);
            }
            for (int i = 0; i < n2; ++i) {
                IPort iPort = eTList.item(i);
                if (iPort == null) continue;
                DataReporter.printLine(fileWriter, n + 2, "Port  " + String.valueOf(i + 1));
                DataReporter.printLine(fileWriter, n + 4, "Name: " + iPort.getName());
                ETList<IInterface> eTList2 = iPort.getProvidedInterfaces();
                if (eTList2 == null) continue;
                int n3 = eTList2.getCount();
                DataReporter.printLine(fileWriter, n + 4, "Provided Interface Count:  " + n3);
                for (int j = 0; j < n3; ++j) {
                    IInterface iInterface = eTList2.item(j);
                    if (iInterface == null) continue;
                    DataReporter.printLine(fileWriter, n + 6, "Interface  " + String.valueOf(j + 1));
                    DataReporter.printLine(fileWriter, n + 6, "Name: " + iInterface.getName());
                }
            }
        }
    }

    protected static void printAssociationClassDetails(FileWriter fileWriter, int n, IAssociationClass iAssociationClass) {
        if (iAssociationClass != null) {
            DataReporter.printAssociationDetails(fileWriter, n, iAssociationClass);
        }
    }

    protected static void printUseCaseDetails(FileWriter fileWriter, int n, IUseCase iUseCase) {
        String string = "";
        String string2 = "";
        ETList<IUseCaseDetail> eTList = iUseCase.getDetails();
        int n2 = eTList.getCount();
        if (n2 > 0) {
            DataReporter.printLine(fileWriter, n, "Use case details count: " + n2);
            for (int i = 0; i < n2; ++i) {
                IUseCaseDetail iUseCaseDetail = eTList.item(i);
                DataReporter.printLine(fileWriter, n + 2, "Use case Detail Value" + String.valueOf(i + 1));
                DataReporter.printLine(fileWriter, n + 4, "name: " + iUseCaseDetail.getName());
                DataReporter.printLine(fileWriter, n + 4, "alias: " + iUseCaseDetail.getAlias());
                DataReporter.printVisibility(fileWriter, n + 4, iUseCaseDetail);
                DataReporter.printLine(fileWriter, n + 4, "Stereotype: " + iUseCaseDetail.getAppliedStereotypesAsString(false));
                DataReporter.printTaggedValues(fileWriter, n + 4, iUseCaseDetail);
                DataReporter.printLine(fileWriter, n + 4, "Documentation: " + iUseCaseDetail.getDocumentation());
                DataReporter.printConstraints(fileWriter, n + 4, iUseCaseDetail);
                DataReporter.printLine(fileWriter, n + 4, "Body: " + iUseCaseDetail.getBody());
                ETList<IUseCaseDetail> eTList2 = iUseCaseDetail.getSubDetails();
                int n3 = eTList2.getCount();
                if (n3 <= 0) continue;
                DataReporter.printLine(fileWriter, n + 4, "Use case sub details count: " + n3);
                for (int j = 0; j < n3; ++j) {
                    IUseCaseDetail iUseCaseDetail2 = eTList2.item(j);
                    DataReporter.printLine(fileWriter, n + 6, "Use case void Detail Value" + String.valueOf(j + 1));
                    DataReporter.printLine(fileWriter, n + 8, "name: " + iUseCaseDetail2.getName());
                    DataReporter.printLine(fileWriter, n + 8, "alias: " + iUseCaseDetail2.getAlias());
                    DataReporter.printVisibility(fileWriter, n + 8, iUseCaseDetail2);
                    DataReporter.printLine(fileWriter, n + 8, "Stereotype: " + iUseCaseDetail2.getAppliedStereotypesAsString(false));
                    DataReporter.printTaggedValues(fileWriter, n + 8, iUseCaseDetail2);
                    DataReporter.printLine(fileWriter, n + 8, "Documentation: " + iUseCaseDetail2.getDocumentation());
                    DataReporter.printConstraints(fileWriter, n + 8, iUseCaseDetail2);
                    DataReporter.printLine(fileWriter, n + 8, "Body: " + iUseCaseDetail2.getBody());
                }
            }
        }
    }

    protected static void printIncludeDetails(FileWriter fileWriter, int n, IInclude iInclude) {
        if (iInclude != null) {
            IUseCase iUseCase;
            IUseCase iUseCase2 = iInclude.getAddition();
            if (iUseCase2 != null) {
                DataReporter.printLine(fileWriter, n, "Addition Name: " + iUseCase2.getName());
            }
            if ((iUseCase = iInclude.getBase()) != null) {
                DataReporter.printLine(fileWriter, n, "Base Name: " + iUseCase.getName());
            }
        }
    }

    protected static void printExtendDetails(FileWriter fileWriter, int n, IExtend iExtend) {
        if (iExtend != null) {
            IUseCase iUseCase;
            IUseCase iUseCase2 = iExtend.getBase();
            if (iUseCase2 != null) {
                DataReporter.printLine(fileWriter, n, "Base Name: " + iUseCase2.getName());
            }
            if ((iUseCase = iExtend.getExtension()) != null) {
                DataReporter.printLine(fileWriter, n, "Extension Name: " + iUseCase.getName());
            }
        }
    }

    protected static void printStateDetails(FileWriter fileWriter, int n, IState iState) {
        if (iState != null) {
            DataReporter.printLine(fileWriter, n, "Is Composite: " + DataReporter.reportBoolean(iState.getIsComposite()));
            DataReporter.printLine(fileWriter, n, "Is Orthogonal: " + DataReporter.reportBoolean(iState.getIsOrthogonal()));
        }
    }

    protected static void printLifeLineDetails(FileWriter fileWriter, int n, ILifeline iLifeline) {
        DataReporter.printLine(fileWriter, n, "Type: " + iLifeline.getElementType());
        if (iLifeline.getRepresentingClassifier() != null) {
            IClass iClass;
            DataReporter.printLine(fileWriter, n, "RepresentingClassifier: " + iLifeline.getRepresentingClassifier().getName());
            if (iLifeline.getRepresentingClassifier().getElementType().equalsIgnoreCase("CLASS") && (iClass = (IClass)iLifeline.getRepresentingClassifier()) != null) {
                DataReporter.printLine(fileWriter, n + 2, "Active: " + DataReporter.reportBoolean(iClass.getIsActive()));
                ETList<IPart> eTList = iClass.getParts();
                if (eTList != null) {
                    int n2 = eTList.getCount();
                    for (int i = 0; i < n2; ++i) {
                        IPart iPart = eTList.item(i);
                        if (iPart == null) continue;
                        DataReporter.printLine(fileWriter, n + 2, "Part:  " + String.valueOf(i + 1));
                        DataReporter.printLine(fileWriter, n + 4, "Transient: " + DataReporter.reportBoolean(iPart.getIsTransient()));
                        DataReporter.printLine(fileWriter, n + 4, "Static: " + DataReporter.reportBoolean(iPart.getIsStatic()));
                    }
                }
            }
        }
    }

    protected static void printMessageDetails(FileWriter fileWriter, int n, IMessage iMessage) {
        String string = "";
        if (iMessage != null) {
            int n2 = iMessage.getKind();
            switch (n2) {
                case 1: {
                    string = "synchronous";
                    break;
                }
                case 0: {
                    string = "create";
                    break;
                }
                case 3: {
                    string = "result";
                    break;
                }
                case 2: {
                    string = "asynchronous";
                    break;
                }
                case -1: {
                    string = "unknown";
                }
            }
            DataReporter.printLine(fileWriter, n, "Message Type: " + string);
            DataReporter.printLine(fileWriter, n, "Message Number: " + iMessage.getAutoNumber());
            if (iMessage.getOperationInvoked() != null) {
                IElement iElement;
                ETList<IElement> eTList;
                int n3;
                IParameter iParameter;
                IOperation iOperation = iMessage.getOperationInvoked();
                DataReporter.printLine(fileWriter, n, "Operation Invoked name: " + iOperation.getName());
                String string2 = iOperation.getReturnType2();
                if (string2.length() > 0) {
                    DataReporter.printLine(fileWriter, n, "Operation Invoked type: " + string2);
                }
                if ((iParameter = iOperation.getReturnType()) != null && (n3 = (eTList = iParameter.getMultiplicity().getRanges()).getCount()) > 0) {
                    for (int i = 0; i < n3; ++i) {
                        iElement = (IMultiplicityRange)eTList.item(i);
                        DataReporter.printLine(fileWriter, n, "Operation Invoked Multiplicity" + String.valueOf(i) + ": " + iElement.getLower() + ".." + iElement.getUpper());
                    }
                }
                if ((eTList = iMessage.getOperationInvoked().getParameters()) != null) {
                    n3 = eTList.getCount();
                    DataReporter.printLine(fileWriter, n, "Operation Invoked Parameter Count:  " + n3);
                    for (int i = 0; i < n3; ++i) {
                        ETList<IMultiplicityRange> eTList2;
                        int n4;
                        DataReporter.printLine(fileWriter, n + 2, "Parameter  " + String.valueOf(i + 1));
                        iElement = (IParameter)eTList.item(i);
                        DataReporter.printLine(fileWriter, n + 4, " name: " + iElement.getName());
                        IClassifier iClassifier = iElement.getType();
                        if (iClassifier != null) {
                            DataReporter.printLine(fileWriter, n + 4, " type: " + iClassifier.getName());
                        }
                        if ((n4 = (eTList2 = iElement.getMultiplicity().getRanges()).getCount()) <= 0) continue;
                        for (int j = 0; j < n4; ++j) {
                            IMultiplicityRange iMultiplicityRange = eTList2.item(j);
                            DataReporter.printLine(fileWriter, n + 4, "multiplicity" + String.valueOf(j) + ": " + iMultiplicityRange.getLower() + ".." + iMultiplicityRange.getUpper());
                        }
                    }
                }
            }
            if (iMessage.getReceivingLifeline() != null) {
                DataReporter.printLine(fileWriter, n, "Receiving Lifeline: " + iMessage.getReceivingLifeline().getName());
            }
            if (iMessage.getSendingLifeline() != null) {
                DataReporter.printLine(fileWriter, n, "Sending Lifeline: " + iMessage.getSendingLifeline().getName());
            }
            if (iMessage.getReceivingClassifier() != null) {
                DataReporter.printLine(fileWriter, n, "Receiving Classifier: " + iMessage.getReceivingClassifier().getName());
            }
            if (iMessage.getSendingClassifier() != null) {
                DataReporter.printLine(fileWriter, n, "Sending Classifier: " + iMessage.getSendingClassifier().getName());
            }
        }
    }

    protected static void printCfragDetails(FileWriter fileWriter, int n, ICombinedFragment iCombinedFragment) {
        String string = "";
        switch (iCombinedFragment.getOperator()) {
            case 0: {
                string = "alt";
                break;
            }
            case 7: {
                string = "assert";
                break;
            }
            case 1: {
                string = "else";
                break;
            }
            case 4: {
                string = "loop";
                break;
            }
            case 6: {
                string = "neg";
                break;
            }
            case 2: {
                string = "opt";
                break;
            }
            case 3: {
                string = "par";
                break;
            }
            case 5: {
                string = "region";
                break;
            }
            case 8: {
                string = "seq";
                break;
            }
            case 9: {
                string = "strict";
            }
        }
        DataReporter.printLine(fileWriter, n, "CombFrag Operator: " + string);
        ETList<IInteractionOperand> eTList = iCombinedFragment.getOperands();
        int n2 = eTList.getCount();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                DataReporter.printAllElementDetails(fileWriter, n + 2, eTList.item(i));
            }
        }
    }

    protected static void printConnectorDetails(FileWriter fileWriter, int n, IConnector iConnector) {
        ETList<IConnectorEnd> eTList;
        if (iConnector != null && (eTList = iConnector.getEnds()) != null) {
            int n2 = eTList.getCount();
            for (int i = 0; i < n2; ++i) {
                IClassifier iClassifier;
                IClassifier iClassifier2;
                IPart iPart;
                IConnectorEnd iConnectorEnd = eTList.item(i);
                if (iConnectorEnd == null || (iPart = (IPart)iConnectorEnd.getPart()) == null || (iClassifier2 = iPart.getFeaturingClassifier()) == null || (iClassifier = iClassifier2) == null) continue;
                DataReporter.printLine(fileWriter, n, "End " + String.valueOf(i + 1) + " Classifier Name: " + iClassifier.getName());
                DataReporter.printLine(fileWriter, n + 2, "Type: " + iClassifier.getElementType());
            }
        }
    }

    protected static void printImplementationLinkDetails(FileWriter fileWriter, int n, IImplementation iImplementation) {
        if (iImplementation != null) {
            INamedElement iNamedElement;
            INamedElement iNamedElement2 = iImplementation.getSupplier();
            if (iNamedElement2 != null) {
                DataReporter.printLine(fileWriter, n, "Supplier: " + iNamedElement2.getFullyQualifiedName(false));
            }
            if ((iNamedElement = iImplementation.getClient()) != null) {
                DataReporter.printLine(fileWriter, n, "Client: " + iNamedElement.getFullyQualifiedName(false));
            }
        }
    }

    protected static void printGenLinkDetails(FileWriter fileWriter, int n, IGeneralization iGeneralization) {
        if (iGeneralization != null) {
            ETList<IElement> eTList;
            IClassifier iClassifier;
            IClassifier iClassifier2 = iGeneralization.getGeneral();
            if (iClassifier2 != null) {
                DataReporter.printLine(fileWriter, n, "Super: " + iGeneralization.getGeneral().getFullyQualifiedName(false));
            }
            if ((iClassifier = iGeneralization.getSpecific()) != null) {
                DataReporter.printLine(fileWriter, n, "Sub: " + iGeneralization.getSpecific().getFullyQualifiedName(false));
            }
            if ((eTList = iGeneralization.getAssociatedArtifacts()) != null) {
                int n2 = eTList.getCount();
                if (n2 > 0) {
                    DataReporter.printLine(fileWriter, n, "Associated Artifact Count:  " + n2);
                }
                for (int i = 0; i < n2; ++i) {
                    IArtifact iArtifact;
                    IElement iElement = eTList.item(i);
                    if (iElement == null || (iArtifact = (IArtifact)iElement) == null) continue;
                    DataReporter.printLine(fileWriter, n + 2, "Associated Artifact  " + String.valueOf(i + 1));
                    DataReporter.printLine(fileWriter, n + 4, "File name: " + iArtifact.getFileName());
                }
            }
        }
    }

    protected static void printAssociationDetails(FileWriter fileWriter, int n, IAssociation iAssociation) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (iAssociation != null) {
            ETList<IAssociationEnd> eTList = iAssociation.getEnds();
            int n2 = eTList.getCount();
            DataReporter.printAllClassifierDetails(fileWriter, n, iAssociation);
            DataReporter.printLine(fileWriter, n, "Association Type: " + iAssociation.getElementType());
            DataReporter.printLine(fileWriter, n, "Derived: " + DataReporter.reportBoolean(iAssociation.getIsDerived()));
            DataReporter.printLine(fileWriter, n, "Reflexive: " + DataReporter.reportBoolean(iAssociation.getIsReflexive()));
            if (iAssociation.getElementType().equals("Aggregation")) {
                for (int i = 0; i < n2; ++i) {
                    IClassifier iClassifier;
                    IAssociationEnd iAssociationEnd = eTList.item(i);
                    if (iAssociationEnd == null || (iClassifier = iAssociationEnd.getType()) == null) continue;
                    string = iClassifier.getFullyQualifiedName(false);
                    if (i == 0) {
                        DataReporter.printLine(fileWriter, n, "Start Class: " + string);
                        continue;
                    }
                    if (i == n2 - 1) {
                        DataReporter.printLine(fileWriter, n, "End Class: " + string);
                        continue;
                    }
                    DataReporter.printLine(fileWriter, n, "Middle Class: " + string);
                }
                IAggregation iAggregation = (IAggregation)iAssociation;
                if (iAggregation != null) {
                    DataReporter.printLine(fileWriter, n, "Composite: " + DataReporter.reportBoolean(iAggregation.getIsComposite()));
                    DataReporter.printLine(fileWriter, n + 2, "Aggregate End:");
                    DataReporter.printAggregateEndDetails(fileWriter, n + 4, iAggregation);
                    DataReporter.printLine(fileWriter, n + 2, "Part End:");
                    DataReporter.printPartEndDetails(fileWriter, n + 4, iAggregation);
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    IClassifier iClassifier;
                    IAssociationEnd iAssociationEnd = eTList.item(i);
                    if (iAssociationEnd == null || (iClassifier = iAssociationEnd.getType()) == null) continue;
                    string = iClassifier.getFullyQualifiedName(false);
                    if (i == 0) {
                        DataReporter.printLine(fileWriter, n, "Start Class: " + string);
                    } else if (i == n2 - 1) {
                        DataReporter.printLine(fileWriter, n, "End Class: " + string);
                    } else {
                        DataReporter.printLine(fileWriter, n, "Middle Class: " + string);
                    }
                    DataReporter.printAssociationEndDetails(fileWriter, n + 4, iAssociationEnd);
                }
            }
        }
    }

    protected static void printAssociationEndDetails(FileWriter fileWriter, int n, IAssociationEnd iAssociationEnd) {
        String string = "";
        String string2 = "";
        String string3 = "";
        DataReporter.printLine(fileWriter, n, "Name: " + iAssociationEnd.getName());
        DataReporter.printLine(fileWriter, n, "Alias: " + iAssociationEnd.getAlias());
        DataReporter.printVisibility(fileWriter, n, iAssociationEnd);
        DataReporter.printLine(fileWriter, n, "Stereotype: " + iAssociationEnd.getAppliedStereotypesAsString(false));
        DataReporter.printTaggedValues(fileWriter, n, iAssociationEnd);
        DataReporter.printConstraints(fileWriter, n, iAssociationEnd);
        DataReporter.printLine(fileWriter, n, "Final: " + DataReporter.reportBoolean(iAssociationEnd.getIsFinal()));
        DataReporter.printLine(fileWriter, n, "Static: " + DataReporter.reportBoolean(iAssociationEnd.getIsStatic()));
        DataReporter.printLine(fileWriter, n, "Transient: " + DataReporter.reportBoolean(iAssociationEnd.getIsTransient()));
        DataReporter.printLine(fileWriter, n, "Volatile: " + DataReporter.reportBoolean(iAssociationEnd.getIsVolatile()));
        DataReporter.printLine(fileWriter, n, "Type: " + iAssociationEnd.getType().getElementType());
        DataReporter.printClientChangeability(fileWriter, n, iAssociationEnd);
        string3 = iAssociationEnd.getMultiplicity().getRangeAsString(true);
        DataReporter.printLine(fileWriter, n, "Multiplicity: " + string3);
        DataReporter.printLine(fileWriter, n, "Navigable: " + DataReporter.reportBoolean(iAssociationEnd.getIsNavigable()));
        ETList<IAttribute> eTList = iAssociationEnd.getQualifiers();
        if (eTList != null) {
            DataReporter.printQualifierDetails(fileWriter, n, eTList);
        }
    }

    protected static void printAggregateEndDetails(FileWriter fileWriter, int n, IAggregation iAggregation) {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (iAggregation != null) {
            IAssociationEnd iAssociationEnd = iAggregation.getAggregateEnd();
            DataReporter.printLine(fileWriter, n, "Name: " + iAssociationEnd.getName());
            DataReporter.printLine(fileWriter, n, "Alias: " + iAssociationEnd.getAlias());
            DataReporter.printVisibility(fileWriter, n, iAssociationEnd);
            DataReporter.printLine(fileWriter, n, "Stereotype: " + iAssociationEnd.getAppliedStereotypesAsString(false));
            DataReporter.printTaggedValues(fileWriter, n, iAssociationEnd);
            DataReporter.printConstraints(fileWriter, n, iAssociationEnd);
            DataReporter.printLine(fileWriter, n, "Final: " + DataReporter.reportBoolean(iAssociationEnd.getIsFinal()));
            DataReporter.printLine(fileWriter, n, "Static: " + DataReporter.reportBoolean(iAssociationEnd.getIsStatic()));
            DataReporter.printLine(fileWriter, n, "Transient: " + DataReporter.reportBoolean(iAssociationEnd.getIsTransient()));
            DataReporter.printLine(fileWriter, n, "Volatile: " + DataReporter.reportBoolean(iAssociationEnd.getIsVolatile()));
            IClassifier iClassifier = iAssociationEnd.getType();
            if (iClassifier != null) {
                DataReporter.printLine(fileWriter, n, "Type: " + iClassifier.getElementType());
            }
            DataReporter.printClientChangeability(fileWriter, n, iAssociationEnd);
            string3 = iAssociationEnd.getMultiplicity().getRangeAsString(true);
            DataReporter.printLine(fileWriter, n, "Multiplicity: " + string3);
            DataReporter.printLine(fileWriter, n, "Navigable: " + DataReporter.reportBoolean(iAssociationEnd.getIsNavigable()));
            ETList<IAttribute> eTList = iAssociationEnd.getQualifiers();
            if (eTList != null) {
                DataReporter.printQualifierDetails(fileWriter, n, eTList);
            }
        }
    }

    protected static void printPartEndDetails(FileWriter fileWriter, int n, IAggregation iAggregation) {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (iAggregation != null) {
            IAssociationEnd iAssociationEnd = iAggregation.getPartEnd();
            DataReporter.printLine(fileWriter, n, "Name: " + iAssociationEnd.getName());
            DataReporter.printLine(fileWriter, n, "Alias: " + iAssociationEnd.getAlias());
            DataReporter.printVisibility(fileWriter, n, iAssociationEnd);
            DataReporter.printLine(fileWriter, n, "Stereotype: " + iAssociationEnd.getAppliedStereotypesAsString(false));
            DataReporter.printTaggedValues(fileWriter, n, iAssociationEnd);
            DataReporter.printConstraints(fileWriter, n, iAssociationEnd);
            DataReporter.printLine(fileWriter, n, "Final: " + DataReporter.reportBoolean(iAssociationEnd.getIsFinal()));
            DataReporter.printLine(fileWriter, n, "Static: " + DataReporter.reportBoolean(iAssociationEnd.getIsStatic()));
            DataReporter.printLine(fileWriter, n, "Transient: " + DataReporter.reportBoolean(iAssociationEnd.getIsTransient()));
            DataReporter.printLine(fileWriter, n, "Volatile: " + DataReporter.reportBoolean(iAssociationEnd.getIsVolatile()));
            IClassifier iClassifier = iAssociationEnd.getType();
            if (iClassifier != null) {
                DataReporter.printLine(fileWriter, n, "Type: " + iClassifier.getElementType());
            }
            DataReporter.printClientChangeability(fileWriter, n, iAssociationEnd);
            string3 = iAssociationEnd.getMultiplicity().getRangeAsString(true);
            DataReporter.printLine(fileWriter, n, "Multiplicity: " + string3);
            DataReporter.printLine(fileWriter, n, "Navigable: " + DataReporter.reportBoolean(iAssociationEnd.getIsNavigable()));
            ETList<IAttribute> eTList = iAssociationEnd.getQualifiers();
            if (eTList != null) {
                DataReporter.printQualifierDetails(fileWriter, n, eTList);
            }
        }
    }

    protected static void printQualifierDetails(FileWriter fileWriter, int n, ETList<IAttribute> eTList) {
        String string = "";
        if (eTList.getCount() > 0) {
            int n2 = eTList.getCount();
            DataReporter.printLine(fileWriter, n, "Qualifier Count:  " + n2);
            for (int i = 0; i < n2; ++i) {
                IAttribute iAttribute = eTList.item(i);
                if (iAttribute == null) continue;
                DataReporter.printLine(fileWriter, n + 2, "Qualifier " + String.valueOf(i + 1));
                DataReporter.printLine(fileWriter, n + 4, "Name: " + iAttribute.getName());
                IClassifier iClassifier = iAttribute.getType();
                if (iClassifier != null) {
                    DataReporter.printLine(fileWriter, n + 4, "Type: " + iClassifier.getName());
                }
                DataReporter.printVisibility(fileWriter, n + 4, iAttribute);
                DataReporter.printLine(fileWriter, n + 4, "Documentation: " + iAttribute.getDocumentation());
                DataReporter.printLine(fileWriter, n + 4, "Stereotype: " + iAttribute.getAppliedStereotypesAsString(false));
                DataReporter.printTaggedValues(fileWriter, n + 4, iAttribute);
                DataReporter.printConstraints(fileWriter, n + 4, iAttribute);
            }
        }
    }

    protected static void printDependencyDetails(FileWriter fileWriter, int n, IDependency iDependency) {
        if (iDependency != null) {
            INamedElement iNamedElement;
            INamedElement iNamedElement2 = iDependency.getClient();
            if (iNamedElement2 != null) {
                DataReporter.printLine(fileWriter, n, "Client Name: " + iDependency.getClient().getName());
            }
            if ((iNamedElement = iDependency.getSupplier()) != null) {
                DataReporter.printLine(fileWriter, n, "Supplier Name: " + iDependency.getSupplier().getName());
            }
        }
    }

    protected static void printMultiFlowDetails(FileWriter fileWriter, int n, IMultiFlow iMultiFlow) {
        if (iMultiFlow != null) {
            IActivityNode iActivityNode;
            IActivityNode iActivityNode2 = iMultiFlow.getSource();
            if (iActivityNode2 != null) {
                DataReporter.printLine(fileWriter, n, "Source: " + iActivityNode2.getName());
                DataReporter.printLine(fileWriter, n, "Source Type: " + iActivityNode2.getElementType());
            }
            if ((iActivityNode = iMultiFlow.getTarget()) != null) {
                DataReporter.printLine(fileWriter, n, "Target: " + iActivityNode.getName());
                DataReporter.printLine(fileWriter, n, "Target Type: " + iActivityNode.getElementType());
            }
        }
    }

    protected static void printCommentDetails(FileWriter fileWriter, int n, IComment iComment) {
        DataReporter.printLine(fileWriter, n, "Body: " + iComment.getBody());
        ETList<INamedElement> eTList = iComment.getAnnotatedElements();
        if (eTList != null && eTList.getCount() > 0) {
            int n2 = eTList.getCount();
            DataReporter.printLine(fileWriter, n, "Annotated Elements count:  " + n2);
            for (int i = 0; i < n2; ++i) {
                INamedElement iNamedElement = eTList.item(i);
                if (iNamedElement instanceof INamedElement) {
                    INamedElement iNamedElement2 = iNamedElement;
                    DataReporter.printLine(fileWriter, n + 2, "Annotated Element  " + String.valueOf(i + 1));
                    DataReporter.printLine(fileWriter, n + 4, " Name: " + iNamedElement2.getName());
                    DataReporter.printLine(fileWriter, n + 4, " Element Type: " + iNamedElement2.getElementType());
                    continue;
                }
                ETSystem.out.println("not a named element:  " + iNamedElement);
            }
        }
    }

    protected static void printTaggedValues(FileWriter fileWriter, int n, IElement iElement) {
        long l = iElement.getTaggedValueCount();
        if (iElement.getTaggedValueCount() > 0L) {
            ETList<ITaggedValue> eTList = iElement.getAllTaggedValues();
            DataReporter.printLine(fileWriter, n, "TaggedValues count:  " + l);
            int n2 = 0;
            while ((long)n2 < l) {
                ITaggedValue iTaggedValue = eTList.item(n2);
                if (!iTaggedValue.isHidden()) {
                    DataReporter.printLine(fileWriter, n + 2, "Tagged Value " + String.valueOf(n2 + 1));
                } else {
                    DataReporter.printLine(fileWriter, n + 2, "Tagged Value " + String.valueOf(n2 + 1) + " (Hidden)");
                }
                DataReporter.printLine(fileWriter, n + 4, " name: " + iTaggedValue.getName());
                DataReporter.printLine(fileWriter, n + 4, " value: " + iTaggedValue.getDataValue());
                ++n2;
            }
        }
    }

    protected static void printConstraints(FileWriter fileWriter, int n, IElement iElement) {
        ETList<IConstraint> eTList = iElement.getOwnedConstraints();
        int n2 = eTList.getCount();
        if (n2 > 0) {
            DataReporter.printLine(fileWriter, n, "Constraint count:  " + n2);
            for (int i = 0; i < n2; ++i) {
                IConstraint iConstraint = eTList.item(i);
                DataReporter.printLine(fileWriter, n + 2, "Constraint Value " + String.valueOf(i + 1));
                DataReporter.printLine(fileWriter, n + 4, "name: " + iConstraint.getName());
                DataReporter.printLine(fileWriter, n + 4, "express: " + iConstraint.getExpression());
            }
        }
    }

    protected static void printVisibility(FileWriter fileWriter, int n, INamedElement iNamedElement) {
        String string = "";
        switch (iNamedElement.getVisibility()) {
            case 3: {
                string = "package";
                break;
            }
            case 2: {
                string = "private";
                break;
            }
            case 1: {
                string = "protected";
                break;
            }
            case 0: {
                string = "public";
            }
        }
        DataReporter.printLine(fileWriter, n, "Visibility: " + string);
    }

    protected static void printClientChangeability(FileWriter fileWriter, int n, IStructuralFeature iStructuralFeature) {
        DataReporter.printClientChangeability(fileWriter, n, iStructuralFeature.getClientChangeability());
    }

    protected static void printClientChangeability(FileWriter fileWriter, int n, int n2) {
        String string = "";
        switch (n2) {
            case 2: {
                string = "add only";
                break;
            }
            case 3: {
                string = "removed only";
                break;
            }
            case 1: {
                string = "restricted";
                break;
            }
            case 0: {
                string = "unrestricted";
            }
        }
        DataReporter.printLine(fileWriter, n, "ClientChangeability: " + string);
    }

    protected static void printLine(FileWriter fileWriter, int n, String string) {
        try {
            if (fileWriter != null) {
                for (int i = 0; i < n; ++i) {
                    fileWriter.write(" ");
                }
                DataReporter.printLine(fileWriter, string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void printLine(FileWriter fileWriter, String string) {
        try {
            if (fileWriter != null) {
                fileWriter.write(string);
                fileWriter.write("\r\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static String reportBoolean(boolean bl) {
        return bl ? "True" : "False";
    }

    protected static void projectDiagramReport(IProduct iProduct, IProject iProject, String string, String string2, String string3) {
        ProxyDiagramManager proxyDiagramManager = ProxyDiagramManager.instance();
        String string4 = "";
        IDiagramCallback iDiagramCallback = null;
        try {
            FileWriter fileWriter = new FileWriter(string + "\\" + string2);
            if (fileWriter != null) {
                DataReporter.printLine(fileWriter, 0, PRINT_LINE80);
                DataReporter.printLine(fileWriter, 0, "Diagram Report for Project: " + iProject.getName());
                ETList<IProxyDiagram> eTList = proxyDiagramManager.getDiagramsInProject(iProject);
                DataReporter.printLine(fileWriter, 0, "Diagram Count: " + String.valueOf(eTList.getCount()));
                DataReporter.printLine(fileWriter, 0, PRINT_LINE80);
                DataReporter.printLine(fileWriter, 0, "  ");
                int n = eTList.getCount();
                for (int i = 0; i < n; ++i) {
                    IDiagram iDiagram;
                    boolean bl;
                    IProxyDiagram iProxyDiagram = eTList.item(i);
                    if (iProxyDiagram.isOpen()) {
                        bl = false;
                        iDiagram = iProxyDiagram.getDiagram();
                    } else {
                        bl = true;
                        iDiagram = iProduct.getDiagramManager().openDiagram2(iProxyDiagram, true, iDiagramCallback);
                    }
                    DataReporter.diagramReport(fileWriter, iDiagram);
                    if (string3.equalsIgnoreCase("TRUE")) {
                        iDiagram.saveAsGraphic(string.trim() + "\\" + iDiagram.getName().trim() + ".jpg ", 2);
                    }
                    bl = true;
                    if (!true || !iDiagram.isDirty()) continue;
                    iDiagram.save();
                }
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void currentDiagramReport(IProduct iProduct, String string, String string2, String string3) {
        IDiagram iDiagram = iProduct.getDiagramManager().getCurrentDiagram();
        if (iDiagram != null) {
            try {
                FileWriter fileWriter = new FileWriter(string + "\\" + string2);
                if (fileWriter != null) {
                    DataReporter.diagramReport(fileWriter, iDiagram);
                    if (string3.length() > 0) {
                        iDiagram.saveAsGraphic(string.trim() + "\\" + string3.trim(), 2);
                    }
                    fileWriter.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static void printMainDiagramDetails(FileWriter fileWriter, IDiagram iDiagram) {
        String string = "";
        if (iDiagram != null) {
            ETList<IElement> eTList;
            int n;
            int n2;
            DataReporter.printLine(fileWriter, 0, PRINT_LINE80EL);
            DataReporter.printLine(fileWriter, 0, " Diagram: " + iDiagram.getQualifiedName());
            DataReporter.printLine(fileWriter, 0, PRINT_LINE80EL);
            switch (iDiagram.getLayoutStyle()) {
                case 5: {
                    string = "circular";
                    break;
                }
                case 7: {
                    string = "global";
                    break;
                }
                case 1: {
                    string = "hierarchical";
                    break;
                }
                case 8: {
                    string = "incremental";
                    break;
                }
                case 0: {
                    string = "no layout";
                    break;
                }
                case 2: {
                    string = "orthogonal";
                    break;
                }
                case 6: {
                    string = "sequence";
                    break;
                }
                case 3: {
                    string = "symmetric";
                    break;
                }
                case 4: {
                    string = "tree";
                    break;
                }
                case 255: {
                    string = "unknown";
                }
            }
            DataReporter.printLine(fileWriter, 1, "Diagram Layout Style: " + string);
            DataReporter.printLine(fileWriter, 1, "Diagram Kind: " + iDiagram.getDiagramKind2());
            DataReporter.printLine(fileWriter, 1, "Diagram Documentation: " + iDiagram.getDocumentation());
            ETList<IProxyDiagram> eTList2 = iDiagram.getAssociatedDiagrams();
            if (eTList2 != null && (n2 = eTList2.getCount()) > 0) {
                DataReporter.printLine(fileWriter, 1, "Associated Diagram Count:  " + n2);
                for (n = 0; n < n2; ++n) {
                    IProxyDiagram iProxyDiagram = eTList2.item(n);
                    if (iProxyDiagram == null) continue;
                    DataReporter.printLine(fileWriter, 2, "Associated Diagram " + String.valueOf(n + 1));
                    DataReporter.printLine(fileWriter, 4, "Name: " + iProxyDiagram.getName());
                    DataReporter.printLine(fileWriter, 4, "Type: " + iProxyDiagram.getDiagramKindName());
                }
            }
            if ((eTList = iDiagram.getAssociatedElements()) != null && (n = eTList.getCount()) > 0) {
                DataReporter.printLine(fileWriter, 1, "Associated Element Count:" + n);
                for (int i = 0; i < n; ++i) {
                    INamedElement iNamedElement;
                    IElement iElement = eTList.item(i);
                    if (iElement == null || (iNamedElement = (INamedElement)iElement) == null) continue;
                    DataReporter.printLine(fileWriter, 2, "Associated Element" + String.valueOf(i + 1));
                    DataReporter.printLine(fileWriter, 4, "Name: " + iNamedElement.getName());
                    DataReporter.printLine(fileWriter, 4, "Type: " + iNamedElement.getElementType());
                }
            }
            DataReporter.printLine(fileWriter, 1, " ");
        }
    }

    protected static void diagramReport(FileWriter fileWriter, IDiagram iDiagram) {
        if (iDiagram != null) {
            DataReporter.printMainDiagramDetails(fileWriter, iDiagram);
            if (!iDiagram.getDiagramKind2().equals("Sequence Diagram")) {
                ETList<IPresentationElement> eTList = iDiagram.getAllItems();
                int n = eTList.getCount();
                for (int i = 0; i < n; ++i) {
                    INamedElement iNamedElement;
                    IElement iElement = eTList.item(i).getFirstSubject();
                    if (iElement != null) {
                        DataReporter.printLine(fileWriter, 1, "Element:" + String.valueOf(i));
                        DataReporter.printLine(fileWriter, 1, "Type:" + iElement.getExpandedElementType());
                    }
                    if ((iNamedElement = (INamedElement)iElement) == null) continue;
                    DataReporter.printLine(fileWriter, 1, "Name:" + iNamedElement.getName());
                }
                DataReporter.printLine(fileWriter, 1, "");
            }
        }
    }

    public static void diagramReport2(IDiagram iDiagram, String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string + "\\" + string2);
            if (fileWriter != null) {
                DataReporter.diagramReport(fileWriter, iDiagram);
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void interactionReport(IOperation iOperation, IProject iProject, String string, String string2) {
        ElementLocator elementLocator = new ElementLocator();
        try {
            FileWriter fileWriter = new FileWriter(string + "\\" + string2);
            if (fileWriter != null) {
                DataReporter.printLine(fileWriter, 0, PRINT_LINE80);
                DataReporter.printLine(fileWriter, 0, " BASELINE REPORT");
                DataReporter.printLine(fileWriter, 0, PRINT_LINE80);
                DataReporter.printLine(fileWriter, 0, " VERSION 6.0");
                DataReporter.printLine(fileWriter, 0, "Interaction Information");
                DataReporter.printLine(fileWriter, 0, PRINT_LINE80);
                ETList<IElement> eTList = elementLocator.findElementsByQuery(iOperation, ".//UML:CombinedFragment");
                ETList<IElement> eTList2 = iOperation.getElements();
                int n = eTList2.getCount();
                for (int i = 0; i < n; ++i) {
                    int n2;
                    IElement iElement = eTList2.item(i);
                    if (!(iElement instanceof IInteraction)) continue;
                    IInteraction iInteraction = (IInteraction)iElement;
                    ETList<IMessage> eTList3 = iInteraction.getMessages();
                    int n3 = eTList3.getCount();
                    DataReporter.printLine(fileWriter, 0, "Total Message Count: " + n3);
                    ETList<ILifeline> eTList4 = iInteraction.getLifelines();
                    int n4 = eTList4.getCount();
                    DataReporter.printLine(fileWriter, 0, "Total Lifeline Count: " + n4);
                    int n5 = eTList.getCount();
                    DataReporter.printLine(fileWriter, 0, "Total Comb Frag Count: " + n5);
                    DataReporter.printLine(fileWriter, 0, PRINT_LINE80);
                    for (n2 = 0; n2 < n3; ++n2) {
                        DataReporter.printLine(fileWriter, 0, "Message:" + String.valueOf(n2 + 1));
                        DataReporter.printMessageDetails(fileWriter, 1, eTList3.item(n2));
                        DataReporter.printLine(fileWriter, 0, "");
                    }
                    DataReporter.printLine(fileWriter, 0, PRINT_LINE80);
                    for (n2 = 0; n2 < n4; ++n2) {
                        DataReporter.printLine(fileWriter, 0, "Lifeline:" + String.valueOf(n2 + 1));
                        DataReporter.printLifeLineDetails(fileWriter, 1, eTList4.item(n2));
                        DataReporter.printLine(fileWriter, 0, "");
                    }
                    DataReporter.printLine(fileWriter, 0, PRINT_LINE80);
                    for (n2 = 0; n2 < n5; ++n2) {
                        DataReporter.printLine(fileWriter, 0, "Fragment:" + String.valueOf(n2 + 1));
                        ICombinedFragment iCombinedFragment = (ICombinedFragment)eTList.item(n2);
                        DataReporter.printLine(fileWriter, 0, "");
                    }
                }
                fileWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

