/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.treetable;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.StringTokenizer;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.uml.core.configstringframework.ConfigStringTranslator;
import org.netbeans.modules.uml.core.support.Debug;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyDefinition;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElement;
import org.netbeans.modules.uml.ui.swing.propertyeditor.PropertyEditor;
import org.netbeans.modules.uml.ui.swing.treetable.JDefaultMutableTreeNode;
import org.netbeans.modules.uml.ui.swing.treetable.JDescribeButton;
import org.netbeans.modules.uml.ui.swing.treetable.JDescribeComboBox;
import org.netbeans.modules.uml.ui.swing.treetable.JPropertyTreeTable;
import org.netbeans.modules.uml.ui.swing.treetable.JTreeTable;
import org.netbeans.modules.uml.ui.swing.treetable.PropertyTreeTableModel;
import org.netbeans.modules.uml.ui.swing.treetable.TreeTableModel;

public class TreeTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JTreeTable.TreeTableCellRenderer tree = null;
    private PropertyEditor m_Editor = null;

    public TreeTableCellEditor() {
    }

    public TreeTableCellEditor(JTreeTable.TreeTableCellRenderer treeTableCellRenderer) {
        this.tree = treeTableCellRenderer;
    }

    public TreeTableCellEditor(JTreeTable.TreeTableCellRenderer treeTableCellRenderer, PropertyEditor propertyEditor) {
        this.tree = treeTableCellRenderer;
        this.m_Editor = propertyEditor;
    }

    public JTreeTable.TreeTableCellRenderer getTree() {
        return this.tree;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        JComboBox<String> jComboBox = null;
        this.m_Editor.setCurrentRow(n);
        this.m_Editor.processLastCell(false);
        boolean bl2 = true;
        if (n2 == 2) {
            JDefaultMutableTreeNode jDefaultMutableTreeNode;
            IPropertyElement iPropertyElement;
            Object object2;
            TreePath treePath = this.getTree().getPathForRow(n);
            if (treePath != null && (object2 = treePath.getLastPathComponent()) instanceof JDefaultMutableTreeNode && (iPropertyElement = (IPropertyElement)(jDefaultMutableTreeNode = (JDefaultMutableTreeNode)object2).getUserObject()) != null) {
                IPropertyDefinition iPropertyDefinition = iPropertyElement.getPropertyDefinition();
                long l = iPropertyDefinition.getMultiplicity();
                String string = iPropertyDefinition.getValidValues();
                if (string != null) {
                    if (string.equals("FormatString")) {
                        JTextField jTextField = new JTextField();
                        jTextField.setBorder(null);
                        jTextField.setEditable(false);
                        jTextField.setText((String)object);
                        bl2 = false;
                        jComboBox = jTextField;
                    } else if (string.startsWith("#DataTypeList")) {
                        String string2 = this.m_Editor.buildDataTypeList(iPropertyElement);
                        JDescribeComboBox jDescribeComboBox = new JDescribeComboBox(this.m_Editor);
                        jDescribeComboBox.setEnabled(true);
                        jDescribeComboBox.setBorder(null);
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string3 = stringTokenizer.nextToken();
                            jDescribeComboBox.addItem(string3);
                        }
                        jDescribeComboBox.setSelectedItem(object);
                        jComboBox = jDescribeComboBox;
                    } else {
                        String string4 = iPropertyDefinition.getControlType();
                        if (string4 != null && string4.equals("read-only")) {
                            JTextField jTextField = new JTextField();
                            jTextField.setEditable(false);
                            bl2 = false;
                            jTextField.setBorder(null);
                            if (object != null) {
                                ConfigStringTranslator configStringTranslator = new ConfigStringTranslator();
                                jTextField.setText(configStringTranslator.translate(iPropertyDefinition, object.toString()));
                            }
                            jComboBox = jTextField;
                        } else {
                            ConfigStringTranslator configStringTranslator = new ConfigStringTranslator();
                            JComboBox<String> jComboBox2 = new JComboBox<String>();
                            jComboBox2.setEnabled(true);
                            jComboBox2.setBorder(null);
                            jComboBox2.setFocusable(true);
                            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                            while (stringTokenizer.hasMoreTokens()) {
                                String string5 = configStringTranslator.translate(iPropertyDefinition, stringTokenizer.nextToken());
                                jComboBox2.addItem(string5);
                            }
                            jComboBox2.setSelectedItem(object);
                            jComboBox = jComboBox2;
                        }
                    }
                } else {
                    String string6 = iPropertyDefinition.getControlType();
                    if (!(l <= 1L || string6 != null && string6.equals("read-only"))) {
                        if (jTable instanceof JPropertyTreeTable) {
                            PropertyEditor propertyEditor = ((JPropertyTreeTable)jTable).getPropertyEditor();
                            JDescribeButton jDescribeButton = new JDescribeButton(n, propertyEditor);
                            jDescribeButton.setBorder(null);
                            jComboBox = jDescribeButton;
                            bl2 = false;
                        }
                    } else {
                        JTextField jTextField = new JTextField();
                        jTextField.setBorder(null);
                        if (object != null) {
                            jTextField.setText(object.toString());
                        }
                        if (string6 == null || string6.equals("read-only")) {
                            jTextField.setEditable(false);
                            bl2 = false;
                        }
                        jComboBox = jTextField;
                    }
                }
            }
        } else if (n2 == 1) {
            Object object3;
            TreePath treePath = this.getTree().getPathForRow(n);
            if (treePath != null && (object3 = treePath.getLastPathComponent()) instanceof JDefaultMutableTreeNode) {
                JDefaultMutableTreeNode jDefaultMutableTreeNode = (JDefaultMutableTreeNode)object3;
                if (jDefaultMutableTreeNode.getChildCount() <= 0) return null;
                jComboBox = null;
            }
        } else if (n2 == 0) {
            this.m_Editor.sortPropertyEditorElements(n);
            return null;
        }
        if (jComboBox == null || n2 != 2 || bl2) {
            // empty if block
        }
        if (jComboBox != null && n2 == 2) {
            jComboBox.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        // empty if block
                    }
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        // empty if block
                    }
                    Debug.out.println("Edit Control Lost Focus");
                }
            });
            jComboBox.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                }

                public void keyPressed(KeyEvent keyEvent) {
                    TreeTableCellEditor.this.handleKeyPress(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                }
            });
        }
        this.m_Editor.setEditingComponent(jComboBox);
        return jComboBox;
    }

    public boolean isCellEditable(EventObject eventObject) {
        TreeModel treeModel;
        if (eventObject instanceof MouseEvent && (treeModel = this.tree.getModel()) instanceof TreeTableModel) {
            TreeTableModel treeTableModel = (TreeTableModel)treeModel;
            for (int i = treeTableModel.getColumnCount() - 1; i >= 0; --i) {
                Object object;
                if (!treeTableModel.getColumnClass(i).equals(PropertyTreeTableModel.class)) continue;
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                if (mouseEvent.getClickCount() == 2) {
                    this.m_Editor.handleDoubleClick();
                    continue;
                }
                int n = this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n == -1 || !((object = treePath.getLastPathComponent()) instanceof JDefaultMutableTreeNode)) break;
                JDefaultMutableTreeNode jDefaultMutableTreeNode = (JDefaultMutableTreeNode)object;
                int n2 = jDefaultMutableTreeNode.getLevel();
                TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
                if (treeCellRenderer == null || !(treeCellRenderer instanceof DefaultTreeCellRenderer)) break;
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                int n3 = defaultTreeCellRenderer.getHorizontalTextPosition();
                int n4 = defaultTreeCellRenderer.getIconTextGap();
                int n5 = treePath.getPathCount();
                Insets insets = defaultTreeCellRenderer.getInsets();
                int n6 = 15;
                int n7 = insets != null ? insets.left : 0;
                int n8 = (n7 += (n5 - 2) * 16 + n3 + n6) + n4 + n3;
                if (n7 > mouseEvent.getX() || n8 < mouseEvent.getX()) break;
                if (!jDefaultMutableTreeNode.isExpanded() && jDefaultMutableTreeNode.getAllowsChildren()) {
                    this.m_Editor.onNodeExpanding(n);
                    if (treeModel instanceof PropertyTreeTableModel) {
                        ((PropertyTreeTableModel)treeModel).expand(n, true);
                    }
                    jDefaultMutableTreeNode.setExpanded(true);
                    this.m_Editor.refresh();
                    break;
                }
                if (!jDefaultMutableTreeNode.isExpanded()) break;
                jDefaultMutableTreeNode.setExpanded(false);
                if (!(treeModel instanceof PropertyTreeTableModel)) break;
                ((PropertyTreeTableModel)treeModel).expand(n, false);
                break;
            }
        }
        return true;
    }

    public Object getCellEditorValue() {
        return this.tree;
    }

    public boolean stopCellEditing() {
        this.m_Editor.handleSave(true, null);
        this.m_Editor.setEditingComponent(null);
        if (!this.m_Editor.isFocusOwner()) {
            this.m_Editor.handleSave(false, null);
        }
        return true;
    }

    public void cancelCellEditing() {
        this.m_Editor.setEditingComponent(null);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        boolean bl = false;
        if (eventObject instanceof MouseEvent) {
            bl = true;
        }
        return bl;
    }

    public void handleKeyPress(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        Object object = this.m_Editor.getEditingComponent();
        if (n == 27) {
            this.cancelCellEditing();
            this.m_Editor.onKeyDownGrid(keyEvent);
        } else if (n == 10) {
            this.stopCellEditing();
            if (object != null && object instanceof JDescribeButton) {
                ((JDescribeButton)object).actionPerformed(null);
            } else {
                this.m_Editor.onKeyDownGrid(keyEvent);
            }
        } else if (n == 9) {
            this.stopCellEditing();
            this.m_Editor.onKeyDownGrid(keyEvent);
        } else if (object != null && object instanceof Component) {
            if (n == 38 || n == 40) {
                if (!(object instanceof JComboBox)) {
                    this.stopCellEditing();
                    this.m_Editor.onKeyDownGrid(keyEvent);
                }
            } else {
                this.m_Editor.onKeyDownGrid(keyEvent);
            }
        } else {
            this.m_Editor.onKeyDownGrid(keyEvent);
        }
    }

    private class EditorFocusListener
    implements FocusListener {
        private EditorFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

