/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.trackbar;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.accessibility.AccessibleContext;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.dom4j.Element;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.ui.controls.trackbar.TrackBarResource;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveElement;
import org.netbeans.modules.uml.ui.support.archivesupport.ProductArchiveElementImpl;
import org.netbeans.modules.uml.ui.swing.trackbar.JTrackBar;
import org.netbeans.modules.uml.ui.swing.trackbar.TrackCar;
import org.netbeans.modules.uml.ui.swing.trackbar.TrackItem;

public class TrackCoupling
extends TrackItem
implements ActionListener {
    public static final int INSET_H = 3;
    public static final int CAP_HEIGHT = 10;
    public static final int NO_CONSTRAINT = 0;
    public static final int MIN_SIZE_CONSTRAINT = 1;
    public static final int MESSAGE_SIZE_CONSTRAINT = 2;
    public static final String NO_WIDTH_CONSTRAINT = "NO_WIDTH_CONSTRAINT";
    public static final String MINSIZE_WIDTH_CONSTRAINT = "MINSIZE_WIDTH_CONSTRAINT";
    public static final String MESSAGE_WIDTH_CONSTRAINT = "MESSAGE_WIDTH_CONSTRAINT";
    public static final String SHOW_INDICATORS = "SHOW_INDICATORS";
    public static final String ELEMENT_COUPLING = "SequenceCoupling";
    public static final String ATTR_COUPLING_PREVIOUS = "previous";
    public static final String ATTR_COUPLING_NEXT = "next";
    public static final String ATTR_COUPLING_TYPE = "type";
    public static final String ATTR_COUPLING_SHOW = "show";
    private int m_CouplingType = 0;
    private boolean m_ShowCouplingType = true;
    AccessibleTrackCoupling accessibleContext;

    public TrackCoupling(JTrackBar jTrackBar, TrackItem trackItem, TrackItem trackItem2) {
        super(jTrackBar);
        this.setPreviousItem(trackItem);
        this.setNextItem(trackItem2);
    }

    public boolean isCoupling() {
        return true;
    }

    public void paint(Graphics graphics) {
        Color color = graphics.getColor();
        if (this.hasFocus()) {
            graphics.setColor(SystemColor.textHighlight);
        } else {
            graphics.setColor(this.getBackground());
        }
        Rectangle rectangle = this.getBounds();
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        if (this.isShowCouplingType()) {
            if (this.hasFocus()) {
                graphics.setColor(SystemColor.textHighlightText);
            } else {
                graphics.setColor(SystemColor.textText);
            }
            switch (this.getCouplingType()) {
                case 1: {
                    this.paintMinSizeConstraint(graphics);
                    break;
                }
                case 2: {
                    this.paintMessageSizeConstraint(graphics);
                    break;
                }
                default: {
                    this.paintNoConstraint(graphics);
                }
            }
        }
        graphics.setColor(color);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof TrackCoupling) {
            bl = this.isBetweenSameNeighbors((TrackCoupling)object);
        }
        return bl;
    }

    public void load(IProductArchiveElement iProductArchiveElement) {
        Element element;
        if (iProductArchiveElement != null && (element = iProductArchiveElement.getDOMElement()) != null) {
            Node node;
            TrackCar trackCar = (TrackCar)this.getPreviousItem();
            TrackCar trackCar2 = (TrackCar)this.getNextItem();
            String string = "SequenceCoupling[";
            if (trackCar != null) {
                string = string + "@previous='" + trackCar.getXMIID() + "'";
            }
            if (trackCar2 != null) {
                if (trackCar != null) {
                    string = string + " and ";
                }
                string = string + "@next='" + trackCar2.getXMIID() + "'";
            }
            if ((node = XMLManip.selectSingleNode((Node)element, string = string + "]")) instanceof Element) {
                Element element2 = (Element)node;
                ProductArchiveElementImpl productArchiveElementImpl = new ProductArchiveElementImpl(element2);
                this.setCouplingType((int)productArchiveElementImpl.getAttributeLong(ATTR_COUPLING_TYPE));
                this.setShowCouplingType(productArchiveElementImpl.getAttributeBool(ATTR_COUPLING_SHOW));
            }
        }
    }

    public void save(IProductArchiveElement iProductArchiveElement) {
        IProductArchiveElement iProductArchiveElement2;
        if (iProductArchiveElement != null && (iProductArchiveElement2 = iProductArchiveElement.createElement(ELEMENT_COUPLING)) != null) {
            TrackCar trackCar;
            if (this.getPreviousItem() instanceof TrackCar) {
                trackCar = (TrackCar)this.getPreviousItem();
                iProductArchiveElement2.addAttributeString(ATTR_COUPLING_PREVIOUS, trackCar.getXMIID());
            }
            if (this.getNextItem() instanceof TrackCar) {
                trackCar = (TrackCar)this.getNextItem();
                iProductArchiveElement2.addAttributeString(ATTR_COUPLING_NEXT, trackCar.getXMIID());
            }
            iProductArchiveElement2.addAttributeLong(ATTR_COUPLING_TYPE, this.getCouplingType());
            iProductArchiveElement2.addAttributeBool(ATTR_COUPLING_SHOW, this.isShowCouplingType());
        }
    }

    public boolean isBetweenSameNeighbors(TrackItem trackItem) {
        String string;
        boolean bl = false;
        TrackCar trackCar = null;
        if (trackItem.getPreviousItem() instanceof TrackCar) {
            trackCar = (TrackCar)trackItem.getPreviousItem();
        }
        TrackCar trackCar2 = null;
        if (trackItem.getNextItem() instanceof TrackCar) {
            trackCar2 = (TrackCar)trackItem.getNextItem();
        }
        TrackCar trackCar3 = null;
        if (this.getPreviousItem() instanceof TrackCar) {
            trackCar3 = (TrackCar)this.getPreviousItem();
        }
        TrackCar trackCar4 = null;
        if (this.getNextItem() instanceof TrackCar) {
            trackCar4 = (TrackCar)this.getNextItem();
        }
        if (trackCar != null && trackCar3 != null) {
            string = trackCar.getXMIID();
            if (string.equals(trackCar3.getXMIID())) {
                bl = true;
            }
        } else if (trackCar == null && trackCar3 == null) {
            bl = true;
        }
        if (bl) {
            if (trackCar2 != null && trackCar4 != null) {
                string = trackCar2.getXMIID();
                if (string.equals(trackCar4.getXMIID())) {
                    bl = true;
                }
            } else if (trackCar2 == null && trackCar4 == null) {
                bl = true;
            }
        }
        return bl;
    }

    public void copyAttributes(TrackItem trackItem) {
        if (trackItem instanceof TrackCoupling) {
            TrackCoupling trackCoupling = (TrackCoupling)trackItem;
            this.setCouplingType(trackCoupling.getCouplingType());
            this.setShowCouplingType(trackCoupling.isShowCouplingType());
        }
    }

    protected void paintNoConstraint(Graphics graphics) {
    }

    protected void paintMessageSizeConstraint(Graphics graphics) {
        int n = this.getHeight() / 2;
        int n2 = this.getHeight() * 2 / 3;
        int n3 = Math.min(this.getWidth(), n2);
        int n4 = n3 / 2;
        int n5 = this.getWidth() - 3 - n3;
        int n6 = n - n4;
        graphics.drawArc(3, n6, n3, n3, 90, 180);
        graphics.drawArc(n5, n6, n3, n3, 270, 180);
        graphics.drawLine(3 + n4, n, n5 + n4, n);
    }

    protected void paintMinSizeConstraint(Graphics graphics) {
        int n = this.getWidth() - 3;
        int n2 = this.getHeight() / 2;
        int n3 = n2 - 5;
        int n4 = n2 + 5;
        graphics.drawLine(3, n3, 3, n4);
        graphics.drawLine(n, n3, n, n4);
        graphics.drawLine(3, n2, n, n2);
    }

    public void push(int n) {
        switch (this.getCouplingType()) {
            case 1: {
                this.pushMinSizeConstraint(n);
                break;
            }
            case 2: {
                this.pushMessageSizeConstraint(n);
                this.notifyNeighborsOfMove(n);
                break;
            }
            default: {
                this.pushNoConstraint(n);
            }
        }
    }

    protected void pushNoConstraint(int n) {
        if (this.getWidth() - Math.abs(n) <= 0) {
            this.notifyNeighborsOfMove(n);
        } else {
            this.updateContraints(n);
        }
    }

    protected void pushMessageSizeConstraint(int n) {
    }

    protected void pushMinSizeConstraint(int n) {
        this.notifyNeighborsOfMove(n);
    }

    public void updateContraints(int n) {
        this.resizeToFitNeighbors();
    }

    public void resizeToFitNeighbors() {
        this.resizeToFitNeighbors(null);
    }

    public void resizeToFitNeighbors(TrackCar trackCar) {
        if (this.getTrackBar() != null && !this.getTrackBar().isVisible()) {
            return;
        }
        Rectangle rectangle = this.determineBoundingRect();
        int n = rectangle.width;
        if (n < 0) {
            TrackItem trackItem = this.getPreviousItem();
            TrackItem trackItem2 = this.getNextItem();
            if (trackItem2 == trackCar) {
                if (trackItem != null) {
                    trackItem.push(n);
                }
            } else if (trackItem2 != null) {
                trackItem2.push(-n);
            }
            n = 0;
            rectangle = this.determineBoundingRect();
        }
        this.setBounds(rectangle);
    }

    protected void limitBoundingRect(Rectangle rectangle) {
        TrackItem trackItem = this.getPreviousItem();
        TrackItem trackItem2 = this.getNextItem();
        if (trackItem != null && trackItem2 != null) {
            rectangle.x = trackItem.getX() + trackItem.getWidth();
            rectangle.width = trackItem2.getX() - rectangle.x;
        }
    }

    public Rectangle getBounds() {
        return this.determineBoundingRect();
    }

    public int getCouplingType() {
        return this.m_CouplingType;
    }

    public void setCouplingType(int n) {
        if (this.m_CouplingType != n) {
            this.fireAccessiblePropertyChange("AccessibleDescription", new Integer(this.m_CouplingType), new Integer(n));
        }
        this.m_CouplingType = n;
    }

    public boolean isShowCouplingType() {
        return this.m_ShowCouplingType;
    }

    public void setShowCouplingType(boolean bl) {
        this.m_ShowCouplingType = bl;
    }

    public void buildContextMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.add(this.getNoRestrictionsMenuItem());
        jPopupMenu.add(this.getMinWidthMenuItem());
        jPopupMenu.add(this.getMessageWidthMenuItem());
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.getShowIndicatorsMenuItem());
    }

    public JMenuItem getNoRestrictionsMenuItem() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(TrackBarResource.getString("TrackCoupling.No_Width_Restrictions"), this.getCouplingType() == 0);
        String string = TrackBarResource.getString("TrackCoupling.No_Width_Restrictions_MNEMONIC");
        jCheckBoxMenuItem.setMnemonic(string.charAt(0));
        jCheckBoxMenuItem.addActionListener(this);
        jCheckBoxMenuItem.setActionCommand(NO_WIDTH_CONSTRAINT);
        return jCheckBoxMenuItem;
    }

    public JMenuItem getMinWidthMenuItem() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(TrackBarResource.getString("TrackCoupling.Retain_This_Minimum_Width"), this.getCouplingType() == 1);
        String string = TrackBarResource.getString("TrackCoupling.Retain_This_Minimum_Width_MNEMONIC");
        jCheckBoxMenuItem.setMnemonic(string.charAt(0));
        jCheckBoxMenuItem.addActionListener(this);
        jCheckBoxMenuItem.setActionCommand(MINSIZE_WIDTH_CONSTRAINT);
        return jCheckBoxMenuItem;
    }

    public JMenuItem getMessageWidthMenuItem() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(TrackBarResource.getString("TrackCoupling.Set_Width_to_Message_Width"), this.getCouplingType() == 2);
        String string = TrackBarResource.getString("TrackCoupling.Set_Width_to_Message_Width_MNEMONIC");
        jCheckBoxMenuItem.setMnemonic(string.charAt(0));
        jCheckBoxMenuItem.addActionListener(this);
        jCheckBoxMenuItem.setActionCommand(MESSAGE_WIDTH_CONSTRAINT);
        return jCheckBoxMenuItem;
    }

    public JMenuItem getShowIndicatorsMenuItem() {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(TrackBarResource.getString("TrackCoupling.Show_Indicators_in_Track_Bar"), this.isShowCouplingType());
        String string = TrackBarResource.getString("TrackCoupling.Show_Indicators_in_Track_Bar_MNEMONIC");
        jCheckBoxMenuItem.setMnemonic(string.charAt(0));
        jCheckBoxMenuItem.addActionListener(this);
        jCheckBoxMenuItem.setActionCommand(SHOW_INDICATORS);
        return jCheckBoxMenuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        if (actionEvent.getActionCommand().equals(NO_WIDTH_CONSTRAINT)) {
            this.setCouplingType(0);
        } else if (actionEvent.getActionCommand().equals(MINSIZE_WIDTH_CONSTRAINT)) {
            this.setCouplingType(1);
        } else if (actionEvent.getActionCommand().equals(MESSAGE_WIDTH_CONSTRAINT)) {
            this.setCouplingType(2);
        } else if (actionEvent.getActionCommand().equals(SHOW_INDICATORS) && (object = actionEvent.getSource()) instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)object;
            this.setShowCouplingType(jCheckBoxMenuItem.getState());
        }
        this.repaint();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTrackCoupling();
        }
        return this.accessibleContext;
    }

    public void fireAccessiblePropertyChange(String string, Object object, Object object2) {
        if (this.accessibleContext != null && string != null && string.equals("AccessibleDescription")) {
            String string2 = null;
            String string3 = null;
            if (object != null && object instanceof Integer) {
                string2 = this.accessibleContext.getAccessibleDescription((Integer)object);
            }
            if (object2 != null && object2 instanceof Integer) {
                string3 = this.accessibleContext.getAccessibleDescription((Integer)object2);
            }
            this.accessibleContext.firePropertyChange(string, string2, string3);
        }
    }

    public class AccessibleTrackCoupling
    extends TrackItem.AccessibleTrackItem {
        public AccessibleTrackCoupling() {
            super(TrackCoupling.this);
        }

        public String getAccessibleDescription() {
            return this.getAccessibleDescription(TrackCoupling.this.getCouplingType());
        }

        public String getAccessibleDescription(int n) {
            String string = "";
            switch (n) {
                case 1: {
                    string = TrackBarResource.getString("ACSD_TrackCoupling_MinimumWidth");
                    break;
                }
                case 2: {
                    string = TrackBarResource.getString("ACSD_TrackCoupling_MessageWidth");
                    break;
                }
                case 0: {
                    string = TrackBarResource.getString("ACSD_TrackCoupling_NoWidthRestrictions");
                }
            }
            return MessageFormat.format(TrackBarResource.getString("ACSD_TrackCoupling"), string);
        }
    }
}

