/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.trackbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.dynamics.ILifeline;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.IDataFormatter;
import org.netbeans.modules.uml.ui.controls.drawingarea.GetHelper;
import org.netbeans.modules.uml.ui.controls.drawingarea.IUIDiagram;
import org.netbeans.modules.uml.ui.controls.trackbar.TrackBarResource;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.ILabelPresentation;
import org.netbeans.modules.uml.ui.support.applicationmanager.INodePresentation;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchive;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveElement;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADGraphWindow;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDiagramEngine;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.trackbar.ITrackBar;
import org.netbeans.modules.uml.ui.swing.trackbar.TrackCar;
import org.netbeans.modules.uml.ui.swing.trackbar.TrackCoupling;
import org.netbeans.modules.uml.ui.swing.trackbar.TrackItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTrackBar
extends JPanel
implements ITrackBar,
FocusListener {
    public static final int INSET = 3;
    private IDiagramEngine m_DiagramEngine = null;
    private HashMap<String, TrackCar> m_TrackCars = new HashMap();
    private String currentFocusedCar = "";
    AccessibleContext accessibleContext;

    public JTrackBar(IDiagramEngine iDiagramEngine) {
        this.setLayout(null);
        this.setDiagramEngine(iDiagramEngine);
        this.setFocusable(true);
        this.addFocusListener(this);
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("control T"), "SWITCH_TRACKBAR_FOCUS");
        this.getActionMap().put("SWITCH_TRACKBAR_FOCUS", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                if (JTrackBar.this.hasFocus()) {
                    bl = false;
                } else {
                    int n = JTrackBar.this.getComponentCount();
                    for (int i = 0; i < n; ++i) {
                        if (!JTrackBar.this.getComponent(i).hasFocus()) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    JTrackBar.this.requestFocus();
                } else {
                    JTrackBar.this.m_DiagramEngine.getDrawingArea().setFocus();
                }
            }
        });
    }

    @Override
    public void setBackStyle(long l) {
    }

    @Override
    public long getBackStyle() {
        return 0L;
    }

    @Override
    public void setDrawMode(long l) {
    }

    @Override
    public long getDrawMode() {
        return 0L;
    }

    @Override
    public void setDrawStyle(long l) {
    }

    @Override
    public long getDrawStyle() {
        return 0L;
    }

    @Override
    public void setDrawWidth(long l) {
    }

    @Override
    public long getDrawWidth() {
        return 0L;
    }

    @Override
    public void setFillStyle(long l) {
    }

    @Override
    public long getFillStyle() {
        return 0L;
    }

    @Override
    public IDiagram getDiagram() {
        IDrawingAreaControl iDrawingAreaControl;
        IDiagram iDiagram = null;
        IDiagramEngine iDiagramEngine = this.getDiagramEngine();
        if (iDiagramEngine != null && (iDrawingAreaControl = iDiagramEngine.getDrawingArea()) != null) {
            iDiagram = iDrawingAreaControl.getDiagram();
        }
        return iDiagram;
    }

    @Override
    public void initialize() {
        ETList<IPresentationElement> eTList;
        IDiagram iDiagram = this.getDiagram();
        Component[] componentArray = this.getComponents();
        this.clear();
        if (iDiagram != null && (eTList = iDiagram.getAllItems()) != null && eTList.size() > 0) {
            for (IPresentationElement iPresentationElement : eTList) {
                this.addPresentationElement(iPresentationElement);
            }
        }
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof TrackCoupling)) continue;
            TrackCoupling trackCoupling = (TrackCoupling)componentArray[i];
            int n = this.getComponentCount();
            boolean bl = false;
            for (int j = 0; j < n && !bl; ++j) {
                TrackCoupling trackCoupling2;
                Component component = this.getComponent(j);
                if (!(component instanceof TrackCoupling) || !trackCoupling.equals(trackCoupling2 = (TrackCoupling)component)) continue;
                trackCoupling.copyAttributes(trackCoupling2);
            }
        }
        this.repaint();
    }

    @Override
    public void invalidate(boolean bl) {
        this.invalidate(bl);
    }

    @Override
    public void load(IProductArchive iProductArchive) {
        IProductArchiveElement iProductArchiveElement;
        if (iProductArchive != null && (iProductArchiveElement = iProductArchive.getElement("Embarcadero.AxTrackBar")) != null) {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                TrackItem trackItem = (TrackItem)this.getComponent(i);
                if (trackItem == null) continue;
                trackItem.load(iProductArchiveElement);
            }
        }
        this.repaint();
    }

    @Override
    public void save(IProductArchive iProductArchive) {
        IProductArchiveElement iProductArchiveElement;
        if (iProductArchive != null && (iProductArchiveElement = iProductArchive.createElement("Embarcadero.AxTrackBar")) != null) {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                TrackItem trackItem = (TrackItem)this.getComponent(i);
                if (trackItem == null) continue;
                trackItem.save(iProductArchiveElement);
            }
        }
    }

    @Override
    public void addPresentationElement(IPresentationElement iPresentationElement) {
        if (iPresentationElement != null) {
            TrackCar trackCar = this.getTrackCar(iPresentationElement);
            if (trackCar == null) {
                IElement iElement = TypeConversions.getElement(iPresentationElement);
                if (iElement instanceof ILifeline) {
                    TrackCar trackCar2 = new TrackCar(this, iPresentationElement);
                    trackCar2.setName(this.getCaption(iPresentationElement));
                    this.addCar(trackCar2);
                    this.updateCarLocation(trackCar2);
                }
            } else {
                this.addCar(trackCar, false);
                this.updateCarLocation(trackCar);
            }
        }
    }

    protected String getCaption(IPresentationElement iPresentationElement) {
        IDataFormatter iDataFormatter;
        IElement iElement;
        String string = " : ";
        if (iPresentationElement != null && (iElement = TypeConversions.getElement(iPresentationElement)) != null && (iDataFormatter = ProductHelper.getDataFormatter()) != null) {
            string = iDataFormatter.formatElement(iElement);
        }
        return string;
    }

    @Override
    public void removePresentationElement(IPresentationElement iPresentationElement) {
        if (iPresentationElement != null) {
            TrackCar trackCar = this.getTrackCar(iPresentationElement);
            if (trackCar != null) {
                TrackCoupling trackCoupling = this.removeCar(trackCar);
                trackCoupling = null;
            }
            trackCar = null;
        }
        this.repaint();
    }

    @Override
    public void preResize(IPresentationElement iPresentationElement) {
    }

    @Override
    public boolean resize(IPresentationElement iPresentationElement) {
        boolean bl = false;
        TrackCar trackCar = this.getTrackCar(iPresentationElement);
        if (trackCar != null) {
            TrackItem trackItem;
            int n = trackCar.getX();
            int n2 = n + trackCar.getWidth();
            trackCar.resizeBasedOnPresentationElement(true);
            int n3 = trackCar.getX();
            int n4 = n3 + trackCar.getWidth();
            TrackItem trackItem2 = trackCar.getPreviousItem();
            if (trackItem2 != null) {
                int n5 = n3 - n;
                if (n5 < 0) {
                    trackItem2.push(n5);
                } else {
                    trackItem2.updateContraints(n5);
                }
            }
            if ((trackItem = trackCar.getNextItem()) != null) {
                int n6 = n4 - n2;
                if (n6 > 0) {
                    trackItem.push(n6);
                } else {
                    trackItem.updateContraints(n6);
                }
            }
        }
        return bl;
    }

    @Override
    public void updateName(IPresentationElement iPresentationElement) {
        if (iPresentationElement != null) {
            TrackCar trackCar = this.getTrackCar(iPresentationElement);
            this.updateName(trackCar);
        }
    }

    public void updateName(TrackCar trackCar) {
        if (trackCar != null) {
            String string = this.getCaption(trackCar.getPresentationElement());
            trackCar.setName(string);
            trackCar.invalidate();
        }
    }

    @Override
    public void updateAllCarNames() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof TrackCar)) continue;
            TrackCar trackCar = (TrackCar)component;
            this.updateName(trackCar);
        }
    }

    @Override
    public void expandAssociatedCoupling(ILabelPresentation iLabelPresentation) {
    }

    @Override
    public void expandCouplings() {
    }

    @Override
    public boolean onPostScrollZoom() {
        IDiagram iDiagram = this.getDiagram();
        if (iDiagram != null) {
            this.layoutTrack();
        }
        return true;
    }

    protected void layoutTrack() {
        TrackItem trackItem;
        Component component;
        int n;
        int n2 = this.getComponentCount();
        for (n = 0; n < n2; ++n) {
            component = this.getComponent(n);
            if (!(component instanceof TrackCar)) continue;
            trackItem = (TrackCar)component;
            ((TrackCar)trackItem).resizeBasedOnPresentationElement(false);
        }
        for (n = 0; n < n2; ++n) {
            component = this.getComponent(n);
            if (!(component instanceof TrackCoupling)) continue;
            trackItem = (TrackCoupling)component;
            ((TrackCoupling)trackItem).resizeToFitNeighbors();
        }
    }

    private void debugPrintOrder() {
        ETSystem.out.println("Begin Track Location Trace...");
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof TrackCar)) continue;
            TrackCar trackCar = (TrackCar)component;
            String string = trackCar.getName();
            Rectangle rectangle = trackCar.getBounds();
            ETSystem.out.println("Car '" + string + "' at " + rectangle.getX() + " to " + (rectangle.getX() + rectangle.getWidth()));
            TrackCoupling trackCoupling = (TrackCoupling)trackCar.getPreviousItem();
            if (trackCoupling == null) continue;
            rectangle = trackCoupling.getBounds();
            ETSystem.out.println("Coupling at " + rectangle.getX() + " to " + (rectangle.getX() + rectangle.getWidth()));
        }
        ETSystem.out.println("End Track Location Trace");
    }

    @Override
    public boolean onKeyDown(KeyEvent keyEvent) {
        return false;
    }

    @Override
    public boolean onKeyUp(KeyEvent keyEvent) {
        return false;
    }

    @Override
    public void postLayoutSequenceDiagram() {
        HashMap<String, TrackCar> hashMap = new HashMap<String, TrackCar>(this.m_TrackCars);
        this.clear();
        this.m_TrackCars.clear();
        IDiagram iDiagram = this.getDiagram();
        if (iDiagram != null) {
            IUIDiagram iUIDiagram = null;
            if (iDiagram instanceof IUIDiagram) {
                iUIDiagram = (IUIDiagram)iDiagram;
            }
            IDrawingAreaControl iDrawingAreaControl = null;
            if (iUIDiagram != null) {
                iDrawingAreaControl = iUIDiagram.getDrawingArea();
                ETList<IPresentationElement> eTList = iDiagram.getAllItems();
                ETList<IPresentationElement> eTList2 = null;
                if (iDrawingAreaControl != null) {
                    eTList2 = GetHelper.sortNodesLeftToRight(eTList);
                }
                if (eTList2 != null) {
                    for (IPresentationElement iPresentationElement : eTList2) {
                    }
                    int n = eTList2.getCount();
                    for (int i = 0; i < n; ++i) {
                        IPresentationElement iPresentationElement = eTList2.item(i);
                        IPresentationElement iPresentationElement2 = null;
                        if (i > 0) {
                            iPresentationElement2 = eTList2.item(i - 1);
                        }
                        INodePresentation iNodePresentation = null;
                        if (iPresentationElement instanceof INodePresentation) {
                            iNodePresentation = (INodePresentation)iPresentationElement;
                        }
                        INodePresentation iNodePresentation2 = null;
                        if (iPresentationElement2 instanceof INodePresentation) {
                            iNodePresentation2 = (INodePresentation)iPresentationElement2;
                        }
                        if (iNodePresentation == null) continue;
                        if (iNodePresentation2 == null) {
                            this.addPresentationElement(iPresentationElement);
                            continue;
                        }
                        IETRect iETRect = iNodePresentation.getLocation();
                        IETRect iETRect2 = iNodePresentation2.getLocation();
                        if (iETRect.getCenterX() < iETRect2.getCenterX()) {
                            int n2 = 25;
                            double d = iETRect2.getCenterX() + iETRect2.getWidth() / 2.0 + 5.0;
                            iNodePresentation.moveTo((int)d, 0, n2);
                        }
                        this.addPresentationElement(iPresentationElement);
                    }
                }
            }
        }
    }

    @Override
    public void removePresentationElements(ETList<IPresentationElement> eTList) {
        Iterator iterator = eTList.iterator();
        while (iterator.hasNext()) {
            this.removePresentationElement((IPresentationElement)iterator.next());
        }
    }

    @Override
    public boolean moveObjects(ETList<IPresentationElement> eTList, long l) {
        boolean bl = false;
        Iterator iterator = eTList.iterator();
        while (iterator.hasNext()) {
            TrackCar trackCar = this.getTrackCar((IPresentationElement)iterator.next());
            if (trackCar == null) continue;
            this.updateCarLocation(trackCar);
            bl = true;
        }
        return bl;
    }

    protected void updateCarLocation(TrackCar trackCar) {
        TrackItem trackItem = trackCar.getPreviousItem();
        TrackItem trackItem2 = trackCar.getNextItem();
        TrackCoupling trackCoupling = this.removeCar(trackCar);
        if (trackCoupling != null) {
            this.remove(trackCoupling);
        }
        this.addCar(trackCar);
        TrackItem trackItem3 = trackCar.getPreviousItem();
        TrackItem trackItem4 = trackCar.getNextItem();
        if (trackItem != null && trackItem3 != null && trackItem.isBetweenSameNeighbors(trackItem3)) {
            trackItem3.copyAttributes(trackItem);
        } else if (trackItem != null && trackItem4 != null && trackItem.isBetweenSameNeighbors(trackItem4)) {
            trackItem4.copyAttributes(trackItem);
        }
        if (trackItem2 != null && trackItem3 != null && trackItem2.isBetweenSameNeighbors(trackItem3)) {
            trackItem3.copyAttributes(trackItem);
        } else if (trackItem2 != null && trackItem4 != null && trackItem2.isBetweenSameNeighbors(trackItem4)) {
            trackItem4.copyAttributes(trackItem2);
        }
        if (trackCoupling != null) {
            this.remove(trackCoupling);
        }
    }

    public void clear() {
        this.removeAll();
        this.m_TrackCars.clear();
    }

    public TrackCoupling removeCar(TrackCar trackCar) {
        TrackCoupling trackCoupling = null;
        if (trackCar != null) {
            TrackItem trackItem = trackCar.getPreviousItem();
            TrackItem trackItem2 = trackCar.getNextItem();
            if (trackItem == null) {
                if (trackItem2 != null) {
                    if (trackItem2 instanceof TrackCoupling) {
                        trackCoupling = (TrackCoupling)trackItem2;
                    }
                    trackItem2 = trackItem2.getNextItem();
                }
            } else {
                if (trackItem instanceof TrackCoupling) {
                    trackCoupling = (TrackCoupling)trackItem;
                }
                trackItem = trackItem.getPreviousItem();
            }
            if (trackItem != null) {
                trackItem.setNextItem(trackItem2);
                trackCoupling.setPreviousItem(null);
                this.remove(trackCoupling);
            }
            if (trackItem2 != null) {
                trackItem2.setPreviousItem(trackItem);
                if (trackItem == null) {
                    trackCoupling.setPreviousItem(null);
                    this.remove(trackCoupling);
                }
            }
            trackCar.setPreviousItem(null);
            trackCar.setNextItem(null);
            this.m_TrackCars.remove(trackCar.getXMIID());
            this.remove(trackCar);
            this.layoutTrack();
        }
        return trackCoupling;
    }

    @Override
    public Dimension getPreferredSize() {
        ADGraphWindow aDGraphWindow;
        Object object;
        Dimension dimension = null;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight() + fontMetrics.getDescent() + 9;
        IDiagramEngine iDiagramEngine = this.getDiagramEngine();
        if (iDiagramEngine != null && (object = iDiagramEngine.getDrawingArea()) != null && (aDGraphWindow = object.getGraphWindow()) != null) {
            dimension = aDGraphWindow.getPreferredSize();
        }
        object = null;
        object = dimension != null ? new Dimension(dimension.width, n) : new Dimension(0, n);
        return object;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(color);
    }

    public void addCar(TrackCar trackCar) {
        this.addCar(trackCar, true);
    }

    public void addCar(TrackCar trackCar, boolean bl) {
        trackCar.resizeBasedOnPresentationElement(false);
        if (!bl) {
            this.remove(trackCar);
        }
        if (this.getComponentCount() == 0) {
            this.add(trackCar);
        } else {
            int n = this.findPreviousItem(trackCar);
            this.insertCar(trackCar, n);
        }
        if (bl) {
            this.m_TrackCars.put(trackCar.getXMIID(), trackCar);
        }
        this.repaint();
        this.reportCars();
    }

    protected void reportCars() {
    }

    protected void insertCar(TrackCar trackCar, int n) {
        TrackCoupling trackCoupling;
        this.add((Component)trackCar, n);
        int n2 = this.getComponentCount();
        TrackItem trackItem = null;
        if (n + 1 < n2) {
            trackItem = (TrackItem)this.getComponent(n + 1);
        }
        TrackItem trackItem2 = null;
        if (n - 1 >= 0) {
            trackItem2 = (TrackItem)this.getComponent(n - 1);
        }
        if (trackItem != null) {
            if (trackItem instanceof TrackCoupling) {
                trackCoupling = (TrackCoupling)trackItem;
                trackCoupling.setPreviousItem(trackCar);
                trackCar.setNextItem(trackCoupling);
                trackCoupling.resizeToFitNeighbors(trackCar);
            } else {
                trackCoupling = new TrackCoupling(this, trackCar, trackItem);
                trackCar.setNextItem(trackCoupling);
                trackItem.setPreviousItem(trackCoupling);
                trackCoupling.resizeToFitNeighbors(trackCar);
                this.add((Component)trackCoupling, n + 1);
            }
        }
        if (trackItem2 != null) {
            if (trackItem2 instanceof TrackCoupling) {
                trackCoupling = (TrackCoupling)trackItem2;
                trackCoupling.setNextItem(trackCar);
                trackCar.setPreviousItem(trackCoupling);
                trackCoupling.resizeToFitNeighbors(trackCar);
            } else {
                trackCoupling = new TrackCoupling(this, trackItem2, trackCar);
                trackCar.setPreviousItem(trackCoupling);
                trackItem2.setNextItem(trackCoupling);
                trackCoupling.resizeToFitNeighbors(trackCar);
                ETSystem.out.println(trackCoupling.getBounds());
                this.add((Component)trackCoupling, n);
            }
        }
        this.repaint();
    }

    protected int findPreviousItem(TrackCar trackCar) {
        Component component;
        int n;
        int n2 = 0;
        int n3 = trackCar.getX() + trackCar.getWidth() / 2;
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length && (n = (component = componentArray[i]).getX() + component.getWidth() / 2) < n3; ++i) {
            n2 = i + 1;
        }
        return n2;
    }

    public IDiagramEngine getDiagramEngine() {
        return this.m_DiagramEngine;
    }

    public void setDiagramEngine(IDiagramEngine iDiagramEngine) {
        this.m_DiagramEngine = iDiagramEngine;
    }

    protected TrackCar getTrackCar(IPresentationElement iPresentationElement) {
        TrackCar trackCar = null;
        if (iPresentationElement != null) {
            trackCar = this.getTrackCar(iPresentationElement.getXMIID());
        }
        return trackCar;
    }

    protected TrackCar getTrackCar(String string) {
        TrackCar trackCar = null;
        if (string != null && string.length() > 0) {
            trackCar = this.m_TrackCars.get(string);
        }
        return trackCar;
    }

    protected void showContextMenu(MouseEvent mouseEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.getComponentCount() > 0) {
            this.getComponent(0).requestFocus();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTrackBar();
        }
        return this.accessibleContext;
    }

    public class AccessibleJTrackBar
    extends JPanel.AccessibleJPanel {
        public AccessibleJTrackBar() {
            super(JTrackBar.this);
        }

        public String getAccessibleName() {
            return TrackBarResource.getString("ACSN_TrackBar");
        }

        public String getAccessibleDescription() {
            String string = null;
            if (JTrackBar.this.getDiagramEngine() != null && JTrackBar.this.getDiagramEngine().getDrawingArea() != null) {
                string = JTrackBar.this.getDiagramEngine().getDrawingArea().getName();
            }
            return MessageFormat.format(TrackBarResource.getString("ACSD_TrackBar"), string);
        }
    }

    public class TrackBarMouseListener
    extends MouseInputAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JTrackBar.this.showContextMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JTrackBar.this.showContextMenu(mouseEvent);
            }
        }
    }
}

