/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.projecttree;

import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.IDataFormatter;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProject;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeItem;
import org.netbeans.modules.uml.ui.controls.projecttree.ProductProjectTreeModel;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProxyUserInterface;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeElement;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeItem;
import org.netbeans.modules.uml.ui.swing.projecttree.ISwingProjectTreeModel;
import org.netbeans.modules.uml.ui.swing.projecttree.ProjectTreeResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTreeSwingModel
extends ProductProjectTreeModel
implements ISwingProjectTreeModel {
    private ArrayList<TreeModelListener> m_ModelListeners = new ArrayList();

    public ProjectTreeSwingModel(ICoreProduct iCoreProduct) {
        super(iCoreProduct);
    }

    public ProjectTreeSwingModel() {
    }

    protected ArrayList<TreeModelListener> getModelListeners() {
        return this.m_ModelListeners;
    }

    @Override
    public ITreeItem getTreeItem(TreePath treePath) {
        ITreeItem iTreeItem = null;
        if (treePath.getLastPathComponent() != null && treePath.getLastPathComponent() instanceof ITreeItem) {
            iTreeItem = (ITreeItem)treePath.getLastPathComponent();
        }
        return iTreeItem;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.getRoot() != null) {
            this.fireTreeStructureChanged(this.getRoot(), new TreePath(this.getRoot()));
        }
    }

    @Override
    public Object getRoot() {
        return super.getRootItem();
    }

    @Override
    public Object getChild(Object object, int n) {
        return super.getChildItem(object, n);
    }

    @Override
    public int getChildCount(Object object) {
        return super.getChildCount(object);
    }

    @Override
    public boolean isLeaf(Object object) {
        return super.isLeaf(object);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        int n = 0;
        boolean bl = object instanceof ITreeItem;
        boolean bl2 = object2 instanceof ITreeItem;
        if (bl && bl2) {
            n = super.getIndexOfChild((ITreeItem)object, (ITreeItem)object2);
        }
        return n;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.m_ModelListeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.m_ModelListeners.remove(treeModelListener);
    }

    @Override
    public void notifyOfStructureChange(ETList<ITreeItem> eTList) {
        for (ITreeItem iTreeItem : eTList) {
            if (iTreeItem == null) continue;
            iTreeItem.setIsInitalized(false);
            this.fireTreeStructureChanged(this, new TreePath(iTreeItem.getPath()));
        }
    }

    @Override
    public void notifyOfRemovedChildren(ITreeItem iTreeItem, int[] nArray, ITreeItem[] iTreeItemArray) {
        if (iTreeItemArray != null && nArray != null) {
            this.fireTreeNodesRemoved(this, iTreeItem.getPath(), nArray, iTreeItemArray);
        }
    }

    @Override
    public void notifyOfAddedChildren(ITreeItem iTreeItem, int[] nArray) {
        if (nArray != null) {
            ITreeItem iTreeItem2 = this.getChildItem(iTreeItem, nArray[0]);
            Object[] objectArray = new ITreeItem[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = iTreeItem.getChild(nArray[i]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(iTreeItem), nArray, objectArray);
        }
    }

    @Override
    public void notifyOfNodesChanged(ITreeItem iTreeItem, int[] nArray, ITreeItem[] iTreeItemArray) {
        if (iTreeItemArray != null && nArray != null && iTreeItem != null) {
            if (nArray != null) {
                int n = nArray.length;
                if (n > 0) {
                    Object[] objectArray = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        objectArray[i] = iTreeItem.getChild(nArray[i]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(iTreeItem), nArray, objectArray);
                }
            } else if (iTreeItem == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(iTreeItem), null, null);
            }
        }
    }

    protected int[] getAffectedChildren(ITreeItem iTreeItem, int[] nArray) {
        int[] nArray2 = null;
        if (iTreeItem != null && nArray != null) {
            if (nArray.length == 1) {
                int n = this.findLocation(iTreeItem, iTreeItem.getChild(nArray[0]));
                nArray2 = nArray[0] < n ? this.getIndexBetween(nArray[0], iTreeItem.getChildCount() - 1) : (nArray[0] > n ? this.getIndexBetween(n, iTreeItem.getChildCount() - 1) : new int[]{nArray[0]});
            } else {
                int n;
                int n2 = iTreeItem.getChildCount() - 1;
                for (n = 0; n < nArray.length; ++n) {
                    int n3;
                    ITreeItem iTreeItem2 = iTreeItem.getChild(n);
                    if (iTreeItem2 == null || (n3 = this.findLocation(iTreeItem, iTreeItem.getChild(nArray[n]))) >= n2) continue;
                    n2 = n3;
                }
                for (n = 0; n < nArray.length; ++n) {
                    if (nArray[n] >= n2) continue;
                    n2 = nArray[n];
                }
                nArray2 = this.getIndexBetween(n2, iTreeItem.getChildCount() - 1);
            }
        }
        return nArray2;
    }

    protected int[] getIndexBetween(int n, int n2) {
        int[] nArray = new int[n2 - n];
        int n3 = n;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n3++;
        }
        return nArray;
    }

    public Object[] getPathToRoot(ITreeItem iTreeItem) {
        return this.getPathToRoot(iTreeItem, 0);
    }

    protected ITreeItem[] getPathToRoot(ITreeItem iTreeItem, int n) {
        ITreeItem[] iTreeItemArray = null;
        if (iTreeItem == null) {
            if (n > 0) {
                iTreeItemArray = new ITreeItem[n];
            }
        } else {
            iTreeItemArray = iTreeItem == this.getRoot() ? new ITreeItem[n] : this.getPathToRoot(iTreeItem.getParentItem(), ++n);
            iTreeItemArray[iTreeItemArray.length - n] = iTreeItem;
        }
        return iTreeItemArray;
    }

    protected void fireTreeNodesChanged(final Object object, final Object[] objectArray, final int[] nArray, final Object[] objectArray2) {
        final ArrayList<TreeModelListener> arrayList = this.m_ModelListeners;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeModelEvent treeModelEvent = null;
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    try {
                        if (treeModelEvent == null) {
                            treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                        }
                        TreeModelListener treeModelListener = (TreeModelListener)arrayList.get(i);
                        treeModelListener.treeNodesChanged(treeModelEvent);
                        continue;
                    }
                    catch (Exception exception) {
                        Log.stackTrace(exception);
                    }
                }
            }
        });
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = null;
        for (int i = this.m_ModelListeners.size() - 1; i >= 0; --i) {
            try {
                Object object2;
                if (treeModelEvent == null) {
                    object2 = new TempTreePath(objectArray);
                    TreePath treePath = ((TreePath)object2).getParentPath();
                    treeModelEvent = new TreeModelEvent(object, (TreePath)object2, nArray, objectArray2);
                }
                object2 = this.m_ModelListeners.get(i);
                object2.treeNodesInserted(treeModelEvent);
                continue;
            }
            catch (Exception exception) {
                Log.stackTrace(exception);
            }
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = null;
        for (int i = this.m_ModelListeners.size() - 1; i >= 0; --i) {
            try {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                TreeModelListener treeModelListener = this.m_ModelListeners.get(i);
                treeModelListener.treeNodesRemoved(treeModelEvent);
                continue;
            }
            catch (Exception exception) {
                Log.stackTrace(exception);
            }
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = null;
        for (int i = this.m_ModelListeners.size() - 1; i >= 0; --i) {
            try {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
                }
                TreeModelListener treeModelListener = this.m_ModelListeners.get(i);
                treeModelListener.treeStructureChanged(treeModelEvent);
                continue;
            }
            catch (Exception exception) {
                Log.stackTrace(exception);
            }
        }
    }

    protected void fireTreeStructureChanged(Object object, TreePath treePath) {
        TreeModelEvent treeModelEvent = null;
        for (int i = this.m_ModelListeners.size() - 1; i >= 0; --i) {
            try {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent(object, treePath);
                }
                TreeModelListener treeModelListener = this.m_ModelListeners.get(i);
                treeModelListener.treeStructureChanged(treeModelEvent);
                continue;
            }
            catch (Exception exception) {
                Log.stackTrace(exception);
            }
        }
    }

    @Override
    public String getProjectTreeName() {
        return ProjectTreeResources.getString("ProjectTreeSwingModel.ProjectTree_Name");
    }

    @Override
    public void setProjectTree(JTree jTree) {
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
    }

    @Override
    public IProjectTreeItem addWorkspace(ITreeItem iTreeItem, IWorkspace iWorkspace) {
        this.setWorkspace(iWorkspace);
        return null;
    }

    @Override
    public void handleProjectCreated(IProject iProject, IResultCell iResultCell) {
        if (this.isProjectTree() && iProject != null) {
            ITreeItem iTreeItem = this.projectOpened(iProject);
        }
    }

    @Override
    public void handleProjectOpened(IProject iProject, IResultCell iResultCell) {
        ITreeElement iTreeElement;
        if (this.isProjectTree() && iProject != null && (iTreeElement = this.getProjectNode(iProject)) != null) {
            iTreeElement.setElement(iProject);
            int[] nArray = new int[]{super.getIndexOfChild(this.getRootItem(), iTreeElement)};
            ITreeItem[] iTreeItemArray = new ITreeItem[]{iTreeElement};
            this.notifyOfNodesChanged(this.getRootItem(), nArray, iTreeItemArray);
            this.fireProjectOpened(iTreeElement, iProject);
        }
    }

    @Override
    public void handleProjectClosed(IProject iProject, IResultCell iResultCell) {
        ITreeElement iTreeElement;
        if (this.isProjectTree() && iProject != null && (iTreeElement = this.getProjectNode(iProject)) != null) {
            this.fireProjectClosed(iTreeElement, iProject);
            ITreeItem[] iTreeItemArray = new ITreeItem[]{iTreeElement};
            int[] nArray = new int[]{super.getIndexOfChild(this.getRootItem(), iTreeElement)};
            iTreeElement.setElement(null);
            iTreeElement.setIsInitalized(false);
            this.notifyOfNodesChanged(this.getRootItem(), nArray, iTreeItemArray);
            ITreeItem[] iTreeItemArray2 = new ITreeItem[iTreeElement.getChildCount()];
            int[] nArray2 = new int[iTreeElement.getChildCount()];
            for (int i = 0; i < iTreeItemArray2.length; ++i) {
                iTreeItemArray2[i] = iTreeElement.getChild(i);
                nArray2[i] = i;
            }
            iTreeElement.removeAllChildren();
            this.notifyOfRemovedChildren(iTreeElement, nArray2, iTreeItemArray2);
        }
    }

    @Override
    public void handleProjectRenamed(IProject iProject, String string, IResultCell iResultCell) {
        ITreeElement iTreeElement;
        if (this.isProjectTree() && iProject != null && (iTreeElement = this.getProjectNode(string)) != null) {
            IDataFormatter iDataFormatter = ProductHelper.getDataFormatter();
            String string2 = iDataFormatter.formatElement(iProject);
            iTreeElement.setDisplayedName(string2);
            iTreeElement.setName(string2);
            int[] nArray = new int[]{super.getIndexOfChild(this.getRootItem(), iTreeElement)};
            ITreeItem[] iTreeItemArray = new ITreeItem[]{iTreeElement};
            this.notifyOfNodesChanged(this.getRootItem(), nArray, iTreeItemArray);
        }
    }

    @Override
    public void handleWSProjectRemoved(IWSProject iWSProject, IResultCell iResultCell) {
    }

    @Override
    public void handleWSProjectInserted(IWSProject iWSProject, IResultCell iResultCell) {
    }

    @Override
    public boolean isProjectTree() {
        return true;
    }

    @Override
    public void closeProject(IProject iProject) {
        IProxyUserInterface iProxyUserInterface = ProductHelper.getProxyUserInterface();
        iProxyUserInterface.closeProject(iProject);
    }

    @Override
    public void fireItemExpanding(ITreeItem iTreeItem) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ITreeItem getDiagramsRootNode(IProject iProject) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isDiagramsRootNode(ITreeItem iTreeItem) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public class TempTreePath
    extends TreePath {
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof TreePath) {
                TreePath treePath = (TreePath)object;
                if (this.getPathCount() != treePath.getPathCount()) {
                    return false;
                }
                for (TreePath treePath2 = this; treePath2 != null; treePath2 = treePath2.getParentPath()) {
                    if (!treePath2.getLastPathComponent().equals(treePath.getLastPathComponent())) {
                        return false;
                    }
                    treePath = treePath.getParentPath();
                }
                return true;
            }
            return false;
        }

        public TempTreePath(Object[] objectArray) {
            super(objectArray);
        }
    }
}

