/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.projecttree;

import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PreserveTreeState {
    private JTree m_ProjectTree = null;
    private int m_NumInstances = 0;
    private ArrayList m_ExpandNodes = new ArrayList();
    private TreePath[] m_SelectedItems = null;

    public PreserveTreeState(JTree jTree) {
        this.setProjectTree(jTree);
    }

    public void perserveState() {
        this.increment();
        if (this.isAbleToPerserve() && this.getProjectTree() != null) {
            int n = this.getProjectTree().getRowCount();
            for (int i = 0; i < n; ++i) {
                this.addToExpandedNodes(i);
            }
            this.m_SelectedItems = this.getProjectTree().getSelectionPaths();
        }
    }

    protected void addToExpandedNodes(int n) {
        if (this.getProjectTree().isExpanded(n)) {
            this.m_ExpandNodes.add(this.getProjectTree().getPathForRow(n));
        }
    }

    public void restoreState() {
        if (this.isAbleToPerserve() && this.getProjectTree() != null) {
            this.expand();
        }
        this.decrement();
    }

    protected void expand() {
        if (this.isAbleToPerserve()) {
            for (TreePath treePath : this.m_ExpandNodes) {
                this.expandThisItem(treePath);
            }
        }
    }

    protected void expandThisItem(TreePath treePath) {
        TreeModel treeModel = this.getProjectTree().getModel();
        Object[] objectArray = treePath.getPath();
        Object object = null;
        TreePath treePath2 = null;
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                object = this.findChildItem(object, objectArray[i], treeModel);
                if (object == null) break;
                treePath2 = treePath2 == null ? new TreePath(object) : treePath2.pathByAddingChild(object);
                this.getProjectTree().expandPath(treePath2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Object findChildItem(Object object, Object object2, TreeModel treeModel) {
        Object object3 = null;
        if (object != null) {
            int n = treeModel.getChildCount(object);
            for (int i = 0; i < n && object3 == null; ++i) {
                Object object4 = treeModel.getChild(object, i);
                if (!object2.equals(object4)) continue;
                object3 = object4;
            }
        } else if (object2.equals(treeModel.getRoot())) {
            object3 = treeModel.getRoot();
        }
        return object3;
    }

    public JTree getProjectTree() {
        return this.m_ProjectTree;
    }

    public void setProjectTree(JTree jTree) {
        this.m_ProjectTree = jTree;
    }

    public boolean isAbleToPerserve() {
        return this.m_NumInstances == 1;
    }

    public void increment() {
        ++this.m_NumInstances;
    }

    public void decrement() {
        --this.m_NumInstances;
    }
}

