/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.projecttree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.uml.core.eventframework.IEventPayload;
import org.netbeans.modules.uml.ui.controls.filter.FilterItem;
import org.netbeans.modules.uml.ui.controls.filter.IFilterDialog;
import org.netbeans.modules.uml.ui.controls.filter.IFilterItem;
import org.netbeans.modules.uml.ui.controls.filter.IFilterNode;
import org.netbeans.modules.uml.ui.controls.filter.IProjectTreeFilterDialogEventDispatcher;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeModel;
import org.netbeans.modules.uml.ui.support.DispatchHelper;
import org.netbeans.modules.uml.ui.swing.SelectableLabel;
import org.netbeans.modules.uml.ui.swing.commondialogs.JCenterDialog;
import org.netbeans.modules.uml.ui.swing.projecttree.ProjectTreeResources;

public class JFilterDialog
extends JCenterDialog
implements IFilterDialog {
    private JTree m_FilterTree = new JTree();
    private JButton m_OKBtn = null;
    private JButton m_CancelBtn = null;
    private DefaultTreeModel m_Model = null;
    private DefaultMutableTreeNode m_Root = new DefaultMutableTreeNode();
    private DispatchHelper m_Helper = new DispatchHelper();
    private IProjectTreeModel m_ProjectTreeModel = null;
    private JLabel spacer = new JLabel();

    public JFilterDialog(IProjectTreeModel iProjectTreeModel) {
        this.initialize();
        this.pack();
        this.setProjectTreeModel(iProjectTreeModel);
    }

    public JFilterDialog(Frame frame, IProjectTreeModel iProjectTreeModel) {
        super(frame, true);
        this.initialize();
        this.pack();
        this.center(frame);
        this.setProjectTreeModel(iProjectTreeModel);
    }

    public JFilterDialog(Dialog dialog, IProjectTreeModel iProjectTreeModel) {
        super(dialog, true);
        this.initialize();
        this.pack();
        this.center(dialog);
        this.setProjectTreeModel(iProjectTreeModel);
    }

    protected void initialize() {
        this.setTitle(ProjectTreeResources.getString("JFilterDialog.Filter_Dialog_Title"));
        this.initializeControls();
        this.setPreferredSize(new Dimension(400, 500));
        this.setResizable(true);
        CheckBoxTreeRenderEditor checkBoxTreeRenderEditor = new CheckBoxTreeRenderEditor();
        this.m_FilterTree.setCellRenderer(checkBoxTreeRenderEditor);
        this.m_FilterTree.setShowsRootHandles(true);
        this.m_FilterTree.addMouseListener(new NodeSelectionListener(this.m_FilterTree));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = JFilterDialog.this.m_FilterTree.getSelectionRows();
                if (nArray == null || nArray.length == 0) {
                    return;
                }
                int n = nArray[0];
                TreePath treePath = JFilterDialog.this.m_FilterTree.getPathForRow(n);
                if (treePath != null) {
                    FilterNode filterNode = (FilterNode)treePath.getLastPathComponent();
                    boolean bl = !filterNode.isOn();
                    int n2 = 2;
                    if (bl) {
                        n2 = 1;
                    }
                    JFilterDialog.this.setItemState(filterNode, n2);
                    ((DefaultTreeModel)JFilterDialog.this.m_FilterTree.getModel()).nodeChanged(filterNode);
                    if (n == 0) {
                        JFilterDialog.this.m_FilterTree.revalidate();
                        JFilterDialog.this.m_FilterTree.repaint();
                    }
                }
            }
        };
        this.m_FilterTree.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 0), 0);
        this.m_FilterTree.addFocusListener(new TreeFocusListerner());
        this.m_FilterTree.setEditable(true);
        this.m_FilterTree.setRootVisible(false);
        this.m_FilterTree.setShowsRootHandles(true);
    }

    protected void initializeControls() {
        this.m_OKBtn = new JButton(new OKAction(this));
        this.getRootPane().setDefaultButton(this.m_OKBtn);
        this.m_CancelBtn = new JButton(new CancelAction());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 5, 10));
        jPanel.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this.m_FilterTree);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.9, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        jPanel.add((Component)this.spacer, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.1, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
        jPanel.add((Component)this.m_OKBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 3), 0, 0));
        jPanel.add((Component)this.m_CancelBtn, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 3, 0, 3), 0, 0));
        Dimension dimension = this.m_OKBtn.getPreferredSize();
        Dimension dimension2 = this.m_CancelBtn.getPreferredSize();
        if (dimension2.width > dimension.width) {
            this.m_OKBtn.setPreferredSize(dimension2);
        } else {
            this.m_CancelBtn.setPreferredSize(dimension);
        }
        this.getContentPane().add(jPanel);
    }

    public IFilterNode createRootNode(String string) {
        FilterItem filterItem = new FilterItem(string);
        return this.createRootNode(filterItem);
    }

    public IFilterNode createRootNode(IFilterItem iFilterItem) {
        FilterNode filterNode = null;
        if (this.m_Root.getChildCount() < 2) {
            filterNode = new FilterNode(iFilterItem);
            this.m_Root.add(filterNode);
        }
        return filterNode;
    }

    public IFilterNode addFilterItem(IFilterNode iFilterNode, IFilterItem iFilterItem) {
        FilterNode filterNode = null;
        if (iFilterNode != null) {
            filterNode = new FilterNode(iFilterItem);
            iFilterNode.add(filterNode);
        }
        return filterNode;
    }

    public void show() {
        TreeModel treeModel = this.getModel();
        this.initializeModel(treeModel);
        this.m_FilterTree.setModel(treeModel);
        super.show();
    }

    public void show(DefaultTreeModel defaultTreeModel) {
        this.initializeModel(defaultTreeModel);
        this.m_FilterTree.setModel(defaultTreeModel);
        this.setModel(defaultTreeModel);
        super.show();
    }

    protected void clearModel() {
        this.m_Root.removeAllChildren();
        this.m_Model = null;
    }

    protected void initializeModel(TreeModel treeModel) {
        IProjectTreeFilterDialogEventDispatcher iProjectTreeFilterDialogEventDispatcher = null;
        iProjectTreeFilterDialogEventDispatcher = this.m_Helper.getProjectTreeFilterDialogDispatcher();
        IEventPayload iEventPayload = iProjectTreeFilterDialogEventDispatcher.createPayload("ProjectTreeFilterDialogInit");
        iProjectTreeFilterDialogEventDispatcher.fireProjectTreeFilterDialogInit(this, iEventPayload);
    }

    protected TreeModel getModel() {
        if (this.m_Model == null) {
            this.m_Root.removeAllChildren();
            this.m_Model = new DefaultTreeModel(this.m_Root);
        }
        return this.m_Model;
    }

    protected void setModel(DefaultTreeModel defaultTreeModel) {
        this.m_Model = defaultTreeModel;
        this.m_Root = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        this.m_Model.setRoot(this.m_Root);
    }

    public DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.getModel();
    }

    public IFilterNode[] getRootNodes() {
        IFilterNode[] iFilterNodeArray = new FilterNode[this.m_Root.getChildCount()];
        for (int i = 0; i < iFilterNodeArray.length; ++i) {
            iFilterNodeArray[i] = (IFilterNode)((Object)this.m_Root.getChildAt(i));
        }
        return iFilterNodeArray;
    }

    protected void setItemState(IFilterNode iFilterNode, int n) {
        iFilterNode.setState(n);
        int n2 = iFilterNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            FilterNode filterNode = (FilterNode)this.m_Model.getChild(iFilterNode, i);
            if (filterNode == null) continue;
            filterNode.setState(n);
        }
    }

    public IProjectTreeModel getProjectTreeModel() {
        return this.m_ProjectTreeModel;
    }

    protected void setProjectTreeModel(IProjectTreeModel iProjectTreeModel) {
        this.m_ProjectTreeModel = iProjectTreeModel;
    }

    public static void main(String[] stringArray) {
        final JFilterDialog jFilterDialog = new JFilterDialog(null);
        jFilterDialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowClosing(WindowEvent windowEvent) {
                jFilterDialog.dispose();
            }
        });
        IFilterNode iFilterNode = jFilterDialog.createRootNode(ProjectTreeResources.getString("JFilterDialog.Root_Node_Name"));
        jFilterDialog.addFilterItem(iFilterNode, new FilterItem(ProjectTreeResources.getString("JFilterDialog.Class_Node_Name")));
        jFilterDialog.addFilterItem(iFilterNode, new FilterItem(ProjectTreeResources.getString("JFilterDialog.Interface_Node_Name")));
        jFilterDialog.addFilterItem(iFilterNode, new FilterItem(ProjectTreeResources.getString("JFilterDialog.SourceFileArtifact_Node_Name")));
        jFilterDialog.show();
    }

    public class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(ProjectTreeResources.getString("JFilterDialog.Cancel_Btn_Title"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFilterDialog.this.hide();
            JFilterDialog.this.dispose();
        }
    }

    protected class OKAction
    extends AbstractAction {
        private JFilterDialog m_Dialog;

        public OKAction(JFilterDialog jFilterDialog2) {
            super(ProjectTreeResources.getString("JFilterDialog.OK_Btn_Title"));
            this.m_Dialog = null;
            this.m_Dialog = jFilterDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IFilterNode[] iFilterNodeArray = JFilterDialog.this.getRootNodes();
            if (iFilterNodeArray != null) {
                for (int i = 0; i < iFilterNodeArray.length; ++i) {
                    iFilterNodeArray[i].save(this.m_Dialog);
                }
            }
            IProjectTreeFilterDialogEventDispatcher iProjectTreeFilterDialogEventDispatcher = null;
            iProjectTreeFilterDialogEventDispatcher = JFilterDialog.this.m_Helper.getProjectTreeFilterDialogDispatcher();
            IEventPayload iEventPayload = iProjectTreeFilterDialogEventDispatcher.createPayload("ProjectTreeFilterDialogOKActivated");
            iProjectTreeFilterDialogEventDispatcher.fireProjectTreeFilterDialogOKActivated(this.m_Dialog, iEventPayload);
            JFilterDialog.this.hide();
            JFilterDialog.this.dispose();
        }
    }

    protected class FilterNode
    extends DefaultMutableTreeNode
    implements IFilterNode {
        private int m_State = 1;
        private IFilterItem m_Item = null;
        private Icon m_Icon = null;

        public FilterNode(IFilterItem iFilterItem) {
            this.setItem(iFilterItem);
        }

        public FilterNode(IFilterItem iFilterItem, Icon icon) {
            this.setIcon(icon);
            this.setItem(iFilterItem);
        }

        public boolean isOn() {
            return this.m_State == 1;
        }

        public void setState(int n) {
            this.m_State = n;
        }

        public IFilterItem getItem() {
            return this.m_Item;
        }

        public void setItem(IFilterItem iFilterItem) {
            this.m_Item = iFilterItem;
            this.setState(iFilterItem.getState());
        }

        public String getDispalyName() {
            String string = "";
            if (this.m_Item != null) {
                string = this.m_Item.getName();
            }
            return string;
        }

        public Icon getIcon() {
            Icon icon = null;
            if (this.getItem() != null) {
                icon = this.getItem().getIcon();
            }
            if (icon == null) {
                icon = this.m_Icon;
            }
            return icon;
        }

        public void setIcon(Icon icon) {
            this.m_Icon = icon;
        }

        public void save(IFilterDialog iFilterDialog) {
            IFilterItem iFilterItem = this.getItem();
            if (iFilterItem != null && this.m_State != iFilterItem.getState()) {
                iFilterItem.setState(this.m_State, iFilterDialog);
            }
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                IFilterNode iFilterNode;
                TreeNode treeNode = this.getChildAt(i);
                if (!(treeNode instanceof IFilterNode) || (iFilterNode = (IFilterNode)((Object)treeNode)) == null) continue;
                iFilterNode.save(iFilterDialog);
            }
        }

        public void add(IFilterNode iFilterNode) throws IllegalArgumentException {
            if (iFilterNode instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)iFilterNode;
                super.add(filterNode);
            }
        }
    }

    class TreeFocusListerner
    implements FocusListener {
        JTree tree;

        TreeFocusListerner() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component instanceof JTree) {
                this.tree = (JTree)component;
                TreePath treePath = this.tree.getPathForRow(0);
                this.tree.setSelectionPath(treePath);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component instanceof JTree) {
                this.tree = (JTree)component;
                this.tree.clearSelection();
            }
        }
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;

        NodeSelectionListener(JTree jTree) {
            this.tree = jTree;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object;
            int n;
            int n2 = mouseEvent.getX();
            int n3 = this.tree.getRowForLocation(n2, n = mouseEvent.getY());
            TreePath treePath = this.tree.getPathForRow(n3);
            if (treePath != null && (object = treePath.getLastPathComponent()) instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)object;
                boolean bl = !filterNode.isOn();
                int n4 = 2;
                if (bl) {
                    n4 = 1;
                }
                JFilterDialog.this.setItemState(filterNode, n4);
                ((DefaultTreeModel)this.tree.getModel()).nodeChanged(filterNode);
                if (n3 == 0) {
                    this.tree.revalidate();
                    this.tree.repaint();
                }
            }
        }
    }

    class CheckBoxTreeRenderEditor
    extends JPanel
    implements TreeCellRenderer {
        protected JCheckBox check;
        protected SelectableLabel strLabel;

        public CheckBoxTreeRenderEditor() {
            this.setLayout(null);
            this.check = new JCheckBox();
            this.add(this.check);
            this.strLabel = new SelectableLabel();
            this.add(this.strLabel);
            this.check.setLocation(50, 0);
            this.check.setBackground(UIManager.getColor("Tree.textBackground"));
            this.setOpaque(false);
            this.check.requestFocus();
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.initializeControl(object, jTree, bl, bl4);
            return this;
        }

        protected void initializeControl(Object object, JTree jTree, boolean bl, boolean bl2) {
            if (object instanceof IFilterNode) {
                IFilterNode iFilterNode = (IFilterNode)object;
                String string = iFilterNode.getDispalyName();
                this.setEnabled(jTree.isEnabled());
                if (iFilterNode != null) {
                    this.check.setSelected(iFilterNode.isOn());
                }
                this.strLabel.setFont(jTree.getFont());
                this.strLabel.setText(string);
                this.strLabel.setIcon(iFilterNode.getIcon());
                this.strLabel.setSelected(bl);
                this.strLabel.setFocus(bl2);
                if (bl) {
                    this.strLabel.setSelectedBackground(UIManager.getColor("Tree.selectionBackground"));
                    this.strLabel.setForeground(UIManager.getColor("Tree.selectionForeground"));
                } else {
                    this.strLabel.setForeground(UIManager.getColor("Tree.textForeground"));
                }
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode.getUserObject() != null) {
                    this.strLabel.setText("  " + defaultMutableTreeNode.getUserObject().toString());
                }
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.check.getPreferredSize();
            Dimension dimension2 = this.strLabel.getPreferredSize();
            return new Dimension(dimension.width + dimension2.width, dimension.height < dimension2.height ? dimension2.height : dimension.height);
        }

        public void doLayout() {
            Dimension dimension = this.check.getPreferredSize();
            Dimension dimension2 = this.strLabel.getPreferredSize();
            int n = 0;
            int n2 = 0;
            if (dimension.height > dimension2.height) {
                n = (dimension2.height - dimension.height) / 2;
            } else {
                n2 = (dimension.height - dimension2.height) / 2;
            }
            this.check.setLocation(0, n);
            this.check.setBounds(0, n, dimension.width, dimension.height);
            this.strLabel.setLocation(dimension.width, n2);
            this.strLabel.setBounds(dimension.width, n2, dimension2.width, dimension2.height);
        }

        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }
    }
}

