/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEWindowInputTool;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.ui.products.ad.drawengines.INodeDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ETPointEx;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETNode;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADGraphWindow;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.ETCrossHairCursor;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.ETInvalidCrossHair;

public class NodeDecoratorTool
extends TSEWindowInputTool {
    private Cursor m_DefaultCursor = ETCrossHairCursor.getCursor();
    private Cursor m_InvalidCrossHair = ETInvalidCrossHair.getCursor();
    private String m_Type = "";

    public NodeDecoratorTool(String string) {
        this.setDefaultCursor(this.m_DefaultCursor);
        this.setType(string);
    }

    public String getType() {
        return this.m_Type;
    }

    public void setType(String string) {
        this.m_Type = string;
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        IDrawEngine iDrawEngine;
        IETNode iETNode;
        if (!mouseEvent.isPopupTrigger() && this.isLeftMouseEvent(mouseEvent) && this.getType().length() > 0 && (iETNode = this.getObject(mouseEvent)) != null && (iDrawEngine = TypeConversions.getDrawEngine(iETNode)) instanceof INodeDrawEngine) {
            INodeDrawEngine iNodeDrawEngine = (INodeDrawEngine)iDrawEngine;
            ETPointEx eTPointEx = new ETPointEx(this.getAlignedWorldPoint(mouseEvent));
            iNodeDrawEngine.addDecoration(this.getType(), eTPointEx);
        }
        if (mouseEvent.isPopupTrigger()) {
            this.exitState();
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.exitState();
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        IETNode iETNode = this.getObject(mouseEvent);
        if (iETNode != null) {
            this.setCursor(this.m_DefaultCursor);
        } else {
            this.setCursor(this.m_InvalidCrossHair);
        }
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
        boolean bl = iDrawingAreaControl.isFocused();
        if (!bl) {
            iDrawingAreaControl.setFocus();
        }
    }

    protected IDrawingAreaControl getDrawingArea() {
        ADGraphWindow aDGraphWindow = this.getGraphWindow() instanceof ADGraphWindow ? (ADGraphWindow)this.getGraphWindow() : null;
        return aDGraphWindow != null ? aDGraphWindow.getDrawingArea() : null;
    }

    protected boolean isLeftMouseEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent);
    }

    protected boolean isRightMouseEvent(MouseEvent mouseEvent) {
        return !this.isLeftMouseEvent(mouseEvent);
    }

    protected IETNode getObject(MouseEvent mouseEvent) {
        return this.getObject(this.getNonalignedWorldPoint(mouseEvent));
    }

    protected IETNode getObject(TSConstPoint tSConstPoint) {
        IETNode iETNode = null;
        TSENode tSENode = this.getNodeAt(tSConstPoint, null, this.getGraphWindow().getGraph());
        if (tSENode instanceof IETNode) {
            iETNode = (IETNode)tSENode;
        }
        return iETNode;
    }

    protected void setDefaultState() {
        try {
            ((ADGraphWindow)this.getGraphWindow()).getDrawingArea().switchToDefaultState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void exitState() {
        this.stopMouseInput();
        this.setType("");
        this.setDefaultState();
    }
}

