/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.tool.TSEReconnectEdgeTool;
import com.tomsawyer.editor.tool.TSESelectTool;
import com.tomsawyer.editor.ui.TSENodeUI;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.common.generics.IteratorT;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.support.umlsupport.ETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.ui.products.ad.drawengines.ETEdgeDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.graphobjects.ETEdge;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.ETGenericEdgeUI;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.IETGraphObjectUI;
import org.netbeans.modules.uml.ui.support.CreationFactoryHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.IEdgePresentation;
import org.netbeans.modules.uml.ui.support.relationshipVerification.AddEdgeEventDispatcher;
import org.netbeans.modules.uml.ui.support.relationshipVerification.IEdgeVerification;
import org.netbeans.modules.uml.ui.support.relationshipVerification.IReconnectEdgeEvents;
import org.netbeans.modules.uml.ui.support.relationshipVerification.ReconnectEdgeEvents;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ETPointEx;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETEdge;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETNode;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IEdgeDrawEngine;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADGraphWindow;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.IReconnectEdgeContext;
import org.netbeans.modules.uml.ui.swing.drawingarea.ReconnectEdgeContext;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.NoDropCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADReconnectEdgeState
extends TSEReconnectEdgeTool
implements IReconnectEdgeEvents {
    protected IEdgeVerification m_IEdgeVerification = null;
    protected Cursor m_defaultCuror = null;
    protected Cursor m_noDropCursor = NoDropCursor.getCursor();
    protected TSENode m_orginalSourceNode;
    protected TSENode m_orginalTargetNode;
    protected IReconnectEdgeEvents m_eventDispatcher = null;
    protected TSConstPoint m_lastMousePos;
    protected boolean m_reconnectedEdge = false;
    protected TSEConnector m_associatedConnector = null;

    public ADReconnectEdgeState(TSEWindowInputTool tSEWindowInputTool) {
        super(tSEWindowInputTool);
    }

    public boolean possibleSourceAt(TSConstPoint tSConstPoint) {
        return super.possibleSourceAt(tSConstPoint);
    }

    public boolean possibleTargetAt(TSConstPoint tSConstPoint) {
        boolean bl = this.isPointOverNode(tSConstPoint);
        if (bl && this.verifyReconnectTarget(tSConstPoint)) {
            this.setCursor(this.m_defaultCuror);
            return super.possibleTargetAt(tSConstPoint);
        }
        if (bl) {
            this.showNoDropCursor();
        } else {
            this.setCursor(this.m_defaultCuror);
        }
        return false;
    }

    protected void showNoDropCursor() {
        this.setCursor(this.m_noDropCursor);
    }

    public void connectEdge() {
        block11: {
            try {
                boolean bl = this.isReconnectingTarget();
                if (this.verifyReconnectTarget(this.m_lastMousePos)) {
                    if (this.m_associatedConnector != null) {
                        if (bl) {
                            this.setTargetConnector(this.m_associatedConnector);
                        } else {
                            this.setSourceConnector(this.m_associatedConnector);
                        }
                        TSENode tSENode = this.getTargetNode();
                        TSENode tSENode2 = this.getSourceNode();
                        ETPairT<List, List> eTPairT = this.getReconnectEdgeBendPoints();
                        try {
                            ETGenericEdgeUI eTGenericEdgeUI = (ETGenericEdgeUI)this.getEdge().getUI();
                            ETEdge eTEdge = (ETEdge)this.getGraphWindow().reconnectEdge(this.getEdge(), bl ? tSENode : tSENode2, this.m_associatedConnector, !bl, eTPairT.getParamOne(), eTPairT.getParamTwo());
                            if (eTEdge != null) {
                                eTGenericEdgeUI.setOwner(eTEdge);
                                eTEdge.setUI((TSEObjectUI)eTGenericEdgeUI);
                                this.setDefaultState();
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        super.connectEdge();
                    }
                    this.m_associatedConnector = null;
                    break block11;
                }
                this.cancelAction();
            }
            catch (Exception exception) {
                ETSystem.out.println(exception.getMessage());
            }
        }
    }

    protected IEdgeVerification getVerification() {
        if (this.m_IEdgeVerification == null) {
            CreationFactoryHelper creationFactoryHelper = new CreationFactoryHelper();
            this.m_IEdgeVerification = creationFactoryHelper.getEdgeVerification();
        }
        return this.m_IEdgeVerification;
    }

    protected IEdgeDrawEngine getDrawEngine() {
        IETGraphObjectUI iETGraphObjectUI;
        TSEEdge tSEEdge = this.getEdge();
        if (tSEEdge != null && tSEEdge.getUI() instanceof IETGraphObjectUI && (iETGraphObjectUI = (IETGraphObjectUI)tSEEdge.getUI()) != null && iETGraphObjectUI.getDrawEngine() instanceof IEdgeDrawEngine) {
            return (IEdgeDrawEngine)iETGraphObjectUI.getDrawEngine();
        }
        return null;
    }

    protected void initBuildEdge() {
        this.m_associatedConnector = null;
        this.m_reconnectedEdge = false;
        this.m_orginalTargetNode = (TSENode)this.getEdge().getTargetNode();
        this.m_orginalSourceNode = (TSENode)this.getEdge().getSourceNode();
        if (this.fireReconnectEdgeStart(this.getReconnectContext())) {
            this.showNoDropCursor();
            this.cancelAction();
            return;
        }
        super.initBuildEdge();
        this.m_defaultCuror = this.getDefaultCursor();
        if (!this.getAllowReconnection()) {
            this.cancelAction();
            return;
        }
    }

    protected boolean getAllowReconnection() {
        IEdgeDrawEngine iEdgeDrawEngine = this.getDrawEngine();
        return iEdgeDrawEngine != null && iEdgeDrawEngine.getAllowReconnection() && this.verifyReconnectStart();
    }

    protected boolean verifyReconnectStart() {
        return this.getVerification().verifyReconnectStart(this.isReconnectingTarget() ? this.getTargetElement() : this.getSourceElement(), this.getDrawEngine().getElementType());
    }

    protected IETGraphObjectUI getSourceUI() {
        return this.m_orginalSourceNode != null ? (IETGraphObjectUI)this.m_orginalSourceNode.getUI() : null;
    }

    protected IETGraphObjectUI getTargetUI() {
        return this.m_orginalTargetNode != null ? (IETGraphObjectUI)this.m_orginalTargetNode.getUI() : null;
    }

    protected boolean verifyReconnectTarget(TSConstPoint tSConstPoint) {
        return this.verifyReconnectTarget(this.getUIAt(tSConstPoint));
    }

    protected boolean verifyReconnectTarget(MouseEvent mouseEvent) {
        return this.verifyReconnectTarget(this.getUIAt(mouseEvent));
    }

    protected boolean verifyReconnectTarget(IETGraphObjectUI iETGraphObjectUI) {
        IElement iElement;
        IElement iElement2;
        if (iETGraphObjectUI == null) {
            return false;
        }
        boolean bl = false;
        if (this.isReconnectingTarget()) {
            iElement2 = this.getSourceElement();
            iElement = iETGraphObjectUI.getModelElement();
        } else {
            iElement2 = iETGraphObjectUI.getModelElement();
            iElement = this.getTargetElement();
        }
        if (iElement2 != null && iElement != null && this.getDrawEngine() != null) {
            return this.getVerification().verifyFinishNode(iElement2, iElement, this.getDrawEngine().getElementType());
        }
        return false;
    }

    protected boolean verifyReconnectTarget() {
        return this.verifyReconnectTarget(this.isReconnectingTarget() ? (IETGraphObjectUI)super.getTargetNode().getUI() : (IETGraphObjectUI)super.getSourceNode().getUI());
    }

    protected IElement getNodeElement(TSENode tSENode) {
        IETGraphObjectUI iETGraphObjectUI = tSENode != null ? (IETGraphObjectUI)tSENode.getUI() : null;
        return iETGraphObjectUI != null ? iETGraphObjectUI.getModelElement() : null;
    }

    protected IElement getSourceElement() {
        return this.getNodeElement(this.m_orginalSourceNode);
    }

    protected IElement getTargetElement() {
        return this.getNodeElement(this.m_orginalTargetNode);
    }

    protected boolean fireShouldCreateBendEvent(TSConstPoint tSConstPoint) {
        AddEdgeEventDispatcher addEdgeEventDispatcher = new AddEdgeEventDispatcher(this.getDrawingArea().getDrawingAreaDispatcher(), this.getDrawingArea().getDiagram(), "");
        return addEdgeEventDispatcher.fireShouldCreateBendEvent(tSConstPoint);
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        this.m_lastMousePos = this.getNonalignedWorldPoint(mouseEvent);
        boolean bl = false;
        boolean bl2 = this.isLeftMouseEvent(mouseEvent);
        IEdgeDrawEngine iEdgeDrawEngine = this.getDrawEngine();
        if (iEdgeDrawEngine != null && bl2) {
            bl = this.isDragInProgress() ? iEdgeDrawEngine.handleLeftMouseBeginDrag(this.getETPoint(this.m_lastMousePos), this.getETPoint(this.m_lastMousePos)) : iEdgeDrawEngine.handleLeftMouseButton(mouseEvent);
        }
        if (!bl) {
            if (mouseEvent.isPopupTrigger() || !bl2) {
                this.cancelAction();
            }
            if (!this.isReconnecting()) {
                super.onMousePressed(mouseEvent);
            } else if (!this.isMouseOverNode(mouseEvent) && bl2 && this.fireShouldCreateBendEvent(this.m_lastMousePos)) {
                super.onMousePressed(mouseEvent);
            } else if (this.verifyReconnectTarget(mouseEvent) && this.finishReconnection(mouseEvent)) {
                super.onMousePressed(mouseEvent);
            }
        }
    }

    protected boolean isMouseOverNode(MouseEvent mouseEvent) {
        return this.isPointOverNode(this.getNonalignedWorldPoint(mouseEvent));
    }

    protected boolean isPointOverNode(TSConstPoint tSConstPoint) {
        IETGraphObjectUI iETGraphObjectUI = this.getUIAt(tSConstPoint);
        return iETGraphObjectUI != null && iETGraphObjectUI instanceof TSENodeUI;
    }

    public Cursor cursorFromPoint(TSConstPoint tSConstPoint) {
        boolean bl = this.isPointOverNode(tSConstPoint);
        if (bl && this.verifyReconnectTarget(tSConstPoint)) {
            return this.m_defaultCuror;
        }
        if (bl) {
            return this.m_noDropCursor;
        }
        return this.m_defaultCuror;
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        TSConstPoint tSConstPoint;
        this.m_lastMousePos = tSConstPoint = this.getNonalignedWorldPoint(mouseEvent);
        IReconnectEdgeContext iReconnectEdgeContext = this.getReconnectContext(tSConstPoint);
        boolean bl = this.fireReconnectEdgeMouseMove(iReconnectEdgeContext);
        if (bl) {
            if (this.getDisconnectedFromNode() != null && this.getDisconnectedFromNode().getETUI() != this.getUIAt(tSConstPoint)) {
                this.showNoDropCursor();
            }
        } else {
            super.onMouseMoved(mouseEvent);
            this.setCursor(this.m_defaultCuror);
            this.refresh();
        }
        if (!bl) {
            this.setCursor(this.m_defaultCuror);
        }
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        boolean bl = false;
        this.m_lastMousePos = this.getNonalignedWorldPoint(mouseEvent);
        IEdgeDrawEngine iEdgeDrawEngine = this.getDrawEngine();
        this.setCursor(this.cursorFromPoint(this.m_lastMousePos));
        if (iEdgeDrawEngine != null) {
            IETPoint iETPoint = this.getETPoint(mouseEvent);
            bl = iEdgeDrawEngine.handleLeftMouseDrag(iETPoint, iETPoint);
        }
        if (!bl) {
            super.onMouseDragged(mouseEvent);
        } else {
            this.refresh();
        }
    }

    public void onMouseClicked(MouseEvent mouseEvent) {
        this.m_lastMousePos = this.getNonalignedWorldPoint(mouseEvent);
        boolean bl = false;
        IEdgeDrawEngine iEdgeDrawEngine = this.getDrawEngine();
        if (iEdgeDrawEngine != null) {
            if (this.isLeftMouseEvent(mouseEvent)) {
                bl = mouseEvent.getClickCount() == 2 ? iEdgeDrawEngine.handleLeftMouseButtonDoubleClick(mouseEvent) : iEdgeDrawEngine.handleLeftMouseButton(mouseEvent);
            } else if (this.isRightMouseEvent(mouseEvent)) {
                bl = iEdgeDrawEngine.handleRightMouseButton(mouseEvent);
            }
            this.refresh();
        }
        if (!bl) {
            super.onMouseClicked(mouseEvent);
        }
    }

    protected IETPoint getETPoint(TSConstPoint tSConstPoint) {
        return tSConstPoint != null ? new ETPointEx(tSConstPoint) : new ETPoint(0, 0);
    }

    protected IETPoint getETPoint(MouseEvent mouseEvent, boolean bl) {
        return !bl ? this.getETPoint(mouseEvent) : this.getETPoint(this.getNonalignedWorldPoint(mouseEvent));
    }

    protected IETPoint getETPoint(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        return new ETPoint(point.x, point.y);
    }

    protected boolean isLeftMouseEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent);
    }

    protected boolean isRightMouseEvent(MouseEvent mouseEvent) {
        return !this.isLeftMouseEvent(mouseEvent);
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        boolean bl = false;
        IEdgeDrawEngine iEdgeDrawEngine = this.getDrawEngine();
        if (iEdgeDrawEngine != null && this.isLeftMouseEvent(mouseEvent)) {
            bl = mouseEvent.isControlDown() ? iEdgeDrawEngine.handleLeftMouseDrop(this.getETPoint(mouseEvent), null, false) : iEdgeDrawEngine.handleLeftMouseDrop(this.getETPoint(mouseEvent), null, true);
            this.refresh();
        }
        if (!bl) {
            boolean bl2 = bl = !this.finishReconnection(mouseEvent);
        }
        if (!bl) {
            super.onMouseReleased(mouseEvent);
            this.m_reconnectedEdge = false;
        } else if (this.getDisconnectedFromNode() != null && this.getDisconnectedFromNode().getETUI() == this.getUIAt(mouseEvent)) {
            this.cancelAction();
        } else {
            this.showNoDropCursor();
        }
    }

    protected boolean isReconnectingTarget() {
        return !this.isReconnectingSource();
    }

    protected IETGraphObjectUI getUIAt(TSConstPoint tSConstPoint) {
        TSEObject tSEObject = this.getHitTesting().getGraphObjectAt(tSConstPoint, this.getGraphWindow().getGraph(), true);
        if (tSEObject instanceof TSEConnector) {
            tSEObject = (TSEObject)((TSEConnector)tSEObject).getOwner();
        }
        if (this.getEdge() == tSEObject) {
            tSEObject = this.getHitTesting().getGraphObjectAt(tSConstPoint, this.getGraphWindow().getGraph(), true);
        }
        return tSEObject != null && tSEObject.getUI() instanceof IETGraphObjectUI ? (IETGraphObjectUI)tSEObject.getUI() : null;
    }

    protected IETGraphObjectUI getUIAt(MouseEvent mouseEvent) {
        return this.getUIAt(this.getNonalignedWorldPoint(mouseEvent));
    }

    protected IEdgePresentation getIEdgePresentation() {
        if (this.getDrawEngine() instanceof ETEdgeDrawEngine) {
            ETEdgeDrawEngine eTEdgeDrawEngine = (ETEdgeDrawEngine)this.getDrawEngine();
            return eTEdgeDrawEngine.getIEdgePresentation();
        }
        return null;
    }

    protected IETNode getAnchoredNode() {
        return this.isReconnectingTarget() ? (IETNode)this.m_orginalSourceNode : (IETNode)this.m_orginalTargetNode;
    }

    protected IETNode getDisconnectedFromNode() {
        return this.isReconnectingTarget() ? (IETNode)this.m_orginalTargetNode : (IETNode)this.m_orginalSourceNode;
    }

    protected IReconnectEdgeContext getReconnectContext(TSConstPoint tSConstPoint) {
        IETGraphObjectUI iETGraphObjectUI;
        IETEdge iETEdge = this.getIETEdge();
        ReconnectEdgeContext reconnectEdgeContext = new ReconnectEdgeContext();
        reconnectEdgeContext.setEdge(iETEdge);
        reconnectEdgeContext.setReconnectTarget(this.isReconnectingTarget());
        reconnectEdgeContext.setAnchoredNode(this.getAnchoredNode());
        reconnectEdgeContext.setLogicalPoint(this.getETPoint(tSConstPoint));
        if (iETEdge != null) {
            reconnectEdgeContext.setPreConnectNode(this.isReconnectingTarget() ? iETEdge.getToNode() : iETEdge.getFromNode());
        }
        if ((iETGraphObjectUI = this.getUIAt(tSConstPoint)) != null) {
            TSEObject tSEObject = iETGraphObjectUI.getDrawEngine().getParent().getOwner();
            if (tSEObject instanceof TSENode) {
                reconnectEdgeContext.setProposedEndNode((IETNode)tSEObject);
            } else if (tSEObject instanceof TSEConnector) {
                TSEConnector tSEConnector = (TSEConnector)tSEObject;
                reconnectEdgeContext.setProposedEndNode((IETNode)tSEConnector.getOwner());
            }
        }
        return reconnectEdgeContext;
    }

    protected TSConstPoint getEndPoint() {
        ETEdgeDrawEngine eTEdgeDrawEngine = (ETEdgeDrawEngine)this.getDrawEngine();
        if (eTEdgeDrawEngine != null) {
            if (this.isReconnectingTarget()) {
                ETPairT<TSConstPoint, TSConstPoint> eTPairT = eTEdgeDrawEngine.getFromLineSegment();
                return eTPairT != null ? eTPairT.getParamTwo() : null;
            }
            ETPairT<TSConstPoint, TSConstPoint> eTPairT = eTEdgeDrawEngine.getToLineSegment();
            return eTPairT != null ? eTPairT.getParamOne() : null;
        }
        return null;
    }

    protected TSConstPoint getStartingPoint() {
        ETEdgeDrawEngine eTEdgeDrawEngine = (ETEdgeDrawEngine)this.getDrawEngine();
        if (eTEdgeDrawEngine != null) {
            if (this.isReconnectingTarget()) {
                ETPairT<TSConstPoint, TSConstPoint> eTPairT = eTEdgeDrawEngine.getToLineSegment();
                return eTPairT != null ? eTPairT.getParamOne() : null;
            }
            ETPairT<TSConstPoint, TSConstPoint> eTPairT = eTEdgeDrawEngine.getFromLineSegment();
            return eTPairT != null ? eTPairT.getParamTwo() : null;
        }
        return null;
    }

    protected IReconnectEdgeContext getReconnectContext() {
        TSConstPoint tSConstPoint = this.getStartingPoint();
        return tSConstPoint != null ? this.getReconnectContext(tSConstPoint) : null;
    }

    protected IReconnectEdgeContext getReconnectContext(MouseEvent mouseEvent) {
        return this.getReconnectContext(this.getNonalignedWorldPoint(mouseEvent));
    }

    public boolean finishReconnection(TSConstPoint tSConstPoint) {
        boolean bl;
        boolean bl2 = false;
        IReconnectEdgeContext iReconnectEdgeContext = this.getReconnectContext(tSConstPoint);
        boolean bl3 = bl = !this.m_reconnectedEdge ? this.fireReconnectEdgeFinish(iReconnectEdgeContext) : false;
        if (bl) {
            bl2 = false;
        } else {
            if (iReconnectEdgeContext.getAssociatedConnector() != null && iReconnectEdgeContext.getEdge() != null) {
                this.m_associatedConnector = (TSEConnector)iReconnectEdgeContext.getAssociatedConnector();
            }
            bl2 = true;
        }
        return bl2;
    }

    public boolean finishReconnection(MouseEvent mouseEvent) {
        boolean bl = this.verifyReconnectTarget(mouseEvent) ? this.finishReconnection(this.getNonalignedWorldPoint(mouseEvent)) : false;
        if (bl) {
            mouseEvent.consume();
        }
        return bl;
    }

    protected void refresh() {
        this.getGraphWindow().drawGraph();
        this.getGraphWindow().fastRepaint();
    }

    public IETEdge getIETEdge() {
        TSEEdge tSEEdge = this.getEdge();
        return tSEEdge instanceof IETEdge ? (IETEdge)tSEEdge : null;
    }

    protected IDrawingAreaControl getDrawingArea() {
        ADGraphWindow aDGraphWindow = this.getGraphWindow() instanceof ADGraphWindow ? (ADGraphWindow)this.getGraphWindow() : null;
        return aDGraphWindow != null ? aDGraphWindow.getDrawingArea() : null;
    }

    protected IReconnectEdgeEvents getEventDispatcher() {
        if (this.m_eventDispatcher == null) {
            this.m_eventDispatcher = new ReconnectEdgeEvents(this.getDrawingArea().getDrawingAreaDispatcher(), this.getDrawingArea().getDiagram());
        }
        return this.m_eventDispatcher;
    }

    public void cancelAction() {
        try {
            this.stopMouseInput();
            super.cancelAction();
        }
        catch (Exception exception) {
            this.finalizeTool();
        }
    }

    @Override
    public IReconnectEdgeContext createReconnectEdgeContext(TSConstPoint tSConstPoint, IETEdge iETEdge, boolean bl, IETNode iETNode, IETNode iETNode2, IETNode iETNode3) {
        ReconnectEdgeContext reconnectEdgeContext = new ReconnectEdgeContext();
        reconnectEdgeContext.setEdge(iETEdge);
        reconnectEdgeContext.setReconnectTarget(bl);
        reconnectEdgeContext.setAnchoredNode(iETNode);
        reconnectEdgeContext.setPreConnectNode(iETNode2);
        reconnectEdgeContext.setProposedEndNode(iETNode3);
        return reconnectEdgeContext;
    }

    @Override
    public boolean fireReconnectEdgeFinish(IReconnectEdgeContext iReconnectEdgeContext) {
        return this.getEventDispatcher().fireReconnectEdgeFinish(iReconnectEdgeContext);
    }

    @Override
    public boolean fireReconnectEdgeMouseMove(IReconnectEdgeContext iReconnectEdgeContext) {
        return this.getEventDispatcher().fireReconnectEdgeMouseMove(iReconnectEdgeContext);
    }

    @Override
    public boolean fireReconnectEdgeStart(IReconnectEdgeContext iReconnectEdgeContext) {
        return this.getEventDispatcher().fireReconnectEdgeStart(iReconnectEdgeContext);
    }

    @Override
    public IDiagram getParentDiagram() {
        return this.getEventDispatcher().getParentDiagram();
    }

    @Override
    public void setParentDiagram(IDiagram iDiagram) {
        this.getEventDispatcher().setParentDiagram(iDiagram);
    }

    protected ETPairT<List, List> getReconnectEdgeBendPoints() {
        if (this.getEdge() != null) {
            List list = this.getEdge().bendPoints();
            ETArrayList eTArrayList = new ETArrayList();
            IteratorT iteratorT = new IteratorT(list);
            while (iteratorT.hasNext()) {
                eTArrayList.add((TSConstPoint)((TSConstPoint)iteratorT.next()).clone());
            }
            return new ETPairT<List, List>(list, eTArrayList);
        }
        return new ETPairT<List, List>();
    }

    protected void setDefaultState() {
        try {
            if (this.getParentTool() instanceof TSESelectTool) {
                TSESelectTool tSESelectTool = (TSESelectTool)this.getParentTool();
                tSESelectTool.setReconnectEdgeTool((TSEReconnectEdgeTool)new ADReconnectEdgeState((TSEWindowInputTool)tSESelectTool));
            }
            ((ADGraphWindow)this.getGraphWindow()).getDrawingArea().switchToDefaultState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addDirtyRegion(TSEObject tSEObject) {
        if (tSEObject != null) {
            super.addDirtyRegion(tSEObject);
        }
    }
}

