/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.tool.TSEMoveSelectedTool;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.common.Util;
import org.netbeans.modules.uml.core.support.umlsupport.ETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.graphobjects.ETGraph;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ETPointEx;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETGraphObject;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADGraphWindow;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADMoveSelectedState
extends TSEMoveSelectedTool {
    protected long initalMemoryUsed = 0L;

    public ADMoveSelectedState(TSEWindowTool tSEWindowTool, TSConstPoint tSConstPoint, boolean bl) {
        super(tSEWindowTool, tSConstPoint, bl);
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        try {
            if (this.initalMemoryUsed == 0L) {
                this.initalMemoryUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            }
            super.onMouseDragged(mouseEvent);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        super.onMouseReleased(mouseEvent);
        ETList<IETGraphObject> eTList = this.getSelectedObjects();
        IDrawingAreaControl iDrawingAreaControl = ((ADGraphWindow)this.getGraphWindow()).getDrawingArea();
        if (iDrawingAreaControl != null) {
            iDrawingAreaControl.onGraphEvent(3, new ETPointEx(this.getStartPoint()), this.getETPoint(mouseEvent), eTList);
        }
        eTList.clear();
    }

    protected boolean shouldRunGC() {
        long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        if (l != 0L) {
            double d = (double)this.initalMemoryUsed / (double)l * 10.0;
            return d > 9.0;
        }
        return false;
    }

    protected void runBackgroundGC() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Util.runBackgroundGC();
            }
        });
    }

    protected IETPoint getETPoint(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        return new ETPoint(point.x, point.y);
    }

    public ETList<IETGraphObject> getSelectedObjects() {
        ETGraph eTGraph = (ETGraph)this.getGraphWindow().getGraph();
        ETArrayList<IETGraphObject> eTArrayList = new ETArrayList<IETGraphObject>();
        eTArrayList.addAll(eTGraph.selectedNodes());
        return eTGraph != null ? eTArrayList : null;
    }
}

