/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEWindowInputTool;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.tool.TSESelectRegionTool;
import com.tomsawyer.editor.tool.TSESelectTool;
import com.tomsawyer.graph.TSGraphObject;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.support.umlsupport.ETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.graphobjects.ETGraph;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.IETGraphObjectUI;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ETRectEx;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ICompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETGraphObject;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ITSGraphObject;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.SetCursorEvent;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADGraphWindow;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools.ADMoveSelectedState;
import org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools.ADResizeGraphObjectState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADDrawingAreaSelectState
extends TSESelectTool {
    private IETGraphObjectUI dropSourceUI;
    private boolean isMouseDragged;
    private IPresentationElement m_SelectedPresElement = null;
    private ICompartment m_SelectedCompartment = null;
    private IDrawingAreaControl m_SelectedDia = null;

    protected IDrawingAreaControl getDrawingArea() {
        return ((ADGraphWindow)this.getGraphWindow()).getDrawingArea();
    }

    public void onDrop(DropTargetDropEvent dropTargetDropEvent) {
        TSEObject tSEObject = null;
        if (dropTargetDropEvent.getLocation() != null) {
            Point point = dropTargetDropEvent.getLocation();
            TSConstPoint tSConstPoint = new TSConstPoint(this.getGraphWindow().getNonalignedWorldPoint(point));
            tSEObject = this.getHitTesting().getGraphObjectAt(tSConstPoint, this.getGraph(), true);
        }
        super.onDrop(dropTargetDropEvent);
        this.getDrawingArea().onDrop(dropTargetDropEvent, tSEObject);
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        boolean bl = false;
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
        IETGraphObjectUI iETGraphObjectUI = this.getUI(mouseEvent);
        if (iETGraphObjectUI != null && this.isLeftMouseEvent(mouseEvent) && this.dropSourceUI != null && this.isMouseDragged) {
            IDrawEngine iDrawEngine = iETGraphObjectUI.getDrawEngine();
            if (iDrawEngine != null) {
                bl = mouseEvent.isControlDown() ? iDrawEngine.handleLeftMouseDrop(this.getETPoint(mouseEvent), this.dropSourceUI.getDrawEngine().getSelectedCompartments(), false) : iDrawEngine.handleLeftMouseDrop(this.getETPoint(mouseEvent), this.dropSourceUI.getDrawEngine().getSelectedCompartments(), true);
            }
            iDrawingAreaControl.refresh(true);
            if (bl) {
                this.dropSourceUI = null;
            }
        }
        super.onMouseReleased(mouseEvent);
        this.isMouseDragged = false;
    }

    protected boolean isLeftMouseEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent);
    }

    protected boolean isRightMouseEvent(MouseEvent mouseEvent) {
        return !this.isLeftMouseEvent(mouseEvent);
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        try {
            boolean bl = false;
            IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
            if (iDrawingAreaControl != null && !iDrawingAreaControl.getReadOnly()) {
                IETPoint iETPoint = this.getETPoint(mouseEvent);
                IETGraphObjectUI iETGraphObjectUI = this.getUI(mouseEvent);
                if (iETGraphObjectUI != null) {
                    IDrawEngine iDrawEngine = iETGraphObjectUI.getDrawEngine();
                    if (iDrawEngine != null) {
                        bl = iDrawEngine.handleLeftMouseDrag(iETPoint, iETPoint);
                    }
                    iDrawingAreaControl.refreshRect(new ETRectEx(iETGraphObjectUI.getOwner().getBounds()));
                }
                if (!this.isMouseDragged) {
                    boolean bl2 = this.isMouseDragged = iETGraphObjectUI != null;
                    if (this.checkIfNeedToFireEvent(iETGraphObjectUI)) {
                        iDrawingAreaControl.fireSelectEvent(this.getSelectedObjects());
                    }
                }
                if (this.dropSourceUI != null && !bl) {
                    this.setCursor(mouseEvent.isControlDown() ? DragSource.DefaultCopyDrop : DragSource.DefaultMoveDrop);
                } else if (!bl) {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (!bl) {
                    super.onMouseDragged(mouseEvent);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        IDrawEngine iDrawEngine;
        TSConstPoint tSConstPoint;
        TSEHitTesting tSEHitTesting;
        int n;
        super.onMouseMoved(mouseEvent);
        IETGraphObjectUI iETGraphObjectUI = this.getUI(mouseEvent);
        if (iETGraphObjectUI != null && (n = (tSEHitTesting = this.getGraphWindow().getHitTesting()).getGrappleAt(tSConstPoint = this.getNonalignedWorldPoint(mouseEvent), this.getGraph(), true)) == 0 && (iDrawEngine = iETGraphObjectUI.getDrawEngine()) != null) {
            iDrawEngine.handleSetCursor(new SetCursorEvent(mouseEvent, (TSEWindowTool)this));
        }
    }

    public ETList<TSGraphObject> getSelectedObjects() {
        ETGraph eTGraph = (ETGraph)this.getGraphWindow().getGraph();
        return eTGraph != null ? eTGraph.getSelectedObjects(false, false) : null;
    }

    public void onMouseClicked(MouseEvent mouseEvent) {
        boolean bl = false;
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
        IETGraphObjectUI iETGraphObjectUI = this.getUI(mouseEvent);
        TSEObject tSEObject = this.getObject(mouseEvent);
        if (tSEObject != null) {
            // empty if block
        }
        if (iETGraphObjectUI != null) {
            IDrawEngine iDrawEngine = iETGraphObjectUI.getDrawEngine();
            if (this.isLeftMouseEvent(mouseEvent) && iDrawEngine != null) {
                boolean bl2 = bl = mouseEvent.getClickCount() == 2 ? iDrawEngine.handleLeftMouseButtonDoubleClick(mouseEvent) : iDrawEngine.handleLeftMouseButton(mouseEvent);
            }
        }
        if (!bl) {
            super.onMouseClicked(mouseEvent);
        }
        iDrawingAreaControl.onGraphEvent(17, null, null, null);
        iDrawingAreaControl.refresh(true);
        if (this.checkIfNeedToFireEvent(iETGraphObjectUI)) {
            iDrawingAreaControl.fireSelectEvent(this.getSelectedObjects());
        }
    }

    private boolean checkIfNeedToFireEvent(IETGraphObjectUI iETGraphObjectUI) {
        return true;
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        boolean bl = false;
        ADGraphWindow aDGraphWindow = (ADGraphWindow)this.getGraphWindow();
        IDrawingAreaControl iDrawingAreaControl = aDGraphWindow.getDrawingArea();
        IETGraphObjectUI iETGraphObjectUI = this.getUI(mouseEvent);
        boolean bl2 = mouseEvent.isControlDown();
        boolean bl3 = mouseEvent.isShiftDown();
        if (iETGraphObjectUI != null && this.isLeftMouseEvent(mouseEvent)) {
            IDrawEngine iDrawEngine = iETGraphObjectUI.getDrawEngine();
            if (iDrawEngine != null) {
                bl = iDrawEngine.handleLeftMouseBeginDrag(this.getETPoint(mouseEvent), this.getETPoint(mouseEvent));
            }
            if (iETGraphObjectUI.getTSObject().isNode()) {
                IETGraphObjectUI iETGraphObjectUI2 = this.dropSourceUI = bl ? iETGraphObjectUI : null;
            }
            if (iDrawEngine != null && !bl) {
                bl = iDrawEngine.handleLeftMouseButtonPressed(mouseEvent);
            }
            if (bl) {
                ITSGraphObject iTSGraphObject;
                if (!bl2 && !bl3) {
                    aDGraphWindow.deselectAll(true);
                }
                if (!(iTSGraphObject = iETGraphObjectUI.getTSObject()).isSelected()) {
                    aDGraphWindow.selectObject(iTSGraphObject.getObject(), true);
                }
            }
        } else if (iETGraphObjectUI != null && this.isRightMouseEvent(mouseEvent)) {
            IDrawEngine iDrawEngine = iETGraphObjectUI.getDrawEngine();
            if (iDrawEngine != null) {
                ITSGraphObject iTSGraphObject = iETGraphObjectUI.getTSObject();
                ETList<TSGraphObject> eTList = this.getSelectedObjects();
                if (eTList != null) {
                    if (eTList.size() == 1) {
                        aDGraphWindow.deselectAll(true);
                        aDGraphWindow.selectObject(iTSGraphObject.getObject(), true);
                    } else if (eTList.size() > 1 && !iTSGraphObject.isSelected()) {
                        aDGraphWindow.deselectAll(true);
                        aDGraphWindow.selectObject(iTSGraphObject.getObject(), true);
                    }
                } else if (!iTSGraphObject.isSelected()) {
                    aDGraphWindow.selectObject(iTSGraphObject.getObject(), true);
                }
                bl = iDrawEngine.handleRightMouseButton(mouseEvent);
                iDrawingAreaControl.onGraphEvent(17, null, null, null);
                iDrawingAreaControl.refresh(true);
                eTList = this.getSelectedObjects();
                if (eTList != null && eTList.size() > 0) {
                    iDrawingAreaControl.fireSelectEvent(eTList);
                }
            }
        } else if (iETGraphObjectUI == null && this.isRightMouseEvent(mouseEvent)) {
            aDGraphWindow.deselectAll(true);
            iDrawingAreaControl.onGraphEvent(17, null, null, null);
            iDrawingAreaControl.refresh(true);
            bl = true;
        }
        if (!bl) {
            super.onMousePressed(mouseEvent);
        }
    }

    protected TSEObject getObject(TSConstPoint tSConstPoint) {
        return this.getHitTesting().getGraphObjectAt(tSConstPoint, this.getGraphWindow().getGraph(), true);
    }

    protected TSEObject getObject(MouseEvent mouseEvent) {
        TSConstPoint tSConstPoint;
        TSEEdge tSEEdge = null;
        TSEHitTesting tSEHitTesting = new TSEHitTesting(this.getGraphWindow());
        tSEEdge = tSEHitTesting.getEdgeAt(tSConstPoint = this.getNonalignedWorldPoint(mouseEvent), this.getGraphWindow().getGraph(), true);
        if (tSEEdge == null && (tSEEdge = tSEHitTesting.getNodeLabelAt(tSConstPoint, this.getGraphWindow().getGraph(), true)) == null && (tSEEdge = tSEHitTesting.getEdgeLabelAt(tSConstPoint, this.getGraphWindow().getGraph(), true)) == null && (tSEEdge = tSEHitTesting.getConnectorAt(tSConstPoint, this.getGraphWindow().getGraph(), true)) == null && (tSEEdge = tSEHitTesting.getConnectorLabelAt(tSConstPoint, this.getGraphWindow().getGraph(), true)) == null) {
            tSEEdge = tSEHitTesting.getNodeAt(tSConstPoint, this.getGraphWindow().getGraph(), true);
        }
        return tSEEdge;
    }

    protected TSEObject getObject(IETGraphObjectUI iETGraphObjectUI) {
        return iETGraphObjectUI != null ? (TSEObject)iETGraphObjectUI.getTSObject() : null;
    }

    protected IETGraphObjectUI getUI(MouseEvent mouseEvent) {
        TSEObject tSEObject = this.getObject(mouseEvent);
        return tSEObject != null && tSEObject.getUI() instanceof IETGraphObjectUI ? (IETGraphObjectUI)tSEObject.getUI() : null;
    }

    protected IETGraphObjectUI getUI(TSConstPoint tSConstPoint) {
        TSEObject tSEObject = this.getObject(tSConstPoint);
        return tSEObject != null && tSEObject.getUI() instanceof IETGraphObjectUI ? (IETGraphObjectUI)tSEObject.getUI() : null;
    }

    protected IETPoint getETPoint(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        return new ETPoint(point.x, point.y);
    }

    public void moveSelected(TSConstPoint tSConstPoint) {
        IETGraphObjectUI iETGraphObjectUI = this.getUI(tSConstPoint);
        if (iETGraphObjectUI != null && iETGraphObjectUI.getTSObject() != null && !iETGraphObjectUI.getTSObject().isSelected()) {
            iETGraphObjectUI.getTSObject().setSelected(true);
        }
        ETArrayList<IETGraphObject> eTArrayList = new ETArrayList<IETGraphObject>();
        List list = this.getGraph().selectedNodes();
        if (list != null) {
            eTArrayList.addAll(list);
            Point point = this.getGraphWindow().getTransform().pointToDevice(tSConstPoint);
            this.getDrawingArea().onGraphEvent(2, new ETPoint(point), new ETPoint(point), eTArrayList);
        }
        this.setTool((TSEWindowTool)new ADMoveSelectedState((TSEWindowTool)this, tSConstPoint, false));
    }

    public void resizeGraphObject(TSConstPoint tSConstPoint) {
        this.isMouseDragged = false;
        this.setTool((TSEWindowTool)new ADResizeGraphObjectState((TSEWindowInputTool)this, tSConstPoint, false));
    }

    protected void onMarqueeSelectNotify() {
        this.getDrawingArea().fireSelectEvent(this.getSelectedObjects());
    }

    public void selectRegion(TSConstPoint tSConstPoint) {
        this.setTool((TSEWindowTool)new ETSelectRegionState(tSConstPoint));
    }

    class ETSelectRegionState
    extends TSESelectRegionTool {
        public ETSelectRegionState(TSConstPoint tSConstPoint) {
            super((TSEWindowInputTool)ADDrawingAreaSelectState.this, tSConstPoint, ADDrawingAreaSelectState.this.getGraphWindow().getGraph());
        }

        public void onMouseReleased(MouseEvent mouseEvent) {
            super.onMouseReleased(mouseEvent);
            ADDrawingAreaSelectState.this.onMarqueeSelectNotify();
        }
    }
}

