/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.tool.TSECreateNodeTool;
import com.tomsawyer.graph.TSNode;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.support.umlsupport.ETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.ui.products.ad.ADDrawEngines.IADContainerDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.drawengines.IComponentDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.drawengines.INodeDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.drawengines.IPackageDrawEngine;
import org.netbeans.modules.uml.ui.support.CreationFactoryHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.INodePresentation;
import org.netbeans.modules.uml.ui.support.relationshipVerification.INodeVerification;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETGraphObject;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETNode;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADGraphWindow;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.ETDragResizeCursor;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.NoDropCursor;

public class ADCreateNodeState
extends TSECreateNodeTool {
    protected TSConstPoint m_createTopLeftPoint = null;
    protected TSENode node = null;
    protected INodeVerification m_verifcation;
    protected IETRect m_minRect = null;
    protected boolean m_bStateSwitched = false;

    public void createNode(TSConstPoint tSConstPoint) {
        if (!this.m_bStateSwitched && this.onVerifyMouseMove(tSConstPoint)) {
            TSEGraph tSEGraph;
            this.getGraphWindow().deselectAll(false);
            super.createNode(tSConstPoint);
            this.node = this.getVirtualNode();
            if (this.node == null) {
                tSEGraph = this.getSelectedGraph();
                this.node = (TSENode)tSEGraph.nodes().get(tSEGraph.nodes().size() - 1);
            }
            if (this.node != null) {
                this.postCreateObj();
                tSEGraph = this.node.getBounds();
                this.m_createTopLeftPoint = new TSConstPoint(tSEGraph.getLeft(), tSEGraph.getTop());
            }
        }
    }

    protected void setDefaultState() {
        try {
            ETSystem.out.println("ADCreateNodeState setDefaultState");
            this.m_bStateSwitched = true;
            this.getGraphWindow().setCurrentNodeUI(null);
            this.getDrawingArea().switchToDefaultState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void postCreateObj(IETNode iETNode, boolean bl) {
        try {
            IDrawEngine iDrawEngine;
            IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
            if (iDrawingAreaControl == null || iETNode == null) {
                return;
            }
            TSEObjectUI tSEObjectUI = (TSEObjectUI)iETNode.getETUI();
            if (iDrawingAreaControl != null && bl) {
                iDrawingAreaControl.onInteractiveObjCreated(tSEObjectUI);
            }
            if ((iDrawEngine = TypeConversions.getDrawEngine(iETNode)) != null) {
                iDrawEngine.sizeToContents();
            }
            iETNode.invalidate();
            iDrawingAreaControl.refresh(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void postCreateObj() {
        this.postCreateObj((IETNode)this.getCreatedNode(), true);
    }

    protected void firePostCreateEvent(IETNode iETNode) {
        ETArrayList<IETGraphObject> eTArrayList = new ETArrayList<IETGraphObject>();
        eTArrayList.add(iETNode);
        this.getDrawingArea().onGraphEvent(1, null, null, eTArrayList);
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        if (!(this.m_bStateSwitched || !mouseEvent.isPopupTrigger() && this.isLeftMouseEvent(mouseEvent))) {
            this.m_bStateSwitched = true;
        }
        if (this.onVerifyMouseMove(this.getAlignedWorldPoint(mouseEvent))) {
            super.onMousePressed(mouseEvent);
        }
        if (mouseEvent.isPopupTrigger()) {
            this.setDefaultState();
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        IETRect iETRect;
        INodeDrawEngine iNodeDrawEngine;
        if (this.node == null) {
            super.onMouseReleased(mouseEvent);
        }
        if (mouseEvent.isPopupTrigger()) {
            this.setDefaultState();
        }
        if (this.node != null) {
            this.firePostCreateEvent((IETNode)this.node);
        }
        if (this.m_minRect != null && this.node != null && (iNodeDrawEngine = (INodeDrawEngine)TypeConversions.getDrawEngine((TSNode)this.node)) != null && ((iETRect = iNodeDrawEngine.getLogicalBoundingRect(false)).getWidth() < this.m_minRect.getWidth() || iETRect.getHeight() < this.m_minRect.getHeight())) {
            INodePresentation iNodePresentation = (INodePresentation)iNodeDrawEngine.getPresentation();
            iNodePresentation.resize(Math.max(iETRect.getWidth(), this.m_minRect.getWidth()), Math.max(iETRect.getHeight(), this.m_minRect.getHeight()), true);
            this.refresh();
        }
        this.m_createTopLeftPoint = null;
        this.node = null;
        this.m_verifcation = null;
        this.m_minRect = null;
    }

    public TSENode getCreatedNode() {
        return this.node;
    }

    protected void showNoDropCursor() {
        this.setCursor(this.getNoDropCursor());
    }

    protected Cursor getNoDropCursor() {
        return NoDropCursor.getCursor();
    }

    protected void showCreateRelationCursor() {
        this.setCursor(this.getDefaultCursor());
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        this.onVerifyMouseMove(this.getAlignedWorldPoint(mouseEvent));
        super.onMouseMoved(mouseEvent);
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
        boolean bl = iDrawingAreaControl.isFocused();
        if (!bl) {
            iDrawingAreaControl.setFocus();
        }
    }

    protected boolean onVerifyMouseMove(TSConstPoint tSConstPoint) {
        boolean bl = false;
        if (this.getVerification() != null && this.getVerification().verifyCreationLocation(this.getDiagram(), new ETPoint((int)tSConstPoint.getX(), (int)tSConstPoint.getY()))) {
            this.showCreateRelationCursor();
            bl = true;
        } else {
            this.showNoDropCursor();
        }
        return bl;
    }

    protected IDrawingAreaControl getDrawingArea() {
        ADGraphWindow aDGraphWindow = this.getGraphWindow() instanceof ADGraphWindow ? (ADGraphWindow)this.getGraphWindow() : null;
        return aDGraphWindow != null ? aDGraphWindow.getDrawingArea() : null;
    }

    protected IDiagram getDiagram() {
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
        return iDrawingAreaControl != null ? iDrawingAreaControl.getDiagram() : null;
    }

    protected INodeVerification getVerification() {
        if (this.m_verifcation == null) {
            this.m_verifcation = this.createVerification();
        }
        return this.m_verifcation;
    }

    protected INodeVerification createVerification() {
        CreationFactoryHelper creationFactoryHelper = new CreationFactoryHelper();
        return creationFactoryHelper.getNodeVerification();
    }

    public void setGraphWindow(TSEGraphWindow tSEGraphWindow) {
        super.setGraphWindow(tSEGraphWindow);
    }

    protected boolean shouldResizeOnDrag() {
        IDrawEngine iDrawEngine = TypeConversions.getDrawEngine((TSNode)this.getVirtualNode());
        return !this.m_bStateSwitched && this.getGraphWindow().getCurrentNodeUI() != null && (iDrawEngine instanceof IPackageDrawEngine || iDrawEngine instanceof IComponentDrawEngine || iDrawEngine instanceof IADContainerDrawEngine);
    }

    protected boolean isLeftMouseEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent);
    }

    protected void dragResize(MouseEvent mouseEvent) {
        IDrawEngine iDrawEngine = TypeConversions.getDrawEngine((TSNode)this.getVirtualNode());
        if (iDrawEngine instanceof INodeDrawEngine) {
            this.setCursor(ETDragResizeCursor.getCursor());
            TSConstPoint tSConstPoint = this.getAlignedWorldPoint(mouseEvent);
            if (this.m_createTopLeftPoint == null && this.node == null && this.getVirtualNode() != null) {
                this.createNode(tSConstPoint);
                iDrawEngine = TypeConversions.getDrawEngine((TSNode)this.node);
                IETRect iETRect = this.m_minRect = iDrawEngine != null && iDrawEngine.isInitialized() ? iDrawEngine.getLogicalBoundingRect(false) : null;
            }
            if (this.node != null && this.m_createTopLeftPoint != null) {
                INodeDrawEngine iNodeDrawEngine = (INodeDrawEngine)iDrawEngine;
                double d = Math.abs(tSConstPoint.getX() - this.m_createTopLeftPoint.getX());
                double d2 = Math.abs(tSConstPoint.getY() - this.m_createTopLeftPoint.getY());
                INodePresentation iNodePresentation = (INodePresentation)iNodeDrawEngine.getPresentation();
                iNodePresentation.resize(d, d2, true);
                this.refresh();
            }
        }
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = this.isLeftMouseEvent(mouseEvent) || mouseEvent.isPopupTrigger();
        if (bl && this.shouldResizeOnDrag()) {
            this.dragResize(mouseEvent);
        } else if (bl) {
            super.onMouseDragged(mouseEvent);
        } else {
            this.setDefaultState();
            return;
        }
    }

    public void resetState() {
        ETSystem.out.println("CreateNodeState reset state");
        this.m_createTopLeftPoint = null;
        this.node = null;
        this.m_verifcation = null;
        this.m_minRect = null;
        super.resetTool();
        this.getDrawingArea().setModelElement(null);
    }

    public void cancelAction() {
        ETSystem.out.println("CreateNodeState cancelAction");
        this.refresh();
        this.m_createTopLeftPoint = null;
        this.node = null;
        this.m_verifcation = null;
        this.m_minRect = null;
    }

    protected void refresh() {
        if (this.node != null) {
            this.getDrawingArea().getGraphWindow().addInvalidRegion((TSEObject)this.node);
        }
        this.getDrawingArea().refresh(true);
    }
}

