/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.drawingarea;

import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.editor.service.layout.jlayout.AccessiblityUtils;
import com.tomsawyer.editor.service.layout.jlayout.TSEDisconnectedTabExt;
import com.tomsawyer.editor.service.layout.jlayout.TSEGeneralTabExt;
import com.tomsawyer.editor.service.layout.jlayout.TSEHierarchicalTabExt;
import com.tomsawyer.editor.service.layout.jlayout.TSELayoutPropertiesDialog;
import com.tomsawyer.editor.service.layout.jlayout.TSEOrthogonalTabExt;
import com.tomsawyer.editor.service.layout.jlayout.TSERoutingTabExt;
import com.tomsawyer.editor.service.layout.jlayout.TSESymmetricTabExt;
import com.tomsawyer.editor.service.layout.properties.TSETabComponent;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.client.TSServiceProxy;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADGraphWindow;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.IETSecondaryWindow;

public class ETLayoutPropertiesDialog
extends TSELayoutPropertiesDialog
implements IETSecondaryWindow {
    private boolean hasBeenVisible = false;
    private static TSEResourceBundleWrapper tsResBundle = TSEResourceBundleWrapper.getSystemLabelBundle();
    static String[] internationalizedTabNames = new String[]{tsResBundle.getStringSafely("General"), tsResBundle.getStringSafely("Disconnected"), tsResBundle.getStringSafely("Hierarchical"), tsResBundle.getStringSafely("Orthogonal"), tsResBundle.getStringSafely("Symmetric"), tsResBundle.getStringSafely("Routing")};

    public ETLayoutPropertiesDialog(Frame frame, String string, TSEGraphWindow tSEGraphWindow, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        super(frame, string, tSEGraphWindow, tSServiceProxy, tSEAllOptionsServiceInputData);
        if (tSServiceProxy == null) {
            ETSystem.out.println("null layout Server passed to the layout properties dialog.");
        }
    }

    public ETLayoutPropertiesDialog(Frame frame, String string, TSEGraphWindow tSEGraphWindow, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData, Class clazz) {
        super(frame, string, tSEGraphWindow, tSServiceProxy, tSEAllOptionsServiceInputData, clazz);
    }

    public ETLayoutPropertiesDialog(Frame frame, String string, TSEGraphWindow tSEGraphWindow, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData, int n) {
        super(frame, string, tSEGraphWindow, tSServiceProxy, tSEAllOptionsServiceInputData, n);
    }

    protected void init() {
        super.init();
        this.setA11yFeatures();
    }

    public void onLayout() {
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
        if (iDrawingAreaControl != null) {
            this.setLayoutStyleFromTab();
            this.onApply();
            iDrawingAreaControl.setLayoutStyle(iDrawingAreaControl.getLayoutStyle());
        } else {
            super.onLayout();
        }
    }

    public TSETabComponent getActiveTab() {
        TSETabComponent[] tSETabComponentArray = this.getTabs();
        for (int i = 0; i < this.getNumberOfTabs(); ++i) {
            TSETabComponent tSETabComponent = tSETabComponentArray[i];
            if (tSETabComponent == null || !tSETabComponent.isShowing()) continue;
            return tSETabComponent;
        }
        return null;
    }

    public int getActiveLayoutStyle() {
        int n = -1;
        TSETabComponent tSETabComponent = this.getActiveTab();
        if (tSETabComponent != null) {
            n = tSETabComponent.getLayoutStyle();
        }
        if (n == -1) {
            // empty if block
        }
        return n;
    }

    protected void setLayoutStyleFromTab() {
    }

    protected IDrawingAreaControl getDrawingArea() {
        ADGraphWindow aDGraphWindow = this.getGraphWindow() instanceof ADGraphWindow ? (ADGraphWindow)this.getGraphWindow() : null;
        return aDGraphWindow != null ? aDGraphWindow.getDrawingArea() : null;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!this.hasBeenVisible && bl) {
            super.setVisible(false);
            super.setVisible(true);
            this.hasBeenVisible = true;
        }
    }

    public void setA11yFeatures() {
        this.okButton.setMnemonic(AccessiblityUtils.getMnemonic((String)"OK"));
        this.cancelButton.setMnemonic(AccessiblityUtils.getMnemonic((String)"Cancel"));
        this.applyButton.setMnemonic(AccessiblityUtils.getMnemonic((String)"Apply"));
        this.layoutButton.setMnemonic(AccessiblityUtils.getMnemonic((String)"Layout"));
        this.resetButton.setMnemonic(AccessiblityUtils.getMnemonic((String)"Reset"));
        this.defaultsButton.setMnemonic(AccessiblityUtils.getMnemonic((String)"Defaults"));
        AccessiblityUtils.setAccessibleProperties((Component)this.okButton, null, (String)"OK");
        AccessiblityUtils.setAccessibleProperties((Component)this.cancelButton, null, (String)"Cancel");
        AccessiblityUtils.setAccessibleProperties((Component)this.applyButton, null, (String)"Apply");
        AccessiblityUtils.setAccessibleProperties((Component)this.layoutButton, null, (String)"Layout");
        AccessiblityUtils.setAccessibleProperties((Component)this.resetButton, null, (String)"Reset");
        AccessiblityUtils.setAccessibleProperties((Component)this.defaultsButton, null, (String)"Defaults");
        this.getAccessibleContext().setAccessibleDescription(this.getTitle());
        this.tabbedPane.getAccessibleContext().setAccessibleDescription("");
        TSETabComponent tSETabComponent = (TSETabComponent)this.tabbedPane.getSelectedComponent();
        Font font = tSETabComponent.getFont();
        if (font != null) {
            System.out.println("ETLayout: one of the tab's font=" + font);
            this.tabbedPane.setFont(font);
        }
        this.getRootPane().setDefaultButton(this.okButton);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ETLayoutPropertiesDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    public TSEGraph getGraph() {
        ADGraphWindow aDGraphWindow;
        TSEGraph tSEGraph = super.getGraph();
        if (tSEGraph == null && this.getDrawingArea() != null && (aDGraphWindow = this.getDrawingArea().getGraphWindow()) != null) {
            tSEGraph = aDGraphWindow.getGraph();
        }
        return tSEGraph;
    }

    public void show() {
        super.show();
        this.hideHelpButton();
    }

    protected void hideHelpButton() {
    }

    public void setGraphWindow(TSEGraphWindow tSEGraphWindow) {
    }

    protected TSETabComponent createAppropriateTab(String string) {
        TSEGeneralTabExt tSEGeneralTabExt = null;
        if (string.equals(tsResBundle.getStringSafely("General"))) {
            tSEGeneralTabExt = new TSEGeneralTabExt(this.getGraph(), (TSServiceInputData)this.inputData, (JDialog)((Object)this));
        } else if (string.equals(tsResBundle.getStringSafely("Disconnected"))) {
            tSEGeneralTabExt = new TSEDisconnectedTabExt(this.getGraph(), (TSServiceInputData)this.inputData, (JDialog)((Object)this));
        } else if (string.equals(tsResBundle.getStringSafely("Hierarchical"))) {
            tSEGeneralTabExt = new TSEHierarchicalTabExt(this.getGraph(), (TSServiceInputData)this.inputData, (JDialog)((Object)this));
        } else if (string.equals(tsResBundle.getStringSafely("Orthogonal"))) {
            tSEGeneralTabExt = new TSEOrthogonalTabExt(this.getGraph(), (TSServiceInputData)this.inputData, (JDialog)((Object)this));
        } else if (string.equals(tsResBundle.getStringSafely("Symmetric"))) {
            tSEGeneralTabExt = new TSESymmetricTabExt(this.getGraph(), (TSServiceInputData)this.inputData, (JDialog)((Object)this));
        } else if (string.equals(tsResBundle.getStringSafely("Routing"))) {
            tSEGeneralTabExt = new TSERoutingTabExt(this.getGraph(), (TSServiceInputData)this.inputData, (JDialog)((Object)this));
        }
        return tSEGeneralTabExt;
    }

    protected String[] getTabNames() {
        return internationalizedTabNames;
    }
}

