/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.drawingarea;

import com.tomsawyer.diagramming.TSMoveControl;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGeometricObject;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.command.TSEMoveGroupCommand;
import com.tomsawyer.util.command.TSCommand;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import org.netbeans.modules.uml.ui.products.ad.diagramengines.sequencediagram.IMessageEdgeDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.graphobjects.ETEdge;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools.SmartDragTool;

public class ADMoveSelectedKeyAdapter
extends TSEWindowTool {
    private IMessageEdgeDrawEngine selectedMessage = null;
    private SmartDragTool messageTool = null;
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int MOVING = 10;
    public static final int DONE = 20;
    TSMoveControl moveControl;
    TSConstPoint startPoint;
    TSPoint endPoint;
    double xStep;
    double yStep;
    int state;
    int lastMove;
    TSPoint lastExtremePoint;

    public ADMoveSelectedKeyAdapter(TSEGraphWindow tSEGraphWindow) {
        this.setGraphWindow(tSEGraphWindow);
        this.state = 20;
        this.setXStep(this.getDefaultXStep());
        this.setYStep(this.getDefaultYStep());
    }

    public void initMove() {
        TSEGraphManager tSEGraphManager = this.getGraphWindow().getGraphManager();
        List list = tSEGraphManager.selectedNodes();
        List list2 = tSEGraphManager.selectedPathNodes(true);
        List list3 = tSEGraphManager.selectedEdgeLabels(true);
        List list4 = tSEGraphManager.selectedNodeLabels();
        List list5 = tSEGraphManager.selectedConnectorLabels();
        this.selectedMessage = null;
        this.messageTool = null;
        this.moveControl = null;
        this.selectedMessage = this.getSelectedMessage();
        if (this.selectedMessage != null) {
            int n = (int)this.selectedMessage.getEdge().getSourceConnector().getCenterX() + 10;
            int n2 = (int)this.selectedMessage.getEdge().getSourceConnector().getCenterY();
            System.out.printf("Location (%d, %d)\n", n, n2);
            Point point = this.getGraphWindow().getTransform().pointToDevice((double)n, (double)n2);
            MouseEvent mouseEvent = new MouseEvent((Component)this.getGraphWindow(), 500, 0L, 0, (int)point.getX(), (int)point.getY(), 1, false, 1);
            this.selectedMessage.handleLeftMouseButtonPressed(mouseEvent);
            TSEWindowTool tSEWindowTool = this.getGraphWindow().getCurrentTool();
            if (tSEWindowTool instanceof SmartDragTool) {
                this.messageTool = (SmartDragTool)tSEWindowTool;
            }
            this.startPoint = new TSConstPoint((double)n, (double)n2);
            this.endPoint = new TSPoint(this.startPoint);
        } else {
            this.moveControl = new TSMoveControl();
            this.moveControl.init(tSEGraphManager.graphs(false), list, list2, list3, list4, list5);
            TSDNode tSDNode = (TSDNode)this.getGraphWindow().getGraph().nodes().get(0);
            this.startPoint = new TSConstPoint(tSDNode.getCenterX(), tSDNode.getCenterY());
            this.endPoint = new TSPoint(this.startPoint);
            this.moveControl.onStartAt(this.startPoint.getX(), this.startPoint.getY());
        }
        this.lastMove = 0;
        this.lastExtremePoint = new TSPoint();
    }

    public void move(int n) {
        if (this.state == 20 && this.getGraphWindow().getGraphManager().hasSelected(true)) {
            this.initMove();
            this.state = 10;
        } else if (!this.getGraphWindow().getGraphManager().hasSelected(true)) {
            return;
        }
        double d = this.endPoint.getX();
        double d2 = this.endPoint.getY();
        if (n == 1) {
            d2 = this.getAlignedWorldY(1);
        } else if (n == 2) {
            d2 = this.getAlignedWorldY(2);
        } else if (n == 3) {
            d = this.getAlignedWorldX(3);
        } else if (n == 4) {
            d = this.getAlignedWorldX(4);
        }
        this.updateGraphInvalidRegions();
        if (this.moveControl != null) {
            this.moveControl.onDragTo(d, d2);
            this.moveControl.updateGraphsBounds();
        } else if (this.messageTool != null) {
            System.out.printf("New Location (%d,%d)\n", (int)d, (int)d2);
            Point point = this.getGraphWindow().getTransform().pointToDevice(d, d2);
            MouseEvent mouseEvent = new MouseEvent(this.getGraphWindow().getCanvas(), 506, 0L, 1040, (int)point.getX(), (int)point.getY(), 1, false, 1);
            this.messageTool.onMouseDragged(mouseEvent);
            this.messageTool.onMouseReleased(mouseEvent);
        }
        this.updateGraphInvalidRegions();
        if (!this.updateVisibleArea(n, true)) {
            this.getGraphWindow().updateInvalidRegions(true);
        }
    }

    public void finalizeState() {
        if (this.state == 10) {
            if (this.moveControl != null) {
                this.moveControl.onCancel();
            } else if (this.messageTool != null) {
                this.getGraphWindow().switchTool(this.getGraphWindow().getDefaultTool());
            }
            this.commitMoving();
            this.state = 20;
            this.lastMove = 0;
            this.lastExtremePoint = null;
        }
    }

    public int getState() {
        return this.state;
    }

    void updateGraphInvalidRegions() {
        if (this.moveControl != null) {
            this.getGraphWindow().addInvalidRegion(this.moveControl.draggedEdges());
            for (TSEEdge tSEEdge : this.moveControl.draggedEdges()) {
                this.getGraphWindow().addInvalidRegion(tSEEdge.labels());
            }
            this.getGraphWindow().addInvalidRegion(this.moveControl.draggedNodes());
            for (TSEEdge tSEEdge : this.moveControl.draggedNodes()) {
                this.getGraphWindow().addInvalidRegion(tSEEdge.labels());
            }
            this.getGraphWindow().addInvalidRegion(this.moveControl.draggedEdgeLabels());
            this.getGraphWindow().addInvalidRegion(this.moveControl.draggedNodeLabels());
            this.getGraphWindow().addInvalidRegion(this.moveControl.draggedPathNodes());
        } else if (this.selectedMessage != null) {
            this.getGraphWindow().addInvalidRegion((TSEObject)this.selectedMessage.getEdge());
        }
    }

    public double getXStep() {
        return this.xStep;
    }

    public void setXStep(double d) {
        this.xStep = d;
    }

    public double getDefaultXStep() {
        return 5.0;
    }

    public double getYStep() {
        return this.yStep;
    }

    public void setYStep(double d) {
        this.yStep = d;
    }

    public double getDefaultYStep() {
        return 5.0;
    }

    public double getNonalignedWorldX(int n) {
        if (n == 3) {
            this.endPoint.setX(this.endPoint.getX() - this.getXStep());
        } else if (n == 4) {
            this.endPoint.setX(this.endPoint.getX() + this.getXStep());
        }
        return this.endPoint.getX();
    }

    public double getNonalignedWorldY(int n) {
        if (n == 1) {
            this.endPoint.setY(this.endPoint.getY() + this.getYStep());
        } else if (n == 2) {
            this.endPoint.setY(this.endPoint.getY() - this.getYStep());
        }
        return this.endPoint.getY();
    }

    public double getAlignedWorldX(int n) {
        double d = this.getNonalignedWorldX(n);
        if (this.getGraphWindow().hasGrid()) {
            if (n == 3) {
                this.endPoint.setX(this.getGraphWindow().getGrid().getLeftNearestGridX(d));
                d = this.endPoint.getX();
            } else if (n == 4) {
                this.endPoint.setX(this.getGraphWindow().getGrid().getRightNearestGridX(d));
                d = this.endPoint.getX();
            }
        }
        return d;
    }

    public double getAlignedWorldY(int n) {
        double d = this.getNonalignedWorldY(n);
        if (this.getGraphWindow().hasGrid()) {
            if (n == 1) {
                this.endPoint.setY(this.getGraphWindow().getGrid().getUpperNearestGridY(d));
                d = this.endPoint.getY();
            } else if (n == 2) {
                this.endPoint.setY(this.getGraphWindow().getGrid().getLowerNearestGridY(d));
                d = this.endPoint.getY();
            }
        }
        return d;
    }

    public boolean updateVisibleArea(int n, boolean bl) {
        TSConstPoint tSConstPoint = this.getExtremePoint(n);
        return super.updateVisibleArea(tSConstPoint, bl);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public TSConstPoint getExtremePoint(int var1_1) {
        if (this.lastMove != 0 && this.lastMove == var1_1 && this.lastExtremePoint != null) {
            return this.lastExtremePoint;
        }
        var2_2 = null;
        if (var1_1 == 1) ** GOTO lbl-1000
        if (var1_1 == 4) lbl-1000:
        // 2 sources

        {
            var3_3 = -Infinity;
        } else {
            var3_3 = Infinity;
        }
        var5_4 = this.getGraphWindow().getGraphManager();
        for (TSDNode var7_6 : var5_4.selectedNodes()) {
            var3_3 = this.adjustExtremeValue((TSGeometricObject)var7_6 /* !! */ , var1_1, var3_3, var7_6 /* !! */ .getCenterX(), var7_6 /* !! */ .getCenterY());
        }
        for (TSDNode var7_6 : var5_4.selectedPathNodes(true)) {
            var3_3 = this.adjustExtremeValue((TSGeometricObject)var7_6 /* !! */ , var1_1, var3_3, var7_6 /* !! */ .getCenterX(), var7_6 /* !! */ .getCenterY());
        }
        for (TSDNode var7_6 : var5_4.selectedEdgeLabels(true)) {
            var3_3 = this.adjustExtremeValue((TSGeometricObject)var7_6 /* !! */ , var1_1, var3_3, var7_6 /* !! */ .getCenterX(), var7_6 /* !! */ .getCenterY());
        }
        for (TSDNode var7_6 : var5_4.selectedNodeLabels()) {
            var3_3 = this.adjustExtremeValue((TSGeometricObject)var7_6 /* !! */ , var1_1, var3_3, var7_6 /* !! */ .getCenterX(), var7_6 /* !! */ .getCenterY());
        }
        for (TSDNode var7_6 : var5_4.selectedEdges(true)) {
            var8_7 = (TSEEdge)var7_6 /* !! */ ;
            var3_3 = this.adjustExtremeValue((TSGeometricObject)var8_7, var1_1, var3_3, var8_7.getRight() + var8_7.getWidth() / 2.0, var8_7.getTop() - var8_7.getHeight() / 2.0);
        }
        return this.lastExtremePoint;
    }

    double adjustExtremeValue(TSGeometricObject tSGeometricObject, int n, double d, double d2, double d3) {
        if (n == 1) {
            if (tSGeometricObject.getTop() > d) {
                this.lastExtremePoint.setLocation(d2, tSGeometricObject.getTop());
                return tSGeometricObject.getTop();
            }
        } else if (n == 2) {
            if (tSGeometricObject.getBottom() < d) {
                this.lastExtremePoint.setLocation(d2, tSGeometricObject.getBottom());
                return tSGeometricObject.getBottom();
            }
        } else if (n == 3) {
            if (tSGeometricObject.getLeft() < d) {
                this.lastExtremePoint.setLocation(tSGeometricObject.getLeft(), d3);
                return tSGeometricObject.getLeft();
            }
        } else if (n == 4 && tSGeometricObject.getRight() > d) {
            this.lastExtremePoint.setLocation(tSGeometricObject.getRight(), d3);
            return tSGeometricObject.getRight();
        }
        return d;
    }

    public void commitMoving() {
        TSEGraphManager tSEGraphManager = this.getGraphWindow().getGraphManager();
        this.getGraphWindow().transmit((TSCommand)new TSEMoveGroupCommand(tSEGraphManager.graphs(false), tSEGraphManager.selectedNodes(), tSEGraphManager.selectedPathNodes(true), tSEGraphManager.selectedEdgeLabels(true), tSEGraphManager.selectedNodeLabels(), tSEGraphManager.selectedConnectorLabels(), this.startPoint, (TSConstPoint)this.endPoint));
    }

    private IMessageEdgeDrawEngine getSelectedMessage() {
        ETEdge eTEdge;
        IDrawEngine iDrawEngine;
        IMessageEdgeDrawEngine iMessageEdgeDrawEngine = null;
        TSEGraphManager tSEGraphManager = this.getGraphWindow().getGraphManager();
        List list = tSEGraphManager.selectedEdges(true);
        if (list.size() == 1 && (iDrawEngine = (eTEdge = (ETEdge)list.get(0)).getEngine()) instanceof IMessageEdgeDrawEngine) {
            iMessageEdgeDrawEngine = (IMessageEdgeDrawEngine)iDrawEngine;
        }
        return iMessageEdgeDrawEngine;
    }
}

