/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.modules.uml.ui.support.wizard.CardPanel;
import org.netbeans.modules.uml.ui.support.wizard.IWizardPage;
import org.netbeans.modules.uml.ui.support.wizard.IWizardSheet;
import org.netbeans.modules.uml.ui.support.wizard.WizardResouces;
import org.netbeans.modules.uml.ui.swing.commondialogs.JCenterDialog;

public abstract class WizardSheet
extends JCenterDialog
implements IWizardSheet {
    private JLabel spacer1 = new JLabel();
    private JButton jbNext = new JButton();
    private JPanel pnlButtonBar = new JPanel();
    private JButton jbFinish = new JButton();
    private JButton jbCancel = new JButton();
    private JLabel spacer2 = new JLabel();
    private JLabel spacer3 = new JLabel();
    private JButton jbBack = new JButton();
    private JLabel spacer4 = new JLabel();
    private JLabel spacer5 = new JLabel();
    private JLabel spacer6 = new JLabel();
    private CardPanel wizardPages = null;
    private int lastButtonPressed;
    private Icon bmpWatermark = null;
    private Icon bmpHeader = null;
    private String m_Title = null;
    protected String m_sHelpFilePath;

    public WizardSheet(int n, Frame frame, int n2, Icon icon, GraphicsConfiguration graphicsConfiguration, Icon icon2) {
        this("", frame, n2, icon, graphicsConfiguration, icon2);
    }

    public WizardSheet(String string, Frame frame, int n, Icon icon, GraphicsConfiguration graphicsConfiguration, Icon icon2) {
        this(frame, string, true);
        this.bmpWatermark = icon;
        this.bmpHeader = icon2;
    }

    public WizardSheet(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.m_Title = string;
        try {
            this.createUI();
            this.pack();
            this.setResizable(false);
            Dimension dimension = this.getToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public WizardSheet() {
        this((Frame)null, "", true);
    }

    public boolean is256ColorsSupported() {
        return true;
    }

    private Dimension setPanelSize() {
        Font font = UIManager.getFont("controlFont");
        int n = font != null ? font.getSize() : 12;
        int n2 = 500;
        int n3 = 350;
        int n4 = 2;
        if (n > 17) {
            n4 = 3;
        }
        n2 += Math.round((float)n2 * ((float)(n4 * n) / 100.0f));
        n3 += Math.round((float)n3 * ((float)(n4 * n) / 100.0f));
        return new Dimension(n2, n3);
    }

    private void createUI() {
        this.wizardPages = new CardPanel(this);
        this.wizardPages.setPreferredSize(this.setPanelSize());
        this.getContentPane().setLayout(new BorderLayout());
        this.pnlButtonBar.setBorder(BorderFactory.createRaisedBevelBorder());
        this.pnlButtonBar.setLayout(new GridBagLayout());
        this.jbBack.setMnemonic(66);
        this.jbNext.setMnemonic(78);
        this.jbFinish.setMnemonic(70);
        Insets insets = new Insets(10, 5, 10, 5);
        if (this.canAddNavigationButtons()) {
            this.jbBack.setText(this.getBackButtonCaption());
            this.jbNext.setText(this.getNextButtonCaption());
            this.pnlButtonBar.add((Component)this.spacer1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, insets, 0, 0));
            this.pnlButtonBar.add((Component)this.jbBack, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, insets, 0, 0));
            this.pnlButtonBar.add((Component)this.jbNext, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, insets, 0, 0));
        } else {
            this.pnlButtonBar.add((Component)this.spacer4, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, insets, 0, 0));
            this.pnlButtonBar.add((Component)this.spacer5, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, insets, 0, 0));
            this.pnlButtonBar.add((Component)this.spacer6, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, insets, 0, 0));
        }
        this.jbFinish.setText(this.getCommitButtonCaption());
        this.getRootPane().setDefaultButton(this.jbFinish);
        this.jbCancel.setText(this.getCancelButtonCaption());
        Dimension dimension = this.getMaxButtonWidth();
        this.jbBack.setMaximumSize(dimension);
        this.jbBack.setPreferredSize(dimension);
        this.jbBack.getAccessibleContext().setAccessibleDescription(WizardResouces.getString("WizardSheet.BACK_BTN_Description"));
        this.jbCancel.setMaximumSize(dimension);
        this.jbCancel.setPreferredSize(dimension);
        this.jbCancel.getAccessibleContext().setAccessibleDescription(WizardResouces.getString("WizardSheet.CANCEL_BTN_Description"));
        this.jbFinish.setMaximumSize(dimension);
        this.jbFinish.setPreferredSize(dimension);
        this.jbNext.setMaximumSize(dimension);
        this.jbNext.setPreferredSize(dimension);
        this.jbNext.getAccessibleContext().setAccessibleDescription(WizardResouces.getString("WizardSheet.NEXT_BTN_Description"));
        this.pnlButtonBar.add((Component)this.jbFinish, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, insets, 0, 0));
        this.pnlButtonBar.add((Component)this.jbCancel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 1, insets, 0, 0));
        this.pnlButtonBar.add((Component)this.spacer3, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 1, insets, 0, 0));
        this.getContentPane().add((Component)this.wizardPages, "Center");
        this.getContentPane().add((Component)this.pnlButtonBar, "South");
        this.addActionListeners();
    }

    protected String getCancelButtonCaption() {
        return WizardResouces.getString("WizardSheet.CANCEL_BTN");
    }

    protected String getCommitButtonCaption() {
        return WizardResouces.getString("WizardSheet.COMMIT_BTN");
    }

    protected String getNextButtonCaption() {
        return WizardResouces.getString("WizardSheet.NEXT_BTN");
    }

    protected String getBackButtonCaption() {
        return WizardResouces.getString("WizardSheet.BACK_BTN");
    }

    protected boolean canAddNavigationButtons() {
        return true;
    }

    private void addActionListeners() {
        this.jbBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WizardSheet.this.jbBack_actionPerformed(actionEvent);
            }
        });
        this.jbNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WizardSheet.this.jbNext_actionPerformed(actionEvent);
            }
        });
        this.jbFinish.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WizardSheet.this.jbFinish_actionPerformed(actionEvent);
            }
        });
        this.jbCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WizardSheet.this.jbCancel_actionPerformed(actionEvent);
            }
        });
    }

    public void init(Icon icon, GraphicsConfiguration graphicsConfiguration, Icon icon2) {
        this.bmpWatermark = icon;
        this.bmpHeader = icon2;
    }

    protected void showPage(String string) {
        this.wizardPages.showCard(string);
    }

    protected void addPage(IWizardPage iWizardPage, String string) {
        if (iWizardPage instanceof JPanel) {
            iWizardPage.setParentSheet(this);
            this.wizardPages.add((Component)((JPanel)((Object)iWizardPage)), string);
        }
    }

    void jbBack_actionPerformed(ActionEvent actionEvent) {
        this.onWizardBack();
    }

    void jbNext_actionPerformed(ActionEvent actionEvent) {
        this.onWizardNext();
    }

    void jbFinish_actionPerformed(ActionEvent actionEvent) {
        this.onWizardFinish();
    }

    void jbCancel_actionPerformed(ActionEvent actionEvent) {
        this.onWizardCancel();
    }

    public Icon getBmpHeader() {
        return this.bmpHeader;
    }

    public Icon getBmpWatermark() {
        return this.bmpWatermark;
    }

    public void setTitle(String string) {
        this.m_Title = string;
        if (string != null) {
            super.setTitle(string);
        }
    }

    public int getActiveIndex() {
        return this.wizardPages.getCurrentCardIndex();
    }

    public void setActivePage(int n) {
        this.wizardPages.showCard(n);
    }

    public int getPageCount() {
        return this.wizardPages.getCardCount();
    }

    public void onPageChange() {
        this.updateButtons();
        Component component = this.wizardPages.getCurrentCard();
        if (component instanceof IWizardPage) {
            IWizardPage iWizardPage = (IWizardPage)((Object)component);
            String string = iWizardPage.getCaption();
            if (string != null && string.length() > 0) {
                super.setTitle(string);
            } else {
                super.setTitle(this.m_Title);
            }
            iWizardPage.onSetActive();
        }
    }

    private void updateButtons() {
        int n = this.getActiveIndex();
        if (n == 0) {
            this.jbBack.setEnabled(false);
            this.jbNext.setEnabled(true);
            this.jbFinish.setEnabled(false);
        } else if (n > 0 && n < this.getPageCount() - 1) {
            this.jbBack.setEnabled(true);
            this.jbNext.setEnabled(true);
            this.jbFinish.setEnabled(false);
        } else if (n == this.getPageCount() - 1) {
            this.jbBack.setEnabled(true);
            this.jbNext.setEnabled(false);
            this.jbFinish.setEnabled(true);
        }
    }

    public void onWizardBack() {
        this.lastButtonPressed = 0;
        Component component = this.wizardPages.getCurrentCard();
        if (component instanceof IWizardPage) {
            IWizardPage iWizardPage = (IWizardPage)((Object)component);
            iWizardPage.onWizardBack();
        }
    }

    public void onWizardNext() {
        this.lastButtonPressed = 1;
        Component component = this.wizardPages.getCurrentCard();
        if (component instanceof IWizardPage) {
            IWizardPage iWizardPage = (IWizardPage)((Object)component);
            iWizardPage.onWizardNext();
        }
    }

    public void onWizardCancel() {
        this.lastButtonPressed = 2;
        this.dispose();
    }

    public void onWizardFinish() {
        this.lastButtonPressed = 3;
        Component component = this.wizardPages.getCurrentCard();
        boolean bl = true;
        if (component instanceof IWizardPage) {
            IWizardPage iWizardPage = (IWizardPage)((Object)component);
            bl = iWizardPage.onDismiss();
        }
        if (bl) {
            this.dispose();
        }
    }

    public int doModal() {
        super.setVisible(true);
        return this.lastButtonPressed;
    }

    public void setCursor(int n) {
        switch (n) {
            case 0: {
                this.setCursor(Cursor.getPredefinedCursor(0));
                break;
            }
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
    }

    public void setButtonEnabled(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.jbBack.setEnabled(bl);
                break;
            }
            case 1: {
                this.jbNext.setEnabled(bl);
                break;
            }
            case 2: {
                this.jbCancel.setEnabled(bl);
                break;
            }
            case 3: {
                this.jbFinish.setEnabled(bl);
            }
        }
    }

    private Dimension getMaxButtonWidth() {
        Dimension dimension = null;
        Dimension dimension2 = this.jbBack.getPreferredSize();
        double d = dimension2.width;
        dimension2 = this.jbCancel.getPreferredSize();
        if ((double)dimension2.width > d) {
            d = dimension2.width;
            dimension = dimension2;
        }
        dimension2 = this.jbFinish.getPreferredSize();
        if ((double)dimension2.width > d) {
            d = dimension2.width;
            dimension = dimension2;
        }
        dimension2 = this.jbNext.getPreferredSize();
        if ((double)dimension2.width > d) {
            d = dimension2.width;
            dimension = dimension2;
        }
        return dimension;
    }
}

