/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support.viewfactorysupport;

import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.graph.TSGraphObject;
import java.awt.Component;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.support.umlsupport.ETDeviceRect;
import org.netbeans.modules.uml.core.support.umlsupport.ETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.ETSize;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETSize;
import org.netbeans.modules.uml.ui.controls.drawingarea.IUIDiagram;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ETPointEx;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ETRectEx;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IMouseEvent;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ISetCursorEvent;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ITSGraphObject;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.PointConversions;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;

public class ETTransform {
    private TSGraphObject m_GraphObject = null;
    private IETPoint m_Origin = null;
    private IETSize m_Size = null;
    private boolean m_IsWorldBasedCoor = false;

    public void setGraphObject(TSGraphObject tSGraphObject) {
        this.m_GraphObject = tSGraphObject;
    }

    public TSGraphObject getGraphObject() {
        return this.getOwnerGraphObject();
    }

    public void setTSAbsolute(IETRect iETRect) {
        IETRect iETRect2 = this.getGraphObjectAbsoluteBoundingRect();
        if (iETRect2 != null && iETRect != null) {
            this.initializeOrigin();
            this.m_Origin.setX(iETRect.getLeft() - iETRect2.getLeft());
            this.m_Origin.setY(iETRect2.getTop() - iETRect.getTop());
            this.initializeSize();
            int n = iETRect.getIntWidth();
            int n2 = iETRect.getIntHeight();
            this.m_Size.setSize(n, n2);
        }
    }

    public void setWinClientRectangle(IETRect iETRect) {
        if (this.isTSWorldCoordinate()) {
            this.setTSAbsolute(iETRect);
        } else if (this.getDrawingAreaControl() != null) {
            this.setTSAbsolute(this.getDrawingAreaControl().deviceToLogicalRect(iETRect));
        }
    }

    public void setWinScaledOwnerRect(IETRect iETRect) {
        double d = this.getZoomLevel();
        this.initializeOrigin();
        this.m_Origin.setX((int)Math.round((double)iETRect.getLeft() * d));
        this.m_Origin.setY((int)Math.round((double)iETRect.getTop() * d));
        this.initializeSize();
        int n = (int)Math.round(iETRect.getWidth() / d);
        int n2 = (int)Math.round(iETRect.getHeight() / d);
        this.m_Size.setSize(n, n2);
    }

    protected boolean isTSWorldCoordinate() {
        return this.m_IsWorldBasedCoor;
    }

    protected void setIsTSWorldCoordinate(boolean bl) {
        this.m_IsWorldBasedCoor = bl;
    }

    public IETRect getTSAbsoluteRect() {
        ETRect eTRect = null;
        IETRect iETRect = this.getGraphObjectAbsoluteBoundingRect();
        if (iETRect != null) {
            int n = iETRect.getLeft();
            int n2 = iETRect.getTop();
            if (this.m_Origin != null) {
                n += this.m_Origin.getX();
                n2 -= this.m_Origin.getY();
            }
            double d = iETRect.getWidth();
            double d2 = iETRect.getHeight();
            if (this.m_Size != null) {
                d = this.m_Size.getWidth();
                d2 = this.m_Size.getHeight();
            }
            eTRect = new ETRect((double)n, (double)n2, d, d2);
        }
        return eTRect;
    }

    public IETRect getWinScreenRect() {
        IETRect iETRect = this.getWinClientRect();
        TSGraphObject tSGraphObject = this.getGraphObject();
        Point point = new Point(iETRect.getLeft(), iETRect.getTop());
        SwingUtilities.convertPointToScreen(point, (Component)this.getGraphWindow());
        Point point2 = new Point(iETRect.getRight(), iETRect.getBottom());
        SwingUtilities.convertPointToScreen(point2, (Component)this.getGraphWindow());
        return new ETDeviceRect(point, point2);
    }

    public IETRect getWinClientRect() {
        IETRect iETRect = this.getTSAbsoluteRect();
        if (iETRect != null) {
            Point point = iETRect.getTopLeft();
            Point point2 = iETRect.getBottomRight();
            TSConstRect tSConstRect = new TSConstRect((double)point.x, (double)point.y, (double)point2.x, (double)point2.y);
            return new ETDeviceRect(this.getTransform().boundsToDevice(tSConstRect));
        }
        return null;
    }

    public IETRect getWinAbsoluteOwnerRect() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.m_Origin != null) {
            n4 = this.m_Origin.getX();
            n3 = this.m_Origin.getY();
        } else {
            n4 = 0;
            n3 = 0;
        }
        if (this.m_Size != null) {
            n2 = this.m_Size.getWidth();
            n = this.m_Size.getHeight();
        } else {
            n2 = 0;
            n = 0;
        }
        ETDeviceRect eTDeviceRect = new ETDeviceRect(n4, n3, n2, n);
        if (this.m_Size != null && (this.m_Size.getWidth() == -1 || n == -1)) {
            IETRect iETRect = this.getGraphObjectAbsoluteBoundingRect();
            if (n2 == -1) {
                eTDeviceRect.setRight((int)iETRect.getWidth());
            }
            if (n == -1) {
                eTDeviceRect.setBottom((int)iETRect.getHeight());
            }
        }
        return eTDeviceRect;
    }

    public IETRect getWinScaledOwnerRect() {
        IETRect iETRect = this.getWinAbsoluteOwnerRect();
        double d = this.getZoomLevel();
        int n = (int)Math.round((double)iETRect.getLeft() * d);
        int n2 = (int)Math.round((double)iETRect.getTop() * d);
        int n3 = (int)Math.round((double)iETRect.getRight() * d);
        int n4 = (int)Math.round((double)iETRect.getBottom() * d);
        iETRect.setSides(n, n2, n3, n4);
        return iETRect;
    }

    public IETRect getMilsRect() {
        int n;
        int n2;
        int n3;
        int n4;
        IETRect iETRect = this.getTSAbsoluteRect();
        double d = iETRect.getWidth() / 2.0;
        double d2 = -iETRect.getHeight() / 2.0;
        if (this.m_Origin != null) {
            n4 = this.m_Origin.getX();
            n3 = this.m_Origin.getY();
        } else {
            n4 = 0;
            n3 = 0;
        }
        if (this.m_Size != null) {
            n2 = this.m_Size.getWidth();
            n = this.m_Size.getHeight();
        } else {
            n2 = 0;
            n = 0;
        }
        return new ETRect(Math.round(((double)n4 - d) * 1000.0 / d), Math.round((d2 - (double)n3) * 1000.0 / d2), Math.round((double)((n4 - n2) * 1000) / d), Math.round((d2 - (double)(n3 - n)) * 1000.0 / d2));
    }

    public void setScaledSize(ETSize eTSize) {
        double d = this.getZoomLevel();
        this.initializeSize();
        this.m_Size.setSize((int)Math.round((double)eTSize.getWidth() / d), (int)Math.round((double)eTSize.getHeight() / d));
    }

    public IETPoint getAbsoluteOwnerOrigin() {
        return this.m_Origin != null ? this.m_Origin : new ETPoint(0, 0);
    }

    public void setAbsoluteOwnerOrigin(IETPoint iETPoint) {
        this.initializeOrigin();
        this.m_Origin = iETPoint;
    }

    public IETSize getAbsoluteSize() {
        return this.m_Size != null ? this.m_Size : new ETSize(0, 0);
    }

    public void setAbsoluteSize(IETSize iETSize) {
        this.initializeOrigin();
        this.m_Size = iETSize;
    }

    public void setAbsoluteSize(int n, int n2) {
        if (this.m_Size != null) {
            this.m_Size.setSize(n, n2);
        } else {
            this.setAbsoluteSize(new ETSize(n, n2));
        }
    }

    public IETSize getScaledSize() {
        double d = this.getZoomLevel();
        return new ETSize((int)Math.round((double)this.m_Size.getWidth() * d), (int)Math.round((double)this.m_Size.getHeight() * d));
    }

    public IETPoint getWinClientMouseLocation(IMouseEvent iMouseEvent) {
        if (null == iMouseEvent) {
            throw new IllegalArgumentException();
        }
        Point point = new Point(iMouseEvent.getDeviceX(), iMouseEvent.getDeviceY());
        IETRect iETRect = this.getWinClientRect();
        point.x -= iETRect.getLeft();
        point.y -= iETRect.getTop();
        iMouseEvent.setClientX(point.x);
        iMouseEvent.setClientY(point.y);
        return PointConversions.newETPoint(point);
    }

    public IETPoint getWinScaledOwnerCursorPosition(ISetCursorEvent iSetCursorEvent) {
        if (null == iSetCursorEvent) {
            throw new IllegalArgumentException();
        }
        ETPoint eTPoint = null;
        Point point = iSetCursorEvent.getWinClientLocation();
        IETRect iETRect = this.getWinClientRect();
        if (point != null && iETRect != null) {
            eTPoint = new ETPoint(point.x - iETRect.getLeft(), point.y - iETRect.getTop());
        }
        return eTPoint;
    }

    public IETPoint getTSAbsoluteToWinClient(IETPoint iETPoint) {
        IETPoint iETPoint2 = null;
        TSTransform tSTransform = this.getTransform();
        if (tSTransform != null) {
            Point point = tSTransform.pointToDevice((double)iETPoint.getX(), (double)iETPoint.getY());
            iETPoint2 = PointConversions.newETPoint(point);
        }
        return iETPoint2;
    }

    public IETPoint getTSAbsoluteToWinScaledOwner(IETPoint iETPoint) {
        int n;
        int n2;
        if (this.m_Origin != null) {
            n2 = this.m_Origin.getX();
            n = this.m_Origin.getY();
        } else {
            n2 = 0;
            n = 0;
        }
        ETPoint eTPoint = new ETPoint(iETPoint.getX() + n2, iETPoint.getY() - n);
        IETPoint iETPoint2 = this.getTSAbsoluteToWinClient(eTPoint);
        IETRect iETRect = this.getWinClientRect();
        return new ETPoint(iETPoint2.getX() - iETRect.getLeft(), iETPoint2.getY() - iETRect.getTop());
    }

    public IETPoint getWinAbsoluteOwnerToTSAbsolute(IETPoint iETPoint) {
        IETRect iETRect = this.getTSAbsoluteRect();
        return new ETPoint(iETPoint.getX() + iETRect.getLeft(), iETRect.getTop() - iETPoint.getY());
    }

    IETPoint getWinClientToTSAbsolute(IETPoint iETPoint) {
        TSTransform tSTransform = this.getTransform();
        if (tSTransform != null && iETPoint != null) {
            return new ETPointEx(tSTransform.pointToWorld(iETPoint.getX(), iETPoint.getX()));
        }
        return null;
    }

    public IETPoint getTSAbsoluteToWinAbsoluteOwner(IETPoint iETPoint) {
        IETRect iETRect = this.getTSAbsoluteRect();
        return new ETPoint(iETPoint.getX() - iETRect.getLeft(), iETRect.getTop() - iETPoint.getY());
    }

    public double getZoomLevel() {
        return this.getZoomLevel(null);
    }

    public double getZoomLevel(IDrawInfo iDrawInfo) {
        double d = 1.0;
        if (iDrawInfo != null) {
            d = iDrawInfo.getOnDrawZoom();
        } else {
            IDrawingAreaControl iDrawingAreaControl = this.getDrawingAreaControl();
            if (iDrawingAreaControl != null) {
                d = iDrawingAreaControl.getCurrentZoom();
            }
        }
        return d;
    }

    public boolean isValid() {
        return this.getGraphObject() != null;
    }

    IDrawingAreaControl getDrawingAreaControl() {
        IDiagram iDiagram;
        if (this.isValid() && (iDiagram = TypeConversions.getDiagram(this.getGraphObject())) instanceof IUIDiagram) {
            IUIDiagram iUIDiagram = (IUIDiagram)iDiagram;
            return iUIDiagram.getDrawingArea();
        }
        return null;
    }

    protected IETRect getGraphObjectAbsoluteBoundingRect() {
        TSGraphObject tSGraphObject = this.getGraphObject();
        if (tSGraphObject instanceof ITSGraphObject) {
            ITSGraphObject iTSGraphObject = (ITSGraphObject)tSGraphObject;
            return new ETRectEx(iTSGraphObject.getBounds());
        }
        ETSystem.out.println("Error! invalid graph object.");
        return null;
    }

    public TSTransform getTransform() {
        TSEGraphWindow tSEGraphWindow = this.getGraphWindow();
        return tSEGraphWindow != null ? tSEGraphWindow.getTransform() : null;
    }

    public TSEGraphWindow getGraphWindow() throws NullPointerException {
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingAreaControl();
        if (iDrawingAreaControl == null) {
            throw new NullPointerException();
        }
        return iDrawingAreaControl.getGraphWindow();
    }

    public TSGraphObject getOwnerGraphObject() {
        return this.m_GraphObject;
    }

    protected void initializeOrigin() {
        if (this.m_Origin == null) {
            this.m_Origin = new ETPointEx(0.0, 0.0);
        }
    }

    protected void initializeSize() {
        if (this.m_Size == null) {
            this.m_Size = new ETSize(0, 0);
        }
    }

    public static AffineTransform convertTransform(TSTransform tSTransform) {
        if (tSTransform == null) {
            return null;
        }
        AffineTransform affineTransform = new AffineTransform(tSTransform.getScaleX(), 0.0, 0.0, tSTransform.getScaleY(), tSTransform.getOffsetX(), tSTransform.getOffsetY());
        return affineTransform;
    }
}

