/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support.umltsconversions;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;

public class RectConversions {
    public static IETRect newETRect(TSConstRect tSConstRect) {
        return tSConstRect != null ? new ETRect(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getWidth(), tSConstRect.getHeight()) : null;
    }

    public static TSRect etRectToTSRect(IETRect iETRect) {
        if (iETRect != null) {
            ETRect eTRect = ETRect.ensureLogicalRect(iETRect);
            return new TSRect((double)eTRect.getLeft(), (double)eTRect.getTop(), (double)eTRect.getRight(), (double)eTRect.getBottom());
        }
        return null;
    }

    public static IETRect unionTSCoordinates(IETRect iETRect, IETRect iETRect2) {
        IETRect iETRect3 = null;
        if (iETRect != null && iETRect2 != null && (iETRect3 = (IETRect)iETRect.clone()) != null) {
            iETRect3.unionWith(iETRect2);
        }
        return iETRect3;
    }

    public static boolean moveToNearestPoint(IETRect iETRect, TSPoint tSPoint) {
        if (iETRect != null && tSPoint != null) {
            ETRect eTRect = ETRect.ensureLogicalRect(iETRect);
            TSConstRect tSConstRect = new TSConstRect((double)eTRect.getLeft(), (double)eTRect.getTop(), (double)eTRect.getRight(), (double)eTRect.getBottom());
            return RectConversions.moveToNearestPoint(tSConstRect, tSPoint);
        }
        return false;
    }

    public static boolean moveToNearestPoint(TSConstRect tSConstRect, TSPoint tSPoint) {
        double d = Math.abs(tSConstRect.getLeft() - tSPoint.getX());
        double d2 = Math.abs(tSConstRect.getRight() - tSPoint.getX());
        double d3 = Math.abs(tSConstRect.getTop() - tSPoint.getY());
        double d4 = Math.abs(tSConstRect.getBottom() - tSPoint.getY());
        boolean bl = false;
        if (d != 0.0 && d2 != 0.0) {
            bl = true;
        } else if (d3 != 0.0 && d4 != 0.0) {
            bl = true;
        }
        if (!bl) {
            return bl;
        }
        double d5 = Math.min(d, d2);
        double d6 = Math.min(d3, d4);
        boolean bl2 = tSConstRect.withinXRange((TSConstPoint)tSPoint);
        boolean bl3 = tSConstRect.withinYRange((TSConstPoint)tSPoint);
        if (bl2 && bl3) {
            if (d5 <= d6) {
                if (d < d2) {
                    tSPoint.setX(tSConstRect.getLeft());
                } else {
                    tSPoint.setX(tSConstRect.getRight());
                }
            } else if (d3 < d4) {
                tSPoint.setY(tSConstRect.getTop());
            } else {
                tSPoint.setY(tSConstRect.getBottom());
            }
            return bl;
        }
        if (bl2) {
            if (d3 < d4) {
                tSPoint.setY(tSConstRect.getTop());
            } else {
                tSPoint.setY(tSConstRect.getBottom());
            }
        } else if (bl3) {
            if (d < d2) {
                tSPoint.setX(tSConstRect.getLeft());
            } else {
                tSPoint.setX(tSConstRect.getRight());
            }
        } else {
            if (d3 < d4) {
                tSPoint.setY(tSConstRect.getTop());
            } else {
                tSPoint.setY(tSConstRect.getBottom());
            }
            if (d < d2) {
                tSPoint.setX(tSConstRect.getLeft());
            } else {
                tSPoint.setX(tSConstRect.getRight());
            }
        }
        return bl;
    }

    public static int getClosestSide(TSConstRect tSConstRect, TSConstPoint tSConstPoint) {
        double d = Math.abs(tSConstRect.getTop() - tSConstPoint.getY());
        double d2 = Math.abs(tSConstRect.getBottom() - tSConstPoint.getY());
        double d3 = Math.abs(tSConstRect.getLeft() - tSConstPoint.getX());
        double d4 = Math.abs(tSConstRect.getRight() - tSConstPoint.getX());
        double d5 = Math.min(d, d2);
        double d6 = Math.min(d3, d4);
        if (d6 > d5) {
            if (d <= d2) {
                return 1;
            }
            return 3;
        }
        if (d3 < d4) {
            return 2;
        }
        return 0;
    }

    public static TSRect inflate(TSConstRect tSConstRect, double d, double d2) {
        if (tSConstRect != null) {
            TSRect tSRect = new TSRect();
            TSConstSize tSConstSize = new TSConstSize(tSConstRect.getWidth() + d, tSConstRect.getHeight() + d2);
            tSRect.setBoundsFromCenter(tSConstRect.getCenter(), tSConstSize);
            return tSRect;
        }
        return null;
    }
}

