/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.viewfactory;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.graphics.TSEGraphics;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.ETArrowHead;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.ETFilledDiamond;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;

public class ETCirclePlusArrow
extends ETArrowHead {
    public ETCirclePlusArrow() {
        super(9);
    }

    protected boolean isOpenRegion() {
        return false;
    }

    public boolean draw(IDrawInfo iDrawInfo, TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2, TSEColor tSEColor) {
        Rectangle rectangle = this.getCircleBounds(iDrawInfo, tSConstPoint, tSConstPoint2);
        return this.drawCircle(iDrawInfo, rectangle, TSEColor.white) && this.drawCross(iDrawInfo, rectangle, tSEColor);
    }

    protected boolean drawCircle(IDrawInfo iDrawInfo, Rectangle rectangle, TSEColor tSEColor) {
        boolean bl;
        Shape shape = this.getCircle(rectangle);
        TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
        if (shape != null) {
            if (this.isFilled() || !this.isOpenRegion()) {
                Color color = tSEGraphics.getColor();
                tSEGraphics.setColor(tSEColor);
                tSEGraphics.fill(shape);
                tSEGraphics.setColor(color);
            }
            tSEGraphics.draw(shape);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    protected boolean drawCross(IDrawInfo iDrawInfo, Rectangle rectangle, TSEColor tSEColor) {
        boolean bl;
        Shape shape = this.getCross(rectangle);
        TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
        if (shape != null) {
            tSEGraphics.draw(shape);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public int getDefaultHeight() {
        return 14;
    }

    public int getDefaultWidth() {
        return this.getDefaultHeight();
    }

    public Shape getShape(IDrawInfo iDrawInfo, TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        Rectangle rectangle = this.getCircleBounds(iDrawInfo, tSConstPoint, tSConstPoint2);
        if (rectangle == null) {
            return null;
        }
        GeneralPath generalPath = new GeneralPath(0);
        Shape shape = this.getCircle(rectangle);
        Shape shape2 = this.getCross(rectangle);
        if (generalPath != null && shape != null && shape2 != null) {
            generalPath.append(shape, false);
            generalPath.append(shape2, false);
        }
        return generalPath;
    }

    protected Shape getCircle(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        double d = Math.max(rectangle.getWidth(), rectangle.getHeight());
        return new Ellipse2D.Double(rectangle.getX(), rectangle.getY(), d, d);
    }

    protected Rectangle getCircleBounds(IDrawInfo iDrawInfo, TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        ETFilledDiamond eTFilledDiamond = new ETFilledDiamond();
        if (eTFilledDiamond != null) {
            eTFilledDiamond.setWidth(this.getWidth());
            eTFilledDiamond.setHeight(this.getHeight() / 2);
            Shape shape = ((ETArrowHead)eTFilledDiamond).getShape(iDrawInfo, tSConstPoint, tSConstPoint2);
            return shape != null ? shape.getBounds() : null;
        }
        return null;
    }

    protected Shape getCross(Rectangle rectangle) {
        int n = (int)Math.max(rectangle.getWidth(), rectangle.getHeight());
        if (n == 0) {
            return null;
        }
        GeneralPath generalPath = new GeneralPath(0);
        int n2 = n / 2;
        generalPath.moveTo(rectangle.x, rectangle.y + n2);
        generalPath.lineTo(rectangle.x + n, rectangle.y + n2);
        generalPath.moveTo(rectangle.x + n2, rectangle.y);
        generalPath.lineTo(rectangle.x + n2, rectangle.y + n);
        return generalPath;
    }
}

