/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.layout;

import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.layout.jlayout.TSLayoutInputTailor;
import java.util.Hashtable;
import java.util.List;

public class ADLayoutProcessor {
    TSEGraphManager graphManager;
    TSEGraph graph;
    Hashtable nodeDataTable = new Hashtable();

    public ADLayoutProcessor() {
    }

    public ADLayoutProcessor(TSEGraph tSEGraph) {
        this();
        if (tSEGraph == null) {
            throw new IllegalArgumentException("null graph");
        }
        this.graph = tSEGraph;
        this.graphManager = null;
    }

    public ADLayoutProcessor(TSEGraphManager tSEGraphManager) {
        this();
        if (tSEGraphManager == null) {
            throw new IllegalArgumentException("null graphManager");
        }
        this.graphManager = tSEGraphManager;
        this.graph = null;
    }

    public void preprocess() {
        TSServiceInputData tSServiceInputData = new TSServiceInputData();
        TSLayoutInputTailor tSLayoutInputTailor = new TSLayoutInputTailor(tSServiceInputData);
        if (this.graphManager != null) {
            for (TSEGraph tSEGraph : this.graphManager.graphs(false)) {
                int n = tSLayoutInputTailor.getLayoutStyle((TSDGraph)tSEGraph);
                if (!this.layoutCanChangeSize(n)) continue;
                this.preprocess(tSEGraph.nodes());
            }
        } else {
            int n = tSLayoutInputTailor.getLayoutStyle((TSDGraph)this.graph);
            if (this.layoutCanChangeSize(n)) {
                this.preprocess(this.graph.nodes());
            }
        }
    }

    protected void preprocess(List list) {
        for (TSENode tSENode : list) {
            if (tSENode.isExpanded()) continue;
            NodeData nodeData = new NodeData();
            nodeData.width = (int)tSENode.getOriginalWidth();
            nodeData.height = (int)tSENode.getOriginalHeight();
            nodeData.resizability = tSENode.getResizability();
            this.nodeDataTable.put(tSENode, nodeData);
            tSENode.setResizability(0);
        }
    }

    protected void postprocess(List list) {
        for (TSENode tSENode : list) {
            if (tSENode.isExpanded()) continue;
            NodeData nodeData = (NodeData)this.nodeDataTable.get(tSENode);
            if ((int)tSENode.getWidth() != nodeData.width || (int)tSENode.getHeight() != nodeData.height) continue;
            tSENode.setResizability(nodeData.resizability);
        }
    }

    public void postprocess() {
        TSServiceInputData tSServiceInputData = new TSServiceInputData();
        TSLayoutInputTailor tSLayoutInputTailor = new TSLayoutInputTailor(tSServiceInputData);
        if (this.graphManager != null) {
            for (TSEGraph tSEGraph : this.graphManager.graphs(false)) {
                int n = tSLayoutInputTailor.getLayoutStyle((TSDGraph)tSEGraph);
                if (!this.layoutCanChangeSize(n)) continue;
                this.postprocess(tSEGraph.nodes());
            }
        } else {
            int n = tSLayoutInputTailor.getLayoutStyle((TSDGraph)this.graph);
            if (this.layoutCanChangeSize(n)) {
                this.postprocess(this.graph.nodes());
            }
        }
    }

    private boolean layoutCanChangeSize(int n) {
        return n == 1 || n == 2;
    }

    static class NodeData {
        int width;
        int height;
        int resizability;

        NodeData() {
        }
    }
}

