/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.drawengines;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;

public class Padlock {
    private double centerX = 0.0;
    private double centerY = 0.0;
    private double scale = 1.0;
    private double rotation = 0.0;
    private boolean mirrorY = true;
    private int originalPointAnchor = 0;
    private Point2D originalPoint;

    public Padlock() {
    }

    public Padlock(double d, double d2, double d3, double d4) {
        this.centerX = d;
        this.centerY = d2;
        this.scale = d3;
        this.rotation = d4;
    }

    public void setLocation(double d, double d2) {
        this.centerX = d;
        this.centerY = d2;
    }

    public double getLocationX() {
        return this.centerX;
    }

    public double getLocationY() {
        return this.centerY;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setRotation(double d) {
        this.rotation = d;
    }

    public double getRotation() {
        return this.rotation;
    }

    public boolean getMirrorY() {
        return this.mirrorY;
    }

    public void setMirrorY(boolean bl) {
        this.mirrorY = bl;
    }

    public void setOriginalPoint(int n) {
        if (n == this.originalPointAnchor) {
            return;
        }
        switch (n) {
            case 0: {
                this.originalPointAnchor = n;
                this.originalPoint = null;
                break;
            }
            case 1: {
                this.originalPointAnchor = n;
                this.originalPoint = new Point2D.Float(0.0f, -9.0f);
                break;
            }
            case 2: {
                this.originalPointAnchor = n;
                this.originalPoint = new Point2D.Float(6.5f, -9.0f);
                break;
            }
            case 3: {
                this.originalPointAnchor = n;
                this.originalPoint = new Point2D.Float(6.5f, 0.0f);
                break;
            }
            case 4: {
                this.originalPointAnchor = n;
                this.originalPoint = new Point2D.Float(6.5f, 9.0f);
                break;
            }
            case 5: {
                this.originalPointAnchor = n;
                this.originalPoint = new Point2D.Float(0.0f, 9.0f);
                break;
            }
            case 6: {
                this.originalPointAnchor = n;
                this.originalPoint = new Point2D.Float(-6.5f, 9.0f);
                break;
            }
            case 7: {
                this.originalPointAnchor = n;
                this.originalPoint = new Point2D.Float(-6.5f, 0.0f);
                break;
            }
            case 8: {
                this.originalPointAnchor = n;
                this.originalPoint = new Point2D.Float(-6.5f, -9.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.translate(this.centerX, this.centerY);
        graphics2D2.scale(this.scale, this.mirrorY ? -this.scale : this.scale);
        graphics2D2.rotate(this.rotation);
        if (this.originalPointAnchor != 0) {
            graphics2D2.translate(this.mirrorY ? -this.originalPoint.getX() : this.originalPoint.getX(), -this.originalPoint.getY());
        }
        graphics2D2.setComposite(AlphaComposite.getInstance(3, 0.4f));
        PadlockDrawEngin.paint(graphics2D2);
    }

    private static class PadlockDrawEngin {
        private static final float lockBodyHWidth = 6.5f;
        private static final float lockBodyHeight = 10.0f;
        private static final float keyHoleYShift = 1.0f;
        private static final float keyHoleHeight = 5.0f;
        private static final float keyHoleHWidth = 1.3f;
        private static final float keyHoleRadius = 1.5f;
        private static final float claspHeight = 8.0f;
        private static final float claspHWidth = 3.0f;
        private static final float claspThickness = 2.0f;
        public static final float totalHeightHalf = 9.0f;
        public static final float totalWidthHalf = 6.5f;
        private static GeneralPath lockBodyWithHole = null;
        private static GeneralPath clasp = null;

        private PadlockDrawEngin() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void initLockTemplate() {
            if (lockBodyWithHole != null && clasp != null) return;
            Class<PadlockDrawEngin> clazz = PadlockDrawEngin.class;
            synchronized (PadlockDrawEngin.class) {
                if (lockBodyWithHole != null && clasp != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(-6.5f, -1.0f, 13.0f, 10.0f, 2.6f, 2.0f);
                Ellipse2D.Double double_ = new Ellipse2D.Double(-1.5, 1.0, 3.0, 3.0);
                GeneralPath generalPath = new GeneralPath(0);
                generalPath.moveTo(0.0f, 1.0f);
                generalPath.lineTo(-1.3f, 6.0f);
                generalPath.lineTo(1.3f, 6.0f);
                generalPath.lineTo(0.0f, 1.0f);
                Area area = new Area(generalPath);
                area.add(new Area(double_));
                lockBodyWithHole = new GeneralPath(0);
                lockBodyWithHole.append(float_, false);
                lockBodyWithHole.append(area, false);
                clasp = new GeneralPath(0);
                float f = -3.0f;
                float f2 = -2.0f;
                clasp.moveTo(f, f2);
                float f3 = f2 - 4.0f;
                clasp.lineTo(f, f3);
                float f4 = 3.0f;
                clasp.curveTo(f, -9.0f, f4, -9.0f, f4, f3);
                clasp.lineTo(f4, f2);
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        public static void paint(Graphics2D graphics2D) {
            PadlockDrawEngin.initLockTemplate();
            BasicStroke basicStroke = new BasicStroke(2.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(Color.black);
            graphics2D.draw(clasp);
            graphics2D.fill(lockBodyWithHole);
        }
    }
}

