/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.drawengines;

import com.tomsawyer.drawing.TSOvalShape;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSShape;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import org.netbeans.modules.uml.common.generics.IteratorT;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IUsage;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IInterface;
import org.netbeans.modules.uml.core.support.umlsupport.ETSize;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETSize;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.application.IMenuManager;
import org.netbeans.modules.uml.ui.products.ad.application.action.ContextMenuActionClass;
import org.netbeans.modules.uml.ui.products.ad.drawengines.ETNodeDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.graphobjects.ETEdge;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.ETGenericNodeUI;
import org.netbeans.modules.uml.ui.support.applicationmanager.INodePresentation;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.GDISupport;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETGraphObject;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ILabelManager;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADGraphWindow;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools.SmartDragTool;

public class ETInterfaceDrawEngine
extends ETNodeDrawEngine {
    private Color m_defaultFillColor = Color.yellow;

    public String getElementType() {
        String string = super.getElementType();
        if (string == null) {
            string = new String("Interface");
        }
        return string;
    }

    private IInterface getInterface() {
        return (IInterface)this.getFirstModelElement();
    }

    public void onContextMenu(IMenuManager iMenuManager) {
        IInterface iInterface = this.getInterface();
        if (iInterface != null) {
            this.addInterfaceEdgeMenuItems(iMenuManager);
        }
        super.onContextMenu(iMenuManager);
    }

    public boolean setSensitivityAndCheck(String string, ContextMenuActionClass contextMenuActionClass) {
        boolean bl = false;
        boolean bl2 = this.isParentDiagramReadOnly();
        if (string.equals("MBK_SHOW_INTERFACENAME")) {
            ILabelManager iLabelManager = this.getLabelManager();
            IInterface iInterface = this.getInterface();
            if (iLabelManager != null && iInterface != null) {
                boolean bl3 = iLabelManager.isDisplayed(0);
                contextMenuActionClass.setChecked(bl3);
                boolean bl4 = bl = !bl2;
            }
        }
        if (!bl) {
            super.setSensitivityAndCheck(string, contextMenuActionClass);
        }
        return bl;
    }

    public boolean onHandleButton(ActionEvent actionEvent, String string) {
        ILabelManager iLabelManager;
        boolean bl = false;
        if (string.equals("MBK_SHOW_INTERFACENAME") && (iLabelManager = this.getLabelManager()) != null) {
            boolean bl2 = iLabelManager.isDisplayed(0);
            iLabelManager.showLabel(0, !bl2);
            this.invalidate();
            bl = true;
        }
        if (!bl) {
            bl = super.onHandleButton(actionEvent, string);
        }
        return bl;
    }

    public String getDrawEngineID() {
        return "InterfaceDrawEngine";
    }

    public void drawContents(IDrawInfo iDrawInfo) {
        this.FixEdgeConnections();
        if (this.isConnector()) {
            if (this.isImplementOrInterfaceConnector()) {
                this.drawLittleLollipop(iDrawInfo);
            }
            this.drawDish(iDrawInfo);
        } else {
            this.drawLollipop(iDrawInfo);
        }
    }

    private boolean isImplementationOrInterface(IElement iElement) {
        return iElement.getElementType().compareTo("Interface") == 0 || iElement.getElementType().compareTo("Implementation") == 0;
    }

    private void FixEdgeConnections() {
        try {
            boolean bl = this.isConnector();
            INodePresentation iNodePresentation = this.getNodePresentation();
            ETList<IETGraphObject> eTList = iNodePresentation.getEdges(true, true);
            IteratorT iteratorT = new IteratorT(eTList);
            while (iteratorT.hasNext()) {
                ETEdge eTEdge = (ETEdge)iteratorT.next();
                if (!bl) {
                    this.RemoveTSConnector(eTEdge);
                    continue;
                }
                IElement iElement = TypeConversions.getElement(eTEdge);
                if (this.isImplementationOrInterface(iElement)) {
                    this.ConnectToCenter(eTEdge);
                    continue;
                }
                if (iElement.getElementType().compareTo("Usage") != 0) continue;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void ConnectToCenter(ETEdge eTEdge) {
        TSENode tSENode = this.getNode();
        Object var3_3 = null;
    }

    private void RemoveTSConnector(ETEdge eTEdge) {
        TSENode tSENode = this.getNode();
        Object var3_3 = null;
    }

    private void drawLittleLollipop(IDrawInfo iDrawInfo) {
        TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
        ETGenericNodeUI eTGenericNodeUI = (ETGenericNodeUI)this.getParent();
        TSENode tSENode = eTGenericNodeUI.getOwnerNode();
        TSConstRect tSConstRect = tSENode.getLocalBounds();
        double d = tSConstRect.getWidth() / 4.0;
        double d2 = tSConstRect.getHeight() / 4.0;
        TSConstRect tSConstRect2 = new TSConstRect(tSConstRect.getLeft() + d, tSConstRect.getTop() - d2, tSConstRect.getRight() - d, tSConstRect.getBottom() + d2);
        float f = (float)tSConstRect2.getCenterX();
        GradientPaint gradientPaint = new GradientPaint(f, (int)tSConstRect2.getBottom(), this.getFillColor(), f, (int)tSConstRect2.getTop(), this.getLightGradientFillColor());
        tSEGraphics.setPaint((Paint)gradientPaint);
        tSEGraphics.fillOval(tSConstRect2);
        tSEGraphics.setColor(this.getBorderColor());
        tSEGraphics.drawOval(tSConstRect2);
    }

    private void drawDish(IDrawInfo iDrawInfo) {
        try {
            TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
            ETGenericNodeUI eTGenericNodeUI = (ETGenericNodeUI)this.getParent();
            TSENode tSENode = eTGenericNodeUI.getOwnerNode();
            TSConstRect tSConstRect = tSENode.getLocalBounds();
            TSConstPoint tSConstPoint = tSConstRect.getCenter();
            INodePresentation iNodePresentation = this.getNodePresentation();
            ETList<IETGraphObject> eTList = iNodePresentation.getEdges(true, true);
            IteratorT iteratorT = new IteratorT(eTList);
            while (iteratorT.hasNext()) {
                ETEdge eTEdge = (ETEdge)iteratorT.next();
                IElement iElement = TypeConversions.getElement(eTEdge);
                if (iElement.getElementType().compareTo("Usage") != 0) continue;
                TSRect tSRect = new TSRect();
                int n = 0;
                int n2 = 0;
                IUsage iUsage = (IUsage)iElement;
                if (iUsage.getSupplier().isSame(this.getFirstModelElement())) {
                    TSConstPoint tSConstPoint2 = eTEdge.getSourcePoint();
                    double d = tSConstPoint2.getX() - tSConstPoint.getX();
                    double d2 = tSConstPoint2.getY() - tSConstPoint.getY();
                    if (Math.abs(d2) > Math.abs(d)) {
                        tSRect.setLeft(tSConstRect.getLeft());
                        tSRect.setRight(tSConstRect.getRight());
                        n = 0;
                        if (d2 > 0.0) {
                            tSRect.setTop(tSConstRect.getTop());
                            tSRect.setBottom(tSConstPoint.getY());
                            tSRect.setBottom(tSRect.getBottom() - tSRect.getHeight());
                            n2 = 180;
                        } else {
                            tSRect.setTop(tSConstPoint.getY());
                            tSRect.setBottom(tSConstRect.getBottom());
                            tSRect.setTop(tSRect.getTop() + tSRect.getHeight());
                            n2 = -180;
                        }
                    } else {
                        tSRect.setTop(tSConstRect.getTop());
                        tSRect.setBottom(tSConstRect.getBottom());
                        n = 90;
                        if (d > 0.0) {
                            tSRect.setLeft(tSConstPoint.getX());
                            tSRect.setRight(tSConstRect.getRight());
                            tSRect.setLeft(tSRect.getLeft() - tSRect.getWidth());
                            n2 = -180;
                        } else {
                            tSRect.setLeft(tSConstRect.getLeft());
                            tSRect.setRight(tSConstPoint.getX());
                            tSRect.setRight(tSRect.getRight() + tSRect.getWidth());
                            n2 = 180;
                        }
                    }
                }
                tSEGraphics.drawArc((TSConstRect)tSRect, n, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isConnector() {
        boolean bl = false;
        try {
            INodePresentation iNodePresentation = this.getNodePresentation();
            ETList<IETGraphObject> eTList = iNodePresentation.getEdges(true, true);
            IteratorT iteratorT = new IteratorT(eTList);
            while (iteratorT.hasNext()) {
                IETGraphObject iETGraphObject = (IETGraphObject)iteratorT.next();
                IElement iElement = TypeConversions.getElement(iETGraphObject);
                if (iElement == null || iElement.getElementType().compareTo("Usage") != 0) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private boolean isImplementOrInterfaceConnector() {
        boolean bl = false;
        try {
            INodePresentation iNodePresentation = this.getNodePresentation();
            ETList<IETGraphObject> eTList = iNodePresentation.getEdges(true, true);
            IteratorT iteratorT = new IteratorT(eTList);
            while (iteratorT.hasNext()) {
                IETGraphObject iETGraphObject = (IETGraphObject)iteratorT.next();
                IElement iElement = TypeConversions.getElement(iETGraphObject);
                if (!this.isImplementationOrInterface(iElement)) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private void drawLollipop(IDrawInfo iDrawInfo) {
        TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
        IETRect iETRect = iDrawInfo.getDeviceBounds();
        float f = (float)iETRect.getCenterX();
        GradientPaint gradientPaint = new GradientPaint(f, iETRect.getBottom(), this.getFillColor(), f, iETRect.getTop(), this.getLightGradientFillColor());
        GDISupport.drawEllipse((Graphics2D)tSEGraphics, iETRect.getRectangle(), this.getBorderColor(), gradientPaint);
    }

    public IETSize calculateOptimumSize(IDrawInfo iDrawInfo, boolean bl) {
        IETSize iETSize = new ETSize(20, 20);
        if (!bl && iETSize != null) {
            TSTransform tSTransform = iDrawInfo != null ? iDrawInfo.getTSTransform() : this.getTransform();
            iETSize = this.scaleSize(iETSize, tSTransform);
        }
        return iETSize;
    }

    public void sizeToContents() {
        TSENode tSENode = this.getOwnerNode();
        if (tSENode != null) {
            IETSize iETSize = this.calculateOptimumSize(null, false);
            this.resize(iETSize, false);
            tSENode.setShape((TSShape)new TSOvalShape());
        }
    }

    public String getManagerMetaType(int n) {
        IElement iElement;
        String string = null;
        if (n == 0) {
            string = "InterfaceLabelManager";
        } else if (n == 2 && (iElement = this.getFirstModelElement()) != null && iElement instanceof IInterface) {
            string = "ADInterfaceEventManager";
        }
        return string;
    }

    public boolean handleLeftMouseButtonPressed(MouseEvent mouseEvent) {
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
        ADGraphWindow aDGraphWindow = iDrawingAreaControl != null ? iDrawingAreaControl.getGraphWindow() : null;
        SmartDragTool smartDragTool = this.createSmartDragTool(mouseEvent);
        if (smartDragTool == null) {
            return false;
        }
        aDGraphWindow.getCurrentTool().setTool((TSEWindowTool)smartDragTool);
        smartDragTool.onMousePressed(mouseEvent);
        return true;
    }

    public void initResources() {
        this.setFillColor("ellipsefill", 251, 233, 126);
        this.setLightGradientFillColor("ellipselightgradient", 254, 254, 254);
        this.setBorderColor("ellipseborder", Color.BLACK);
        super.initResources();
    }
}

