/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.drawengines;

import java.util.HashMap;
import org.netbeans.modules.uml.common.ETException;
import org.netbeans.modules.uml.common.ETStrings;
import org.netbeans.modules.uml.core.metamodel.core.foundation.FactoryRetriever;
import org.netbeans.modules.uml.core.metamodel.core.foundation.ICreationFactory;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.IETGraphObjectUI;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ICompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;

public class ETDrawEngineFactory {
    private static final String COMPARTMENT_PACKAGE = "org.netbeans.modules.uml.ui.products.ad.compartments.";
    public static final String ATTRIBUTE_LIST_COMPARTMENT = "ETAttributeListCompartment";
    public static final String CLASS_ATTRIBUTE_COMPARTMENT = "ETClassAttributeCompartment";
    public static final String CLASS_OPERATION_COMPARTMENT = "ETClassOperationCompartment";
    public static final String CLASS_NAME_COMPARTMENT = "ETClassNameCompartment";
    public static final String CLASS_NAME_LIST_COMPARTMENT = "ETClassNameListCompartment";
    public static final String OPERATION_LIST_COMPARTMENT = "ETOperationListCompartment";
    public static final String REDEFINED_OPERATION_LIST_COMPARTMENT = "ETRedefinedOperationListCompartment";
    public static final String STEREOTYPE_COMPARTMENT = "ETStereoTypeCompartment";
    public static final String TAGGED_VALUES_COMPARTMENT = "ETTaggedValuesCompartment";
    private static HashMap compartmentMap;

    public static IDrawEngine createDrawEngine(IETGraphObjectUI iETGraphObjectUI) throws ETException {
        IDrawEngine iDrawEngine = ETDrawEngineFactory.createDrawEngine(iETGraphObjectUI.getDrawEngineClass());
        if (iDrawEngine != null) {
            iDrawEngine.setParent(iETGraphObjectUI);
            iETGraphObjectUI.setDrawEngine(iDrawEngine);
        }
        return iDrawEngine;
    }

    public static IDrawEngine createDrawEngine(String string) throws ETException {
        ICreationFactory iCreationFactory = FactoryRetriever.instance().getCreationFactory();
        Object object = iCreationFactory.retrieveEmptyMetaType("DrawEngines", string, null);
        return object instanceof IDrawEngine ? (IDrawEngine)object : null;
    }

    public static ICompartment createCompartment(String string) throws ETException {
        try {
            ICompartment iCompartment = (ICompartment)Class.forName(COMPARTMENT_PACKAGE + ETDrawEngineFactory.getCompartmentClass(string)).newInstance();
            return iCompartment;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ETException(ETStrings.E_CMN_UNEXPECTED_EXC, "ETDrawEngineFactory.createCompartment()", exception.getMessage());
        }
    }

    private static String getCompartmentClass(String string) {
        if (compartmentMap == null) {
            ETDrawEngineFactory.initComparmtentMap();
            return (String)compartmentMap.get(string);
        }
        return (String)compartmentMap.get(string);
    }

    private static void initComparmtentMap() {
        compartmentMap = new HashMap();
        compartmentMap.put(ATTRIBUTE_LIST_COMPARTMENT, ATTRIBUTE_LIST_COMPARTMENT);
        compartmentMap.put(CLASS_ATTRIBUTE_COMPARTMENT, CLASS_ATTRIBUTE_COMPARTMENT);
        compartmentMap.put(CLASS_OPERATION_COMPARTMENT, CLASS_OPERATION_COMPARTMENT);
        compartmentMap.put(CLASS_NAME_COMPARTMENT, CLASS_NAME_COMPARTMENT);
        compartmentMap.put(CLASS_NAME_LIST_COMPARTMENT, CLASS_NAME_LIST_COMPARTMENT);
        compartmentMap.put(OPERATION_LIST_COMPARTMENT, OPERATION_LIST_COMPARTMENT);
        compartmentMap.put(REDEFINED_OPERATION_LIST_COMPARTMENT, REDEFINED_OPERATION_LIST_COMPARTMENT);
        compartmentMap.put(STEREOTYPE_COMPARTMENT, STEREOTYPE_COMPARTMENT);
        compartmentMap.put(TAGGED_VALUES_COMPARTMENT, TAGGED_VALUES_COMPARTMENT);
        compartmentMap.put("ADAttributeListCompartment", ATTRIBUTE_LIST_COMPARTMENT);
        compartmentMap.put("ADClassAttributeCompartment", CLASS_ATTRIBUTE_COMPARTMENT);
        compartmentMap.put("ADClassOperationCompartment", CLASS_OPERATION_COMPARTMENT);
        compartmentMap.put("ADClassNameCompartment", CLASS_NAME_COMPARTMENT);
        compartmentMap.put("ADClassNameListCompartment", CLASS_NAME_LIST_COMPARTMENT);
        compartmentMap.put("ADOperationListCompartment", OPERATION_LIST_COMPARTMENT);
        compartmentMap.put("ADRedefinedOperationListCompartment", REDEFINED_OPERATION_LIST_COMPARTMENT);
        compartmentMap.put("StereotypeCompartment", STEREOTYPE_COMPARTMENT);
    }
}

