/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.drawengines;

import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.structure.IDeploymentSpecification;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.ETSize;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETSize;
import org.netbeans.modules.uml.ui.products.ad.compartments.ETClassNameCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.ETClassNameListCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.IADClassNameListCompartment;
import org.netbeans.modules.uml.ui.products.ad.drawengines.ETNodeDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.GDISupport;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ICompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IListCompartment;

public class ETDeploymentSpecDrawEngine
extends ETNodeDrawEngine {
    protected final int NODE_WIDTH = 140;
    protected final int NODE_HEIGHT = 100;
    private TSEFont m_staticTextFont = new TSEFont("Arial-plain-12");
    private TSEColor m_defaultTextColor = new TSEColor(TSEColor.black);

    public String getDrawEngineID() {
        return "DeploymentSpecDrawEngine";
    }

    public String getElementType() {
        String string = super.getElementType();
        if (string == null) {
            string = new String("DeploymentSpecification");
        }
        return string;
    }

    public void initResources() {
        this.setFillColor("deploymentspecfill", 195, 226, 203);
        this.setLightGradientFillColor("deploymentspeclightgradient", 255, 255, 255);
        this.setBorderColor("deploymentspecborder", Color.BLACK);
        super.initResources();
    }

    public void createCompartments() {
        this.clearCompartments();
        ETClassNameListCompartment eTClassNameListCompartment = new ETClassNameListCompartment(this);
        eTClassNameListCompartment.addCompartment(new ETClassNameCompartment(this), -1, false);
        eTClassNameListCompartment.setName("<<deployment spec>>");
        this.addCompartment(eTClassNameListCompartment);
    }

    public void initCompartments(IPresentationElement iPresentationElement) {
        IElement iElement;
        int n = this.getNumCompartments();
        if (n == 0) {
            try {
                this.createCompartments();
                n = this.getNumCompartments();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((iElement = iPresentationElement.getFirstSubject()) != null && n > 0) {
            IADClassNameListCompartment iADClassNameListCompartment;
            String string = iElement.getElementType();
            if (iElement instanceof IDeploymentSpecification && (iADClassNameListCompartment = (IADClassNameListCompartment)this.getCompartmentByKind(IADClassNameListCompartment.class)) != null) {
                iADClassNameListCompartment.attach(iElement);
            }
        }
    }

    public void drawContents(IDrawInfo iDrawInfo) {
        TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        if (iDrawInfo != null) {
            IETRect iETRect = iDrawInfo.getDeviceBounds();
            TSConstRect tSConstRect = tSTransform.boundsToWorld(iETRect.getRectangle());
            float f = (float)iETRect.getCenterX();
            GradientPaint gradientPaint = new GradientPaint(f, iETRect.getBottom(), this.getBkColor(), f, iETRect.getTop(), this.getLightGradientFillColor());
            GDISupport.drawRectangle((Graphics2D)tSEGraphics, iETRect.getRectangle(), this.getBorderBoundsColor(), gradientPaint);
            Font font = tSEGraphics.getFont();
            this.setLastDrawPointWorldY(tSConstRect.getTop() - 5.0);
            for (ICompartment iCompartment : this.getCompartments()) {
                IListCompartment iListCompartment;
                if (!(iCompartment instanceof IListCompartment) || !((iListCompartment = (IListCompartment)iCompartment) instanceof ETClassNameListCompartment)) continue;
                String string = iListCompartment.getName();
                if (string != null && string.length() > 0) {
                    tSEGraphics.setFont(this.m_staticTextFont.getScaledFont(iDrawInfo.getFontScaleFactor()));
                    this.updateLastDrawPointWorldY(tSTransform.heightToWorld(tSEGraphics.getFontMetrics().getHeight()) / 1.5);
                    tSEGraphics.setColor(this.m_defaultTextColor);
                    tSEGraphics.drawString(string, tSTransform.xToDevice(tSConstRect.getLeft() + tSConstRect.getWidth() / 2.0) - tSEGraphics.getFontMetrics().stringWidth(string) / 2, tSTransform.yToDevice(this.getLastDrawPointWorldY()));
                    this.updateLastDrawPointWorldY(tSTransform.heightToWorld(tSEGraphics.getFontMetrics().getHeight() / 2));
                }
                IETSize iETSize = iListCompartment.calculateOptimumSize(iDrawInfo, false);
                ETRect eTRect = new ETRect(iETRect.getLeft(), tSTransform.yToDevice(this.getLastDrawPointWorldY()), iETRect.getIntWidth(), iETSize.getHeight());
                iListCompartment.draw(iDrawInfo, eTRect);
                this.updateLastDrawPointWorldY(tSTransform.heightToWorld(iETSize.getHeight()));
            }
            tSEGraphics.setFont(font);
        }
    }

    public IETSize calculateOptimumSize(IDrawInfo iDrawInfo, boolean bl) {
        ETSize eTSize = new ETSize(0, 0);
        IETSize iETSize = super.calculateOptimumSize(iDrawInfo, true);
        eTSize.setWidth(Math.max(iETSize.getWidth(), 140));
        eTSize.setHeight(Math.max(iETSize.getHeight(), 100));
        return bl || eTSize == null ? eTSize : this.scaleSize(eTSize, iDrawInfo != null ? iDrawInfo.getTSTransform() : this.getTransform());
    }
}

