/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.drawengines;

import com.tomsawyer.drawing.geometry.TSConstRect;
import java.awt.Color;
import java.awt.event.ActionEvent;
import org.netbeans.modules.uml.common.ETException;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.metamodel.common.commonactivities.IJoinNode;
import org.netbeans.modules.uml.core.metamodel.common.commonactivities.IMergeNode;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.support.umlsupport.ETSize;
import org.netbeans.modules.uml.core.support.umlsupport.IETSize;
import org.netbeans.modules.uml.ui.products.ad.ADDrawEngines.ADNodeDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.application.IMenuManager;
import org.netbeans.modules.uml.ui.products.ad.application.action.ContextMenuActionClass;
import org.netbeans.modules.uml.ui.products.ad.compartments.ETBoxCompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IBoxCompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETNodeUI;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IEllipseCompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ILabelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETControlNodeDrawEngine
extends ADNodeDrawEngine {
    public static final long FORK_NODE_HEIGHT = 80L;
    public static final long FORK_NODE_WIDTH = 7L;
    public static final long DECISION_NODE_HEIGHT = 30L;
    public static final long DECISION_NODE_WIDTH = 20L;
    public static final long OTHER_NODES_HEIGHT = 16L;
    public static final long OTHER_NODES_WIDTH = 16L;
    public static final long FLOW_FINAL_NODE_HEIGHT = 27L;
    public static final long FLOW_FINAL_NODE_WIDTH = 27L;
    private static final String HORIZONTAL = "Horizontal";
    private static int HORIZONTAL_FORK = 0;
    private static int VERTICAL_FORK = 1;

    @Override
    public IETSize calculateOptimumSize(IDrawInfo iDrawInfo, boolean bl) {
        try {
            ETPairT<Long, Long> eTPairT = this.getOptimalHeightAndWidth();
            long l = eTPairT.getParamOne();
            long l2 = eTPairT.getParamTwo();
            IETSize iETSize = new ETSize((int)l, (int)l2);
            if (!bl) {
                iETSize = this.scaleSize(iETSize, iDrawInfo != null ? iDrawInfo.getTSTransform() : this.getTransform());
            }
            return iETSize;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void doDraw(IDrawInfo iDrawInfo) {
        this.dispatchDrawToCompartments(iDrawInfo, iDrawInfo.getDeviceBounds());
        this.drawInvalidRectangle(iDrawInfo);
    }

    @Override
    public String getDrawEngineID() {
        return "ControlNodeDrawEngine";
    }

    @Override
    public void sizeToContents() {
        try {
            ETPairT<Long, Long> eTPairT = this.getOptimalHeightAndWidth();
            long l = eTPairT.getParamOne();
            long l2 = eTPairT.getParamTwo();
            this.sizeToContentsWithMin(l, l2, false, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public void createCompartments() throws ETException {
        try {
            this.clearCompartments();
            String string = this.getMetaTypeOfElement();
            if (string == null) {
                return;
            }
            if (string.equals("ActivityFinalNode") || string.equals("FlowFinalNode") || string.equals("InitialNode")) {
                this.createAndAddCompartment("EllipseCompartment", 0);
            } else if (string.equals("ForkNode") || string.equals("JoinNode") || string.equals("JoinForkNode")) {
                this.createAndAddCompartment("BoxCompartment", 0);
                this.initResources();
            } else if (string.equals("DecisionNode") || string.equals("MergeNode") || string.equals("DecisionMergeNode")) {
                this.createAndAddCompartment("BoxCompartment", 0);
                this.initResources();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void initCompartments(IPresentationElement iPresentationElement) {
        try {
            String string;
            long l = this.getNumCompartments();
            if (l == 0L) {
                this.createCompartments();
            }
            if ((string = this.getMetaTypeOfElement()) == null) {
                return;
            }
            IEllipseCompartment iEllipseCompartment = (IEllipseCompartment)this.getCompartmentByKind(IEllipseCompartment.class);
            IBoxCompartment iBoxCompartment = (IBoxCompartment)this.getCompartmentByKind(IBoxCompartment.class);
            if (iEllipseCompartment != null) {
                if (string.equals("ActivityFinalNode")) {
                    iEllipseCompartment.setEllipseKind(0);
                } else if (string.equals("FlowFinalNode")) {
                    iEllipseCompartment.setEllipseKind(1);
                } else if (string.equals("InitialNode")) {
                    iEllipseCompartment.setEllipseKind(2);
                } else {
                    iEllipseCompartment.setEllipseKind(-1);
                }
                if (this.getNodeUI() != null) {
                    this.getNodeUI().setResizable(false);
                }
            } else if (iBoxCompartment != null) {
                if (string.equals("ForkNode") || string.equals("JoinNode") || string.equals("JoinForkNode")) {
                    iBoxCompartment.setBoxKind(4);
                } else if (string.equals("DecisionNode") || string.equals("MergeNode") || string.equals("DecisionMergeNode")) {
                    iBoxCompartment.setBoxKind(3);
                }
                if (this.getNodeUI() != null) {
                    this.getNodeUI().setResizable(true);
                }
            }
            this.invalidate();
            this.getDiagram().refresh(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void initResources() {
        IBoxCompartment iBoxCompartment;
        String string = this.getMetaTypeOfElement();
        Color color = null;
        Color color2 = null;
        Color color3 = Color.BLACK;
        String string2 = "boxfill";
        String string3 = "boxlightgradient";
        String string4 = "boxborder";
        if (string != null) {
            if (string.equals("ForkNode") || string.equals("JoinNode") || string.equals("JoinForkNode")) {
                string2 = "forkfill";
                string3 = "forklightgradient";
                string4 = "forkborder";
                color2 = new Color(191, 235, 235);
                color = new Color(50, 199, 199);
            } else if (string.equals("InitialNode")) {
                string2 = "initialnodefill";
                string3 = "initialnodelightgradient";
                string4 = "initialnodeborder";
                color2 = new Color(116, 189, 136);
                color = new Color(26, 120, 51);
            } else if (string.equals("ActivityFinalNode")) {
                string2 = "activityfinalfill";
                string3 = "activityfinallightgradient";
                string4 = "activityfinalborder";
                color2 = new Color(255, 225, 217);
                color = new Color(255, 51, 0);
            } else if (string.equals("FlowFinalNode")) {
                string2 = "flowfinalfill";
                string3 = "flowfinallightgradient";
                string4 = "flowfinalborder";
                color2 = new Color(255, 225, 217);
                color = new Color(255, 51, 0);
            } else if (string.equals("DecisionMergeNode") || string.equals("DecisionNode") || string.equals("MergeNode")) {
                string2 = "mergefill";
                string3 = "mergelightgradient";
                string4 = "mergeborder";
                color2 = new Color(255, 255, 255);
                color = new Color(167, 240, 240);
            }
        }
        if (color3 != null) {
            this.setBorderColor(string4, color3);
        }
        if (color != null) {
            this.setFillColor(string2, color);
            this.setLightGradientFillColor(string3, color2);
        }
        if ((iBoxCompartment = (IBoxCompartment)this.getCompartmentByKind(IBoxCompartment.class)) != null) {
            ((ETBoxCompartment)iBoxCompartment).initBoxResources(string2, string3, string4);
        }
        super.initResources();
    }

    @Override
    public boolean isDrawEngineValidForModelElement() {
        String string = this.getMetaTypeOfElement();
        return string != null && (string.equals("DecisionNode") || string.equals("FlowFinalNode") || string.equals("ForkNode") || string.equals("JoinForkNode") || string.equals("InitialNode") || string.equals("JoinNode") || string.equals("MergeNode") || string.equals("DecisionMergeNode") || string.equals("ActivityFinalNode"));
    }

    @Override
    public void setupOwner() {
        this.sizeToContents();
        super.setupOwner();
    }

    @Override
    public String getElementType() {
        String string = super.getElementType();
        if (string == null) {
            string = new String("Control Class");
        }
        return string;
    }

    @Override
    public String getManagerMetaType(int n) {
        if (n == 2) {
            IElement iElement = this.getFirstModelElement();
            if (iElement instanceof IJoinNode || iElement instanceof IMergeNode) {
                return "JoinForkNodeEventManager";
            }
        } else if (n == 0) {
            return "SimpleStereotypeAndNameLabelManager";
        }
        return null;
    }

    protected ETPairT<Long, Long> getOptimalHeightAndWidth() {
        long l = 16L;
        long l2 = 16L;
        try {
            String string;
            boolean bl = true;
            IElement iElement = this.getFirstModelElement();
            if (iElement != null) {
                string = this.getMetaTypeOfElement();
                bl = string != null && string.equals("ForkNode") || string.equals("JoinNode") || string.equals("JoinForkNode") || string.equals("DecisionNode") || string.equals("DecisionMergeNode") || string.equals("MergeNode") || string.equals("FlowFinalNode") || string.equals("ActivityFinalNode");
            }
            if (bl && (string = this.getInitializationString()) != null && string.length() > 0) {
                if (string.indexOf(HORIZONTAL) >= 0) {
                    l = 80L;
                    l2 = 7L;
                } else if (string.indexOf("ActivityFinalNode") >= 0) {
                    l = 27L;
                    l2 = 27L;
                } else if (string.indexOf("ForkNode") >= 0 || string.indexOf("JoinNode") >= 0 || string.indexOf("JoinForkNode") >= 0) {
                    l = 7L;
                    l2 = 80L;
                } else if (string.indexOf("DecisionNode") >= 0) {
                    l = 20L;
                    l2 = 30L;
                } else {
                    l = 16L;
                    l2 = 16L;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new ETPairT<Long, Long>(new Long(l), new Long(l2));
    }

    protected boolean isHorizontalJoinOrMergeNode() {
        boolean bl = false;
        try {
            TSConstRect tSConstRect;
            String string = this.getMetaTypeOfElement();
            if ((string.equals("ForkNode") || string.equals("JoinNode") || string.equals("JoinForkNode")) && this.getNodeUI() != null && (tSConstRect = this.getNodeUI().getBounds()).getWidth() > tSConstRect.getHeight()) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    protected int getForkKind() {
        int n = -1;
        try {
            String string = this.getMetaTypeOfElement();
            if ((string.equals("ForkNode") || string.equals("JoinNode") || string.equals("JoinForkNode")) && this.getNodeUI() != null) {
                TSConstRect tSConstRect = this.getNodeUI().getBounds();
                n = tSConstRect.getWidth() > tSConstRect.getHeight() ? HORIZONTAL_FORK : VERTICAL_FORK;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    @Override
    public boolean setSensitivityAndCheck(String string, ContextMenuActionClass contextMenuActionClass) {
        boolean bl = this.isParentDiagramReadOnly();
        boolean bl2 = this.handleStandardLabelSensitivityAndCheck(string, contextMenuActionClass);
        if (!bl2) {
            if (string.equals("MBK_SHOW_NAME_LABEL")) {
                ILabelManager iLabelManager = this.getLabelManager();
                if (iLabelManager != null) {
                    boolean bl3 = iLabelManager.isDisplayed(12);
                    contextMenuActionClass.setChecked(bl3);
                    bl2 = !bl;
                }
            } else {
                bl2 = string.equals("MBK_SHOW_VERTICAL_FORK") || string.equals("MBK_SHOW_HORIZONTAL_FORK") ? !bl : super.setSensitivityAndCheck(string, contextMenuActionClass);
            }
        }
        return bl2;
    }

    @Override
    public boolean onHandleButton(ActionEvent actionEvent, String string) {
        boolean bl = this.handleStandardLabelSelection(actionEvent, string);
        if (!bl) {
            if (string.equals("MBK_SHOW_NAME_LABEL")) {
                ILabelManager iLabelManager = this.getLabelManager();
                if (iLabelManager != null) {
                    boolean bl2 = iLabelManager.isDisplayed(12);
                    iLabelManager.showLabel(12, !bl2);
                    this.invalidate();
                }
                bl = true;
            } else if (string.equals("MBK_SHOW_VERTICAL_FORK") || string.equals("MBK_SHOW_HORIZONTAL_FORK")) {
                IETNodeUI iETNodeUI = this.getNodeUI();
                if (iETNodeUI != null) {
                    TSConstRect tSConstRect = iETNodeUI.getBounds();
                    double d = tSConstRect.getWidth();
                    double d2 = tSConstRect.getHeight();
                    this.resize(Math.round((long)d2), Math.round((long)d), false);
                    String string2 = this.getInitializationString();
                    String string3 = "";
                    if (string2 != null && string2.length() > 0) {
                        int n = string2.lastIndexOf(HORIZONTAL);
                        string3 = n > -1 ? string2.substring(0, n).trim() : string2.concat(" Horizontal");
                        iETNodeUI.setInitStringValue(string3);
                    }
                }
                bl = true;
            }
        }
        if (!bl) {
            bl = super.onHandleButton(actionEvent, string);
        }
        return bl;
    }

    @Override
    public void onContextMenu(IMenuManager iMenuManager) {
        this.addControlNodeMenuItems(iMenuManager);
        super.onContextMenu(iMenuManager);
    }

    protected void addControlNodeMenuItems(IMenuManager iMenuManager) {
        int n;
        IMenuManager iMenuManager2 = iMenuManager.createOrGetSubMenu(this.loadString("IDS_LABELS_TITLE"), "");
        if (iMenuManager2 != null) {
            iMenuManager2.add(this.createMenuAction(this.loadString("IDS_NAME_LABEL"), "MBK_SHOW_NAME_LABEL"));
        }
        if ((n = this.getForkKind()) != -1) {
            ContextMenuActionClass contextMenuActionClass = n == HORIZONTAL_FORK ? this.createMenuAction(this.loadString("IDS_POPUP_ACD_TO_VERTICAL_FORK"), "MBK_SHOW_VERTICAL_FORK") : this.createMenuAction(this.loadString("IDS_POPUP_ACD_TO_HORIZONTAL_FORK"), "MBK_SHOW_HORIZONTAL_FORK");
            iMenuManager.add(contextMenuActionClass);
        }
    }
}

