/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.drawengines;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSObject;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import org.netbeans.modules.uml.common.ETException;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.ICoreRelationshipDiscovery;
import org.netbeans.modules.uml.core.metamodel.infrastructure.IPort;
import org.netbeans.modules.uml.core.metamodel.structure.IComponent;
import org.netbeans.modules.uml.core.preferenceframework.PreferenceAccessor;
import org.netbeans.modules.uml.core.support.umlsupport.ETSize;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETSize;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.application.IMenuManager;
import org.netbeans.modules.uml.ui.products.ad.application.action.ContextMenuActionClass;
import org.netbeans.modules.uml.ui.products.ad.compartments.INameListCompartment;
import org.netbeans.modules.uml.ui.products.ad.diagramengines.IADRelationshipDiscovery;
import org.netbeans.modules.uml.ui.products.ad.drawEngineManagers.IADInterfaceEventManager;
import org.netbeans.modules.uml.ui.products.ad.drawengines.ETContainerDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.drawengines.ETNodeDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.drawengines.IComponentDrawEngine;
import org.netbeans.modules.uml.ui.support.PresentationReferenceHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.INodePresentation;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductGraphPresentation;
import org.netbeans.modules.uml.ui.support.umltsconversions.RectConversions;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.GDISupport;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETGraphObject;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETNode;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IEventManager;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.PresentationHelper;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDiagramEngine;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETComponentDrawEngine
extends ETContainerDrawEngine
implements IComponentDrawEngine {
    protected final int NODE_WIDTH = 180;
    protected final int NODE_HEIGHT = 100;
    private static final int s_PortOffset = 10;
    private static final int s_PortSize = 10;
    IETRect m_originalSize;
    ETNodeDrawEngine.ETHiddenNodeList m_HiddenNodes = null;
    ETList<PortLocations> m_PortLocations = new ETArrayList<PortLocations>();
    IETRect m_additionalInvalidateRect;
    boolean m_autoRouteEdges;

    @Override
    public String getDrawEngineID() {
        return "ComponentDrawEngine";
    }

    @Override
    public void initCompartments(IPresentationElement iPresentationElement) {
        if (null == iPresentationElement) {
            throw new IllegalArgumentException();
        }
        try {
            INameListCompartment iNameListCompartment;
            IElement iElement;
            long l = this.getNumCompartments();
            if (l == 0L) {
                this.createCompartments();
            }
            if ((iElement = iPresentationElement.getFirstSubject()) != null && (iNameListCompartment = (INameListCompartment)this.getCompartmentByKind(INameListCompartment.class)) != null) {
                iNameListCompartment.attach(iElement);
            }
        }
        catch (ETException eTException) {
            eTException.printStackTrace();
        }
    }

    @Override
    public void createCompartments() throws ETException {
        this.clearCompartments();
        this.createAndAddCompartment("ADNameListCompartment", 0);
        INameListCompartment iNameListCompartment = (INameListCompartment)this.getCompartmentByKind(INameListCompartment.class);
        if (iNameListCompartment != null) {
            iNameListCompartment.addStaticText("<<component>>");
        }
    }

    @Override
    public void sizeToContents() {
        ETList<IElement> eTList = this.getPorts2();
        int n = eTList != null ? eTList.getCount() : 0;
        int n2 = 40;
        int n3 = 40;
        if (n > 0) {
            PortsPerSide portsPerSide = new PortsPerSide();
            if (n2 < (portsPerSide.m_nTop + 1) * 10 + (portsPerSide.m_nTop + 1) * 10) {
                n2 = (portsPerSide.m_nTop + 1) * 10 + (portsPerSide.m_nTop + 1) * 10;
            }
            if (n2 < (portsPerSide.m_nBottom + 1) * 10 + (portsPerSide.m_nBottom + 1) * 10) {
                n2 = (portsPerSide.m_nBottom + 1) * 10 + (portsPerSide.m_nBottom + 1) * 10;
            }
            if (n3 < (portsPerSide.m_nLeft + 1) * 10 + (portsPerSide.m_nLeft + 1) * 10) {
                n3 = (portsPerSide.m_nLeft + 1) * 10 + (portsPerSide.m_nLeft + 1) * 10;
            }
            if (n3 < (portsPerSide.m_nRight + 1) * 10 + (portsPerSide.m_nRight + 1) * 10) {
                n3 = (portsPerSide.m_nRight + 1) * 10 + (portsPerSide.m_nRight + 1) * 10;
            }
        }
        this.sizeToContentsWithMin(n2, n3, false, true);
    }

    @Override
    public void doDraw(IDrawInfo iDrawInfo) {
        TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
        IETRect iETRect = iDrawInfo.getDeviceBounds();
        Color color = this.getBorderBoundsColor();
        Color color2 = this.getBkColor();
        float f = (float)iETRect.getCenterX();
        GradientPaint gradientPaint = new GradientPaint(f, iETRect.getBottom(), color2, f, iETRect.getTop(), this.getLightGradientFillColor());
        GDISupport.drawRectangle((Graphics2D)tSEGraphics, iETRect.getRectangle(), color, gradientPaint);
        this.handleNameListCompartmentDrawForContainers(iDrawInfo, iETRect);
        super.doDraw(iDrawInfo);
    }

    @Override
    public String getElementType() {
        return new String("Component");
    }

    @Override
    public void initResources() {
        this.setFillColor("componentfill", 255, 204, 0);
        this.setLightGradientFillColor("componentlightgradient", 254, 241, 187);
        this.setBorderColor("componentborder", Color.BLACK);
        super.initResources();
    }

    @Override
    public void onGraphEvent(int n) {
        switch (n) {
            case 2: {
                this.selectAllPorts(true, true, true);
                break;
            }
            case 9: {
                this.selectAllPorts(true, false, false);
                break;
            }
            case 3: 
            case 11: {
                ETPairT<IETRect, IETRect> eTPairT = this.getBoundingRectWithLollypops();
                if (eTPairT != null) {
                    this.invalidateRect(eTPairT.getParamTwo());
                }
                this.selectAllPorts(false);
                break;
            }
            case 5: {
                this.rememberAllPortPositions();
                this.hideAllPorts(true);
                break;
            }
            case 6: {
                this.hideAllPorts(false);
                this.restoreAllPortPositions();
                ETPairT<IETRect, IETRect> eTPairT = this.getBoundingRectWithLollypops();
                if (eTPairT == null) break;
                this.invalidateRect(eTPairT.getParamTwo());
                break;
            }
            case 7: {
                ETPairT<IETRect, IETRect> eTPairT;
                INodePresentation iNodePresentation = this.getNodePresentation();
                if (iNodePresentation != null && (eTPairT = this.getBoundingRectWithLollypops()) != null) {
                    this.m_originalSize = eTPairT.getParamOne();
                    IETRect iETRect = eTPairT.getParamTwo();
                    double d = this.m_originalSize.getWidth();
                    double d2 = this.m_originalSize.getHeight();
                    if (iETRect != null) {
                        d = iETRect.getWidth();
                        d2 = iETRect.getHeight();
                    }
                    iNodePresentation.resize((long)d, (long)d2, false);
                }
                this.rememberAllPortPositions();
                this.hideAllPorts(true);
                break;
            }
            case 8: {
                INodePresentation iNodePresentation = this.getNodePresentation();
                if (iNodePresentation != null && this.m_originalSize != null) {
                    double d = this.m_originalSize.getWidth();
                    double d3 = this.m_originalSize.getHeight();
                    iNodePresentation.resize((long)d, (long)d3, true);
                    this.m_originalSize = null;
                }
                this.hideAllPorts(false);
                this.restoreAllPortPositions();
                this.distributeInterfacesOnAllPorts(false);
            }
        }
        super.onGraphEvent(n);
    }

    @Override
    public void onContextMenu(IMenuManager iMenuManager) {
        this.addPortMenuItems(iMenuManager);
        super.onContextMenu(iMenuManager);
    }

    @Override
    public boolean setSensitivityAndCheck(String string, ContextMenuActionClass contextMenuActionClass) {
        boolean bl = false;
        if (string.equals("MBK_COMPONENT_PORT_NAME") || string.equals("MBK_COMPONENT_PORT_NAME_END")) {
            int n = 0;
            boolean bl2 = this.isDisplayed(n);
            contextMenuActionClass.setChecked(bl2);
        } else {
            bl = super.setSensitivityAndCheck(string, contextMenuActionClass);
        }
        return bl;
    }

    @Override
    public boolean onHandleButton(ActionEvent actionEvent, String string) {
        boolean bl = false;
        if (string.equals("MBK_COMPONENT_PORT_NAME") || string.equals("MBK_COMPONENT_PORT_NAME_END")) {
            ICoreRelationshipDiscovery iCoreRelationshipDiscovery;
            IDiagramEngine iDiagramEngine;
            int n = 0;
            boolean bl2 = this.isDisplayed(n);
            IPort iPort = this.getPortAtIndex(n);
            IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
            if (iDrawingAreaControl != null && iPort != null && bl2) {
                ETList<IPresentationElement> eTList = this.getPorts();
                if (eTList != null) {
                    int n2 = eTList.size();
                    for (int i = 0; i < n2; ++i) {
                        boolean bl3;
                        IPresentationElement iPresentationElement = (IPresentationElement)eTList.get(i);
                        IElement iElement = TypeConversions.getElement(iPresentationElement);
                        if (iElement == null || !(bl3 = iElement.isSame(iPort)) || !(iPresentationElement instanceof INodePresentation)) continue;
                        iDrawingAreaControl.postDeletePresentationElement(iPresentationElement);
                    }
                }
            } else if (iDrawingAreaControl != null && iPort != null && (iDiagramEngine = iDrawingAreaControl.getDiagramEngine()) != null && (iCoreRelationshipDiscovery = iDiagramEngine.getRelationshipDiscovery()) != null && iCoreRelationshipDiscovery instanceof IADRelationshipDiscovery) {
                IPresentationElement iPresentationElement;
                IADRelationshipDiscovery iADRelationshipDiscovery = (IADRelationshipDiscovery)iCoreRelationshipDiscovery;
                IPresentationElement iPresentationElement2 = this.getPresentationElement();
                if (iPresentationElement2 != null && (iPresentationElement = iADRelationshipDiscovery.createPortPresentationElement(iPresentationElement2, iPort)) != null) {
                    this.repositionAllPorts();
                }
            }
        } else {
            bl = super.onHandleButton(actionEvent, string);
        }
        return bl;
    }

    @Override
    public IETSize calculateOptimumSize(IDrawInfo iDrawInfo, boolean bl) {
        ETSize eTSize = new ETSize(0, 0);
        IETSize iETSize = super.calculateOptimumSize(iDrawInfo, true);
        eTSize.setWidth(Math.max(iETSize.getWidth(), 180));
        eTSize.setHeight(Math.max(iETSize.getHeight(), 100));
        TSTransform tSTransform = iDrawInfo != null ? iDrawInfo.getTSTransform() : this.getTransform();
        return bl || eTSize == null ? eTSize : this.scaleSize(eTSize, tSTransform);
    }

    @Override
    public ETPairT<IETRect, IETRect> getBoundingRectWithLollypops() {
        TSENode tSENode = this.getOwnerNode();
        if (tSENode != null) {
            TSConstRect tSConstRect = tSENode.getBounds();
            IETRect iETRect = RectConversions.newETRect(tSConstRect);
            ETList<IPresentationElement> eTList = this.getPorts();
            if (eTList != null) {
                for (IPresentationElement iPresentationElement : eTList) {
                    ETList<IETGraphObject> eTList2;
                    IProductGraphPresentation iProductGraphPresentation = null;
                    if (!(iPresentationElement instanceof IProductGraphPresentation)) continue;
                    iProductGraphPresentation = (IProductGraphPresentation)iPresentationElement;
                    IETRect iETRect2 = iProductGraphPresentation.getBoundingRect();
                    TSRect tSRect = RectConversions.etRectToTSRect(iETRect2);
                    TSConstRect tSConstRect2 = tSConstRect = tSRect != null ? tSConstRect.union((TSConstRect)tSRect) : tSConstRect;
                    TSENode tSENode2 = TypeConversions.getOwnerNode(iPresentationElement);
                    if (tSENode2 == null || (eTList2 = this.getLollypopInterfacesControlledByPort(tSENode2)) == null) continue;
                    for (IETGraphObject iETGraphObject : eTList2) {
                        IPresentationElement iPresentationElement2 = TypeConversions.getPresentationElement(iETGraphObject);
                        if (!(iPresentationElement2 instanceof IProductGraphPresentation)) continue;
                        IProductGraphPresentation iProductGraphPresentation2 = (IProductGraphPresentation)iPresentationElement2;
                        IETRect iETRect3 = iProductGraphPresentation2.getBoundingRect();
                        TSRect tSRect2 = RectConversions.etRectToTSRect(iETRect3);
                        tSConstRect = tSRect2 != null ? tSConstRect.union((TSConstRect)tSRect2) : tSConstRect;
                    }
                }
            }
            return new ETPairT<IETRect, IETRect>(iETRect, RectConversions.newETRect(tSConstRect));
        }
        return null;
    }

    @Override
    public ETList<IPresentationElement> getPorts() {
        IPresentationElement iPresentationElement = this.getPresentationElement();
        if (iPresentationElement != null) {
            return PresentationReferenceHelper.getAllReferredElements(iPresentationElement);
        }
        return null;
    }

    @Override
    public ETList<IElement> getPorts2() {
        ETArrayList eTArrayList = null;
        IPresentationElement iPresentationElement = this.getPresentationElement();
        if (iPresentationElement != null) {
            ETList<IElement> eTList = PresentationReferenceHelper.getAllReferredSubjects(iPresentationElement);
            eTArrayList = new ETArrayList();
            if (eTArrayList != null) {
                int n = eTList != null ? eTList.getCount() : 0;
                for (int i = 0; i < n; ++i) {
                    IElement iElement = eTList.item(i);
                    if (!(iElement instanceof IPort)) continue;
                    IPort iPort = (IPort)iElement;
                    eTArrayList.add(iPort);
                }
            }
        }
        return eTArrayList;
    }

    @Override
    public void selectAllPorts(boolean bl) {
        this.selectAllPorts(bl, false, false);
    }

    public void selectAllPorts(boolean bl, boolean bl2, boolean bl3) {
        ETList<IPresentationElement> eTList = this.getPorts();
        if (eTList != null && eTList.getCount() > 0) {
            for (IPresentationElement iPresentationElement : eTList) {
                ETList<IETGraphObject> eTList2;
                TSENode tSENode = TypeConversions.getOwnerNode(iPresentationElement);
                if (tSENode == null) continue;
                tSENode.setSelected(bl);
                if (!bl3 || (eTList2 = this.getLollypopInterfacesControlledByPort(tSENode)) == null || eTList2.getCount() <= 0) continue;
                for (IETGraphObject iETGraphObject : eTList2) {
                    TSENode tSENode2;
                    if (iETGraphObject == null || (tSENode2 = TypeConversions.getOwnerNode(iETGraphObject)) == null) continue;
                    iETGraphObject.getEngine().invalidate();
                    tSENode2.setSelected(bl);
                    if (!bl2) continue;
                    IETGraphObject iETGraphObject2 = TypeConversions.getETGraphObject((TSNode)tSENode2);
                    iETGraphObject2.onGraphEvent(2);
                }
            }
        }
    }

    @Override
    public void hideAllPorts(boolean bl) {
        if (bl) {
            ETList<IPresentationElement> eTList = this.getPorts();
            if (eTList == null) {
                return;
            }
            this.m_HiddenNodes = this.createHiddenList(eTList);
            this.m_HiddenNodes.hide();
        } else if (this.m_HiddenNodes != null) {
            this.m_HiddenNodes.unHide();
            this.m_HiddenNodes = null;
        }
    }

    @Override
    public void repositionAllPorts() {
        ETList<IPresentationElement> eTList = this.getPorts();
        if (eTList == null) {
            return;
        }
        TSENode tSENode = this.getOwnerNode();
        TSConstRect tSConstRect = tSENode.getBounds();
        for (IPresentationElement iPresentationElement : eTList) {
            TSPoint tSPoint;
            TSENode tSENode2 = TypeConversions.getOwnerNode(iPresentationElement);
            if (tSENode2 == null || (tSPoint = new TSPoint(tSENode2.getCenter())) == null || !RectConversions.moveToNearestPoint(tSConstRect, tSPoint)) continue;
            tSENode2.assignCenter(tSPoint.getX(), tSPoint.getY());
            if (!(tSENode2 instanceof IETNode)) continue;
            IETNode iETNode = (IETNode)tSENode2;
            iETNode.getEngine().invalidate();
            iETNode.invalidateEdges();
        }
    }

    @Override
    public void rememberAllPortPositions() {
        this.m_PortLocations.clear();
        ETList<IPresentationElement> eTList = this.getPorts();
        TSENode tSENode = this.getOwnerNode();
        if (eTList != null && eTList.getCount() > 0 && tSENode != null) {
            TSConstRect tSConstRect = tSENode.getBounds();
            for (IPresentationElement iPresentationElement : eTList) {
                TSENode tSENode2 = TypeConversions.getOwnerNode(iPresentationElement);
                if (tSENode2 == null) continue;
                PortLocations portLocations = new PortLocations();
                TSConstPoint tSConstPoint = tSENode.getCenter();
                TSConstPoint tSConstPoint2 = tSENode2.getCenter();
                if (tSConstPoint == null || tSConstPoint2 == null) continue;
                portLocations.m_delta.setX(tSConstPoint2.getX() - tSConstPoint.getX());
                portLocations.m_delta.setY(tSConstPoint2.getY() - tSConstPoint.getY());
                portLocations.m_node = tSENode2;
                portLocations.m_closestSide = RectConversions.getClosestSide(tSConstRect, tSConstPoint2);
                this.m_PortLocations.add(portLocations);
            }
        }
    }

    @Override
    public void restoreAllPortPositions() {
        TSENode tSENode = this.getOwnerNode();
        TSConstRect tSConstRect = tSENode.getBounds();
        TSPoint tSPoint = new TSPoint(tSConstRect.getCenter());
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
        if (tSENode != null && iDrawingAreaControl != null && tSPoint != null && tSConstRect != null) {
            for (PortLocations portLocations : this.m_PortLocations) {
                TSPoint tSPoint2 = new TSPoint();
                tSPoint2.setX(tSPoint.getX() + portLocations.m_delta.getX());
                tSPoint2.setY(tSPoint.getY() + portLocations.m_delta.getY());
                if (portLocations.m_closestSide == 0) {
                    tSPoint2.setX(tSConstRect.getRight());
                } else if (portLocations.m_closestSide == 1) {
                    tSPoint2.setY(tSConstRect.getTop());
                } else if (portLocations.m_closestSide == 2) {
                    tSPoint2.setX(tSConstRect.getLeft());
                } else if (portLocations.m_closestSide == 3) {
                    tSPoint2.setY(tSConstRect.getBottom());
                }
                if (!RectConversions.moveToNearestPoint(tSConstRect, tSPoint2)) continue;
                INodePresentation iNodePresentation = TypeConversions.getNodePresentation((TSObject)portLocations.m_node);
                if (iNodePresentation != null) {
                    iNodePresentation.invalidate();
                }
                portLocations.m_node.assignCenter(tSPoint2.getX(), tSPoint2.getY());
            }
        }
        this.m_PortLocations.clear();
        this.repositionAllPorts();
    }

    public ETList<IETGraphObject> getLollypopInterfacesControlledByPort(TSENode tSENode) {
        PresentationHelper.LollypopsAndEdges lollypopsAndEdges;
        if (tSENode == null) {
            return null;
        }
        IETGraphObject iETGraphObject = TypeConversions.getETGraphObject((TSNode)tSENode);
        if (iETGraphObject != null && (lollypopsAndEdges = PresentationHelper.getLollypopsWithOneControllingEdge(iETGraphObject)) != null) {
            return lollypopsAndEdges.getLollypops();
        }
        return null;
    }

    @Override
    public void distributeInterfacesOnAllPorts(boolean bl) {
        int n;
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
        ETList<IPresentationElement> eTList = this.getPorts();
        ETArrayList<IPresentationElement> eTArrayList = new ETArrayList<IPresentationElement>();
        ETArrayList<IPresentationElement> eTArrayList2 = new ETArrayList<IPresentationElement>();
        ETArrayList<IPresentationElement> eTArrayList3 = new ETArrayList<IPresentationElement>();
        ETArrayList<IPresentationElement> eTArrayList4 = new ETArrayList<IPresentationElement>();
        for (IPresentationElement iPresentationElement : eTList) {
            if (iPresentationElement == null) continue;
            IDrawEngine iDrawEngine = TypeConversions.getDrawEngine(iPresentationElement);
            if (iDrawEngine != null) {
                this.distributeAttachedInterfaces(iDrawEngine, bl);
                IETRect iETRect = iDrawEngine.getBoundingRect();
                n = this.getPortSide(iPresentationElement);
                if (n == 0) {
                    eTArrayList.add(iPresentationElement);
                } else if (n == 1) {
                    eTArrayList2.add(iPresentationElement);
                } else if (n == 2) {
                    eTArrayList3.add(iPresentationElement);
                } else if (n == 3) {
                    eTArrayList4.add(iPresentationElement);
                }
            }
            iDrawingAreaControl.executeStackingCommand(iPresentationElement, 1, bl);
        }
        boolean bl2 = PresentationHelper.haveIntersections(eTArrayList);
        boolean bl3 = PresentationHelper.haveIntersections(eTArrayList2);
        boolean bl4 = PresentationHelper.haveIntersections(eTArrayList3);
        n = PresentationHelper.haveIntersections(eTArrayList4);
        if (bl2) {
            this.movePortsToAvoidIntersections(0, eTArrayList);
        }
        if (bl3) {
            this.movePortsToAvoidIntersections(1, eTArrayList2);
        }
        if (bl4) {
            this.movePortsToAvoidIntersections(2, eTArrayList3);
        }
        if (n != 0) {
            this.movePortsToAvoidIntersections(3, eTArrayList4);
        }
        this.getDrawingArea().getGraphWindow().updateInvalidRegion();
        iDrawingAreaControl.refresh(false);
    }

    @Override
    public void movePortsToAvoidIntersections(int n, ETList<IPresentationElement> eTList) {
        IETRect iETRect = this.getLogicalBoundingRect();
        if (iETRect != null) {
            long l = 0L;
            for (int i = 0; i < eTList.getCount(); ++i) {
                IETRect iETRect2;
                IPresentationElement iPresentationElement = eTList.item(i);
                if (!(iPresentationElement instanceof INodePresentation)) continue;
                INodePresentation iNodePresentation = (INodePresentation)iPresentationElement;
                IDrawEngine iDrawEngine = TypeConversions.getDrawEngine(iPresentationElement);
                if (iDrawEngine == null || (iETRect2 = iDrawEngine.getLogicalBoundingRect(false)) == null) continue;
                double d = iETRect2.getWidth();
                double d2 = Math.abs(iETRect2.getHeight());
                double d3 = 0.0;
                double d4 = 0.0;
                switch (n) {
                    case 0: 
                    case 2: {
                        d = 10.0;
                        d3 = n == 0 ? (double)iETRect.getRight() : (double)iETRect.getLeft();
                        if (i == 0) {
                            l = Math.max(iETRect.getBottom(), iETRect.getTop());
                        }
                        d4 = (double)(l - 10L) - d2 / 2.0;
                        l = (long)(d4 - d2 / 2.0);
                        if (!(d4 < (double)Math.min(iETRect.getBottom(), iETRect.getTop()))) break;
                        d4 = (double)Math.min(iETRect.getBottom(), iETRect.getTop()) + d2 / 2.0;
                        break;
                    }
                    case 1: 
                    case 3: {
                        d2 = 10.0;
                        d4 = n == 1 ? (double)Math.max(iETRect.getBottom(), iETRect.getTop()) : (double)Math.min(iETRect.getBottom(), iETRect.getTop());
                        if (i == 0) {
                            l = iETRect.getLeft();
                        }
                        d3 = (double)(l + 10L) + d / 2.0;
                        l = (long)(d3 + d / 2.0);
                        if (!(d3 > (double)iETRect.getRight())) break;
                        d3 = (double)iETRect.getRight() - d / 2.0;
                    }
                }
                TSPoint tSPoint = new TSPoint();
                tSPoint.setX(d3);
                tSPoint.setY(d4);
                iNodePresentation.moveTo((int)d3, (int)d4, 11);
                iNodePresentation.resize((int)d, (int)d2, false);
                IDrawEngine iDrawEngine2 = TypeConversions.getDrawEngine(iNodePresentation);
                if (iDrawEngine2 == null) continue;
                this.distributeAttachedInterfaces(iDrawEngine2, true);
            }
        }
    }

    @Override
    public void movePortsToSide(int n) {
        ETList<IPresentationElement> eTList = this.getPorts();
        this.movePortsToSide(n, eTList);
    }

    @Override
    public void movePortsToSide(int n, ETList<IPresentationElement> eTList) {
        if (eTList != null) {
            this.movePortsToAvoidIntersections(n, eTList);
            this.getDrawingArea().getGraphWindow().updateInvalidRegion();
            this.getDrawingArea().refresh(true);
        }
    }

    @Override
    public boolean getAllowAutoRouteEdges() {
        return this.m_autoRouteEdges;
    }

    @Override
    public void setAllowAutoRouteEdges(boolean bl) {
        this.m_autoRouteEdges = bl;
    }

    protected IPort getPortAtIndex(int n) {
        ETList<IPort> eTList;
        IPort iPort = null;
        IComponent iComponent = this.getComponent();
        if (iComponent != null && (eTList = iComponent.getExternalInterfaces()) != null && eTList.size() > n) {
            iPort = (IPort)eTList.get(n);
        }
        return iPort;
    }

    protected boolean isDisplayed(int n) {
        boolean bl = false;
        IPort iPort = this.getPortAtIndex(n);
        if (iPort != null) {
            bl = this.isDisplayed(iPort);
        }
        return bl;
    }

    protected boolean isDisplayed(IPort iPort) {
        boolean bl = false;
        IComponent iComponent = this.getComponent();
        if (iComponent != null) {
            ETList<IPort> eTList = iComponent.getExternalInterfaces();
            ETList<IElement> eTList2 = this.getPorts2();
            if (eTList != null && eTList2 != null && iPort != null) {
                bl = eTList2.isInList(iPort);
            }
        }
        return bl;
    }

    protected IComponent getComponent() {
        IComponent iComponent = null;
        IElement iElement = TypeConversions.getElement(this);
        if (iElement != null && iElement instanceof IComponent) {
            iComponent = (IComponent)iElement;
        }
        return iComponent;
    }

    protected int getPortSide(IPresentationElement iPresentationElement) {
        TSENode tSENode;
        int n = 3;
        if (iPresentationElement != null && (tSENode = this.getOwnerNode()) != null) {
            TSConstPoint tSConstPoint;
            TSConstRect tSConstRect = tSENode.getBounds();
            TSENode tSENode2 = TypeConversions.getOwnerNode(iPresentationElement);
            if (tSENode2 != null && (tSConstPoint = tSENode2.getCenter()) != null) {
                n = RectConversions.getClosestSide(tSConstRect, tSConstPoint);
            }
        }
        return n;
    }

    protected void distributeAttachedInterfaces(IDrawEngine iDrawEngine, boolean bl) {
        IEventManager iEventManager = iDrawEngine.getEventManager();
        IADInterfaceEventManager iADInterfaceEventManager = null;
        if (iEventManager instanceof IADInterfaceEventManager) {
            iADInterfaceEventManager = (IADInterfaceEventManager)iEventManager;
        }
        if (iADInterfaceEventManager != null) {
            iADInterfaceEventManager.distributeAttachedInterfaces(bl);
        }
    }

    protected void addPortMenuItems(IMenuManager iMenuManager) {
        IMenuManager iMenuManager2;
        int n;
        IComponent iComponent;
        ETList<IPort> eTList;
        IElement iElement = TypeConversions.getElement(this);
        if (iElement != null && iElement instanceof IComponent && (eTList = (iComponent = (IComponent)iElement).getExternalInterfaces()) != null && (n = eTList.size()) > 0 && (iMenuManager2 = iMenuManager.createOrGetSubMenu(this.loadString("IDS_PORTS_TITLE"), "")) != null) {
            for (int i = 0; i < n; ++i) {
                IPort iPort = (IPort)eTList.get(i);
                String string = iPort.getName();
                if (string == null || string.length() == 0) {
                    string = PreferenceAccessor.instance().getDefaultElementName();
                }
                iMenuManager2.add(this.createMenuAction(string, "MBK_COMPONENT_PORT_NAME" + i));
            }
        }
    }

    protected class PortsPerSide {
        public int m_nLeft = 0;
        public int m_nRight = 0;
        public int m_nTop = 0;
        public int m_nBottom = 0;
        public int m_nNotAssigned = 0;

        public PortsPerSide() {
            ETList<IPresentationElement> eTList = ETComponentDrawEngine.this.getPorts();
            int n = eTList != null ? eTList.getCount() : 0;
            block7: for (int i = 0; i < n; ++i) {
                IPresentationElement iPresentationElement = eTList.item(i);
                if (iPresentationElement == null) continue;
                int n2 = ETComponentDrawEngine.this.getPortSide(iPresentationElement);
                switch (n2) {
                    case 0: {
                        ++this.m_nRight;
                        continue block7;
                    }
                    case 1: {
                        ++this.m_nTop;
                        continue block7;
                    }
                    case 2: {
                        ++this.m_nLeft;
                        continue block7;
                    }
                    case 3: {
                        ++this.m_nBottom;
                        continue block7;
                    }
                    case 4: {
                        ++this.m_nNotAssigned;
                    }
                }
            }
        }
    }

    class PortLocations {
        public TSPoint m_delta = new TSPoint();
        public TSENode m_node = null;
        public int m_closestSide;
    }
}

