/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.drawengines;

import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.util.Iterator;
import org.netbeans.modules.uml.common.ETException;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETSize;
import org.netbeans.modules.uml.ui.products.ad.compartments.ETClassNameCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.ETClassNameListCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.INameListCompartment;
import org.netbeans.modules.uml.ui.products.ad.drawengines.ETNodeDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.ETGenericNodeUI;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.GDISupport;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ICompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETNodeUI;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IListCompartment;

public class ETArtifactDrawEngine
extends ETNodeDrawEngine {
    protected final int NODE_HEIGHT = 45;
    protected final int NODE_WIDTH = 105;
    protected final String STATIC_TEXT_FONT = "Arial-12";

    public void initResources() {
        this.setFillColor("artifactfill", 163, 184, 204);
        this.setLightGradientFillColor("artifactlightgradient", 204, 216, 227);
        this.setBorderColor("artifactborder", Color.BLACK);
        super.initResources();
    }

    public String getElementType() {
        String string = super.getElementType();
        if (string == null) {
            string = new String("Artifact");
        }
        return string;
    }

    public void createCompartments() throws ETException {
        ETClassNameListCompartment eTClassNameListCompartment = new ETClassNameListCompartment(this);
        eTClassNameListCompartment.addCompartment(new ETClassNameCompartment(this), -1, false);
        eTClassNameListCompartment.setName("<<artifact>>");
        this.addCompartment(eTClassNameListCompartment);
    }

    public void initCompartments(IPresentationElement iPresentationElement) {
        ETGenericNodeUI eTGenericNodeUI = (ETGenericNodeUI)this.getParent();
        if (eTGenericNodeUI.getOwnerNode() != null) {
            if (eTGenericNodeUI.getModelElement() != null) {
                IElement iElement = eTGenericNodeUI.getModelElement();
                this.createAndAddCompartment("ADClassNameListCompartment");
                INameListCompartment iNameListCompartment = (INameListCompartment)this.getCompartmentByKind(INameListCompartment.class);
                if (iNameListCompartment != null) {
                    iNameListCompartment.attach(iElement);
                    this.setDefaultCompartment(iNameListCompartment);
                    String string = this.getElementType();
                    if (string.equals("Artifact")) {
                        iNameListCompartment.setName("<<artifact>>");
                    } else if (string.equals("SourceFileArtifact")) {
                        iNameListCompartment.setName("<<sourcefileartifact>>");
                    }
                }
            } else {
                try {
                    this.createCompartments();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void doDraw(IDrawInfo iDrawInfo) {
        TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
        IETNodeUI iETNodeUI = (IETNodeUI)this.getParent();
        Color color = this.getBorderBoundsColor();
        Color color2 = this.getBkColor();
        if (iETNodeUI.getOwner() != null) {
            IListCompartment iListCompartment;
            IETRect iETRect = iDrawInfo.getDeviceBounds();
            int n = iETRect.getLeft();
            int n2 = iETRect.getIntWidth();
            int n3 = iETRect.getTop();
            int n4 = iETRect.getIntHeight();
            float f = (float)iETRect.getCenterX();
            GradientPaint gradientPaint = new GradientPaint(f, iETRect.getBottom(), this.getBkColor(), f, iETRect.getTop(), this.getLightGradientFillColor());
            GDISupport.drawRectangle((Graphics2D)tSEGraphics, iETRect.getRectangle(), color, gradientPaint);
            TSEFont tSEFont = iETNodeUI.getFont();
            TSEFont tSEFont2 = new TSEFont("Arial-12");
            iETNodeUI.setFont(tSEFont2);
            Font font = tSEFont2.getScaledFont(iDrawInfo.getFontScaleFactor());
            tSEGraphics.setFont(font);
            tSEGraphics.setColor(color);
            String string = this.getElementType();
            String string2 = "<<artifact>>";
            if (string.equals("SourceFileArtifact")) {
                string2 = "<<sourcefileartifact>>";
            }
            int n5 = tSEGraphics.getFontMetrics().stringWidth(string2);
            int n6 = tSEGraphics.getFontMetrics().getHeight();
            tSEGraphics.drawString(string2, iETRect.getLeft() + iETRect.getIntWidth() / 2 - tSEGraphics.getFontMetrics().stringWidth(string2) / 2, n3 + tSEGraphics.getFontMetrics().getHeight());
            tSEGraphics.setFont(tSEFont);
            Iterator iterator = this.getCompartments().iterator();
            ETRect eTRect = new ETRect(n, n3 + n6, n2, n4 - n6);
            if (iterator.hasNext() && (iListCompartment = (IListCompartment)iterator.next()) instanceof ETClassNameListCompartment) {
                iListCompartment.draw(iDrawInfo, eTRect);
            }
        }
    }

    public IETSize calculateOptimumSize(IDrawInfo iDrawInfo, boolean bl) {
        TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        ETGenericNodeUI eTGenericNodeUI = (ETGenericNodeUI)this.getParent();
        TSEFont tSEFont = eTGenericNodeUI.getFont();
        TSEFont tSEFont2 = new TSEFont("Arial-12");
        eTGenericNodeUI.setFont(tSEFont2);
        Font font = tSEFont2.getFont();
        tSEGraphics.setFont(font);
        String string = this.getElementType();
        String string2 = "<<artifact>>";
        if (string.equals("sourcefileartifact")) {
            string2 = "<<sourcefileartifact>>";
        }
        int n = tSEGraphics.getFontMetrics().stringWidth(string2);
        int n2 = tSEGraphics.getFontMetrics().getHeight();
        tSEGraphics.setFont(tSEFont);
        IETSize iETSize = null;
        for (ICompartment iCompartment : this.getCompartments()) {
            if (!(iCompartment instanceof ETClassNameListCompartment)) continue;
            iETSize = iCompartment.calculateOptimumSize(iDrawInfo, true);
            break;
        }
        if (iETSize != null) {
            iETSize.setSize(Math.max(iETSize.getWidth(), n), iETSize.getHeight() + 2 * n2);
            iETSize.setSize(Math.max(iETSize.getWidth(), 105), Math.max(iETSize.getHeight(), 45));
        }
        return bl || iETSize == null ? iETSize : this.scaleSize(iETSize, tSTransform);
    }

    public String getDrawEngineID() {
        return "ArtifactDrawEngine";
    }
}

