/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.drawEngineManagers;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSNode;
import org.netbeans.modules.uml.common.generics.IteratorT;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.InvalidArguments;
import org.netbeans.modules.uml.ui.products.ad.drawEngineManagers.ADEventManager;
import org.netbeans.modules.uml.ui.products.ad.drawEngineManagers.IADClassifierEventManager;
import org.netbeans.modules.uml.ui.support.applicationmanager.IEdgePresentation;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETGraphObject;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.PresentationHelper;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADClassifierEventManager
extends ADEventManager
implements IADClassifierEventManager {
    private TSConstSize m_OriginalSize = null;
    private TSPoint m_OriginalCenterDelta = new TSPoint();
    protected ETList<InterfaceLocation> m_InterfaceLocations = new ETArrayList<InterfaceLocation>();

    @Override
    public void onGraphEvent(int n) {
        switch (n) {
            case 7: {
                this.onPreLayout();
                break;
            }
            case 8: {
                this.onPostLayout();
            }
        }
    }

    protected void onPreLayout() {
        if (this.getOwnerNode() != null) {
            ETList<TSConstRect> eTList = this.hideLollypops();
            this.swallowBounds(eTList);
        }
    }

    private void swallowBounds(ETList<TSConstRect> eTList) {
        try {
            TSENode tSENode = this.getOwnerNode();
            this.m_OriginalSize = tSENode.getSize();
            TSConstRect tSConstRect = new TSConstRect(tSENode.getBounds());
            IteratorT iteratorT = new IteratorT(eTList);
            while (iteratorT.hasNext()) {
                TSConstRect tSConstRect2 = (TSConstRect)iteratorT.next();
                tSConstRect = tSConstRect.union(tSConstRect2);
            }
            this.m_OriginalCenterDelta.setX(tSConstRect.getCenterX() - tSENode.getCenterX());
            this.m_OriginalCenterDelta.setY(tSConstRect.getCenterY() - tSENode.getCenterY());
            tSENode.setLocalBounds(tSConstRect);
            tSENode.setOriginalSize(tSConstRect.getSize());
        }
        catch (InvalidArguments invalidArguments) {
            invalidArguments.printStackTrace();
        }
    }

    protected void onPostLayout() {
        TSENode tSENode = this.getOwnerNode();
        if (tSENode != null) {
            tSENode.setSize(this.m_OriginalSize);
            tSENode.moveBy(0.0 - this.m_OriginalCenterDelta.getX(), 0.0 - this.m_OriginalCenterDelta.getY());
            this.showLollypops();
        }
    }

    private void showLollypops() {
        try {
            TSENode tSENode = this.getOwnerNode();
            if (tSENode == null) {
                return;
            }
            TSConstPoint tSConstPoint = tSENode.getCenter();
            TSGraph tSGraph = tSENode.getOwnerGraph();
            IteratorT iteratorT = new IteratorT(this.m_InterfaceLocations);
            while (iteratorT.hasNext()) {
                InterfaceLocation interfaceLocation = (InterfaceLocation)iteratorT.next();
                TSENode tSENode2 = interfaceLocation.getLollypop();
                TSConstPoint tSConstPoint2 = interfaceLocation.getDelta();
                tSGraph.insert((TSNode)tSENode2);
                tSENode2.setLocalCenter(tSConstPoint.getX() + tSConstPoint2.getX(), tSConstPoint.getY() + tSConstPoint2.getY());
            }
        }
        catch (InvalidArguments invalidArguments) {
            invalidArguments.printStackTrace();
        }
    }

    private ETList<TSConstRect> hideLollypops() {
        ETArrayList<TSConstRect> eTArrayList = new ETArrayList<TSConstRect>();
        this.m_InterfaceLocations.clear();
        try {
            TSENode tSENode = this.getOwnerNode();
            if (this.m_parentETGraphObject == null || tSENode == null) {
                return eTArrayList;
            }
            PresentationHelper.LollypopsAndEdges lollypopsAndEdges = PresentationHelper.getLollypopsWithOneControllingEdge(this.m_parentETGraphObject);
            int n = lollypopsAndEdges.getLollypops().size();
            if (n == 0) {
                return eTArrayList;
            }
            TSGraph tSGraph = tSENode.getOwnerGraph();
            if (tSGraph != null) {
                IteratorT iteratorT = new IteratorT(lollypopsAndEdges.getLollypops());
                IteratorT iteratorT2 = new IteratorT(lollypopsAndEdges.getEdges());
                while (iteratorT.hasNext()) {
                    Object object;
                    IEdgePresentation iEdgePresentation;
                    IETGraphObject iETGraphObject = (IETGraphObject)iteratorT.next();
                    IETGraphObject iETGraphObject2 = (IETGraphObject)iteratorT2.next();
                    if (iETGraphObject2 != null && (iEdgePresentation = TypeConversions.getEdgePresentation(iETGraphObject2)) != null) {
                        iEdgePresentation.discardAllBends();
                    }
                    if (iETGraphObject == null) continue;
                    iEdgePresentation = TypeConversions.getOwnerNode(iETGraphObject);
                    if (iEdgePresentation != null) {
                        object = iEdgePresentation.getBounds();
                        eTArrayList.add(object);
                    }
                    object = new InterfaceLocation((TSENode)iEdgePresentation, tSENode);
                    this.m_InterfaceLocations.add(object);
                    tSGraph.remove((TSNode)iEdgePresentation);
                }
            }
        }
        catch (InvalidArguments invalidArguments) {
            invalidArguments.printStackTrace();
        }
        return eTArrayList;
    }

    protected class InterfaceLocation {
        private TSENode m_node;
        private TSPoint m_delta;

        public InterfaceLocation(TSENode tSENode, TSENode tSENode2) {
            this.m_node = tSENode;
            TSConstPoint tSConstPoint = tSENode.getCenter();
            TSConstPoint tSConstPoint2 = tSENode2.getCenter();
            this.m_delta = new TSPoint(tSConstPoint.getX() - tSConstPoint2.getX(), tSConstPoint.getY() - tSConstPoint2.getY());
        }

        public TSConstPoint getDelta() {
            return this.m_delta;
        }

        public TSENode getLollypop() {
            return this.m_node;
        }
    }
}

