/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces;

import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.core.support.umlsupport.ETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.ETLifelineCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.ActivationBar;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.Lifeline;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.LifelineCompartmentPiece;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.RecursiveHelper;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.SuspensionArea;
import org.netbeans.modules.uml.ui.products.ad.drawengines.INodeDrawEngine;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveElement;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParentPiece
extends LifelineCompartmentPiece {
    public static final String SUSPENSION_AREA_ID = "SuspensionArea";
    public static final String LIFELINE_ID = "Lifeline";
    public static final String DESTORY_ELEMENT_ID = "DestroyElement";
    public static final String ACTIVATION_BAR_ID = "ActivationBar";
    protected ETList<ParentPiece> m_ListPieces = new ETArrayList<ParentPiece>();

    public ParentPiece(ETLifelineCompartment eTLifelineCompartment, LifelineCompartmentPiece lifelineCompartmentPiece, IETPoint iETPoint, int n) {
        super(eTLifelineCompartment, lifelineCompartmentPiece, iETPoint, n);
    }

    public abstract ParentPiece createNewPiece(int var1, int var2, int var3);

    public ParentPiece getPieceAbove(int n) {
        ParentPiece parentPiece = null;
        for (int i = this.m_ListPieces.size() - 1; i >= 0; --i) {
            int n2;
            ParentPiece parentPiece2 = (ParentPiece)this.m_ListPieces.get(i);
            if (parentPiece2 == null || n <= (n2 = parentPiece2.getBottom())) continue;
            parentPiece = parentPiece2;
            break;
        }
        return parentPiece;
    }

    public ParentPiece getPieceBelow(int n) {
        ParentPiece parentPiece = null;
        for (int i = this.m_ListPieces.size() - 1; i >= 0; --i) {
            int n2;
            ParentPiece parentPiece2 = (ParentPiece)this.m_ListPieces.get(i);
            if (parentPiece2 == null || n >= (n2 = parentPiece2.getTop())) continue;
            parentPiece = parentPiece2;
            break;
        }
        return parentPiece;
    }

    public ParentPiece getPieceAt(int n) {
        ParentPiece parentPiece = null;
        for (int i = this.m_ListPieces.size() - 1; i >= 0; --i) {
            ParentPiece parentPiece2 = (ParentPiece)this.m_ListPieces.get(i);
            if (parentPiece2 == null) continue;
            int n2 = parentPiece2.getLogicalBottom();
            int n3 = parentPiece2.getLogicalTop();
            if (n > n3 || n < n2) continue;
            parentPiece = parentPiece2;
            ParentPiece parentPiece3 = parentPiece2;
            if ((parentPiece2 = parentPiece3.getPieceAt(n)) == null) break;
            parentPiece = parentPiece2;
            break;
        }
        return parentPiece;
    }

    public ETList<ParentPiece> getPieces() {
        return this.m_ListPieces;
    }

    public void setPieces(ETList<ParentPiece> eTList) {
        this.m_ListPieces = eTList;
    }

    @Override
    public void setHeight(int n) {
        LifelineCompartmentPiece lifelineCompartmentPiece;
        int n2 = n - this.getHeight();
        super.setHeight(n);
        if (n2 > 0 && (lifelineCompartmentPiece = this.getParentPiece()) instanceof ParentPiece) {
            ParentPiece parentPiece = (ParentPiece)lifelineCompartmentPiece;
            parentPiece.bumpSiblingsBelow(this, true);
        }
    }

    public int getNumChildren() {
        return this.m_ListPieces.size();
    }

    public void stretch(int n, int n2) {
        if (n2 != 0) {
            LifelineCompartmentPiece lifelineCompartmentPiece = this.getParentPiece();
            if (lifelineCompartmentPiece instanceof ParentPiece) {
                ((ParentPiece)lifelineCompartmentPiece).stretch(n, n2);
            }
            if (n2 > 0) {
                this.moveSiblingsBelow(n, n2);
                int n3 = this.getHeight() + n2;
                this.setHeight(n3);
            } else {
                int n4 = this.getHeight() + n2;
                this.setHeight(n4);
                this.moveSiblingsBelow(n, n2);
            }
        }
    }

    public ParentPiece findPieceAt(int n) {
        ParentPiece parentPiece = this;
        for (ParentPiece parentPiece2 : this.m_ListPieces) {
            if (parentPiece2 == null) continue;
            ETSystem.out.println("top(" + n + ") >= curPiece.getTop()(" + parentPiece2.getTop() + ") = " + (n >= parentPiece2.getTop()));
            ETSystem.out.println("top(" + n + ") <= curPiece.getBottom()(" + parentPiece2.getBottom() + ") = " + (n <= parentPiece2.getBottom()));
            if (n < parentPiece2.getTop() || n > parentPiece2.getBottom()) continue;
            parentPiece = parentPiece2.findPieceAt(n);
            break;
        }
        return parentPiece;
    }

    public ParentPiece findNearestChildPiece(int n) {
        ParentPiece parentPiece = null;
        if (this.m_ListPieces.size() > 0) {
            int n2 = 0;
            for (ParentPiece parentPiece2 : this.m_ListPieces) {
                if (parentPiece2 == null) continue;
                int n3 = parentPiece2.getBottom();
                if (n <= n3) {
                    if (parentPiece != null) {
                        parentPiece = parentPiece2;
                        break;
                    }
                    int n4 = n - n2;
                    int n5 = parentPiece2.getTop() - n;
                    if (n5 >= n4) break;
                    parentPiece = parentPiece2;
                    break;
                }
                parentPiece = parentPiece2;
                n2 = n3;
            }
        }
        return parentPiece;
    }

    public void cleanUpChildrenActivationBars() {
        for (ParentPiece parentPiece : this.m_ListPieces) {
            if (parentPiece == null) continue;
            parentPiece.cleanUpActivationBars();
            parentPiece.cleanUpChildrenActivationBars();
        }
    }

    public void cleanUpActivationBars() {
        if (this.m_ListPieces.size() > 1) {
            ParentPiece parentPiece = null;
            ParentPiece parentPiece2 = (ParentPiece)this.m_ListPieces.get(0);
            int n = 1;
            int n2 = 0;
            while (n < this.m_ListPieces.size()) {
                parentPiece = parentPiece2;
                if (this.mergeActivationBars(parentPiece, parentPiece2 = (ParentPiece)this.m_ListPieces.get(n))) {
                    n = n2;
                    parentPiece2 = (ParentPiece)this.m_ListPieces.get(n);
                }
                n2 = n++;
            }
            this.removeVoids();
        }
    }

    public boolean mergeActivationBars(ParentPiece parentPiece, ParentPiece parentPiece2) {
        boolean bl = false;
        if (parentPiece != null && parentPiece2 != null && parentPiece instanceof ActivationBar && parentPiece2 instanceof ActivationBar) {
            ActivationBar activationBar = (ActivationBar)parentPiece;
            ActivationBar activationBar2 = (ActivationBar)parentPiece2;
            if (!activationBar.containsMessageOnBottom() && !activationBar2.containsMessageOnTop()) {
                parentPiece.merge(parentPiece2);
                bl = true;
            }
        }
        return bl;
    }

    protected void moveChildrenTo(ParentPiece parentPiece) {
        if (null == parentPiece) {
            throw new IllegalArgumentException();
        }
        for (ParentPiece parentPiece2 : this.m_ListPieces) {
            parentPiece.insertPiece(parentPiece2);
        }
        this.m_ListPieces.clear();
    }

    public void merge(ParentPiece parentPiece) {
        if (parentPiece != null) {
            int n = parentPiece.getLogicalBottom();
            ParentPiece parentPiece2 = (ParentPiece)parentPiece.getParentPiece();
            if (parentPiece2 != null) {
                parentPiece2.voidPiece(parentPiece);
            }
            ETSystem.out.println("Before getHeight() = " + this.getHeight());
            this.setLogicalBottom(n);
            ETSystem.out.println("After getHeight() = " + this.getHeight());
            for (ParentPiece parentPiece3 : parentPiece.getPieces()) {
                if (parentPiece3 == null) continue;
                parentPiece3.setParentPiece(this);
                this.m_ListPieces.add(parentPiece3);
            }
        }
    }

    protected void removePiece(ParentPiece parentPiece) {
        this.m_ListPieces.removeItem(parentPiece);
    }

    public void removeSelfFromStack() {
        LifelineCompartmentPiece lifelineCompartmentPiece = this.getParentPiece();
        if (lifelineCompartmentPiece instanceof ParentPiece) {
            ParentPiece parentPiece = (ParentPiece)lifelineCompartmentPiece;
            parentPiece.removePiece(this);
            for (LifelineCompartmentPiece lifelineCompartmentPiece2 : this.m_ListPieces) {
                if (!(lifelineCompartmentPiece2 instanceof ParentPiece)) continue;
                ((ParentPiece)lifelineCompartmentPiece2).moveChildrenTo(parentPiece);
            }
            this.setParentPiece(null);
        }
    }

    protected void removeVoids() {
        ListIterator listIterator = this.m_ListPieces.listIterator();
        while (listIterator.hasNext()) {
            ParentPiece parentPiece = (ParentPiece)listIterator.next();
            if (parentPiece != null) continue;
            listIterator.remove();
        }
    }

    public void voidPiece(ParentPiece parentPiece) {
        block3: {
            int n = this.m_ListPieces.indexOf(parentPiece);
            if (n > -1) {
                try {
                    this.m_ListPieces.set(n, null);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)"Unable to replace the piece (We should never be here.");
                }
            }
        }
    }

    public void draw(IDrawInfo iDrawInfo, double d) {
        for (ParentPiece parentPiece : this.m_ListPieces) {
            if (parentPiece == null) continue;
            parentPiece.draw(iDrawInfo, d);
        }
    }

    @Override
    public void readFromArchive(IProductArchiveElement iProductArchiveElement) {
        super.readFromArchive(iProductArchiveElement);
        IProductArchiveElement[] iProductArchiveElementArray = iProductArchiveElement.getElements();
        if (iProductArchiveElementArray != null) {
            for (int i = 0; i < iProductArchiveElementArray.length; ++i) {
                String string;
                IProductArchiveElement iProductArchiveElement2 = iProductArchiveElementArray[i];
                if (iProductArchiveElement2 == null || (string = iProductArchiveElement2.getID()).equals("ConnectorList")) continue;
                ParentPiece parentPiece = null;
                if (string.equals(ACTIVATION_BAR_ID)) {
                    parentPiece = new ActivationBar(this.getParent(), this, new ETPoint(0, this.getChildOffset()), 40);
                } else if (!string.equals(DESTORY_ELEMENT_ID)) {
                    if (string.equals(LIFELINE_ID)) {
                        parentPiece = new Lifeline(this.getParent());
                    } else if (string.equals(SUSPENSION_AREA_ID)) {
                        parentPiece = new SuspensionArea(this.getParent(), this, new ETPoint(0, this.getChildOffset()), 40);
                    }
                }
                if (parentPiece == null) continue;
                parentPiece.readFromArchive(iProductArchiveElement2);
                this.m_ListPieces.add(parentPiece);
            }
        }
    }

    public void resizeNode(boolean bl) {
        if (bl) {
            IDrawEngine iDrawEngine = this.getDrawEngine();
            ETLifelineCompartment eTLifelineCompartment = this.getParent();
            if (iDrawEngine instanceof INodeDrawEngine && eTLifelineCompartment != null) {
                INodeDrawEngine iNodeDrawEngine = (INodeDrawEngine)iDrawEngine;
                iNodeDrawEngine.resizeToFitCompartment(eTLifelineCompartment, true, false);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    IDrawEngine iDrawEngine = ParentPiece.this.getDrawEngine();
                    iDrawEngine.sizeToContents();
                }
            });
        }
    }

    public boolean validate() {
        boolean bl = false;
        for (int i = this.m_ListPieces.size() - 1; i >= 0; --i) {
            ParentPiece parentPiece = (ParentPiece)this.m_ListPieces.get(i);
            if (parentPiece == null || parentPiece.validate()) continue;
            this.m_ListPieces.remove(i);
        }
        return !this.m_ListPieces.isEmpty();
    }

    public void updateReflexiveBends() {
        for (ParentPiece parentPiece : this.m_ListPieces) {
            if (parentPiece == null) continue;
            parentPiece.updateReflexiveBends();
        }
    }

    public void resizeTop(int n) {
        int n2 = n - this.getTop();
        if (n2 != 0) {
            super.setY(this.getY() + n2);
            super.setHeight(this.getHeight() - n2);
            for (ParentPiece parentPiece : this.m_ListPieces) {
                if (parentPiece == null) continue;
                parentPiece.setY(parentPiece.getY() - n2);
            }
        }
    }

    @Override
    public IProductArchiveElement writeToArchive(IProductArchiveElement iProductArchiveElement) {
        IProductArchiveElement iProductArchiveElement2 = super.writeToArchive(iProductArchiveElement);
        if (iProductArchiveElement2 != null) {
            for (ParentPiece parentPiece : this.m_ListPieces) {
                if (parentPiece == null) continue;
                parentPiece.writeToArchive(iProductArchiveElement2);
            }
        }
        return iProductArchiveElement2;
    }

    public void insertPiece(ParentPiece parentPiece) {
        this.insertPiece(parentPiece, true);
    }

    public void insertPiece(ParentPiece parentPiece, boolean bl) {
        if (parentPiece != null) {
            int n;
            parentPiece.setParentPiece(this);
            int n2 = parentPiece.getTop();
            boolean bl2 = true;
            int n3 = 0;
            for (n = 0; n < this.m_ListPieces.size(); ++n) {
                ParentPiece parentPiece2 = (ParentPiece)this.m_ListPieces.get(n);
                if (n2 <= parentPiece2.getTop()) {
                    this.m_ListPieces.add(n, parentPiece);
                    bl2 = false;
                    break;
                }
                n3 = parentPiece2.getBottom();
            }
            if (bl2) {
                this.m_ListPieces.add(parentPiece);
            }
            if ((n = n3 + 10) > n2) {
                parentPiece.setY(n - this.getParentTop());
            }
            if (bl) {
                this.bumpSiblingsBelow(parentPiece, false);
            }
            this.resizeNode(false);
        }
    }

    public int promotePiecesTo(ParentPiece parentPiece, int n) {
        int n2 = n;
        assert (parentPiece != null) : "Grand Child is NULL.";
        assert (this != parentPiece) : "I am my own grandchild :-(";
        if (parentPiece != null) {
            int n3 = parentPiece.getTop();
            int n4 = n3 + n;
            int n5 = 0;
            for (ParentPiece parentPiece2 : this.m_ListPieces) {
                if (parentPiece2 == null) continue;
                assert (parentPiece2 instanceof ActivationBar) : "We can only promote activation bars";
                int n6 = parentPiece2.getTop();
                int n7 = parentPiece2.getBottom();
                if (n6 < n3 || n7 > n4 || !this.m_ListPieces.contains(parentPiece2)) continue;
                parentPiece.insertPiece(parentPiece2, false);
                n5 = parentPiece2.getBottom() + 10;
                this.voidPiece(parentPiece2);
            }
            if (n4 < n5) {
                n2 = n5 - n3;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bumpSiblingsAbove(ParentPiece parentPiece) {
        RecursiveHelper recursiveHelper = null;
        try {
            recursiveHelper = new RecursiveHelper("Bump");
            if (RecursiveHelper.isOkToUsePiece("Bump", this) && parentPiece != null) {
                int n;
                assert (this == parentPiece.getParentPiece());
                int n2 = parentPiece.getTop() - 10;
                if (this.m_ListPieces.size() > 1 && (n = this.m_ListPieces.lastIndexOf(parentPiece)) > -1) {
                    ParentPiece parentPiece2 = (ParentPiece)this.m_ListPieces.get(n);
                    ParentPiece parentPiece3 = null;
                    if (n - 1 >= 0) {
                        for (int i = n - 1; i >= 0; --i) {
                            if (parentPiece2 != null) {
                                n2 = parentPiece2.getTop() - 10;
                            }
                            if ((parentPiece3 = (ParentPiece)this.m_ListPieces.get(i)) == null) continue;
                            int n3 = n2 - parentPiece3.getBottomBound();
                            if (n3 < 0) {
                                if (this.mergeActivationBars(parentPiece3, parentPiece2)) {
                                    if (this.m_ListPieces.size() < 2) break;
                                    i = this.m_ListPieces.size() - 1;
                                    parentPiece3 = (ParentPiece)this.m_ListPieces.get(i);
                                } else {
                                    parentPiece3.moveBy(n3);
                                }
                            }
                            parentPiece2 = parentPiece3;
                        }
                    }
                    this.removeVoids();
                }
                if (this.getTop() > n2) {
                    this.setTop(n2);
                }
            }
        }
        finally {
            if (recursiveHelper != null) {
                recursiveHelper.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bumpSiblingsBelow(ParentPiece parentPiece, boolean bl) {
        RecursiveHelper recursiveHelper = null;
        try {
            int n;
            recursiveHelper = new RecursiveHelper("Bump");
            if (!RecursiveHelper.isOkToUsePiece("Bump", this)) {
                return;
            }
            int n2 = 10;
            if (parentPiece != null) {
                assert (this == parentPiece.getParentPiece());
                n2 = parentPiece.getBottomBound() + 10;
            }
            if (this.m_ListPieces.size() > 0 && (n = this.m_ListPieces.indexOf(parentPiece)) > -1) {
                ParentPiece parentPiece2 = (ParentPiece)this.m_ListPieces.get(n);
                ParentPiece parentPiece3 = null;
                if (n + 1 < this.m_ListPieces.size()) {
                    for (int i = n + 1; i < this.m_ListPieces.size(); ++i) {
                        if (parentPiece2 != null) {
                            n2 = parentPiece2.getBottomBound() + 10;
                        }
                        if ((parentPiece3 = (ParentPiece)this.m_ListPieces.get(i)) == null) continue;
                        int n3 = n2 - parentPiece3.getTop();
                        if (n3 > 0) {
                            if (bl && this.mergeActivationBars(parentPiece2, parentPiece3)) {
                                if (this.m_ListPieces.size() < 2) break;
                                parentPiece3 = (ParentPiece)this.m_ListPieces.get(--i);
                            } else {
                                parentPiece3.moveBy(n3);
                            }
                        }
                        parentPiece2 = parentPiece3;
                    }
                }
                if (parentPiece2 != null) {
                    n2 = parentPiece2.getBottom() + 10;
                }
                this.removeVoids();
            }
            if (this.getBottom() < n2) {
                this.grow(n2);
            }
        }
        finally {
            if (recursiveHelper != null) {
                recursiveHelper.done();
            }
        }
    }

    protected void moveSiblingsBelow(int n, int n2) {
        if (this.m_ListPieces.size() > 0) {
            int n3 = Integer.MIN_VALUE;
            LifelineCompartmentPiece lifelineCompartmentPiece = null;
            Iterator iterator = this.m_ListPieces.iterator();
            while (iterator.hasNext()) {
                ParentPiece parentPiece = (ParentPiece)iterator.next();
                if (parentPiece.getTop() <= n) continue;
                lifelineCompartmentPiece = parentPiece;
                break;
            }
            while (lifelineCompartmentPiece != null) {
                lifelineCompartmentPiece.moveBy(n2);
                n3 = lifelineCompartmentPiece.getBottom() + 10;
                lifelineCompartmentPiece = null;
                if (!iterator.hasNext()) continue;
                lifelineCompartmentPiece = (ParentPiece)iterator.next();
            }
            if (this.getBottom() < n3) {
                this.grow(n3);
            }
        }
    }

    public void grow(int n) {
        super.setBottom(n);
    }

    @Override
    public int getLifelinePiecesKind() {
        return 0;
    }

    @Override
    public void setY(long l) {
        long l2 = this.getY();
        super.setY(l);
        this.bumpSiblingsBelow(null, true);
        ParentPiece parentPiece = (ParentPiece)this.getParentPiece();
        if (parentPiece != null) {
            long l3 = (long)this.getY() - l2;
            if (l3 < 0L) {
                parentPiece.bumpSiblingsAbove(this);
            } else if (l3 > 0L) {
                parentPiece.bumpSiblingsBelow(this, true);
            }
        }
    }

    protected int getBottomBound() {
        return this.getBottom();
    }
}

