/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces;

import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.graphics.TSEGraphics;
import java.awt.Color;
import java.util.ArrayList;
import org.netbeans.modules.uml.core.metamodel.dynamics.IMessage;
import org.netbeans.modules.uml.core.support.umlsupport.ETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.ETLifelineCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.ConnectorPiece;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.LifelineCompartmentPiece;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.ParentPiece;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.RecursiveHelper;
import org.netbeans.modules.uml.ui.products.ad.compartments.sequencediagram.lifelinepieces.SuspensionArea;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveElement;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.PresentationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivationBar
extends ConnectorPiece {
    public static final Color ACTIVATION_BAR_COLOR = new Color(72, 167, 244);
    public static final Color COLOR_MESSAGE_SELF = Color.black;
    public static final int SELF_BEND_CNT = 3;
    private boolean m_IsMessageToSelf = false;
    private boolean m_AllowAllUpdatesOfAssocitedPieces = false;

    public ActivationBar(ETLifelineCompartment eTLifelineCompartment, LifelineCompartmentPiece lifelineCompartmentPiece, IETPoint iETPoint, int n) {
        super(eTLifelineCompartment, lifelineCompartmentPiece, iETPoint, n);
    }

    @Override
    public void moveBy(int n) {
        this.m_AllowAllUpdatesOfAssocitedPieces = true;
        super.moveBy(n);
        this.m_AllowAllUpdatesOfAssocitedPieces = false;
    }

    @Override
    public int getLifelinePiecesKind() {
        return 2;
    }

    @Override
    public ParentPiece createNewPiece(int n, int n2, int n3) {
        ConnectorPiece connectorPiece = null;
        ETPoint eTPoint = new ETPoint(this.getLeft() + this.getChildOffset(), n2);
        switch (n) {
            case 2: 
            case 5: {
                ParentPiece parentPiece = this.getPieceAbove(n2);
                if (parentPiece != null) break;
                if (n == 2) {
                    this.setTop(this.getTop() + n2);
                }
                connectorPiece = this;
                break;
            }
            case 3: {
                connectorPiece = new SuspensionArea(this.getParent(), this, eTPoint, n3);
                break;
            }
            case 4: {
                connectorPiece = new SuspensionArea(this.getParent(), this, eTPoint, 0);
                break;
            }
        }
        if (connectorPiece != null && n != 2 && n != 5) {
            this.insertPiece(connectorPiece);
        }
        return connectorPiece;
    }

    @Override
    public void getPropagatedMessages(ETList<IMessage> eTList) {
        super.getPropagatedMessages(eTList);
        for (ParentPiece parentPiece : this.m_ListPieces) {
            if (!(parentPiece instanceof ConnectorPiece)) continue;
            ConnectorPiece connectorPiece = (ConnectorPiece)parentPiece;
            connectorPiece.getPropagatedMessages(eTList);
        }
    }

    @Override
    public void setHeight(int n) {
        SuspensionArea suspensionArea;
        ConnectorPiece connectorPiece;
        super.setHeight(n);
        this.postUpdateReflexiveBends();
        if (!this.containsMessagesOnBottom() && (connectorPiece = this.getAssociatedPiece()) instanceof SuspensionArea && (suspensionArea = (SuspensionArea)connectorPiece) != null && !suspensionArea.isAtomicFragment()) {
            suspensionArea.setLogicalBottom(this.getLogicalBottom());
        }
    }

    @Override
    public void setY(long l) {
        if (this.isMessageToSelf()) {
            l = 10L;
        }
        super.setY(l);
        this.postUpdateReflexiveBends();
    }

    @Override
    public void setLeft(int n) {
        super.setLeft(n);
        this.postUpdateReflexiveBends();
    }

    @Override
    public void draw(IDrawInfo iDrawInfo, double d) {
        TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
        Color color = tSEGraphics.getColor();
        tSEGraphics.setColor(ACTIVATION_BAR_COLOR);
        IETRect iETRect = this.getAbsoluteDrawRect(d);
        TSConstRect tSConstRect = new TSConstRect((double)iETRect.getLeft(), (double)iETRect.getTop(), (double)iETRect.getRight(), (double)iETRect.getBottom());
        tSEGraphics.fillRect(tSConstRect);
        tSEGraphics.setColor(color);
        super.draw(iDrawInfo, d);
    }

    @Override
    public IProductArchiveElement writeToArchive(IProductArchiveElement iProductArchiveElement) {
        if (null == iProductArchiveElement) {
            throw new IllegalArgumentException();
        }
        IProductArchiveElement iProductArchiveElement2 = super.writeToArchive(iProductArchiveElement);
        if (iProductArchiveElement2 != null) {
            iProductArchiveElement2.addAttributeBool("isMessageToSelf", this.m_IsMessageToSelf);
        }
        return iProductArchiveElement2;
    }

    @Override
    public void readFromArchive(IProductArchiveElement iProductArchiveElement) {
        if (null == iProductArchiveElement) {
            throw new IllegalArgumentException();
        }
        super.readFromArchive(iProductArchiveElement);
        this.m_IsMessageToSelf = iProductArchiveElement.getAttributeBool("isMessageToSelf", false);
    }

    protected void postUpdateReflexiveBends() {
        if (this.isMessageToSelf()) {
            this.getParent().postValidateNode();
        }
    }

    @Override
    public boolean canFinishMessage(int n) {
        ParentPiece parentPiece;
        boolean bl = false;
        if (this.getConnector(0) == null && this.getConnector(1) == null && (parentPiece = this.getPieceAbove(n)) == null) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean canUpdateAssociatedPiece(int n) {
        boolean bl = false;
        if (!this.isMessageToSelf()) {
            if (this.m_AllowAllUpdatesOfAssocitedPieces) {
                bl = true;
            } else if (n == 2 || n == 3) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void updateReflexiveBends() {
        super.updateReflexiveBends();
        if (this.isMessageToSelf()) {
            TSConnector tSConnector = this.getConnector(1);
            TSConnector tSConnector2 = this.getConnector(2);
            TSDEdge tSDEdge = PresentationHelper.getConnectedEdge(tSConnector, true);
            this.updateReflexiveBends(tSDEdge);
            tSDEdge = null;
            tSDEdge = PresentationHelper.getConnectedEdge(tSConnector2, true);
            this.updateReflexiveBends(tSDEdge);
        }
    }

    @Override
    public void cleanUpActivationBars() {
        this.cleanUpChildrenActivationBars();
        this.shrinkToFitChildren();
    }

    @Override
    public boolean validate() {
        boolean bl = super.validate();
        if (bl) {
            if (this.isMessageToSelf()) {
                if (this.getY() != 10) {
                    this.setY(10L);
                }
            } else {
                this.shrinkToFitChildren();
            }
        }
        return bl;
    }

    public void shrinkToFitChildren() {
        if (this.getNumChildren() > 0) {
            ParentPiece parentPiece;
            if (!this.containsMessageOnTop()) {
                parentPiece = this.getTopPiece();
                int n = parentPiece.getTop() - 10;
                this.resizeTop(n);
            }
            if (!this.containsMessageOnBottom() && (parentPiece = this.getBottomPiece()) != null) {
                super.setBottom(parentPiece.getBottom() + 10);
            }
        }
    }

    public boolean isMessageToSelf() {
        return this.m_IsMessageToSelf;
    }

    public void setMessageToSelf(boolean bl) {
        this.m_IsMessageToSelf = bl;
        this.updateReflexiveBends();
    }

    protected ParentPiece getTopPiece() {
        ParentPiece parentPiece = null;
        for (int i = 0; i < this.getPieces().size() && (parentPiece = (ParentPiece)this.getPieces().get(i)) == null; ++i) {
        }
        return parentPiece;
    }

    protected ParentPiece getBottomPiece() {
        ParentPiece parentPiece = null;
        for (int i = this.getPieces().size() - 1; i >= 0 && (parentPiece = (ParentPiece)this.getPieces().get(i)) == null; ++i) {
        }
        return parentPiece;
    }

    @Override
    protected String getID() {
        return "ActivationBar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateReflexiveBends(TSDEdge tSDEdge) {
        assert (this.isMessageToSelf()) : "We must only bend message to self messages.";
        RecursiveHelper recursiveHelper = null;
        try {
            recursiveHelper = new RecursiveHelper("UpdateReflexiveBends");
            if (RecursiveHelper.isOkToUsePiece("UpdateReflexiveBends", this) && tSDEdge != null) {
                ConnectorPiece connectorPiece;
                LifelineCompartmentPiece lifelineCompartmentPiece = this.getParentPiece();
                if (lifelineCompartmentPiece instanceof ConnectorPiece) {
                    connectorPiece = (ConnectorPiece)lifelineCompartmentPiece;
                    connectorPiece.updateConnectorsViaTopCenter();
                }
                connectorPiece = tSDEdge.getSourceConnector();
                TSConnector tSConnector = tSDEdge.getTargetConnector();
                if (connectorPiece != null && tSConnector != null) {
                    double d = Math.max(connectorPiece.getCenterY(), tSConnector.getCenterY());
                    double d2 = Math.min(connectorPiece.getCenterY(), tSConnector.getCenterY());
                    double d3 = Math.max(connectorPiece.getCenterX(), tSConnector.getCenterX());
                    ArrayList<TSConstPoint> arrayList = new ArrayList<TSConstPoint>();
                    double d4 = d3 + 10.0;
                    arrayList.add(new TSConstPoint(d4, d));
                    arrayList.add(new TSConstPoint(d4 + 10.0, (d2 + d) / 2.0));
                    arrayList.add(new TSConstPoint(d4, d2));
                    tSDEdge.reroute(arrayList);
                }
            }
        }
        finally {
            if (recursiveHelper != null) {
                recursiveHelper.done();
            }
        }
    }

    @Override
    public void moveConnectorsBy(int n, boolean bl) {
        this.m_AllowAllUpdatesOfAssocitedPieces = bl;
        super.moveConnectorsBy(n, bl);
        this.m_AllowAllUpdatesOfAssocitedPieces = false;
    }
}

