/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.compartments;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSENode;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.ITaggedValue;
import org.netbeans.modules.uml.core.support.umlsupport.ETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.ETSize;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETSize;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.InvalidArguments;
import org.netbeans.modules.uml.ui.products.ad.application.IMenuManager;
import org.netbeans.modules.uml.ui.products.ad.application.action.ContextMenuActionClass;
import org.netbeans.modules.uml.ui.products.ad.compartments.ETSimpleListCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.ETZoneCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.ETZoneDividers;
import org.netbeans.modules.uml.ui.products.ad.compartments.IADZoneCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.IADZonesCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.IETZoneDividers;
import org.netbeans.modules.uml.ui.products.ad.compartments.INameListCompartment;
import org.netbeans.modules.uml.ui.support.QuestionResponse;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchive;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveElement;
import org.netbeans.modules.uml.ui.support.contextmenusupport.IProductContextMenu;
import org.netbeans.modules.uml.ui.support.contextmenusupport.IProductContextMenuItem;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.GDISupport;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ICompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ILabelManager;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.INotificationTargets;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ISetCursorEvent;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ISimpleListCompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IStretchContext;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.commondialogs.SwingQuestionDialogImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ETZonesCompartment
extends ETSimpleListCompartment
implements IADZonesCompartment {
    private final int DIVIDER_SELECT_WIDTH = 5;
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.modules.uml.ui.products.ad.compartments.Bundle");
    protected IETZoneDividers m_zonedividers = new ETZoneDividers(this, 1);
    protected int m_minNumCompartments = 0;
    protected boolean m_DrawTopLine;
    protected String m_strCompartmentID = "ADZoneCompartment";
    protected boolean m_bCollapsible;
    protected boolean m_bResizeable;
    public static final String ORIENTATION_STRING = "orientation";

    public ETZonesCompartment() {
        this.setShowName(false);
        this.m_bCollapsible = false;
        this.m_bResizeable = false;
        this.m_DrawTopLine = true;
    }

    @Override
    public void addModelElement(IElement iElement, int n) throws RuntimeException {
        if (null == iElement) {
            throw new IllegalArgumentException();
        }
        super.addModelElement(iElement, n);
        this.validateZoneCompartments(true);
    }

    @Override
    public void draw(IDrawInfo iDrawInfo, IETRect iETRect) {
        try {
            super.draw(iDrawInfo, iETRect);
            if (iDrawInfo != null) {
                Color color = Color.BLACK;
                int n = this.m_zonedividers.getOrientation();
                switch (n) {
                    case 0: {
                        this.drawHorizontalCompartments(iDrawInfo, iETRect);
                        this.m_zonedividers.draw(iDrawInfo, iETRect, color, 5);
                        break;
                    }
                    case 1: {
                        this.drawVerticalCompartments(iDrawInfo, iETRect);
                        this.m_zonedividers.draw(iDrawInfo, iETRect, color, 5);
                        break;
                    }
                }
                if (-1 != this.m_zonedividers.getOrientation() && this.getDrawTopLine()) {
                    GDISupport.drawLine(iDrawInfo.getTSEGraphics().getGraphics(), iETRect.getTopLeft(), iETRect.getTopRight(), color, 1);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public IProductArchiveElement writeToArchive(IProductArchive iProductArchive, IProductArchiveElement iProductArchiveElement) {
        try {
            IProductArchiveElement iProductArchiveElement2 = super.writeToArchive(iProductArchive, iProductArchiveElement);
            if (iProductArchiveElement2 != null) {
                iProductArchiveElement2.addAttributeLong(ORIENTATION_STRING, this.m_zonedividers.getOrientation());
                this.m_zonedividers.writeToArchive(iProductArchiveElement2);
            }
            return iProductArchiveElement2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void readFromArchive(IProductArchive iProductArchive, IProductArchiveElement iProductArchiveElement) {
        try {
            if (iProductArchive != null && iProductArchiveElement != null) {
                super.readFromArchive(iProductArchive, iProductArchiveElement);
                if (iProductArchiveElement != null) {
                    int n = -1;
                    n = (int)iProductArchiveElement.getAttributeLong(ORIENTATION_STRING);
                    this.m_zonedividers.setOrientation(n);
                    this.m_zonedividers.readFromArchive(iProductArchiveElement);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void onContextMenu(IMenuManager iMenuManager) {
        if (this.getEnableContextMenu()) {
            Point point = iMenuManager.getLocation();
            boolean bl = true;
            if (point != null) {
                bl = this.containsPoint(point);
            }
            if (bl) {
                int n = this.getNumCompartments();
                for (int i = 0; i < n; ++i) {
                    ICompartment iCompartment = this.getCompartment(i);
                    iCompartment.onContextMenu(iMenuManager);
                }
            }
            this.createZonesButtons(iMenuManager);
        }
    }

    @Override
    public boolean setSensitivityAndCheck(String string, ContextMenuActionClass contextMenuActionClass) {
        boolean bl;
        boolean bl2 = bl = !this.isParentDiagramReadOnly();
        if (bl && (string.equals("MBK_Z_DELETE_COLUMN") || string.equals("MBK_Z_DELETE_ROW") || string.equals("MBK_POPULATE_ALL_ZS")) && this.getNumCompartments() <= this.m_minNumCompartments) {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean onHandleButton(ActionEvent actionEvent, String string) {
        boolean bl = true;
        if (string.equals("MBK_Z_ADD_COLUMN")) {
            this.m_zonedividers.setOrientation(1);
            this.insertColumn(-1);
        } else if (string.equals("MBK_Z_DELETE_COLUMN")) {
            int n = this.getCompartmentColumnIndex(actionEvent);
            if (this.askRemoveZoneCompartment(n)) {
                this.m_zonedividers.deleteDivider(n);
                this.m_zonedividers.resetDividers();
            }
        } else if (string.equals("MBK_Z_ADD_ROW")) {
            this.m_zonedividers.setOrientation(0);
            this.insertRow(-1);
        } else if (string.equals("MBK_Z_DELETE_ROW")) {
            int n = this.getCompartmentRowIndex(actionEvent);
            if (this.askRemoveZoneCompartment(n)) {
                this.m_zonedividers.deleteDivider(n);
                this.m_zonedividers.resetDividers();
            }
        } else if (string.equals("MBK_POPULATE_THIS_Z")) {
            if (-1 == this.m_zonedividers.getOrientation()) {
                this.populateWithChildren(this);
            } else {
                int n = 0 == this.m_zonedividers.getOrientation() ? this.getCompartmentRowIndex(actionEvent) : this.getCompartmentColumnIndex(actionEvent);
                this.populateWithChildren(n);
            }
            bl = false;
        } else if (string.equals("MBK_POPULATE_ALL_ZS")) {
            for (int i = 0; i < this.getNumCompartments(); ++i) {
                this.populateWithChildren(i);
            }
            bl = false;
        } else {
            return super.onHandleButton(actionEvent, string);
        }
        if (this.getNumCompartments() <= 0) {
            this.m_zonedividers.setOrientation(-1);
        }
        if (bl && this.m_engine != null) {
            this.m_engine.sizeToContents();
            this.m_engine.invalidate();
        }
        return false;
    }

    @Override
    public long onContextMenu(IProductContextMenu iProductContextMenu, int n, int n2) {
        return super.onContextMenu(iProductContextMenu, n, n2);
    }

    @Override
    public long onContextMenuHandleSelection(IProductContextMenu iProductContextMenu, IProductContextMenuItem iProductContextMenuItem) {
        return super.onContextMenuHandleSelection(iProductContextMenu, iProductContextMenuItem);
    }

    @Override
    public boolean setSensitivityAndCheck(IProductContextMenu iProductContextMenu, IProductContextMenuItem iProductContextMenuItem, int n) {
        return super.setSensitivityAndCheck(iProductContextMenu, iProductContextMenuItem, n);
    }

    @Override
    public IETSize calculateOptimumSize(IDrawInfo iDrawInfo, boolean bl) {
        try {
            IETSize iETSize = this.m_zonedividers.calculateOptimumSize(iDrawInfo);
            if (this.m_zonedividers.getOrientation() != -1) {
                if (this.m_zonedividers.getDividerCnt() < 1) {
                    iETSize = ((ICompartment)this.getCompartments().get(0)).calculateOptimumSize(iDrawInfo, true);
                } else {
                    int n;
                    boolean bl2 = 0 == this.m_zonedividers.getOrientation();
                    int n2 = 0;
                    IETSize iETSize2 = null;
                    ETList<ICompartment> eTList = this.getCompartments();
                    for (n = 0; n < eTList.size(); ++n) {
                        ICompartment iCompartment = (ICompartment)eTList.get(n);
                        iETSize2 = iCompartment.calculateOptimumSize(iDrawInfo, true);
                        n2 = bl2 ? Math.max(n2, iETSize2.getWidth()) : Math.max(n2, iETSize2.getHeight());
                    }
                    n = this.m_zonedividers.getDividerOffset(this.m_zonedividers.getDividerCnt() - 1);
                    if (bl2) {
                        iETSize.setWidth(Math.max(n2, iETSize.getWidth()));
                        iETSize.setHeight(n + iETSize2.getHeight() + 2);
                    } else {
                        iETSize.setHeight(Math.max(n2, iETSize.getHeight()));
                        iETSize.setWidth(n + iETSize2.getWidth() + 2);
                    }
                }
            }
            if (!bl) {
                double d = iDrawInfo.getOnDrawZoom();
                iETSize.setWidth((int)((double)iETSize.getWidth() * d));
                iETSize.setHeight((int)((double)iETSize.getHeight() * d));
            }
            return iETSize;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean handleLeftMouseBeginDrag(IETPoint iETPoint, IETPoint iETPoint2, boolean bl) {
        boolean bl2 = this.m_zonedividers.handleLeftMouseBeginDrag(iETPoint);
        bl2 = bl2 ? false : super.handleLeftMouseBeginDrag(iETPoint, iETPoint2, bl);
        return bl2;
    }

    @Override
    public boolean handleLeftMouseButton(MouseEvent mouseEvent) {
        if (null == mouseEvent) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        bl = this.m_zonedividers.isMouseOnDivider(mouseEvent);
        if (!bl) {
            bl = super.handleLeftMouseButton(mouseEvent);
        }
        return bl;
    }

    @Override
    public boolean handleLeftMouseButtonDoubleClick(MouseEvent mouseEvent) {
        ICompartment iCompartment;
        boolean bl = false;
        ETList<ICompartment> eTList = this.getCompartments();
        Iterator iterator = eTList.iterator();
        while (iterator.hasNext() && !(bl = (iCompartment = (ICompartment)iterator.next()).handleLeftMouseButtonDoubleClick(mouseEvent))) {
        }
        return bl;
    }

    @Override
    public boolean handleLeftMouseButtonPressed(MouseEvent mouseEvent) {
        if (null == mouseEvent) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        bl = this.m_zonedividers.isMouseOnDivider(mouseEvent);
        if (!bl) {
            bl = super.handleLeftMouseButton(mouseEvent);
        }
        return bl;
    }

    public boolean handleLeftMouseBeginDrag(IETPoint iETPoint, IETPoint iETPoint2) {
        boolean bl = this.m_zonedividers.handleLeftMouseBeginDrag(iETPoint);
        bl = bl ? false : super.handleLeftMouseDrag(iETPoint, iETPoint2);
        return bl;
    }

    @Override
    public boolean handleLeftMouseDrop(IETPoint iETPoint, List list, boolean bl) {
        return super.handleLeftMouseDrop(iETPoint, list, bl);
    }

    @Override
    public boolean handleRightMouseButton(MouseEvent mouseEvent) {
        return super.handleRightMouseButton(mouseEvent);
    }

    @Override
    public boolean handleSetCursor(IETPoint iETPoint, ISetCursorEvent iSetCursorEvent) {
        boolean bl = this.m_zonedividers.handleSetCursor(iETPoint, iSetCursorEvent);
        if (!bl) {
            bl = super.handleSetCursor(iETPoint, iSetCursorEvent);
        }
        return bl;
    }

    @Override
    public long stretch(IStretchContext iStretchContext) {
        IETPoint iETPoint;
        IETSize iETSize;
        if (null == iStretchContext) {
            throw new IllegalArgumentException();
        }
        int n = iStretchContext.getType();
        if (!(1 != n && 3 != n || (iETSize = iStretchContext.getStretchSize()).getWidth() == 0 && iETSize.getHeight() == 0 || (iETPoint = iStretchContext.getFinishPoint()) == null)) {
            this.m_zonedividers.updateCurrentDivider(iETPoint);
            if (this.m_engine != null) {
                ILabelManager iLabelManager;
                if (3 == n && (iLabelManager = this.m_engine.getLabelManager()) != null) {
                    iLabelManager.relayoutLabels();
                }
                this.m_engine.invalidate();
                this.getGraphWindow().updateInvalidRegions(true);
            }
        }
        return 0L;
    }

    @Override
    public long clearStretch(IDrawInfo iDrawInfo) {
        this.m_cachedOptimumSize.setSize(-1, -1);
        this.m_cachedUserSize.setSize(-1, -1);
        this.m_cachedVisibleSize.setSize(-1, -1);
        if (this.m_zonedividers.getOrientation() != -1 && this.m_zonedividers.getDividerCnt() > 0) {
            int n;
            boolean bl = 0 == this.m_zonedividers.getOrientation();
            int n2 = n = 1;
            ETList<ICompartment> eTList = this.getCompartments();
            for (int i = 0; i < eTList.size() - 1; ++i) {
                ICompartment iCompartment = (ICompartment)eTList.get(i);
                IETSize iETSize = iCompartment.calculateOptimumSize(iDrawInfo, true);
                n2 = bl ? (n2 += iETSize.getHeight()) : (n2 += iETSize.getWidth());
                this.m_zonedividers.setDividerOffset(i, n2 += n);
                n2 += n;
            }
        }
        return 0L;
    }

    @Override
    public long onGraphEvent(int n) {
        long l = super.onGraphEvent(n);
        switch (n) {
            case 5: {
                this.m_zonedividers.startNodeResize();
                break;
            }
            case 6: {
                this.m_zonedividers.finishNodeResize();
            }
        }
        return l;
    }

    @Override
    public long modelElementHasChanged(INotificationTargets iNotificationTargets) {
        block8: {
            try {
                ITaggedValue iTaggedValue;
                IElement iElement = null;
                int n = -1;
                if (iNotificationTargets == null) break block8;
                iElement = iNotificationTargets.getChangedModelElement();
                n = iNotificationTargets.getKind();
                ITaggedValue iTaggedValue2 = iTaggedValue = iElement instanceof ITaggedValue ? (ITaggedValue)iElement : null;
                if (n == 21 || n == 20 || n == 22 || iTaggedValue != null) {
                    int n2 = this.getNumCompartments();
                    for (int i = 0; i < n2; ++i) {
                        boolean bl;
                        INameListCompartment iNameListCompartment;
                        ICompartment iCompartment = this.getCompartment(i);
                        INameListCompartment iNameListCompartment2 = iNameListCompartment = iCompartment instanceof INameListCompartment ? (INameListCompartment)iCompartment : null;
                        if (iNameListCompartment == null || !(bl = iNameListCompartment.updateAllOptionalCompartments(null))) continue;
                        this.setIsDirty();
                    }
                } else if (n == 0) {
                    int n3 = this.getNumCompartments();
                    for (int i = 0; i < n3; ++i) {
                        INameListCompartment iNameListCompartment;
                        ICompartment iCompartment = this.getCompartment(i);
                        INameListCompartment iNameListCompartment3 = iNameListCompartment = iCompartment instanceof INameListCompartment ? (INameListCompartment)iCompartment : null;
                        if (iNameListCompartment == null) continue;
                        iNameListCompartment.modelElementHasChanged(iNotificationTargets);
                    }
                }
                if (this.getEngine() != null) {
                    this.getEngine().invalidate();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 1L;
    }

    @Override
    public long modelElementDeleted(INotificationTargets iNotificationTargets) {
        this.validateZoneCompartments(false);
        return 0L;
    }

    @Override
    public IETRect getMinimumRect() {
        ETRect eTRect = new ETRect();
        try {
            IETRect iETRect = this.getTSAbsoluteRect();
            int n = this.m_zonedividers.getDividerCnt();
            if (n > 0) {
                switch (this.m_zonedividers.getOrientation()) {
                    case 0: {
                        int n2 = iETRect.getTop() - this.m_zonedividers.getDividerOffset(0);
                        int n3 = iETRect.getTop() - this.m_zonedividers.getDividerOffset(n - 1);
                        eTRect.setSides(0, n2, 0, n3);
                        break;
                    }
                    case 1: {
                        int n4 = iETRect.getLeft() + this.m_zonedividers.getDividerOffset(0);
                        int n5 = iETRect.getLeft() + this.m_zonedividers.getDividerOffset(n - 1);
                        eTRect.setSides(n4, 0, n5, 0);
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return eTRect;
    }

    @Override
    public boolean getDrawTopLine() {
        return this.m_DrawTopLine;
    }

    @Override
    public void setDrawTopLine(boolean bl) {
        this.m_DrawTopLine = bl;
    }

    protected abstract void createZonesButtons(IMenuManager var1);

    int getCompartmentRowIndex(ActionEvent actionEvent) {
        int n = -1;
        if (null == actionEvent) {
            throw new IllegalArgumentException();
        }
        this.ensureProperDividerCount();
        TSConstPoint tSConstPoint = this.getLogicalMouseLocation(actionEvent);
        if (tSConstPoint != null) {
            int n2 = this.getLogicalBoundingRect().getTop() - (int)tSConstPoint.getY();
            n = this.m_zonedividers.getZoneIndex(n2);
        } else {
            IADZoneCompartment iADZoneCompartment = this.getSelectedZoneCompartment();
            if (iADZoneCompartment != null) {
                n = this.getCompartmentIndex(iADZoneCompartment);
            }
        }
        if (-1 == n && this.getNumCompartments() > 0) {
            n = 0;
        }
        return n;
    }

    protected int getCompartmentColumnIndex(ActionEvent actionEvent) {
        int n = -1;
        if (null == actionEvent) {
            throw new IllegalArgumentException();
        }
        this.ensureProperDividerCount();
        TSConstPoint tSConstPoint = this.getLogicalMouseLocation(actionEvent);
        if (tSConstPoint != null) {
            int n2 = (int)tSConstPoint.getX() - this.getLogicalBoundingRect().getLeft();
            n = this.m_zonedividers.getZoneIndex(n2);
        } else {
            IADZoneCompartment iADZoneCompartment = this.getSelectedZoneCompartment();
            if (iADZoneCompartment != null) {
                n = this.getCompartmentIndex(iADZoneCompartment);
            }
        }
        if (-1 == n && this.getNumCompartments() > 0) {
            n = 0;
        }
        return n;
    }

    protected int getCompartmentRowIndex(IMenuManager iMenuManager) {
        Point point = iMenuManager.getLocation();
        int n = this.getLogicalBoundingRect().getTop() - point.y;
        int n2 = this.m_zonedividers.getZoneIndex(n);
        if (-1 == n2 && this.getNumCompartments() > 0) {
            n2 = 0;
        }
        return n2;
    }

    protected void insertRow(int n) {
        if (this.getNumCompartments() == 0) {
            this.insertZoneCompartment(-1);
        }
        this.m_zonedividers.setOrientation(0);
        this.insertZoneCompartment(n);
        this.m_zonedividers.insertDivider(n);
    }

    protected void insertColumn(int n) {
        if (this.getNumCompartments() == 0) {
            this.insertZoneCompartment(-1);
        }
        this.m_zonedividers.setOrientation(1);
        this.insertZoneCompartment(n);
        this.m_zonedividers.insertDivider(n);
    }

    protected abstract void validateZoneCompartments(boolean var1);

    protected void validateZoneCompartments(ETList<IElement> eTList, int n, boolean bl) throws RuntimeException {
        ICompartment iCompartment;
        if (null == eTList) {
            throw new IllegalArgumentException();
        }
        if (null == this.m_engine) {
            throw new IllegalStateException();
        }
        boolean bl2 = false;
        HashSet<ICompartment> hashSet = new HashSet<ICompartment>();
        for (IElement iElement : eTList) {
            if (iElement.isDeleted()) continue;
            iCompartment = this.findCompartmentContainingElement(iElement);
            if (iCompartment == null) {
                iCompartment = this.addZoneCompartment(iElement);
                bl2 = true;
            }
            if (iCompartment == null) continue;
            hashSet.add(iCompartment);
            if (!bl) continue;
            if (iCompartment instanceof ETZoneCompartment) {
                ((ETZoneCompartment)iCompartment).attach(iElement);
                continue;
            }
            iCompartment.addModelElement(iElement, -1);
        }
        int n2 = this.getNumCompartments();
        for (int i = n2 - 1; i >= 0; --i) {
            iCompartment = this.getCompartment(i);
            if (iCompartment == null || hashSet.contains(iCompartment)) continue;
            this.removeCompartmentAt(i, false);
        }
        if (this.getNumCompartments() > 1 && -1 == this.m_zonedividers.getOrientation()) {
            this.m_zonedividers.setOrientation(n);
        }
        this.m_zonedividers.resetDividers();
        if (bl2) {
            this.m_engine.delayedSizeToContents();
        } else {
            this.m_engine.invalidate();
        }
    }

    protected ICompartment addZoneCompartment(IElement iElement) {
        return this.addZoneCompartment(iElement, -1);
    }

    protected ICompartment addZoneCompartment(IElement iElement, int n) throws InvalidArguments {
        ICompartment iCompartment = null;
        if (iElement != null) {
            IADZoneCompartment iADZoneCompartment;
            iCompartment = this.createAndAddCompartment(this.m_strCompartmentID, n, false);
            IADZoneCompartment iADZoneCompartment2 = iADZoneCompartment = iCompartment instanceof IADZoneCompartment ? (IADZoneCompartment)iCompartment : null;
            if (iADZoneCompartment != null) {
                iADZoneCompartment.attach(iElement);
            } else if (iCompartment != null) {
                iCompartment.addModelElement(iElement, -1);
            }
        }
        return iCompartment;
    }

    protected void insertZoneCompartment(int n) throws InvalidArguments {
        if (n < -1 || n >= this.getNumCompartments()) {
            throw new InvalidArguments();
        }
        IElement iElement = this.createNewElement();
        this.addZoneCompartment(iElement);
    }

    protected abstract IElement createNewElement() throws RuntimeException;

    @Override
    public void initCompartments(IPresentationElement iPresentationElement) {
        try {
            this.nodeResized(-1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void ensureProperDividerCount() {
        if (this.m_zonedividers.getDividerCnt() != this.getNumCompartments() - 1) {
            this.m_zonedividers.resetDividers();
        }
    }

    boolean askRemoveZoneCompartment(int n) {
        boolean bl = false;
        if (n >= 0 && n < this.getNumCompartments()) {
            QuestionResponse questionResponse = null;
            SwingQuestionDialogImpl swingQuestionDialogImpl = new SwingQuestionDialogImpl();
            if (swingQuestionDialogImpl != null) {
                String string = messages.getString("IDS_REMOVE_ZONE");
                String string2 = messages.getString("IDS_REMOVE_ZONE_TITLE");
                questionResponse = swingQuestionDialogImpl.displaySimpleQuestionDialog(4, 6, string, 6, null, string2);
            }
            if (questionResponse != null && 5 == questionResponse.getResult()) {
                this.removeCompartmentAt(n, true);
                bl = true;
            }
        }
        return bl;
    }

    protected void drawHorizontalCompartments(IDrawInfo iDrawInfo, IETRect iETRect) {
        int n = this.getNumCompartments();
        if (n > 0) {
            this.ensureProperDividerCount();
            IETRect iETRect2 = (IETRect)iETRect.clone();
            double d = iDrawInfo.getOnDrawZoom();
            IETPoint iETPoint = this.m_zonedividers.getDrawOffset(iETRect);
            int n2 = iETPoint.getY() - iETRect.getTop();
            int n3 = iETRect.getTop();
            for (int i = 0; i < n; ++i) {
                iETRect2.setTop(n3);
                n3 = i < this.m_zonedividers.getDividerCnt() ? iETRect.getTop() + n2 + (int)((double)this.m_zonedividers.getDividerOffset(i) * d) : iETRect.getBottom();
                iETRect2.setBottom(n3);
                ICompartment iCompartment = this.getCompartment(i);
                if (iCompartment == null) continue;
                iCompartment.draw(iDrawInfo, (IETRect)iETRect2.clone());
            }
        }
    }

    protected void drawVerticalCompartments(IDrawInfo iDrawInfo, IETRect iETRect) {
        int n = this.getNumCompartments();
        if (n > 0) {
            this.ensureProperDividerCount();
            IETRect iETRect2 = (IETRect)iETRect.clone();
            double d = iDrawInfo.getOnDrawZoom();
            int n2 = this.m_zonedividers.getDrawOffset(iETRect).getX() - iETRect.getLeft();
            int n3 = iETRect.getLeft();
            for (int i = 0; i < n; ++i) {
                iETRect2.setLeft(n3);
                n3 = i < this.m_zonedividers.getDividerCnt() ? iETRect.getLeft() + (int)((double)n2 + (double)this.m_zonedividers.getDividerOffset(i) * d) : iETRect.getRight();
                iETRect2.setRight(n3);
                ICompartment iCompartment = this.getCompartment(i);
                if (iCompartment == null) continue;
                iCompartment.draw(iDrawInfo, (IETRect)iETRect2.clone());
            }
        }
    }

    protected boolean populateWithChildren(int n) {
        boolean bl = false;
        ICompartment iCompartment = this.getCompartment(n);
        if (iCompartment != null) {
            bl = this.populateWithChildren(iCompartment);
        }
        return bl;
    }

    protected boolean populateWithChildren(ICompartment iCompartment) {
        return false;
    }

    protected void resizeToContain(ICompartment iCompartment, IETRect iETRect) {
        if (null == iCompartment) {
            throw new IllegalArgumentException();
        }
        if (null == this.m_engine) {
            throw new IllegalArgumentException();
        }
        if (iETRect != null) {
            ETList<IPresentationElement> eTList;
            Object object;
            ETArrayList<IPresentationElement> eTArrayList;
            Object object2;
            boolean bl;
            boolean bl2;
            IETRect iETRect2 = TypeConversions.getLogicalBoundingRect(iCompartment);
            int n = iETRect.getLeft() - iETRect2.getLeft();
            int n2 = iETRect.getRight() - iETRect2.getRight();
            int n3 = iETRect.getBottom() - iETRect2.getBottom();
            int n4 = iETRect.getTop() - iETRect2.getTop();
            boolean bl3 = n < 0;
            boolean bl4 = n2 > 0;
            boolean bl5 = n3 < 0;
            boolean bl6 = n4 > 0;
            boolean bl7 = bl2 = 0 == this.m_zonedividers.getOrientation();
            boolean bl8 = bl2 ? bl5 || bl6 : (bl = bl3 || bl4);
            if (bl4 || bl5) {
                object2 = new ETPoint(iETRect2.getTopLeft().x + 5, iETRect2.getTopLeft().y + 5);
                int n5 = this.m_zonedividers.getIndexFromTSLogical((IETPoint)object2);
                if (-1 != this.m_zonedividers.getOrientation()) {
                    int n6 = bl2 ? n3 : n2;
                    this.m_zonedividers.shiftDividers(n6, n5);
                }
                if ((eTArrayList = TypeConversions.getNodePresentation(this.m_engine)) != null) {
                    IETSize iETSize = this.m_zonedividers.calculateOptimumSize(null);
                    IETRect iETRect3 = TypeConversions.getLogicalBoundingRect(this.m_engine);
                    object = new ETSize(Math.max(iETSize.getWidth(), iETRect.getRight() - iETRect3.getLeft()), Math.max(iETSize.getHeight(), iETRect3.getTop() - iETRect.getBottom()));
                    eTList = new ETSize((int)Math.max((double)object.getWidth(), iETRect3.getWidth()), (int)Math.max((double)object.getHeight(), -iETRect3.getHeight()));
                    eTArrayList.resize(eTList.getWidth(), eTList.getHeight(), true);
                }
            }
            if (bl) {
                object2 = new ETArrayList();
                ETArrayList<IPresentationElement> eTArrayList2 = new ETArrayList<IPresentationElement>();
                eTArrayList = object2;
                int n7 = this.getNumCompartments();
                for (int i = 0; i < n7; ++i) {
                    object = this.getCompartment(i);
                    if (iCompartment == object) {
                        eTArrayList = eTArrayList2;
                        continue;
                    }
                    eTList = object.getContained();
                    if (eTList == null) continue;
                    eTArrayList.addThese(eTList);
                }
                ETPoint eTPoint = new ETPoint(0, 0);
                object = new ETPoint(0, 0);
                if (bl2) {
                    if (bl6) {
                        eTPoint.setY(n4);
                    }
                    if (bl5) {
                        object.setY(n3);
                    }
                } else {
                    if (bl3) {
                        eTPoint.setX(n);
                    }
                    if (bl4) {
                        object.setX(n2);
                    }
                }
                this.movePEs((ETList<IPresentationElement>)object2, eTPoint);
                this.movePEs(eTArrayList2, (IETPoint)object);
            }
        }
    }

    protected void movePEs(ETList<IPresentationElement> eTList, IETPoint iETPoint) {
        if (null == eTList) {
            throw new IllegalArgumentException();
        }
        int n = eTList.size();
        for (int i = 0; i < n; ++i) {
            IPresentationElement iPresentationElement = (IPresentationElement)eTList.get(i);
            TSENode tSENode = TypeConversions.getOwnerNode(iPresentationElement);
            if (tSENode == null) continue;
            tSENode.setCenterX((double)iETPoint.getX());
            tSENode.setCenterY((double)iETPoint.getY());
        }
    }

    @Override
    public void setSelected(boolean bl) {
        ETList<ICompartment> eTList = this.getCompartments();
        if (eTList != null && eTList.size() > 0) {
            for (int i = 0; i < eTList.size(); ++i) {
                ICompartment iCompartment = (ICompartment)eTList.get(i);
                if (iCompartment == null || !(iCompartment instanceof IADZoneCompartment) || iCompartment.isSelected()) continue;
                iCompartment.setSelected(bl);
                break;
            }
        }
    }

    public IADZoneCompartment getSelectedZoneCompartment() {
        IADZoneCompartment iADZoneCompartment = null;
        IADZoneCompartment iADZoneCompartment2 = null;
        ETList<ICompartment> eTList = this.getCompartments();
        if (eTList != null && eTList.size() > 0) {
            block0: for (int i = 0; i < eTList.size(); ++i) {
                ICompartment iCompartment = (ICompartment)eTList.get(i);
                if (iCompartment == null || !(iCompartment instanceof IADZoneCompartment) || !((iADZoneCompartment = (IADZoneCompartment)iCompartment) instanceof ISimpleListCompartment)) continue;
                for (ICompartment iCompartment2 : iADZoneCompartment.getCompartments()) {
                    if (iCompartment2 == null || !iCompartment2.isSelected()) continue;
                    iADZoneCompartment2 = iADZoneCompartment;
                    continue block0;
                }
            }
        }
        return iADZoneCompartment2;
    }

    @Override
    public boolean handleKeyDown(int n, int n2) {
        boolean bl = super.handleKeyDown(n, n2);
        return bl;
    }
}

