/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.compartments;

import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEImage;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IConfigManager;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.support.umlsupport.ETSize;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETSize;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.ui.products.ad.compartments.ETNameCompartment;
import org.netbeans.modules.uml.ui.products.ad.compartments.IADStereotypeCompartment;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchive;
import org.netbeans.modules.uml.ui.support.archivesupport.IProductArchiveElement;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawInfo;
import org.openide.util.NbPreferences;

public class ETStereoTypeCompartment
extends ETNameCompartment
implements IADStereotypeCompartment {
    private static final String STEREOTYPE_CONFIG_FILE = "StereotypeIcons.etc";
    public static String SHOWSTEREOTYPEASICONS_STRING = "ShowStereotypesAsIcons";
    private static Document m_Document = null;
    private boolean m_showStereotypesAsIcons = true;
    private static HashMap stereoTypeIconMap;
    private static final int ICON_SIZE = 15;
    private ArrayList m_iconStereoTypesList = new ArrayList();
    private ArrayList m_textStereoTypesList = new ArrayList();
    private String m_oldStereotypeText = null;
    private TSEFont m_defaultTextFont = new TSEFont("Arial-italic-12");

    public ETStereoTypeCompartment() {
        this.init();
    }

    public ETStereoTypeCompartment(IDrawEngine iDrawEngine) {
        super(iDrawEngine);
        this.init();
    }

    private void init() {
        this.setFontString("Arial-italic-12");
        this.initResources();
        this.setReadOnly(true);
    }

    private static HashMap getStereoTypeIcons() {
        if (stereoTypeIconMap == null) {
            IConfigManager iConfigManager = ProductRetriever.retrieveProduct().getConfigManager();
            m_Document = XMLManip.getDOMDocument(iConfigManager.getDefaultConfigLocation() + STEREOTYPE_CONFIG_FILE);
            if (m_Document != null) {
                stereoTypeIconMap = new HashMap();
                Element element = m_Document.getRootElement();
                Element element2 = (Element)XMLManip.selectSingleNode((Node)element, "Icons");
                Iterator iterator = element2.elementIterator("Icon");
                while (iterator.hasNext()) {
                    Element element3 = (Element)iterator.next();
                    Image image = TSEImage.loadImage(ETStereoTypeCompartment.class, (String)XMLManip.getAttributeValue((Node)element3, "Filename"));
                    stereoTypeIconMap.put(XMLManip.getAttributeValue((Node)element3, "Stereotype"), image);
                }
            }
            return stereoTypeIconMap;
        }
        return stereoTypeIconMap;
    }

    public void initResources() {
        this.setName(" ");
        this.setResourceID("stereotype", Color.BLACK);
        super.initResources();
    }

    public IETSize calculateOptimumSize(IDrawInfo iDrawInfo, boolean bl) {
        IETSize iETSize = null;
        TSEGraphics tSEGraphics = this.getGraphics(iDrawInfo);
        String string = this.getStereotypeText();
        if (string != null && string.length() > 0) {
            this.initStereotypeLists(string);
            this.setName(string);
        }
        iETSize = super.calculateOptimumSize(iDrawInfo, false);
        this.m_showStereotypesAsIcons = this.showStereotypeIcons();
        if (this.m_showStereotypesAsIcons) {
            if (this.m_textStereoTypesList.size() == 0) {
                iETSize = new ETSize(0, 0);
            }
            if (this.m_iconStereoTypesList.size() > 0) {
                iETSize.setWidth(iETSize.getWidth() + 15 * this.m_iconStereoTypesList.size() + 1);
                iETSize.setHeight(iETSize.getHeight() + 15 + 1);
            }
        } else if (this.m_textStereoTypesList.size() == 0 && this.m_iconStereoTypesList.size() == 0) {
            iETSize = new ETSize(0, 0);
        }
        if (iETSize != null) {
            this.internalSetOptimumSize(iETSize.getWidth(), iETSize.getHeight());
        }
        return bl ? this.getOptimumSize(bl) : this.scaleSize(this.m_cachedOptimumSize, tSEGraphics != null ? tSEGraphics.getTSTransform() : this.getTransform());
    }

    private void initStereotypeLists(String string) {
        String string2 = this.getStereotypeText();
        if (string2 != null && !string2.equals(this.m_oldStereotypeText)) {
            this.m_oldStereotypeText = string2;
            this.m_textStereoTypesList.clear();
            this.m_iconStereoTypesList.clear();
            HashMap hashMap = ETStereoTypeCompartment.getStereoTypeIcons();
            String string3 = string2.replaceAll("<<", "");
            string3 = string3.replaceAll(">>", "");
            string3 = string3.trim();
            String[] stringArray = string3.split(",");
            if (stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i];
                    Image image = (Image)hashMap.get(string4.trim());
                    if (image == null) {
                        this.m_textStereoTypesList.add(string4);
                        continue;
                    }
                    this.m_iconStereoTypesList.add(image);
                }
            }
        }
    }

    public void draw(IDrawInfo iDrawInfo, IETRect iETRect) {
        String string = this.getStereotypeText();
        if (!this.m_showStereotypesAsIcons) {
            this.setName(string);
            super.draw(iDrawInfo, iETRect);
        } else {
            TSEGraphWindow tSEGraphWindow;
            this.setWinClientRectangle((IETRect)iETRect.clone());
            TSEGraphics tSEGraphics = iDrawInfo.getTSEGraphics();
            TSTransform tSTransform = tSEGraphics.getTSTransform();
            Font font = this.getCompartmentFont(iDrawInfo.getFontScaleFactor());
            tSEGraphics.setFont(font);
            String string2 = null;
            if (this.m_textStereoTypesList.size() > 0) {
                string2 = "<<";
                tSEGraphWindow = this.m_textStereoTypesList.iterator();
                while (tSEGraphWindow.hasNext()) {
                    string2 = string2 + (String)tSEGraphWindow.next() + ",";
                }
                if ((string2 = string2.substring(0, string2.length() - 1) + ">>") != null) {
                    tSEGraphics.setColor(this.getCompartmentFontColor());
                    tSEGraphics.drawString(string2, iETRect.getIntX() + iETRect.getIntWidth() / 2 - tSEGraphics.getFontMetrics().stringWidth(string2) / 2, iETRect.getIntY() + tSEGraphics.getFontMetrics().getHeight() - 2);
                }
            }
            if (this.m_iconStereoTypesList.size() > 0) {
                tSEGraphWindow = tSEGraphics.getGraphWindow();
                int n = (int)(15.0 * tSTransform.getScaleX());
                int n2 = iETRect.getIntX() + iETRect.getIntWidth() - n - 2;
                int n3 = string2 != null ? iETRect.getIntY() + tSEGraphics.getFontMetrics().getHeight() : iETRect.getIntY();
                for (Image image : this.m_iconStereoTypesList) {
                    tSEGraphics.drawImage(image, n2, n3, n, n, (ImageObserver)tSEGraphWindow);
                    n2 = n2 - n - 2;
                }
            }
        }
    }

    protected boolean showStereotypeIcons() {
        return NbPreferences.forModule(ETStereoTypeCompartment.class).getBoolean("UML_Show_Stereotype_Icons", true);
    }

    public boolean getShowStereotypeIcons() {
        return this.m_showStereotypesAsIcons;
    }

    public void setShowStereotypeIcons(boolean bl) {
        this.m_showStereotypesAsIcons = bl;
    }

    public IProductArchiveElement writeToArchive(IProductArchive iProductArchive, IProductArchiveElement iProductArchiveElement) {
        IProductArchiveElement iProductArchiveElement2 = super.writeToArchive(iProductArchive, iProductArchiveElement);
        if (iProductArchiveElement2 != null) {
            iProductArchiveElement2.addAttributeBool(SHOWSTEREOTYPEASICONS_STRING, this.m_showStereotypesAsIcons);
        }
        return iProductArchiveElement2;
    }

    public void readFromArchive(IProductArchive iProductArchive, IProductArchiveElement iProductArchiveElement) {
        super.readFromArchive(iProductArchive, iProductArchiveElement);
        this.m_showStereotypesAsIcons = iProductArchiveElement.getAttributeBool(SHOWSTEREOTYPEASICONS_STRING);
    }

    public String getCompartmentID() {
        return "StereotypeCompartment";
    }

    public long onGraphEvent(int n) {
        switch (n) {
            case 1: {
                this.m_showStereotypesAsIcons = this.showStereotypeIcons();
            }
        }
        return 0L;
    }

    public String getStereotypeText() {
        String string = "";
        IElement iElement = this.getModelElement();
        if (iElement != null) {
            string = super.getStereotypeText(iElement);
        }
        return string;
    }
}

