/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.compartments;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.uml.common.Util;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DuplicateElementRenamePanel
extends JPanel
implements DocumentListener,
ActionListener {
    private INamespace targetNamespace = null;
    private INamedElement sourceElement = null;
    private JLabel messageLabel;
    private JLabel newNameLabel;
    private JTextField newNameText;
    private ButtonGroup projectTypeButtonGroup;
    private JLabel statusLabel;
    private boolean valid = true;
    private String statusMsg = " ";
    private boolean enable = false;
    private String PROP_NEW_NAME = "PROP_PROJECT_NAME";

    public DuplicateElementRenamePanel(INamespace iNamespace, INamedElement iNamedElement, String string) {
        this.targetNamespace = iNamespace;
        this.sourceElement = iNamedElement;
        this.initComponents();
        this.newNameText.getDocument().addDocumentListener(this);
        this.newNameText.setText(string);
        this.enable = false;
        this.valid = false;
        this.notifyPropertyListeners();
        this.messageLabel.setText(NbBundle.getMessage(DuplicateElementRenamePanel.class, (String)"MSG_DuplicateElementRenameMessage", (Object)string));
    }

    private void initComponents() {
        this.projectTypeButtonGroup = new ButtonGroup();
        this.messageLabel = new JLabel();
        this.newNameLabel = new JLabel();
        this.newNameText = new JTextField();
        this.statusLabel = new JLabel();
        this.messageLabel.setText("(Duplicate Rename Message)");
        this.newNameLabel.setLabelFor(this.newNameText);
        Mnemonics.setLocalizedText((JLabel)this.newNameLabel, (String)NbBundle.getMessage(DuplicateElementRenamePanel.class, (String)"LBL_TargetProject"));
        this.statusLabel.setForeground(new Color(0, 0, 255));
        this.statusLabel.setText("<field validation status message>");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.messageLabel, -1, 303, Short.MAX_VALUE).add((Component)this.statusLabel, -1, 303, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(10, 10, 10).add((Component)this.newNameLabel).addPreferredGap(0).add((Component)this.newNameText, -2, 195, -2))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.messageLabel).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.newNameLabel).add((Component)this.newNameText, -2, -1, -2)).addPreferredGap(0).add((Component)this.statusLabel)));
        this.messageLabel.getAccessibleContext().setAccessibleDescription("");
        this.newNameLabel.getAccessibleContext().setAccessibleName("");
        this.newNameLabel.getAccessibleContext().setAccessibleDescription(null);
        this.newNameText.getAccessibleContext().setAccessibleName("");
        this.newNameText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DuplicateElementRenamePanel.class, (String)"ACSD_NewName"));
        this.statusLabel.getAccessibleContext().setAccessibleName("Dialog field validation message");
        this.statusLabel.getAccessibleContext().setAccessibleDescription("Reports the validation messages for all of the input fields of this dialog.");
    }

    public void requestFocus() {
        this.newNameText.requestFocus();
        this.updateValidStatus();
    }

    private void initListeners() {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.newNameText.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("NEW_NAME", null, this.newNameText.getText());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.newNameText.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("NEW_NAME", null, this.newNameText.getText());
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.newNameText.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("NEW_NAME", null, this.newNameText.getText());
        }
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.newNameText.getDocument()) {
            this.updateValidStatus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public String getNewName() {
        return this.newNameText.getText();
    }

    private boolean updateValidStatus() {
        this.enable = true;
        this.statusMsg = " ";
        if (this.newNameText.getText() == null || this.newNameText.getText().trim().equals("") || Util.invalidIdentifier(this.newNameText.getText())) {
            this.enable = Boolean.FALSE;
            this.statusMsg = "ERR_INVALID_NAME";
        } else if (Util.containsSimilarElement(this.targetNamespace, this.newNameText.getText(), this.sourceElement.getElementType(), this.sourceElement)) {
            this.enable = Boolean.FALSE;
            this.statusMsg = "ERR_SimilarElement";
        }
        return this.notifyPropertyListeners();
    }

    private boolean notifyPropertyListeners() {
        this.firePropertyChange("valid", !this.enable, this.enable);
        if (!this.statusMsg.trim().equals("")) {
            this.statusLabel.setText(NbBundle.getMessage(DuplicateElementRenamePanel.class, (String)this.statusMsg));
        } else {
            this.statusLabel.setText(this.statusMsg);
        }
        this.valid = this.enable;
        return this.valid;
    }
}

