/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.products.ad.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.netbeans.modules.uml.ui.products.ad.application.IMenuManager;
import org.netbeans.modules.uml.ui.swing.plaf.basic.BasicPullDownButtonBorder;
import org.netbeans.modules.uml.ui.swing.pulldownbutton.JPullDownButton;
import org.netbeans.modules.uml.ui.swing.pulldownbutton.PopupMenuInvoker;
import org.netbeans.modules.uml.ui.swing.testbed.addin.menu.TestBedMenuManager;

public abstract class ApplicationView
extends JPanel {
    private String m_Title = "";
    private Icon m_Icon = null;
    private String m_ToolTip = null;
    private String m_Id = "";
    private JToolBar m_ToolBarManager = null;
    private JPanel m_ToolComponent;
    private TestBedMenuManager m_ContextMenuManager = null;
    private JMenu m_ContextPopup = new JMenu();

    public ApplicationView(String string) {
        this.setId(string);
    }

    public JPanel getView() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.createViewControl(jPanel);
        this.add((Component)jPanel, "Center");
        this.setPopupMenuListener(new PopupMenuManager(jPanel));
        this.initializeUIBars(this);
        return this;
    }

    public PopupMenuManager getPopupMenuManager(JPanel jPanel) {
        return new PopupMenuManager(jPanel);
    }

    protected void initializeUIBars(JPanel jPanel) {
        this.m_ToolComponent = new JPanel();
        BoxLayout boxLayout = new BoxLayout(this.m_ToolComponent, 0);
        this.m_ToolComponent.setLayout(boxLayout);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.m_ToolBarManager = jToolBar;
        TestBedMenuManager testBedMenuManager = new TestBedMenuManager();
        JMenu jMenu = new JMenu();
        testBedMenuManager.setMenuItem(jMenu);
        this.contributeActionBars(this.m_ToolBarManager);
        this.m_ToolComponent.add(this.m_ToolBarManager);
        testBedMenuManager.createMenuBar();
        if (jMenu.getItemCount() > 0) {
            JPullDownButton jPullDownButton = new JPullDownButton();
            jPullDownButton.setBorder(new BasicPullDownButtonBorder(false));
            jPullDownButton.setPulldownInvoker(new PopupMenuInvoker(jMenu.getPopupMenu()));
            this.m_ToolComponent.add(jPullDownButton);
        }
        jPanel.add((Component)this.m_ToolComponent, "North");
    }

    public abstract void createViewControl(JPanel var1);

    protected void contributeActionBars(JToolBar jToolBar) {
    }

    public void setPopupMenuListener(MouseListener mouseListener) {
    }

    public void registerContextMenu(boolean bl) {
        this.registerContextMenu(this.getId(), bl);
    }

    public void registerContextMenu(String string, boolean bl) {
        this.m_ContextMenuManager = new TestBedMenuManager();
        this.m_ContextMenuManager.setRemoveAllWhenShown(bl);
        this.m_ContextMenuManager.setMenuItem(this.m_ContextPopup);
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
    }

    public void processRemovesIfAny(IMenuManager iMenuManager) {
    }

    public String getTitle() {
        return this.m_Title;
    }

    public void setTitle(String string) {
        this.m_Title = string;
    }

    public Icon getIcon() {
        return this.m_Icon;
    }

    public void setIcon(Icon icon) {
        this.m_Icon = icon;
    }

    public String getToolTip() {
        return this.m_ToolTip;
    }

    public void setToolTip(String string) {
        this.m_ToolTip = string;
    }

    public String getId() {
        return this.m_Id;
    }

    public void setId(String string) {
        this.m_Id = string;
    }

    public class PopupMenuManager
    extends MouseAdapter {
        JPanel m_View = null;

        public PopupMenuManager(JPanel jPanel) {
            this.m_View = jPanel;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.showPopupMenu(mouseEvent);
        }

        public void showPopupMenu(Component component) {
            if (ApplicationView.this.m_ContextMenuManager.getRemoveAllWhenShown()) {
                ApplicationView.this.m_ContextMenuManager.removeAll();
                ApplicationView.this.m_ContextPopup.removeAll();
            }
            ApplicationView.this.menuAboutToShow(ApplicationView.this.m_ContextMenuManager);
            ApplicationView.this.processRemovesIfAny(ApplicationView.this.m_ContextMenuManager);
            ApplicationView.this.m_ContextMenuManager.createMenuBar();
            JPopupMenu jPopupMenu = ApplicationView.this.m_ContextPopup.getPopupMenu();
            jPopupMenu.show(component, component.getLocation().x, component.getLocation().y);
        }

        private boolean showPopupMenu(MouseEvent mouseEvent) {
            boolean bl = mouseEvent.isPopupTrigger();
            if (bl) {
                if (ApplicationView.this.m_ContextMenuManager.getRemoveAllWhenShown()) {
                    ApplicationView.this.m_ContextMenuManager.removeAll();
                    ApplicationView.this.m_ContextPopup.removeAll();
                }
                ApplicationView.this.menuAboutToShow(ApplicationView.this.m_ContextMenuManager);
                ApplicationView.this.processRemovesIfAny(ApplicationView.this.m_ContextMenuManager);
                ApplicationView.this.m_ContextMenuManager.createMenuBar();
                JPopupMenu jPopupMenu = ApplicationView.this.m_ContextPopup.getPopupMenu();
                Component component = mouseEvent.getComponent();
                jPopupMenu.show(component, mouseEvent.getX(), mouseEvent.getY());
            } else {
                super.mousePressed(mouseEvent);
            }
            return bl;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.showPopupMenu(mouseEvent);
        }
    }
}

