/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.controls.newdialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.uml.ui.controls.newdialog.NewDialogProjectDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.NewDialogUtilities;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ProjectLocationPanel
extends JPanel
implements DocumentListener {
    private JButton browseButton;
    private ButtonGroup modelTypeButtonGroup;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private ResourceBundle bundle = NbBundle.getBundle(ProjectLocationPanel.class);

    public ProjectLocationPanel() {
        this.initComponents();
        this.projectNameTextField.setText(NewDialogUtilities.getDefaultProjectName());
        this.projectNameTextField.selectAll();
        this.projectLocationTextField.setText(NewDialogUtilities.getWorkspaceLocation());
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
    }

    public NewDialogProjectDetails getProjectDetails() {
        NewDialogProjectDetails newDialogProjectDetails = new NewDialogProjectDetails();
        newDialogProjectDetails.setName(this.projectNameTextField.getText().trim());
        newDialogProjectDetails.setLocation(this.projectLocationTextField.getText().trim());
        return newDialogProjectDetails;
    }

    private void initComponents() {
        this.modelTypeButtonGroup = new ButtonGroup();
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)this.bundle.getString("LBL_ProjectName_Label"));
        this.projectNameLabel.getAccessibleContext().setAccessibleName("");
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectName"));
        this.projectNameTextField.getAccessibleContext().setAccessibleName("");
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription("");
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)this.bundle.getString("LBL_ProjectLocation_Label"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleName("");
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSD_ProjectLocation"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleName("");
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription("");
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)this.bundle.getString("LBL_BrowseLocation_Button"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectLocationPanel.this.browseLocationAction(actionEvent);
            }
        });
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectLocationPanel.class, (String)"ACSN_browseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_browseButton"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameLabel).add((Component)this.projectLocationLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectNameTextField, -1, 274, Short.MAX_VALUE).add((Component)this.projectLocationTextField, -1, 274, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton, -2, 79, -2).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameLabel).add((Component)this.projectNameTextField, -2, -1, -2)).add(20, 20, 20).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.projectLocationLabel).add((Component)this.browseButton)).addContainerGap(37, Short.MAX_VALUE)));
    }

    private void browseLocationAction(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(this.bundle.getString("LBL_SelectProjectLocation"));
        jFileChooser.setFileSelectionMode(1);
        String string = this.projectLocationTextField.getText();
        if (string.length() > 0 && (file = new File(string)).exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            file = jFileChooser.getSelectedFile();
            this.projectLocationTextField.setText(file.getAbsolutePath());
        }
    }

    private static JFileChooser createChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setName(NbBundle.getMessage(ProjectLocationPanel.class, (String)"LBL_SelectProjectLocation"));
        return jFileChooser;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }
}

