/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.controls.newdialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.uml.common.Util;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.ElementLocator;
import org.netbeans.modules.uml.ui.controls.newdialog.AddPackageWizardPanel1;
import org.netbeans.modules.uml.ui.controls.newdialog.INewDialogPackageDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.INewUMLFileTemplates;
import org.netbeans.modules.uml.ui.controls.newdialog.NewDialogUtilities;
import org.netbeans.modules.uml.ui.swing.drawingarea.DiagramEngine;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class AddPackageVisualPanel1
extends JPanel
implements DocumentListener,
ItemListener,
INewUMLFileTemplates {
    private boolean valid = true;
    private AddPackageWizardPanel1 panel;
    private INewDialogPackageDetails mDetails = null;
    private int errorType = -1;
    static final int INVALID_PACKAGE_NAME = 0;
    static final int PACKAGE_NAME_CONFLICT = 1;
    static final int INVALID_DIAGRAME_NAME = 2;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public AddPackageVisualPanel1(AddPackageWizardPanel1 addPackageWizardPanel1) {
        this.panel = addPackageWizardPanel1;
        this.initComponents();
        this.jTextField1.getDocument().addDocumentListener(this);
        this.jTextField2.getDocument().addDocumentListener(this);
        this.jComboBox1.addItemListener(this);
        this.jCheckBox1.addItemListener(this);
    }

    public void read(WizardDescriptor wizardDescriptor) {
        this.mDetails = (INewDialogPackageDetails)wizardDescriptor.getProperty("packageDetails");
        this.populateNamespaceCombobox();
        this.populateDiagramTypeCombobox();
    }

    void store(WizardDescriptor wizardDescriptor) {
        this.mDetails.setPackageKind(1);
        this.mDetails.setName(this.getPackageName());
        INamespace iNamespace = NewDialogUtilities.getNamespace((String)this.getPackageNamespace());
        this.mDetails.setNamespace(iNamespace);
        this.mDetails.setCreateScopedDiagram(this.isCheckboxSelected());
        this.mDetails.setScopedDiagramName(this.getScopedDiagramName());
        String string = (String)this.getScopedDiagramKind();
        this.mDetails.setScopedDiagramKind(NewDialogUtilities.diagramNameToKind(string));
        wizardDescriptor.putProperty("packageDetails", (Object)this.mDetails);
    }

    public String getName() {
        return NbBundle.getBundle(AddPackageVisualPanel1.class).getString("IDS_CREATEPACKAGE");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getBundle(AddPackageVisualPanel1.class).getString("IDS_PACKAGE")));
        this.jLabel1.setLabelFor(this.jTextField1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(AddPackageVisualPanel1.class).getString("IDS_NAME"));
        this.jTextField1.setText(NewDialogUtilities.getDefaultPackageName());
        this.jTextField1.selectAll();
        this.jTextField1.requestFocus();
        this.jLabel2.setLabelFor(this.jComboBox1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getBundle(AddPackageVisualPanel1.class).getString("IDS_NAMESPACE"));
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jTextField1, -2, 309, -2).add((Component)this.jComboBox1, -2, 281, -2)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.jComboBox1, this.jTextField1}, 1);
        groupLayout.linkSize(new Component[]{this.jLabel1, this.jLabel2}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextField1, -2, -1, -2)).add(15, 15, 15).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jComboBox1, -2, -1, -2)).addContainerGap(24, Short.MAX_VALUE)));
        this.jTextField1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AddPackageVisualPanel1.class).getString("ACSD_NEW_PACKAGE_WIZARD_PACKAGENAME_TEXTFIELD"));
        this.jComboBox1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AddPackageVisualPanel1.class).getString("ACSD_NEW_PACKAGE_WIZARD_PACKAGENAMESPACE_COMBOBOX"));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getBundle(AddPackageVisualPanel1.class).getString("IDS_SCOPEDDIAGRAM")));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getBundle(AddPackageVisualPanel1.class).getString("IDS_CREATESCOPED"));
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        this.jLabel3.setLabelFor(this.jTextField2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getBundle(AddPackageVisualPanel1.class).getString("IDS_DIAGRAMNAME"));
        this.jTextField2.setText(NewDialogUtilities.getDefaultDiagramName());
        this.jTextField2.setEnabled(false);
        this.jLabel4.setLabelFor(this.jComboBox2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getBundle(AddPackageVisualPanel1.class).getString("IDS_DIAGRAMTYPE"));
        this.jComboBox2.setEnabled(false);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jLabel4)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jTextField2, -2, 295, -2).add((Component)this.jComboBox2, -2, 298, -2))).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(10, 10, 10).add((Component)this.jCheckBox1))).addContainerGap()));
        groupLayout2.linkSize(new Component[]{this.jComboBox2, this.jTextField2}, 1);
        groupLayout2.linkSize(new Component[]{this.jLabel3, this.jLabel4}, 1);
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jCheckBox1).add(14, 14, 14).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextField2, -2, -1, -2)).add(15, 15, 15).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jComboBox2, -2, -1, -2)).addContainerGap(24, Short.MAX_VALUE)));
        this.jCheckBox1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AddPackageVisualPanel1.class).getString("ACSD_NEW_PACKAGE_WIZARD_CREATESCOPEDDIAGRAM_CHECKBOX"));
        this.jTextField2.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AddPackageVisualPanel1.class).getString("ACSD_NEW_PACKAGE_WIZARD_SCOPEDDIAGRAM_NAME_TEXTFIELD"));
        this.jComboBox2.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(AddPackageVisualPanel1.class).getString("ACSD_NEW_PACKAGE_WIZARD_SCOPEDDIAGRAM_NAMESPACE_COMBOBOX"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(2).add(1, (Component)this.jPanel2, -1, 425, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addContainerGap(21, Short.MAX_VALUE)));
        this.jPanel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddPackageVisualPanel1.class, (String)"IDS_PACKAGE"));
    }

    private void populateNamespaceCombobox() {
        if (this.jComboBox1 != null) {
            INamespace iNamespace = null;
            if (this.mDetails != null) {
                iNamespace = this.mDetails.getNamespace();
            }
            NewDialogUtilities.loadNamespace(this.jComboBox1, iNamespace);
        }
    }

    private void populateDiagramTypeCombobox() {
        if (this.jComboBox2 != null) {
            NewDialogUtilities.loadDiagramTypes(this.jComboBox2);
            this.jComboBox2.setSelectedIndex(1);
        }
    }

    protected String getPackageName() {
        return this.jTextField1.getText().trim();
    }

    protected Object getPackageNamespace() {
        return this.jComboBox1.getSelectedItem();
    }

    protected String getScopedDiagramName() {
        return this.jTextField2.getText().trim();
    }

    protected Object getScopedDiagramKind() {
        return this.jComboBox2.getSelectedItem();
    }

    protected int getScopedDiagramType() {
        return this.jComboBox2.getSelectedIndex();
    }

    protected boolean isCheckboxSelected() {
        return this.jCheckBox1.isSelected();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.valid = true;
        if (itemEvent.getSource() == this.jCheckBox1) {
            this.jTextField2.setEnabled(this.jCheckBox1.isSelected());
            this.jComboBox2.setEnabled(this.jCheckBox1.isSelected());
            if (this.jCheckBox1.isSelected()) {
                this.jTextField2.selectAll();
                this.jTextField2.requestFocus();
                this.validateDiagramName();
            }
            if (this.valid) {
                this.validatePackageName();
            }
        } else if (itemEvent.getSource() == this.jComboBox1) {
            this.validatePackageName();
        }
        if (this.panel != null) {
            this.panel.fireChangeEvent();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.update(documentEvent);
    }

    private void update(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.jTextField1.getDocument()) {
            this.validatePackageName();
            if (this.jCheckBox1.isEnabled() && this.jCheckBox1.isSelected()) {
                this.validateDiagramName();
            }
        } else {
            this.validateDiagramName();
        }
        if (this.panel != null) {
            this.panel.fireChangeEvent();
        }
    }

    private void validatePackageName() {
        this.valid = true;
        if (this.getPackageName().length() == 0) {
            this.errorType = 0;
            this.valid = false;
        } else {
            ElementLocator elementLocator = new ElementLocator();
            String string = (String)this.getPackageNamespace();
            INamespace iNamespace = NewDialogUtilities.getNamespace(string);
            ETList<INamedElement> eTList = elementLocator.findByName(iNamespace, this.getPackageName());
            if (eTList != null) {
                int n = eTList.getCount();
                for (int i = 0; i < n; ++i) {
                    INamedElement iNamedElement = (INamedElement)eTList.get(i);
                    if (iNamedElement == null || !iNamedElement.getElementType().equals("Package")) continue;
                    this.errorType = 1;
                    this.valid = false;
                }
            }
        }
        this.jCheckBox1.setEnabled(this.valid);
        this.jTextField2.setEnabled(this.jCheckBox1.isEnabled() && this.jCheckBox1.isSelected());
        this.jComboBox2.setEnabled(this.jCheckBox1.isEnabled() && this.jCheckBox1.isSelected());
    }

    private void validateDiagramName() {
        this.valid = true;
        if (!Util.isDiagramNameValid(this.getScopedDiagramName())) {
            this.valid = false;
            this.errorType = 2;
        }
    }

    public boolean isValid(WizardDescriptor wizardDescriptor) {
        String string = "";
        if (!this.valid) {
            switch (this.errorType) {
                case 0: {
                    string = NbBundle.getMessage(AddPackageVisualPanel1.class, (String)"MSG_Invalid_Package_Name");
                    break;
                }
                case 1: {
                    string = NbBundle.getMessage(DiagramEngine.class, (String)"IDS_NAMESPACECOLLISION");
                    break;
                }
                case 2: {
                    string = NbBundle.getMessage(AddPackageVisualPanel1.class, (String)"MSG_Invalid_Diagram_Name", (Object)this.getScopedDiagramName());
                }
            }
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        return this.valid;
    }
}

