/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.addins.diagramcreator;

import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphManager;
import java.util.Vector;
import org.netbeans.modules.uml.core.eventframework.EventBlocker;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.ICoreRelationshipDiscovery;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.infrastructure.IStructuredClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IInterface;
import org.netbeans.modules.uml.core.metamodel.structure.IArtifact;
import org.netbeans.modules.uml.core.metamodel.structure.IComponent;
import org.netbeans.modules.uml.core.support.umlmessagingcore.ThermCtrl;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.addins.diagramcreator.DiagCreatorAddIn;
import org.netbeans.modules.uml.ui.addins.diagramcreator.GenealogyTree;
import org.netbeans.modules.uml.ui.addins.diagramcreator.IComponentDiagramCreator;
import org.netbeans.modules.uml.ui.controls.drawingarea.AutoRoutingAction;
import org.netbeans.modules.uml.ui.controls.drawingarea.IUIDiagram;
import org.netbeans.modules.uml.ui.controls.drawingarea.TopographyChangeAction;
import org.netbeans.modules.uml.ui.products.ad.diagramengines.IADRelationshipDiscovery;
import org.netbeans.modules.uml.ui.products.ad.drawengines.IComponentDrawEngine;
import org.netbeans.modules.uml.ui.support.ThermProgress;
import org.netbeans.modules.uml.ui.support.applicationmanager.INodePresentation;
import org.netbeans.modules.uml.ui.support.helpers.GUIBlocker;
import org.netbeans.modules.uml.ui.support.umltsconversions.RectConversions;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDiagramEngine;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDiagramCreator
implements IComponentDiagramCreator {
    @Override
    public boolean generate(ETList<IElement> eTList, IDiagram iDiagram) {
        boolean bl = true;
        if (eTList != null) {
            int n = eTList.size();
            Vector<IComponent> vector = new Vector<IComponent>();
            Vector<IInterface> vector2 = new Vector<IInterface>();
            for (int i = 0; i < n; ++i) {
                boolean bl2 = false;
                IElement iElement = (IElement)eTList.get(i);
                String string = iElement.getElementType();
                if (string != null) {
                    if (string.equals("Port")) {
                        bl2 = true;
                    } else if (string.equals("Component")) {
                        if (iElement instanceof IComponent) {
                            vector.add((IComponent)iElement);
                            bl2 = true;
                        }
                    } else if (string.equals("Interface") && iElement instanceof IInterface) {
                        vector2.add((IInterface)iElement);
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                eTList.remove(i);
                n = eTList.size();
                --i;
            }
            this.createComponentDiagram(iDiagram, eTList, vector, vector2);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createComponentDiagram(IDiagram iDiagram, ETList<IElement> eTList, Vector<IComponent> vector, Vector<IInterface> vector2) {
        if (null == iDiagram) {
            throw new IllegalArgumentException();
        }
        if (null == eTList) {
            throw new IllegalArgumentException();
        }
        ICoreRelationshipDiscovery iCoreRelationshipDiscovery = TypeConversions.getRelationshipDiscovery(iDiagram);
        if (iCoreRelationshipDiscovery instanceof IADRelationshipDiscovery) {
            IADRelationshipDiscovery iADRelationshipDiscovery = (IADRelationshipDiscovery)iCoreRelationshipDiscovery;
            GUIBlocker gUIBlocker = new GUIBlocker(2048);
            try {
                Object object;
                int n = eTList.size();
                if (n > 0) {
                    ThermProgress thermProgress = new ThermProgress();
                    object = this.loadString("IDS_CREATING_PES");
                    thermProgress.beginProgress((String)object, 0, n, 0);
                    for (int i = 0; i < n; ++i) {
                        IElement iElement = (IElement)eTList.get(i);
                        IPresentationElement iPresentationElement = iADRelationshipDiscovery.createPresentationElement(iElement);
                        thermProgress.setPos(i);
                    }
                }
                boolean bl = EventBlocker.startBlocking();
                try {
                    if (vector != null) {
                        for (IComponent iComponent : vector) {
                            this.createComponentPresentationElement(iDiagram, iADRelationshipDiscovery, iComponent, vector2);
                        }
                    }
                }
                finally {
                    EventBlocker.stopBlocking(bl);
                }
                bl = EventBlocker.startBlocking();
                try {
                    if (vector2 != null) {
                        for (IInterface iInterface : vector2) {
                            iADRelationshipDiscovery.createPresentationElement(iInterface);
                        }
                    }
                }
                finally {
                    EventBlocker.stopBlocking(bl);
                }
                IDiagramEngine iDiagramEngine = TypeConversions.getDiagramEngine(iDiagram);
                if (iDiagramEngine != null) {
                    object = iDiagram.getAllItems3();
                    ETList<IPresentationElement> eTList2 = iADRelationshipDiscovery.discoverCommonRelations(false, (ETList<IElement>)object, null);
                }
            }
            finally {
                if (gUIBlocker != null) {
                    gUIBlocker.clearBlockers();
                }
            }
        }
    }

    private void createComponentPresentationElement(IDiagram iDiagram, IADRelationshipDiscovery iADRelationshipDiscovery, IComponent iComponent, Vector<IInterface> vector) {
        ETList<IPresentationElement> eTList;
        IPresentationElement iPresentationElement = iADRelationshipDiscovery.createPresentationElement(iComponent);
        if (iPresentationElement != null && (eTList = iADRelationshipDiscovery.createPortPresentationElements(iPresentationElement)) != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IPresentationElement iPresentationElement2 = (IPresentationElement)eTList.get(i);
                this.createPortInterfaces(iADRelationshipDiscovery, iPresentationElement2, vector);
            }
        }
    }

    private void createPortInterfaces(IADRelationshipDiscovery iADRelationshipDiscovery, IPresentationElement iPresentationElement, Vector<IInterface> vector) {
        ETList<IPresentationElement> eTList = iADRelationshipDiscovery.createPortProvidedAndRequiredInterfaces(iPresentationElement);
        if (eTList != null && vector != null) {
            int n = eTList.size();
            block0: for (int i = 0; i < n; ++i) {
                IPresentationElement iPresentationElement2 = (IPresentationElement)eTList.get(i);
                IElement iElement = TypeConversions.getElement(iPresentationElement2);
                if (iElement == null) continue;
                int n2 = vector.size();
                for (int j = 0; j < n2; ++j) {
                    IInterface iInterface = vector.get(j);
                    if (!iInterface.isSame(iElement)) continue;
                    vector.remove(j);
                    continue block0;
                }
            }
        }
    }

    @Override
    public long performLayout(IDiagram iDiagram) {
        if (iDiagram != null) {
            ETList<IPresentationElement> eTList;
            IDrawingAreaControl iDrawingAreaControl;
            int n = iDiagram.getLayoutStyle();
            if (iDiagram instanceof IUIDiagram && (iDrawingAreaControl = ((IUIDiagram)iDiagram).getDrawingArea()) != null && (eTList = iDrawingAreaControl.getAllItems()) != null) {
                AutoRoutingAction autoRoutingAction = new AutoRoutingAction();
                autoRoutingAction.forceAutoRoutingStyle(2);
                this.moveNodesSoNothingIsContained(iDrawingAreaControl, eTList);
                GenealogyTree genealogyTree = new GenealogyTree();
                int n2 = eTList.size();
                String string = this.loadString("IDS_PERFORMING_COMPONENT_LAYOUT");
                ThermCtrl thermCtrl = new ThermCtrl(string, n2);
                for (int i = 0; i < n2; ++i) {
                    IPresentationElement iPresentationElement = (IPresentationElement)eTList.get(i);
                    if (!(iPresentationElement instanceof INodePresentation)) continue;
                    INodePresentation iNodePresentation = (INodePresentation)iPresentationElement;
                    IElement iElement = TypeConversions.getElement(iNodePresentation);
                    if (iElement != null) {
                        IDrawEngine iDrawEngine;
                        if (iElement instanceof IComponent && (iDrawEngine = TypeConversions.getDrawEngine(iNodePresentation)) != null && iDrawEngine instanceof IComponentDrawEngine) {
                            ((IComponentDrawEngine)iDrawEngine).movePortsToSide(0);
                        }
                        if (iElement instanceof IComponent || iElement instanceof IStructuredClassifier || iElement instanceof IArtifact) {
                            genealogyTree.addUndeterminedNode(iNodePresentation);
                        }
                    }
                    thermCtrl.update(string, i);
                }
                genealogyTree.onGraphEvent(5, this.loadString("IDS_HIDING_PORTS"));
                genealogyTree.buildGenealogy(iDrawingAreaControl);
                this.processContainerGenealogy(iDrawingAreaControl, genealogyTree);
                genealogyTree.setStackingOrder();
                genealogyTree.onGraphEvent(6, this.loadString("IDS_SHOWING_PORTS"));
                genealogyTree.distributeAllComponentPorts();
                TopographyChangeAction topographyChangeAction = new TopographyChangeAction();
                topographyChangeAction.setKind(5);
                topographyChangeAction.setLayoutStyle(true, true, n);
                iDrawingAreaControl.postDelayedAction(topographyChangeAction);
                iDrawingAreaControl.pumpMessages(false);
                autoRoutingAction.endForce();
            }
        }
        return 0L;
    }

    private void processContainerGenealogy(IDrawingAreaControl iDrawingAreaControl, GenealogyTree genealogyTree) {
        TSEGraph tSEGraph;
        TSConstRect tSConstRect;
        TSGraph tSGraph;
        TSGraphManager tSGraphManager;
        if (iDrawingAreaControl != null && (tSGraphManager = iDrawingAreaControl.getCurrentGraphManager()) != null && (tSGraph = tSGraphManager.getOwnerGraph()) instanceof TSEGraph && (tSConstRect = (tSEGraph = (TSEGraph)tSGraph).getUI().getBounds()) != null) {
            IETRect iETRect = RectConversions.newETRect(tSConstRect);
            genealogyTree.calculateRectangles(iETRect);
            genealogyTree.placeNodes();
        }
    }

    private void moveNodesSoNothingIsContained(IDrawingAreaControl iDrawingAreaControl, ETList<IPresentationElement> eTList) {
        if (iDrawingAreaControl != null && eTList != null) {
            iDrawingAreaControl.pumpMessages(false);
            int n = eTList.size();
            int n2 = 0;
            int n3 = 10;
            for (int i = 0; i < n; ++i) {
                IPresentationElement iPresentationElement = (IPresentationElement)eTList.get(i);
                if (!(iPresentationElement instanceof INodePresentation)) continue;
                INodePresentation iNodePresentation = (INodePresentation)iPresentationElement;
                IETRect iETRect = TypeConversions.getLogicalBoundingRect(iNodePresentation);
                n2 = (int)((double)n2 + (iETRect.getHeight() / 2.0 + (double)n3));
                iETRect.setLeft(0);
                iETRect.setTop((int)((double)n2 - iETRect.getCenterY()));
                iNodePresentation.moveTo(iETRect.getIntX(), iETRect.getIntY(), 0);
                n2 = (int)((double)n2 + (iETRect.getHeight() / 2.0 + (double)n3));
            }
        }
    }

    private String loadString(String string) {
        return DiagCreatorAddIn.loadString(string);
    }
}

