/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.workspacemanagement;

import org.dom4j.Document;
import org.netbeans.modules.uml.core.eventframework.EventBlocker;
import org.netbeans.modules.uml.core.support.umlsupport.Validator;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.core.support.umlutils.InvalidArguments;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspaceEventDispatcher;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspaceManager;
import org.netbeans.modules.uml.core.workspacemanagement.WorkspaceEventDispatchHelper;
import org.netbeans.modules.uml.core.workspacemanagement.WorkspaceImpl;
import org.netbeans.modules.uml.core.workspacemanagement.WorkspaceManagementException;
import org.netbeans.modules.uml.core.workspacemanagement.WorkspaceMessages;

public class WorkspaceManager
implements IWorkspaceManager {
    private IWorkspaceEventDispatcher m_Dispatcher = null;

    public IWorkspace createWorkspace(String string, String string2) throws InvalidArguments, WorkspaceManagementException {
        IWorkspace iWorkspace = null;
        WorkspaceManager.validatePath(string);
        WorkspaceManager.validateName(string2);
        String string3 = WorkspaceMessages.getString("WORKSPACE_HEADER");
        Document document = XMLManip.loadXML(string3);
        if (document.getRootElement() != null) {
            WorkspaceEventDispatchHelper workspaceEventDispatchHelper = new WorkspaceEventDispatchHelper();
            workspaceEventDispatchHelper.setEventDispatcher(this.m_Dispatcher);
            boolean bl = workspaceEventDispatchHelper.dispatchWorkspacePreCreate(string, string2);
            if (bl && (iWorkspace = this.establishNewWorkspace(document, string2, string, false)) != null) {
                iWorkspace.setIsDirty(true);
                iWorkspace.save(string);
                workspaceEventDispatchHelper.dispatchWorkspaceCreated(iWorkspace);
            }
        }
        return iWorkspace;
    }

    public IWorkspace openWorkspace(String string) throws InvalidArguments, WorkspaceManagementException {
        IWorkspace iWorkspace = null;
        Document document = this.verifyFileFormat(string);
        WorkspaceEventDispatchHelper workspaceEventDispatchHelper = new WorkspaceEventDispatchHelper();
        workspaceEventDispatchHelper.setEventDispatcher(this.m_Dispatcher);
        boolean bl = workspaceEventDispatchHelper.dispatchWorkspacePreOpen(string);
        if (bl && (iWorkspace = this.establishNewWorkspace(document, null, string, true)) != null) {
            workspaceEventDispatchHelper.dispatchWorkspaceOpened(iWorkspace);
        }
        return iWorkspace;
    }

    public void collapseWorkspace(IWorkspace iWorkspace) {
    }

    public IWorkspace expandWorkspace(String string) {
        return null;
    }

    public IWorkspaceEventDispatcher getEventDispatcher() {
        return this.m_Dispatcher;
    }

    public void setEventDispatcher(IWorkspaceEventDispatcher iWorkspaceEventDispatcher) {
        this.m_Dispatcher = iWorkspaceEventDispatcher;
    }

    public void closeWorkspace(IWorkspace iWorkspace, String string, boolean bl) throws InvalidArguments, WorkspaceManagementException {
        IWorkspaceEventDispatcher iWorkspaceEventDispatcher = this.getEventDispatcher();
        WorkspaceEventDispatchHelper workspaceEventDispatchHelper = new WorkspaceEventDispatchHelper();
        workspaceEventDispatchHelper.setEventDispatcher(iWorkspaceEventDispatcher);
        boolean bl2 = workspaceEventDispatchHelper.dispatchWorkspacePreClose(iWorkspace);
        if (bl2) {
            iWorkspace.closeAllProjects(bl);
            if (bl) {
                iWorkspace.save(string);
            }
            iWorkspace.setOpen(false);
            workspaceEventDispatchHelper.dispatchWorkspaceClosed(iWorkspace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IWorkspace establishNewWorkspace(Document document, String string, String string2, boolean bl) throws WorkspaceManagementException {
        WorkspaceImpl workspaceImpl = null;
        boolean bl2 = EventBlocker.startBlocking();
        try {
            workspaceImpl = new WorkspaceImpl();
            workspaceImpl.setDocument(document);
            workspaceImpl.setLocation(string2);
            if (!bl) {
                workspaceImpl.setName(string);
            }
            workspaceImpl.setEventDispatcher(this.m_Dispatcher);
            workspaceImpl.setOpen(true);
            workspaceImpl.setIsDirty(false);
        }
        finally {
            EventBlocker.stopBlocking(bl2);
        }
        return workspaceImpl;
    }

    protected Document verifyFileFormat(String string) {
        return Validator.verifyXMLFileFormat(string, "EMBT:Workspace");
    }

    public static void validatePath(String string) throws WorkspaceManagementException {
        if (!Validator.validatePath(string)) {
            throw new WorkspaceManagementException(WorkspaceMessages.getString("BAD_LOCATION"));
        }
    }

    protected static void validateName(String string) throws WorkspaceManagementException {
        if (string.length() <= 0) {
            throw new WorkspaceManagementException(WorkspaceMessages.getString("BAD_NAME"));
        }
    }
}

