/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.workspacemanagement;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.core.eventframework.EventBlocker;
import org.netbeans.modules.uml.core.eventframework.EventState;
import org.netbeans.modules.uml.core.eventframework.IEventDispatcher;
import org.netbeans.modules.uml.core.eventframework.IEventPayload;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.InvalidArguments;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProject;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProjectEventDispatcher;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspaceEventDispatcher;
import org.netbeans.modules.uml.core.workspacemanagement.WSProjectEventDispatcher;
import org.netbeans.modules.uml.core.workspacemanagement.WSProjectImpl;
import org.netbeans.modules.uml.core.workspacemanagement.WorkspaceManagementException;
import org.netbeans.modules.uml.core.workspacemanagement.WorkspaceManager;
import org.netbeans.modules.uml.core.workspacemanagement.WorkspaceMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceImpl
extends WSProjectImpl
implements IWorkspace {
    private Document m_Document = null;
    private ArrayList<IWSProject> m_Projects = new ArrayList();

    @Override
    public IWSProject createWSProject(String string, String string2) throws WorkspaceManagementException {
        Element element;
        IWSProject iWSProject = null;
        EventState eventState = new EventState((IEventDispatcher)this.getEventDispatcher(), "WSProjectEvents");
        this.validateWSProjectCreation(string, string2);
        if (this.dispatchWSProjectPreCreate(string2) && this.getDocument() != null && (element = XMLManip.createElement(this.getRootElement(), "EMBT:WSProject")) != null && (iWSProject = this.createProject(element, string2)) != null) {
            iWSProject.setOpen(true);
            iWSProject.setBaseDirectory(string);
            this.dispatchWSProjectCreate(iWSProject);
            this.m_IsDirty = true;
        }
        eventState.existState();
        return iWSProject;
    }

    @Override
    public String getBaseDirectory() {
        try {
            int n;
            String string = this.getLocation();
            if (string != null && string.length() > 0 && (n = string.lastIndexOf(File.separator)) >= 0) {
                return string.substring(0, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ETList<IWSProject> getWSProjects() throws WorkspaceManagementException {
        ETArrayList<IWSProject> eTArrayList = new ETArrayList<IWSProject>();
        this.validateDocument();
        Document document = this.getDocument();
        List list = document.getRootElement().selectNodes("//EMBT:WSProject");
        boolean bl = this.isDirty();
        boolean bl2 = EventBlocker.startBlocking();
        try {
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof Element)) continue;
                Element element = (Element)list.get(i);
                String string = XMLManip.getAttributeValue((Node)element, "name");
                eTArrayList.add(this.createProject(element, string, true, false));
            }
            if (!bl) {
                this.setIsDirty(bl);
            }
        }
        finally {
            EventBlocker.stopBlocking(bl2);
        }
        return eTArrayList;
    }

    @Override
    public IWSProject getWSProjectByName(String string) {
        return this.getWSProjectByName(string, true);
    }

    @Override
    public Document getDocument() {
        return this.m_Document;
    }

    @Override
    public void setDocument(Document document) throws WorkspaceManagementException {
        this.m_Document = document;
        Element element = this.getRootElement();
        this.setElement(element);
        this.resetState();
    }

    @Override
    public void setLocation(String string) {
        try {
            this.validatePath(string);
            Element element = this.getRootElement();
            this.setAttributeValue("fileName", string);
            this.m_IsDirty = true;
        }
        catch (WorkspaceManagementException workspaceManagementException) {
            workspaceManagementException.printStackTrace();
        }
    }

    @Override
    public String getLocation() {
        String string = "";
        try {
            Element element = this.getRootElement();
            if (element != null) {
                string = XMLManip.getAttributeValue((Node)element, "fileName");
            }
        }
        catch (WorkspaceManagementException workspaceManagementException) {
            workspaceManagementException.printStackTrace();
        }
        return string;
    }

    @Override
    public IWSProject openWSProjectByName(String string) throws WorkspaceManagementException {
        IWSProject iWSProject = this.getWSProjectByName(string, true);
        if (iWSProject != null) {
            this.ensureWSProjectIsOpen(iWSProject);
        }
        return iWSProject;
    }

    @Override
    public IWSProject openWSProjectByLocation(String string) throws WorkspaceManagementException {
        IWSProject iWSProject = null;
        if (string != null && string.length() > 0 && (iWSProject = this.getWSProjectByLocation(string)) != null) {
            this.ensureWSProjectIsOpen(iWSProject);
        }
        return iWSProject;
    }

    private IWSProject getWSProjectByLocation(String string) {
        IWSProject iWSProject = null;
        try {
            if (this.m_Element != null && string.length() > 0) {
                String string2 = string.toLowerCase();
                String string3 = this.retrievePathRelativeToWorkspace(string);
                if (string3.length() > 0) {
                    String string4;
                    XMLManip.checkForIllegals(string3);
                    String string5 = StringUtilities.splice(string3, "\\", "/");
                    String string6 = ".//EMBT:WSElement[@href='";
                    string6 = string6 + string5;
                    string6 = string6 + "']/parent::*";
                    Node node = this.m_Element.selectSingleNode(string6);
                    if (node != null && (string4 = XMLManip.getAttributeValue(node, "name")) != null && string4.length() > 0) {
                        iWSProject = this.getWSProjectByName(string4, true);
                    }
                }
            }
        }
        catch (WorkspaceManagementException workspaceManagementException) {
            // empty catch block
        }
        return iWSProject;
    }

    @Override
    public void closeWSProjectByName(String string, boolean bl) throws WorkspaceManagementException {
        IWSProject iWSProject;
        if (string.length() > 0 && (iWSProject = this.getWSProjectByName(string, false)) != null) {
            iWSProject.close(bl);
        }
    }

    @Override
    public void closeAllProjects(boolean bl) {
        if (!this.m_Projects.isEmpty()) {
            for (IWSProject iWSProject : this.m_Projects) {
                try {
                    iWSProject.close(bl);
                }
                catch (WorkspaceManagementException workspaceManagementException) {}
            }
            this.m_Projects.clear();
        }
    }

    @Override
    public void removeWSProjectByName(String string) throws WorkspaceManagementException {
        if (string.length() > 0) {
            this.validateDocument();
            IWSProject iWSProject = this.getWSProjectByName(string, true);
            EventState eventState = new EventState((IEventDispatcher)this.getEventDispatcher(), "WSProjectEvents");
            IWSProjectEventDispatcher iWSProjectEventDispatcher = this.prepareWSProjectDispatcher();
            try {
                Element element;
                if (iWSProjectEventDispatcher.dispatchWSProjectPreRemove(iWSProject) && (element = iWSProject.getElement()) != null) {
                    Element element2 = this.getRootElement();
                    element2.remove(element);
                    this.removeProject(iWSProject);
                    iWSProjectEventDispatcher.dispatchWSProjectRemoved(iWSProject);
                }
            }
            catch (InvalidArguments invalidArguments) {
                throw new WorkspaceManagementException(invalidArguments);
            }
            eventState.existState();
        }
    }

    @Override
    public void removeWSProject(IWSProject iWSProject) throws WorkspaceManagementException {
        if (iWSProject != null) {
            this.removeWSProjectByName(iWSProject.getName());
        }
    }

    @Override
    public boolean verifyUniqueElementLocation(String string) throws WorkspaceManagementException {
        boolean bl = string.length() > 0;
        ETList<IWSProject> eTList = this.getWSProjects();
        if (string.length() > 0 && eTList != null) {
            for (int i = 0; i < eTList.size() && bl; ++i) {
                bl = ((IWSProject)eTList.get(i)).verifyUniqueLocation(string);
            }
        }
        return bl;
    }

    @Override
    public boolean removeWSElementByLocation(String string) throws WorkspaceManagementException {
        boolean bl = false;
        if (string.length() > 0) {
            Iterator<IWSProject> iterator = this.m_Projects.iterator();
            while (iterator.hasNext() && !bl) {
                IWSProject iWSProject = iterator.next();
                if (iWSProject == null) continue;
                bl = iWSProject.removeElementByLocation(string);
            }
        }
        return bl;
    }

    @Override
    public IWSProject openWSProjectByData(String string) throws WorkspaceManagementException {
        IWSProject iWSProject = null;
        if (string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer("//EMBT:WSElement[@data='");
            stringBuffer.append(string);
            stringBuffer.append("']/parent::*");
            ETSystem.out.println(this.getDocument().asXML());
            ETSystem.out.println(stringBuffer.toString());
            Node node = XMLManip.selectSingleNode((Node)this.m_Document, stringBuffer.toString());
            String string2 = XMLManip.getAttributeValue(node, "name");
            iWSProject = this.openWSProjectByName(string2);
        }
        return iWSProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String string) throws WorkspaceManagementException {
        this.validateDocument();
        if (this.isDirty()) {
            String string2 = string;
            if (string2 == null || string2.length() <= 0) {
                string2 = this.getLocation();
            }
            if (this.validatePath(string2)) {
                block12: {
                    Element element = this.getRootElement();
                    IWorkspaceEventDispatcher iWorkspaceEventDispatcher = this.getEventDispatcher();
                    EventState eventState = new EventState((IEventDispatcher)iWorkspaceEventDispatcher, "WorkspaceEvents");
                    try {
                        boolean bl = this.dispatchWorkspacePreSave(string2);
                        if (!bl) break block12;
                        boolean bl2 = EventBlocker.startBlocking(iWorkspaceEventDispatcher);
                        try {
                            super.save(string2);
                        }
                        finally {
                            EventBlocker.stopBlocking(bl2, iWorkspaceEventDispatcher);
                        }
                        for (IWSProject iWSProject : this.m_Projects) {
                            iWSProject.save();
                        }
                        Attribute attribute = element.attribute("fileName");
                        if (attribute != null) {
                            element.remove(attribute);
                        }
                        boolean bl3 = XMLManip.save(this.getDocument(), string2);
                        XMLManip.setAttributeValue(element, "fileName", string2);
                        if (!bl3) {
                            throw new WorkspaceManagementException();
                        }
                        this.dispatchWorkspaceSaved(this);
                    }
                    finally {
                        eventState.existState();
                    }
                }
                this.m_IsDirty = false;
            }
        }
    }

    protected void dispatchWorkspaceSaved(IWorkspace iWorkspace) {
        try {
            IWorkspaceEventDispatcher iWorkspaceEventDispatcher = this.getEventDispatcher();
            IEventPayload iEventPayload = iWorkspaceEventDispatcher.createPayload("WorkspaceSaved");
            iWorkspaceEventDispatcher.fireWorkspaceSaved(iWorkspace, iEventPayload);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private boolean dispatchWorkspacePreSave(String string) {
        boolean bl = true;
        IWorkspaceEventDispatcher iWorkspaceEventDispatcher = this.getEventDispatcher();
        if (iWorkspaceEventDispatcher != null) {
            IEventPayload iEventPayload = iWorkspaceEventDispatcher.createPayload("WorkspacePreSave");
            bl = iWorkspaceEventDispatcher.fireWorkspacePreSave(string, iEventPayload);
        }
        return bl;
    }

    private boolean validatePath(String string) {
        boolean bl = true;
        try {
            WorkspaceManager.validatePath(string);
        }
        catch (WorkspaceManagementException workspaceManagementException) {
            bl = false;
        }
        return bl;
    }

    protected Element getRootElement() throws WorkspaceManagementException {
        Element element = null;
        this.validateDocument();
        element = this.m_Document.getRootElement();
        if (element == null) {
            throw new WorkspaceManagementException(WorkspaceMessages.getString("WORKSPACE_CORRUPTED"));
        }
        return element;
    }

    private void validateDocument() throws WorkspaceManagementException {
        if (this.m_Document == null) {
            throw new WorkspaceManagementException(WorkspaceMessages.getString("NO_DATASOURCE"));
        }
    }

    private void resetState() {
        this.m_Projects.clear();
        this.setIsDirty(false);
    }

    protected boolean dispatchWSProjectPreCreate(String string) {
        boolean bl = true;
        try {
            IWSProjectEventDispatcher iWSProjectEventDispatcher = this.prepareWSProjectDispatcher();
            IResultCell iResultCell = iWSProjectEventDispatcher.dispatchWSProjectPreCreate(this, string);
            if (iResultCell != null) {
                bl = iResultCell.canContinue();
            }
        }
        catch (InvalidArguments invalidArguments) {
            invalidArguments.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            bl = true;
        }
        return bl;
    }

    protected void dispatchWSProjectCreate(IWSProject iWSProject) {
        try {
            IWSProjectEventDispatcher iWSProjectEventDispatcher = this.prepareWSProjectDispatcher();
            iWSProjectEventDispatcher.dispatchWSProjectCreated(iWSProject);
        }
        catch (InvalidArguments invalidArguments) {
            invalidArguments.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private IWSProjectEventDispatcher prepareWSProjectDispatcher() {
        WSProjectEventDispatcher wSProjectEventDispatcher = new WSProjectEventDispatcher();
        wSProjectEventDispatcher.setEventDispatcher(this.getEventDispatcher());
        return wSProjectEventDispatcher;
    }

    protected void validateWSProjectCreation(String string, String string2) throws WorkspaceManagementException {
        this.validateDocument();
        WorkspaceManager.validateName(string2);
        WorkspaceManager.validatePath(string);
        this.verifyUniqueProject(string2);
    }

    protected void verifyUniqueProject(String string) throws WorkspaceManagementException {
        List list;
        StringBuffer stringBuffer = new StringBuffer("//WSProject[@name=\"");
        stringBuffer.append(string);
        stringBuffer.append("\"]");
        Document document = this.getDocument();
        if (document != null && (list = document.selectNodes(stringBuffer.toString())).size() > 0) {
            throw new WorkspaceManagementException(WorkspaceMessages.getString("PROJECT_EXISTS"));
        }
    }

    protected IWSProject createProject(Element element, String string) {
        return this.createProject(element, string, true);
    }

    protected IWSProject createProject(Element element, String string, boolean bl) {
        return this.createProject(element, string, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IWSProject createProject(Element element, String string, boolean bl, boolean bl2) {
        IWSProject iWSProject = this.findProjectByName(this.m_Projects, string);
        if (iWSProject == null) {
            WSProjectImpl wSProjectImpl = new WSProjectImpl();
            wSProjectImpl.setElement(element);
            wSProjectImpl.setOwner(this);
            if (string != null && string.length() > 0) {
                boolean bl3 = EventBlocker.startBlocking();
                try {
                    wSProjectImpl.setName(string);
                }
                finally {
                    EventBlocker.stopBlocking(bl3);
                }
                if (!bl2) {
                    wSProjectImpl.setIsDirty(false);
                }
            }
            iWSProject = bl ? this.addProject(wSProjectImpl) : wSProjectImpl;
        }
        return iWSProject;
    }

    private IWSProject addProject(IWSProject iWSProject) {
        IWSProject iWSProject2 = iWSProject;
        if (this.m_Projects.size() > 0) {
            String string = iWSProject.getName();
            for (IWSProject iWSProject3 : this.m_Projects) {
                if (iWSProject3 == null || string == null || !string.equals(iWSProject3.getName())) continue;
                iWSProject2 = iWSProject3;
                break;
            }
        }
        if (iWSProject2 == iWSProject) {
            this.m_Projects.add(iWSProject2);
        }
        return iWSProject2;
    }

    private IWSProject findProjectByName(ArrayList arrayList, String string) {
        IWSProject iWSProject = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && iWSProject == null) {
            IWSProject iWSProject2 = (IWSProject)iterator.next();
            if (!string.equals(iWSProject2.getName())) continue;
            iWSProject = iWSProject2;
        }
        return iWSProject;
    }

    public IWSProject getWSProjectByName(String string, boolean bl) {
        IWSProject iWSProject = null;
        if (string.length() > 0) {
            if (this.m_Projects.size() > 0) {
                iWSProject = this.findProjectByName(this.m_Projects, string);
            }
            if (iWSProject == null && bl) {
                StringBuffer stringBuffer = new StringBuffer("//EMBT:WSProject[@name=\"");
                stringBuffer.append(string);
                stringBuffer.append("\"]");
                Node node = XMLManip.selectSingleNode((Node)this.getDocument(), stringBuffer.toString());
                if (node instanceof Element) {
                    iWSProject = this.createProject((Element)node, string);
                }
            }
        }
        return iWSProject;
    }

    private void ensureWSProjectIsOpen(IWSProject iWSProject) throws WorkspaceManagementException {
        if (iWSProject != null && !iWSProject.isOpen()) {
            iWSProject.open();
        }
    }

    @Override
    protected boolean isWorkspace() {
        return true;
    }

    @Override
    public boolean isDirty() {
        boolean bl = false;
        if (!this.m_IsDirty) {
            if (this.m_Projects != null) {
                IWSProject iWSProject;
                int n = this.m_Projects.size();
                for (int i = 0; i < n && !(bl = (iWSProject = this.m_Projects.get(i)).isDirty()); ++i) {
                }
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private void removeProject(IWSProject iWSProject) {
        if (!this.m_Projects.isEmpty()) {
            this.m_Projects.remove(iWSProject);
            this.m_IsDirty = true;
        }
    }
}

