/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.typemanagement;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.IDResolver;
import org.dom4j.Node;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.IApplication;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.eventframework.EventDispatchNameKeeper;
import org.netbeans.modules.uml.core.eventframework.EventDispatchRetriever;
import org.netbeans.modules.uml.core.metamodel.core.foundation.ElementCollector;
import org.netbeans.modules.uml.core.metamodel.core.foundation.ExternalFileManager;
import org.netbeans.modules.uml.core.metamodel.core.foundation.FactoryRetriever;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElementChangeEventDispatcher;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElementLifeTimeEventDispatcher;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElementLifeTimeEventsSink;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IExternalElementEventsSink;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElementEventsSink;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespaceModifiedEventsSink;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IVersionableElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.TypedFactoryRetriever;
import org.netbeans.modules.uml.core.metamodel.core.foundation.UMLXMLManip;
import org.netbeans.modules.uml.core.metamodel.infrastructure.IPart;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.FileManip;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;
import org.netbeans.modules.uml.core.support.umlsupport.IStrings;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.core.support.umlsupport.PathManip;
import org.netbeans.modules.uml.core.support.umlsupport.PreventReEntrance;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlsupport.Strings;
import org.netbeans.modules.uml.core.support.umlsupport.URILocator;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.typemanagement.IPickListManager;
import org.netbeans.modules.uml.core.typemanagement.ITypeManager;
import org.netbeans.modules.uml.core.typemanagement.PickListManager;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProject;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.netbeans.modules.uml.core.workspacemanagement.WorkspaceManagementException;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeManager
implements ITypeManager,
IElementLifeTimeEventsSink,
INamedElementEventsSink,
INamespaceModifiedEventsSink,
IExternalElementEventsSink {
    private static final String IDR_TYPE_XML = "type_fil.htm";
    private IProject m_Project;
    private Document m_Doc;
    private IPickListManager m_rawPickManager;
    private IElementChangeEventDispatcher m_Dispatcher;
    private IElementLifeTimeEventDispatcher m_LifeTimeDispatcher;
    private String m_ProjectID;
    private String m_ProjectFileName;
    private State m_State = null;
    private HashSet<String> m_DeletedCache = new HashSet();
    private HashSet<String> m_UnresolvedIDs = new HashSet();

    @Override
    public IProject getProject() {
        return this.m_Project;
    }

    @Override
    public void setProject(IProject iProject) {
        this.revokeEventSinks();
        this.clearDeletedIDs();
        this.m_Project = iProject;
        if (this.m_Project != null) {
            this.m_ProjectID = this.m_Project.getXMIID();
            this.m_ProjectFileName = this.m_Project.getFileName();
            if (!this.verifyTypeFile(this.m_Project)) {
                this.establishTypeFile(this.m_Project);
                this.m_Project.setChildrenDirty(true);
            } else {
                this.connectToTypeFile();
            }
            this.loadUnresolvedTypes();
            this.registerForEvents();
            String string = iProject.getFileName();
            string = StringUtilities.getPath(string) + ".QueryCache";
            Document document = XMLManip.getDOMDocument(string);
            if (document != null) {
                PickListManager pickListManager = new PickListManager();
                pickListManager.initialize(iProject, document);
                this.m_rawPickManager = pickListManager;
            }
        } else {
            this.saveUnresolvedTypes();
        }
    }

    private void establishTypeFile(IProject iProject) {
        try {
            String string = UMLXMLManip.retrieveXMLFragmentFromResource(this.getClass(), IDR_TYPE_XML);
            if (string != null && string.length() > 0) {
                Log.out("The xml to be load " + string);
                IDResolver iDResolver = new IDResolver();
                iDResolver.addNodeTypeId("Location", "locID");
                iDResolver.addNodeTypeId("Type", "id");
                iDResolver.addNodeTypeId("TypeManagement", "projectID");
                this.m_Doc = XMLManip.loadXML(string, iDResolver);
                this.setProjectID(iProject);
                this.gatherTypeInformation(iProject);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setProjectID(IProject iProject) {
        Element element = this.getTypeManagementElement();
        if (element != null) {
            XMLManip.setAttributeValue(element, "projectID", iProject.getXMIID());
        }
    }

    private Element getTypeManagementElement() {
        Node node;
        if (this.m_Doc != null && (node = this.m_Doc.selectSingleNode("TypeManagement")) instanceof Element) {
            return (Element)node;
        }
        return null;
    }

    private void gatherTypeInformation(IProject iProject) {
        Node node = iProject.getNode();
        if (node != null) {
            this.loadAllExternalElements();
        }
    }

    private void loadAllExternalElements() {
        if (this.m_Project != null) {
            Node node = this.m_Project.getNode();
            this.loadAllExternalElements(node);
        }
    }

    private void loadAllExternalElements(Node node) {
        if (node != null) {
            String string;
            List list;
            Node node2 = node;
            String string2 = XMLManip.getAttributeValue(node, "xmi.id");
            String string3 = node.getNodeTypeName();
            ExternalFileManager externalFileManager = new ExternalFileManager();
            Node node3 = null;
            if (string3 != null) {
                node3 = string3.equals("UML:Project") ? node : this.resolveExternalNode(externalFileManager, node, string2);
            }
            if (node3 != null) {
                node2 = node3;
            }
            if ((list = node2.selectNodes(string = ".//*[@href]")) != null) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Node node4 = (Node)list.get(i);
                    if (externalFileManager.isImportedElement(node4)) {
                        this.addExternalElement(node4);
                        continue;
                    }
                    this.loadAllExternalElements(node4);
                }
            }
        }
    }

    private Node resolveExternalNode(ExternalFileManager externalFileManager, Node node, String string) {
        Object object;
        Object object2;
        Node node2 = null;
        FactoryRetriever factoryRetriever = FactoryRetriever.instance();
        IVersionableElement iVersionableElement = null;
        iVersionableElement = factoryRetriever.retrieveObject(this.retrieveRawXMIID(string));
        if (iVersionableElement != null && (object2 = iVersionableElement.getNode()) != null) {
            object = this.verifyParentsLoaded(externalFileManager, node);
            if (object == null) {
                object = node;
            }
            if ((node2 = ExternalFileManager.resolveExternalNode((Node)object)) == null) {
                node2 = object;
            }
        }
        if (node2 == null) {
            object2 = null;
            if (node == null && string.length() > 0) {
                object2 = this.getImportInfo(string);
                if (object2 != null && ((ImportInfo)object2).isImported()) {
                    node2 = this.loadNodeFromExternalProject(string, (ImportInfo)object2);
                }
            } else {
                object2 = this.getImportInfo(node);
                if (object2 != null && ((ImportInfo)object2).isImported()) {
                    String string2;
                    IVersionableElement iVersionableElement2;
                    ITypeManager iTypeManager;
                    object = this.getProjectByID(((ImportInfo)object2).m_ProjectID);
                    if (object != null && (iTypeManager = object.getTypeManager()) != null && (iVersionableElement2 = iTypeManager.getElementByID(string2 = XMLManip.getAttributeValue(node, "xmi.id"))) != null) {
                        node2 = iVersionableElement2.getNode();
                    }
                } else {
                    object = this.verifyParentsLoaded(externalFileManager, node);
                    if (object == null) {
                        object = node;
                    }
                    node2 = ExternalFileManager.resolveExternalNode((Node)object);
                }
            }
        }
        if (node2 == null && node != null) {
            node2 = node;
        }
        return node2;
    }

    private ImportInfo getImportInfo(String string) {
        ImportInfo importInfo = null;
        Node node = this.getLocationNodeFromXMIID(string);
        if (node != null) {
            importInfo = this.populateImportInfo(node);
        }
        return importInfo;
    }

    private ImportInfo getImportInfo(Node node) {
        Node node2;
        ImportInfo importInfo = null;
        if (node != null && (node2 = this.getLocationNodeFromXMIID(node)) != null) {
            importInfo = this.populateImportInfo(node2);
        }
        return importInfo;
    }

    private Node getLocationNodeFromXMIID(Node node) {
        Node node2 = null;
        String string = XMLManip.getAttributeValue(node, "xmi.id");
        node2 = this.getLocationNodeFromXMIID(string);
        return node2;
    }

    private Node getLocationNodeFromXMIID(String string) {
        Element element;
        Node node = null;
        if (this.m_Doc != null && (element = XMLManip.findElementByID((Branch)this.m_Doc, string)) != null) {
            node = this.getLocationNode((Node)element);
        }
        return node;
    }

    @Override
    public void addTypes(ETList<IElement> eTList, boolean bl) {
        int n;
        if (eTList != null && (n = eTList.size()) > 0) {
            if (this.m_Project != null) {
                this.m_Project.setChildrenDirty(true);
            }
            this.loadAllExternalElements();
            for (int i = 0; i < n; ++i) {
                IElement iElement = (IElement)eTList.get(i);
                this.addType(iElement, bl, false);
            }
        }
    }

    @Override
    public void addType(IVersionableElement iVersionableElement, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (bl) {
            if (this.processElement(iVersionableElement)) {
                bl3 = true;
            }
        } else if (this.isWatchedElement(iVersionableElement)) {
            bl3 = true;
        }
        if (!(iVersionableElement instanceof IPresentationElement) && bl3) {
            this.resolveReferences(iVersionableElement, bl2);
            Node node = iVersionableElement.getNode();
            if (node != null) {
                this.addExternalElement(node);
            }
        }
    }

    private void resolveReferences(IVersionableElement iVersionableElement, boolean bl) {
    }

    @Override
    public IProject getReferencedLibraryProjectByLocation(String string) {
        return this.getRefLibProject(null, string);
    }

    @Override
    public ETList<IProject> getReferencedLibraryProjects() {
        int n;
        ETList<String> eTList;
        ETArrayList eTArrayList = null;
        if (this.m_Project != null && (eTList = this.m_Project.getReferencedLibraries()) != null && (n = eTList.size()) > 0) {
            eTArrayList = new ETArrayList();
            IApplication iApplication = this.getApplication();
            if (iApplication != null) {
                for (int i = 0; i < n; ++i) {
                    IProject iProject;
                    String string = (String)eTList.get(i);
                    if (string == null || string.length() <= 0 || (iProject = this.getRefLibProject(iApplication, string)) == null) continue;
                    eTArrayList.add(iProject);
                }
            }
        }
        return eTArrayList;
    }

    private IProject getRefLibProject(IApplication iApplication, String string) {
        IProject iProject = null;
        if (iApplication == null) {
            iApplication = this.getApplication();
        }
        if (iApplication != null) {
            try {
                boolean bl = true;
                iProject = iApplication.getProjectByFileName(string);
                if (iProject == null) {
                    String string2;
                    IWSProject iWSProject;
                    IWorkspace iWorkspace;
                    ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
                    if (iCoreProduct != null && (iWorkspace = iCoreProduct.getCurrentWorkspace()) != null && (iWSProject = iWorkspace.openWSProjectByLocation(string)) != null && (iProject = iApplication.getProjectByName(string2 = iWSProject.getName())) != null) {
                        bl = false;
                    }
                    if (bl) {
                        iProject = iApplication.openProject(string);
                    }
                }
            }
            catch (WorkspaceManagementException workspaceManagementException) {
                workspaceManagementException.printStackTrace();
            }
        }
        return iProject;
    }

    private void ensureLoadedViaPickListManagement(String string) {
        IStrings iStrings;
        if (this.m_rawPickManager != null && (iStrings = this.m_rawPickManager.getIDsByName(string)) != null) {
            int n = iStrings.getCount();
            for (int i = 0; i < n; ++i) {
                String string2 = iStrings.item(i);
                this.ensureElementLoadedByID(string2);
            }
        }
    }

    @Override
    public ETList<INamedElement> getCachedTypesByName(String string) {
        IStrings iStrings;
        ETList<INamedElement> eTList = null;
        if (this.m_rawPickManager != null && (iStrings = this.m_rawPickManager.getIDsByName(string)) != null) {
            eTList = this.resolveIDs(iStrings);
        }
        return eTList;
    }

    private ETList<INamedElement> resolveIDs(IStrings iStrings) {
        if (iStrings == null) {
            return null;
        }
        ETArrayList<INamedElement> eTArrayList = new ETArrayList<INamedElement>();
        int n = iStrings.size();
        for (int i = 0; i < n; ++i) {
            IVersionableElement iVersionableElement;
            String string = (String)iStrings.get(i);
            if (string == null || string.length() == 0 || !((iVersionableElement = this.getElementByID(string)) instanceof INamedElement)) continue;
            eTArrayList.add((INamedElement)iVersionableElement);
        }
        return eTArrayList;
    }

    @Override
    public INamedElement getCachedTypeByName(String string) {
        int n;
        INamedElement iNamedElement = null;
        ETList<INamedElement> eTList = this.getCachedTypesByName(string);
        if (eTList != null && (n = eTList.size()) > 0) {
            iNamedElement = (INamedElement)eTList.get(0);
        }
        return iNamedElement;
    }

    @Override
    public INamedElement getElementFromLibrariesByNameAndType(String string, String string2) {
        IApplication iApplication;
        int n;
        ETList<String> eTList;
        INamedElement iNamedElement = null;
        if (this.m_Project != null && (eTList = this.m_Project.getReferencedLibraries()) != null && (n = eTList.size()) > 0 && (iApplication = this.getApplication()) != null) {
            for (int i = 0; i < n; ++i) {
                IElement iElement;
                IPickListManager iPickListManager;
                ITypeManager iTypeManager;
                IProject iProject;
                String string3 = (String)eTList.get(i);
                if (string3.length() <= 0 || (iProject = this.getRefLibProject(iApplication, string3)) == null || (iTypeManager = iProject.getTypeManager()) == null || (iPickListManager = iTypeManager.getPickListManager()) == null || (iElement = iPickListManager.getElementByNameAndStringFilter(string, string2)) == null || !(iElement instanceof INamedElement)) continue;
                iNamedElement = (INamedElement)iElement;
                break;
            }
        }
        return iNamedElement;
    }

    private IApplication getApplication() {
        IApplication iApplication = null;
        ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
        if (iCoreProduct != null) {
            iApplication = iCoreProduct.getApplication();
        }
        return iApplication;
    }

    @Override
    public ETList<INamedElement> getLocalCachedTypesByName(String string) {
        IStrings iStrings;
        ETList<INamedElement> eTList = null;
        if (this.m_rawPickManager != null && (iStrings = this.m_rawPickManager.getLocalIDsByName(string)) != null) {
            eTList = this.resolveIDs(iStrings);
        }
        return eTList;
    }

    private ImportInfo populateImportInfo(Node node) {
        ImportInfo importInfo = new ImportInfo();
        if (node != null) {
            importInfo.m_Href = XMLManip.getAttributeValue(node, "href");
            importInfo.m_ProjLocation = XMLManip.getAttributeValue(node, "importProjectLoc");
            importInfo.m_ProjectID = XMLManip.getAttributeValue(node, "importProjID");
        }
        return importInfo;
    }

    private Node loadNodeFromExternalProject(String string, ImportInfo importInfo) {
        return this.loadNodeFromExternalProject(string, importInfo.m_ProjectID);
    }

    private Node loadNodeFromExternalProject(String string, String string2) {
        IVersionableElement iVersionableElement;
        ITypeManager iTypeManager;
        Node node = null;
        IProject iProject = this.getProjectByID(string2);
        if (iProject != null && (iTypeManager = iProject.getTypeManager()) != null && (iVersionableElement = iTypeManager.getElementByID(string)) != null) {
            node = iVersionableElement.getNode();
        }
        return node;
    }

    private Node verifyParentsLoaded(ExternalFileManager externalFileManager, Node node) {
        Node node2 = null;
        if (node != null && node instanceof Element) {
            String string = ((Element)node).getQualifiedName();
            if (string != null && string.equals("UML:Project")) {
                node2 = node;
            } else {
                Object object;
                Node node3 = null;
                try {
                    object = XMLManip.selectAncestorNodesByAttribute(node, "loadedVersion", "true");
                    if (object != null && !object.isEmpty()) {
                        node3 = (Node)object.get(0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (node3 != null) {
                    object = null;
                    try {
                        object = node3.selectSingleNode("ancestor::UML:Project");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    node2 = object != null ? node : this.getParentAndVerify(externalFileManager, node);
                } else {
                    object = XMLManip.getAttributeValue(node, "owner");
                    node2 = (object == null || ((String)object).length() == 0) && externalFileManager.isImportedElement(node) ? ExternalFileManager.resolveExternalNode(node) : this.getParentAndVerify(externalFileManager, node);
                }
            }
        }
        return node2;
    }

    private Node getParentAndVerify(ExternalFileManager externalFileManager, Node node) {
        Node node2 = null;
        if (node != null) {
            Node node3 = this.getParentNode(node, false);
            Node node4 = null;
            if (node4 != null) {
                node2 = this.verifyParentsLoaded(externalFileManager, node4);
            } else if (node3 != null) {
                node2 = node;
            }
        }
        return node2;
    }

    private Node getParentNode(Node node, boolean bl) {
        String string;
        Element element = null;
        if (bl) {
            element = node.getParent();
        }
        if (element == null && (string = XMLManip.getAttributeValue(node, "owner")) != null && string.length() > 0) {
            String string2;
            ETPairT<String, String> eTPairT = URILocator.uriparts(string);
            String string3 = eTPairT.getParamTwo();
            String string4 = eTPairT.getParamOne();
            if (string4.length() > 0 && string3.length() > 0) {
                element = this.getRawElementByID(string);
            } else {
                string2 = this.retrieveTypeHref(string);
                if (string2.length() > 0) {
                    element = this.getRawElementByID(string);
                }
            }
            if (element != null && bl) {
                string2 = XMLManip.getAttributeValue(node, "xmi.id");
                Document document = this.getProjectDocument();
                if (document != null) {
                    Node node2 = this.ensureElementLoadedByID(string);
                    if (node2 == null) {
                        node2 = this.findByID(string);
                    }
                    if (node2 != null) {
                        element = node2;
                        Element element2 = XMLManip.findElementByID((Branch)document, string2);
                        if (element2 != null) {
                            this.loadExternalElement((Node)element2);
                        }
                    }
                }
            }
        }
        return element;
    }

    private void loadExternalElement(Node node) {
        Node node2;
        Node node3 = this.getParentNode(node, false);
        String string = XMLManip.getAttributeValue(node, "xmi.id");
        if (string != null && string.length() > 0 && (node2 = this.findByID(string)) != null) {
            ExternalFileManager externalFileManager = new ExternalFileManager();
            Node node4 = this.resolveExternalNode(externalFileManager, node2, "");
        }
    }

    private Node getModNode(Node node, Node node2, boolean bl) {
        Element element = null;
        Element element2 = null;
        if (bl) {
            element2 = node.getParent();
        }
        if (element2 == null) {
            String string = XMLManip.getAttributeValue(node, "xmi.id");
            Document document = this.getProjectDocument();
            if (document != null) {
                element = XMLManip.findElementByID((Branch)document, string);
            }
        }
        return element;
    }

    private void addExternalElement(Node node) {
        String string = XMLManip.getAttributeValue(node, "xmi.id");
        ETPairT<String, Boolean> eTPairT = UMLXMLManip.getVersionedURI(node);
        String string2 = eTPairT.getParamOne();
        String string3 = XMLManip.getAttributeValue(node, "loadedVersion");
        String string4 = XMLManip.getAttributeValue(node, "name");
        if (!(string3.equals("false") || string2.length() <= 0 && string3.length() <= 0)) {
            Object object;
            Object object2;
            Object object3;
            if (this.m_Project != null) {
                this.m_Project.setChildrenDirty(true);
            }
            if ((object3 = XMLManip.findElementByID((Branch)this.m_Doc, string)) == null) {
                object2 = XMLManip.createElement(this.m_Doc, "Type", "");
                object = this.m_Doc.selectSingleNode("/TypeManagement/Types");
                if (object.getNodeType() == 1) {
                    ((Element)object).add((Node)object2);
                }
                object3 = object2;
            }
            if (object3 != null) {
                XMLManip.setAttributeValue((Node)object3, "id", string);
                object2 = URILocator.uriparts(string2);
                object = (String)((ETPairT)object2).getParamTwo();
                String string5 = (String)((ETPairT)object2).getParamOne();
                String string6 = this.retrieveLocationID(string5, true);
                XMLManip.setAttributeValue((Node)object3, "location", string6);
                XMLManip.setAttributeValue((Node)object3, "name", string4);
            }
        }
    }

    private String retrieveLocationID(String string, boolean bl) {
        String string2 = "";
        if (this.m_Doc != null) {
            String string3 = string;
            if (string.length() == 0 && this.m_State != null) {
                string3 = this.makeRelativeToProject(this.m_State.projectFileName());
            }
            if (string3.length() > 0) {
                XMLManip.checkForIllegals(string3);
                String string4 = "TypeManagement/Locations/Location[@href=\"";
                string4 = string4 + string3;
                string4 = string4 + "\"]";
                Node node = this.m_Doc.selectSingleNode(string4);
                if (node != null) {
                    String string5 = XMLManip.getAttributeValue(node, "locID");
                    if (string5 != null && string5.length() > 0) {
                        string2 = string5;
                    }
                } else if (bl) {
                    string2 = this.addLocationEntry(string);
                }
            }
        }
        return string2;
    }

    private String addLocationEntry(String string) {
        Node node;
        String string2 = "";
        if (this.m_Doc != null && (node = this.m_Doc.selectSingleNode("TypeManagement/Locations")) != null) {
            string2 = this.incrementLocId(node);
            Element element = XMLManip.createElement(this.m_Doc, "Location", "");
            if (element != null) {
                String string3 = string;
                if (string3.length() == 0 && this.m_State != null) {
                    string3 = this.makeRelativeToProject(this.m_State.projectFileName());
                }
                XMLManip.setAttributeValue((Node)element, "locID", string2);
                XMLManip.setAttributeValue((Node)element, "href", string3);
                if (this.m_State != null) {
                    if (this.m_State.reCreating()) {
                        this.establishImportInfo(string, (Node)element);
                    } else {
                        String string4 = this.makeRelativeToProject(this.m_State.projectFileName());
                        String string5 = this.m_State.projectID();
                        XMLManip.setAttributeValue((Node)element, "importProjectLoc", string4);
                        XMLManip.setAttributeValue((Node)element, "importProjID", string5);
                    }
                }
                ((Element)node).add((Node)element);
            }
        }
        return string2;
    }

    private void establishImportInfo(String string, Node node) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = string;
        if (string6.length() == 0 && this.m_State != null && (string5 = this.m_State.projectFileName()).length() > 0) {
            string6 = string5;
        }
        if ((string5 = this.retrieveAbsolutePathFromProject(string6)).length() > 0 && this.m_Project != null && (string4 = this.m_Project.getFileName()).length() > 0 && !(string3 = StringUtilities.getPath(string4)).equals(string2 = StringUtilities.getPath(string5))) {
            String string7 = "";
            String string8 = "";
            if (StringUtilities.getExtension(string5).equals("etd")) {
                Node node2;
                string7 = this.makeRelativeToProject(string6);
                Document document = URILocator.retrieveDocument(string5);
                if (document != null && (node2 = document.selectSingleNode("//UML:Project")) != null) {
                    string8 = XMLManip.getAttributeValue(node2, "xmi.id");
                }
            } else {
                String string9;
                IProject iProject;
                Node node3 = this.getVersionedElement(string5);
                if (node3 != null && (string8 = XMLManip.getAttributeValue(node3, "projectID")) != null && string8.length() > 0 && (iProject = this.getProjectByID(string8)) != null && (string9 = iProject.getFileName()).length() > 0) {
                    string7 = this.makeRelativeToProject(string9);
                }
            }
            XMLManip.setAttributeValue(node, "importProjectLoc", string7);
            XMLManip.setAttributeValue(node, "importProjID", string8);
        }
    }

    private String makeRelativeToProject(String string) {
        String string2;
        String string3 = "";
        if (this.m_Project != null && (string2 = this.m_Project.getFileName()).length() > 0 && string.length() > 0) {
            string3 = PathManip.retrieveRelativePath(string, string2);
        }
        return string3;
    }

    private Node getVersionedElement(String string) {
        Node node = null;
        Document document = URILocator.retrieveDocument(string);
        if (document != null) {
            node = document.selectSingleNode("//VersionedElement");
        }
        return node;
    }

    private String incrementLocId(Node node) {
        String string = "";
        String string2 = XMLManip.getAttributeValue(node, "nextID");
        if (string2 != null && string2.length() > 0) {
            string = "T.";
            string = string + string2;
            int n = Integer.parseInt(string2);
            String string3 = Integer.toString(++n);
            XMLManip.setAttributeValue(node, "nextID", string3);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connectToTypeFile() {
        try {
            File file = this.retrieveTypeFile(this.m_Project);
            IDResolver iDResolver = new IDResolver();
            iDResolver.addNodeTypeId("Location", "locID");
            iDResolver.addNodeTypeId("Type", "id");
            iDResolver.addNodeTypeId("TypeManagement", "projectID");
            this.m_Doc = XMLManip.getDOMDocument(file.getCanonicalPath(), iDResolver);
            if (this.m_Doc != null) return;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void registerForEvents() {
        Object t;
        EventDispatchRetriever eventDispatchRetriever = EventDispatchRetriever.instance();
        Object t2 = eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.modifiedName());
        if (t2 != null && t2 instanceof IElementChangeEventDispatcher) {
            this.m_Dispatcher = (IElementChangeEventDispatcher)t2;
        }
        if ((t = eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.lifeTime())) != null && t instanceof IElementLifeTimeEventDispatcher) {
            this.m_LifeTimeDispatcher = (IElementLifeTimeEventDispatcher)t;
        }
        if (this.m_Dispatcher != null) {
            this.m_Dispatcher.registerForNamespaceModifiedEvents(this);
            this.m_Dispatcher.registerForNamedElementEvents(this);
            this.m_Dispatcher.registerForExternalElementEventsSink(this);
        }
        if (this.m_LifeTimeDispatcher != null) {
            this.m_LifeTimeDispatcher.registerForLifeTimeEvents(this);
        }
    }

    private void saveUnresolvedTypes() {
        String string;
        if (this.m_UnresolvedIDs != null && this.m_UnresolvedIDs.size() > 0 && (string = this.getUnResolveFileName()) != null && string.length() > 0) {
            File file = new File(string);
            String string2 = "";
            for (String object : this.m_UnresolvedIDs) {
                if (object.length() <= 0) continue;
                string2 = string2 + object;
                string2 = string2 + '\t';
            }
            if (string2.length() > 0) {
                try {
                    FileWriter iOException = new FileWriter(file);
                    iOException.write(string2);
                    iOException.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private void loadUnresolvedTypes() {
        String string = this.getUnResolveFileName();
        if (string != null && string.length() > 0) {
            try {
                Object object;
                File file = new File(string);
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String string2 = "";
                while ((object = bufferedReader.readLine()) != null) {
                    string2 = string2 + (String)object;
                }
                object = new StringTokenizer(string2, "\t");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string3 = ((StringTokenizer)object).nextToken();
                    this.addToUnresolved(string3);
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void addToUnresolved(String string) {
    }

    private File getUnresolvedFile() {
        return null;
    }

    private String getUnResolveFileName() {
        String string = "";
        if (this.m_ProjectFileName != null && this.m_ProjectFileName.length() > 0) {
            string = StringUtilities.getPath(this.m_ProjectFileName);
            string = string + ".unresolved";
        }
        return string;
    }

    private boolean verifyTypeFile(IProject iProject) {
        if (iProject.getFileName() == null) {
            return false;
        }
        return this.retrieveTypeFile(iProject).exists();
    }

    private File retrieveTypeFile(IProject iProject) {
        return new File(StringUtilities.ensureExtension(iProject.getFileName(), ".ettm"));
    }

    private String retrieveTypeFileName(IProject iProject) {
        String string = iProject.getFileName();
        if (string != null && string.length() > 0) {
            string = StringUtilities.ensureExtension(string, ".ettm");
        }
        return string;
    }

    @Override
    public void clearDeletedIDs() {
        this.m_DeletedCache.clear();
    }

    private void revokeEventSinks() {
        if (this.m_Dispatcher != null && this.m_LifeTimeDispatcher != null) {
            this.m_Dispatcher.revokeNamespaceModifiedSink(this);
            this.m_Dispatcher.revokeNamedElementSink(this);
            this.m_Dispatcher.revokeExternalElementEventsSink(this);
            this.m_LifeTimeDispatcher.revokeLifeTimeSink(this);
            if (this.m_rawPickManager != null) {
                this.m_rawPickManager.deinitialize();
                this.m_rawPickManager = null;
            }
            this.m_Dispatcher = null;
            this.m_LifeTimeDispatcher = null;
        }
    }

    @Override
    public INamedElement getElementByName(String string) {
        int n;
        INamedElement iNamedElement = null;
        ETList<INamedElement> eTList = this.getElementsByName(string);
        if (eTList != null && (n = eTList.size()) > 0) {
            iNamedElement = (INamedElement)eTList.get(0);
        }
        return iNamedElement;
    }

    @Override
    public ETList<INamedElement> getElementsByName(String string) {
        ETList<INamedElement> eTList = null;
        List list = this.getListOfElementsByName(string);
        if (list != null) {
            this.ensureElementsAreLoaded(list);
        }
        eTList = this.findByName(string);
        return eTList;
    }

    private void ensureElementsAreLoaded(List list) {
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Node node = (Node)list.get(i);
                String string = XMLManip.getAttributeValue(node, "id");
                if (string == null || string.length() <= 0) continue;
                Node node2 = this.ensureElementLoadedByID(string);
            }
        }
    }

    private List getListOfElementsByName(String string) {
        List list = null;
        String string2 = "//*[@name='";
        string2 = string2 + string;
        string2 = string2 + "']";
        if (this.m_Doc != null) {
            list = this.m_Doc.selectNodes(string2);
        }
        if (list == null || list.size() == 0) {
            this.ensureLoadedViaPickListManagement(string);
        }
        return list;
    }

    @Override
    public IVersionableElement getElementByID(String string) {
        TypedFactoryRetriever typedFactoryRetriever;
        Object t;
        IVersionableElement iVersionableElement = null;
        Node node = this.getRawElementByID(string);
        if (node != null && (t = (typedFactoryRetriever = new TypedFactoryRetriever()).createTypeAndFill(node)) != null && t instanceof IVersionableElement) {
            iVersionableElement = (IVersionableElement)t;
        }
        return iVersionableElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getRawElementByID(String string) {
        if (string != null && this.m_Project != null) {
            if (!this.isIDDeleted(string)) {
                Node node = this.findByID(string);
                if (node == null && (node = this.ensureElementLoadedByID(string)) == null) {
                    node = this.findByID(string);
                }
                Node node2 = node;
                return node2;
            }
        }
        return null;
    }

    private Node findByID(String string) {
        Document document;
        Element element = null;
        if (!this.isIDDeleted(string) && (document = this.getProjectDocument()) != null) {
            String string2 = this.retrieveRawXMIID(string);
            element = XMLManip.findElementByID((Branch)document, string2);
            if (element == null) {
                element = this.testFindElementByID(document, string2);
            }
            String string3 = this.m_Project.getFileName();
            ExternalFileManager.setRootFileName(string3);
            ExternalFileManager externalFileManager = new ExternalFileManager();
            Node node = this.resolveExternalNode(externalFileManager, (Node)element, string2);
            if (node != null) {
                element = null;
                element = node;
            }
        }
        return element;
    }

    private Node testFindElementByID(Document document, String string) {
        String string2;
        Document document2;
        Element element = null;
        String string3 = this.m_Project.getFileName();
        int n = string3.lastIndexOf(46);
        String string4 = n != -1 ? string3.substring(0, n) : string3;
        String string5 = string4 + ".etup";
        Document document3 = XMLManip.getDOMDocumentUseWeakCache(string5);
        if (document3 != null && (element = XMLManip.findElementByID((Branch)document3, string)) == null && (document2 = XMLManip.getDOMDocumentUseWeakCache(string2 = string4 + ".ettm")) != null) {
            element = XMLManip.findElementByID((Branch)document2, string);
        }
        return element;
    }

    private Node ensureElementLoadedByID(String string) {
        Node node = null;
        String string2 = this.retrieveRawXMIID(string);
        ImportInfo importInfo = this.getImportInfo(string2);
        if (importInfo != null && importInfo.isImported()) {
            node = this.loadNodeFromExternalProject(string2, importInfo);
        } else {
            String string3 = this.retrieveTypeHref(string);
            ETPairT<String, String> eTPairT = URILocator.uriparts(string3);
            String string4 = eTPairT.getParamTwo();
            String string5 = eTPairT.getParamOne();
            if (string5 != null && string5.length() > 0) {
                String string6 = this.makeURIAbsolute(string5, string4);
                if (string6 != null && string6.length() > 0 && (node = this.loadExternalFileAndReturnNode(string6)) == null) {
                    node = this.findUnknownType(string);
                }
            } else {
                node = this.findUnknownType(string);
            }
        }
        return node;
    }

    private Node findUnknownType(String string) {
        Node node = null;
        String string2 = this.retrieveRawXMIID(string);
        FactoryRetriever factoryRetriever = FactoryRetriever.instance();
        IVersionableElement iVersionableElement = factoryRetriever.retrieveObject(string2);
        if (iVersionableElement == null) {
            node = this.idIsExternalProject(string2);
            if (node == null) {
                String string3 = "xmi.id=\"";
                string3 = string3 + string2;
                string3 = string3 + "\"";
                if (!this.isIrresolvable(string2)) {
                    String string4 = this.findInExternalFiles(string3);
                    if (string4 != null && string4.length() > 0) {
                        if (this.loadExternalFileAndReturnNode(string4) != null) {
                            Node node2 = this.findByID(string2);
                            if (node2 != null) {
                                this.addExternalElement(node2);
                                node = node2;
                            } else {
                                this.addToUnresolved(string2);
                            }
                        } else {
                            node = this.retrieveAndAddFromImports(string2);
                        }
                    } else {
                        node = this.retrieveAndAddFromImports(string2);
                    }
                }
            }
        } else {
            node = iVersionableElement.getNode();
        }
        return node;
    }

    private String findInExternalFiles(String string) {
        String string2 = null;
        IStrings iStrings = this.gatherExternalFileLocations();
        if (iStrings != null) {
            int n = iStrings.getCount();
            for (int i = 0; i < n; ++i) {
                String string3 = iStrings.item(i);
                if (string3.length() <= 0 || !this.isElementPresent(string, string3)) continue;
                string2 = string3;
                break;
            }
        }
        return string2;
    }

    private boolean isElementPresent(String string, String string2) {
        boolean bl = false;
        if (string != null && string2 != null) {
            bl = FileManip.isInFile(string, string2);
        }
        return bl;
    }

    private boolean isIrresolvable(String string) {
        boolean bl = false;
        for (String string2 : this.m_UnresolvedIDs) {
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private Node idIsExternalProject(String string) {
        Node node = null;
        if (this.m_Doc != null) {
            IProject iProject;
            String string2 = "//Location[@importProjID=\"";
            string2 = string2 + string;
            Node node2 = this.m_Doc.selectSingleNode(string2 = string2 + "\"]");
            if (node2 != null && (iProject = this.getProjectByID(string)) != null) {
                node = iProject.getNode();
            }
        }
        return node;
    }

    private Node retrieveAndAddFromImports(String string) {
        Node node = null;
        Node node2 = this.retrieveTypeFromImportedProjects(string);
        if (node2 != null) {
            TypedFactoryRetriever typedFactoryRetriever = new TypedFactoryRetriever();
            Object t = typedFactoryRetriever.createTypeAndFill(node2);
            if (t != null && t instanceof IVersionableElement) {
                IVersionableElement iVersionableElement = (IVersionableElement)t;
                this.addExternalType(iVersionableElement);
            }
            node = node2;
        } else {
            this.addToUnresolved(string);
        }
        return node;
    }

    private Node retrieveTypeFromImportedProjects(String string) {
        Node node = null;
        ETList<IProject> eTList = this.getImportedProjects();
        if (eTList != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                IVersionableElement iVersionableElement;
                IProject iProject = (IProject)eTList.get(i);
                ITypeManager iTypeManager = iProject.getTypeManager();
                if (iTypeManager == null || (iVersionableElement = iTypeManager.getElementByID(string)) == null) continue;
                node = iVersionableElement.getNode();
                break;
            }
        }
        return node;
    }

    private ETList<IProject> getImportedProjects() {
        List list;
        ETArrayList eTArrayList = null;
        if (this.m_Doc != null && (list = this.m_Doc.selectNodes("//Location[@importProjID]")) != null) {
            IProject iProject;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Node node = (Node)list.get(i);
                String string = XMLManip.getAttributeValue(node, "importProjID");
                if (string == null || string.length() <= 0 || (iProject = this.getProjectByID(string)) == null) continue;
                if (eTArrayList == null) {
                    eTArrayList = new ETArrayList();
                }
                eTArrayList.add(iProject);
            }
            ETList<IProject> eTList = this.getReferencedLibraryProjects();
            if (eTList != null) {
                int n2 = eTList.size();
                for (int i = 0; i < n2; ++i) {
                    iProject = (IProject)eTList.get(i);
                    if (eTArrayList == null) {
                        eTArrayList = new ETArrayList();
                    }
                    eTArrayList.add(iProject);
                }
            }
        }
        return eTArrayList;
    }

    private Node loadFirstHRefElement(Document document) {
        Node node = null;
        if (document != null && (node = document.selectSingleNode("//*[@href][1]")) != null) {
            this.loadExternalElement(node);
        }
        return node;
    }

    private String makeURIAbsolute(String string, String string2) {
        String string3 = "";
        String string4 = this.retrieveAbsolutePathFromProject(string);
        if (string4 != null && string4.length() > 0) {
            string4 = this.stripURIDeclaration(string4);
            string3 = string4 + "#" + string2;
        }
        return string3;
    }

    private String stripURIDeclaration(String string) {
        return URILocator.stripURIDeclaration(string);
    }

    private ETList<INamedElement> findByName(String string) {
        ETList eTList = null;
        Document document = this.getProjectDocument();
        if (document != null) {
            String string2 = "//*[@name='";
            string2 = string2 + string;
            string2 = string2 + "']";
            ElementCollector elementCollector = new ElementCollector();
            ETList<Node> eTList2 = elementCollector.selectNodes((Node)document, string2);
            if (eTList != null) {
                eTList = elementCollector.populateCollection(eTList2, INamedElement.class);
            }
        }
        return eTList;
    }

    private String retrieveRawXMIID(String string) {
        return URILocator.retrieveRawID(string);
    }

    private Document getProjectDocument() {
        Node node;
        if (this.m_Project != null && (node = this.m_Project.getNode()) != null) {
            return node.getDocument();
        }
        return null;
    }

    private boolean isIDDeleted(String string) {
        return this.m_DeletedCache.contains(string);
    }

    private boolean isWatchedElement(IVersionableElement iVersionableElement) {
        IElement iElement;
        IProject iProject;
        boolean bl = false;
        if (iVersionableElement != null && this.m_Project != null && iVersionableElement instanceof IElement && (iProject = (iElement = (IElement)iVersionableElement).getProject()) != null && iProject.isSame(this.m_Project)) {
            bl = true;
        }
        return bl;
    }

    private boolean processElement(IVersionableElement iVersionableElement) {
        boolean bl;
        boolean bl2 = false;
        if (this.m_Project != null && (bl = this.m_Project.isVersioned())) {
            bl2 = this.isWatchedElement(iVersionableElement);
        }
        return bl2;
    }

    @Override
    public void save(String string) {
        if (this.m_Doc != null) {
            XMLManip.save(this.m_Doc, string);
        }
    }

    @Override
    public void addType(IVersionableElement iVersionableElement) {
        if (this.processElement(iVersionableElement)) {
            this.addToTypes(iVersionableElement);
        }
    }

    @Override
    public void addExternalType(IVersionableElement iVersionableElement) {
        IElement iElement;
        IProject iProject;
        if (iVersionableElement != null && iVersionableElement instanceof IElement && (iProject = (iElement = (IElement)iVersionableElement).getProject()) != null) {
            State state = new State(this.m_State, iProject, false);
            this.addToTypes(iVersionableElement);
            if (iVersionableElement instanceof INamedElement) {
                this.getPickListManager().addExternalNamedType((INamedElement)iVersionableElement);
            }
        }
    }

    private void addToTypes(IVersionableElement iVersionableElement) {
        if (iVersionableElement != null && !(iVersionableElement instanceof IPresentationElement)) {
            this.resolveReferences(iVersionableElement, true);
            Node node = iVersionableElement.getNode();
            if (node != null) {
                this.addExternalElement(node);
                this.addNecessaryChildElements(iVersionableElement);
            }
        }
    }

    private void addNecessaryChildElements(IVersionableElement iVersionableElement) {
        List list;
        Node node;
        if (iVersionableElement != null && (node = iVersionableElement.getNode()) != null && (list = node.selectNodes("./UML:Element.ownedElement/UML:Part")) != null) {
            TypedFactoryRetriever typedFactoryRetriever = new TypedFactoryRetriever();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Node node2 = (Node)list.get(i);
                Object t = typedFactoryRetriever.createTypeAndFill(node2);
                if (t == null || !(t instanceof IPart)) continue;
                IPart iPart = (IPart)t;
                this.addToTypes(iPart);
            }
        }
    }

    @Override
    public void removeType(IVersionableElement iVersionableElement) {
        if (iVersionableElement != null && this.processElement(iVersionableElement)) {
            Node node = iVersionableElement.getNode();
            this.removeElement(node);
        }
    }

    private void removeElement(Node node) {
        if (node != null) {
            Node node2 = this.isTypePresent(node);
            if (node2 != null) {
                this.removeLocationNode(node2);
                Element element = node2.getParent();
                if (element != null) {
                    node2.detach();
                }
            }
            this.removeChildElements(node);
        }
    }

    private void removeChildElements(Node node) {
        String string;
        List list;
        if (node != null && (list = node.selectNodes(string = ".//*[@xmi.id]")) != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Node node2 = (Node)list.get(i);
                this.removeElement(node2);
            }
        }
    }

    private void removeLocationNode(Node node) {
        Element element;
        Node node2;
        if (node != null && (node2 = this.getLocationNode(node)) != null && (element = node2.getParent()) != null) {
            node2.detach();
        }
    }

    private Node isTypePresent(Node node) {
        String string;
        Element element;
        Element element2 = null;
        if (node != null && (element = XMLManip.findElementByID((Branch)this.m_Doc, string = XMLManip.getAttributeValue(node, "xmi.id"))) != null) {
            element2 = element;
        }
        return element2;
    }

    @Override
    public IStrings gatherExternalFileLocations() {
        int n;
        List list;
        Strings strings = null;
        if (this.m_Doc != null && (list = this.m_Doc.selectNodes("TypeManagement/Locations/*")) != null && (n = list.size()) > 0) {
            strings = new Strings();
            for (int i = 0; i < n; ++i) {
                Node node = (Node)list.get(i);
                String string = XMLManip.getAttributeValue(node, "href");
                if (string == null || string.length() <= 0) continue;
                ImportInfo importInfo = this.populateImportInfo(node);
                String string2 = null;
                if (importInfo.isImported()) {
                    string2 = this.retrieveAbsolutePathFromProject(importInfo.m_ProjLocation);
                    string2 = PathManip.retrieveAbsolutePath(importInfo.m_Href, string2);
                } else {
                    string2 = this.retrieveAbsolutePathFromProject(string);
                }
                strings.add(string2);
            }
        }
        return strings;
    }

    @Override
    public void loadExternalFile(String string) {
        this.loadExternalFileAndReturnNode(string);
    }

    private Node loadExternalFileAndReturnNode(String string) {
        Node node = null;
        boolean bl = true;
        if (string != null && string.length() > 0) {
            String string2;
            String string3 = this.locationIsExternalProject(string);
            if (string3 == null || string3.length() == 0) {
                Document document = URILocator.retrieveDocument(string);
                if (document != null) {
                    Node node2 = document.selectSingleNode("//VersionedElement");
                    if (node2 != null) {
                        bl = this.inSameProject(node2);
                        if (bl) {
                            Node node3 = this.loadFirstHRefElement(document);
                        }
                    } else {
                        Node node4 = this.loadFirstHRefElement(document);
                    }
                }
            } else if (string3.length() > 0 && (string2 = this.retrieveRawXMIID(string)) != null && string2.length() > 0) {
                node = this.loadNodeFromExternalProject(string2, string3);
            }
        }
        return node;
    }

    private boolean inSameProject(Node node) {
        return false;
    }

    private String locationIsExternalProject(String string) {
        String string2 = "";
        if (string != null && string.length() > 0) {
            ETPairT<String, String> eTPairT = URILocator.uriparts(string);
            String string3 = eTPairT.getParamTwo();
            String string4 = eTPairT.getParamOne();
            String string5 = this.makeRelativeToProject(string4);
            String string6 = "//Location[@importProjectLoc=\"";
            string6 = string6 + string5;
            Node node = this.m_Doc.selectSingleNode(string6 = string6 + "\"]");
            if (node != null) {
                string2 = XMLManip.getAttributeValue(node, "importProjID");
            }
        }
        return string2;
    }

    @Override
    public void loadExternalElements() {
        this.loadAllExternalElements();
    }

    @Override
    public IVersionableElement getVersionedOwner(IVersionableElement iVersionableElement) {
        IVersionableElement iVersionableElement2 = null;
        if (iVersionableElement != null) {
            boolean bl = iVersionableElement.isVersioned();
            if (bl) {
                IElement iElement;
                IElement iElement2;
                if (iVersionableElement instanceof IElement && (iElement2 = (iElement = (IElement)iVersionableElement).getOwner()) != null) {
                    bl = iElement2.isVersioned();
                    iVersionableElement2 = bl ? iElement2 : this.getVersionedOwner(iElement2);
                }
            } else {
                Node node = iVersionableElement.getNode();
                ETPairT<String, Boolean> eTPairT = UMLXMLManip.getVersionedURI(node);
                String string = eTPairT.getParamOne();
                if (string != null && string.length() > 0) {
                    Node node2;
                    Element element;
                    List list;
                    Node node3;
                    Document document;
                    String string2;
                    ETPairT<String, String> eTPairT2 = URILocator.uriparts(string);
                    String string3 = eTPairT2.getParamOne();
                    String string4 = eTPairT2.getParamTwo();
                    if (string3 != null && string4 != null && (string2 = this.makeURIAbsolute(string3, string4)) != null && string2.length() > 0 && (document = URILocator.retrieveDocument(string2)) != null && (node3 = document.selectSingleNode("VersionedElement")) instanceof Element && (list = (element = (Element)node3).elements()) != null && list.size() > 0 && (node2 = (Node)list.get(0)) != null) {
                        String string5 = XMLManip.getAttributeValue(node2, "xmi.id");
                        iVersionableElement2 = this.getElementByID(string5);
                    }
                }
            }
        }
        return iVersionableElement2;
    }

    @Override
    public void removeFromTypeLookup(IVersionableElement iVersionableElement) {
        if (iVersionableElement != null) {
            Object object;
            String string = iVersionableElement.getVersionedURI();
            if (this.m_Project != null && string != null && string.length() > 40) {
                object = iVersionableElement.getXMIID();
                this.loadAllExternalElements();
                Node node = this.m_Project.getNode();
                UMLXMLManip.replaceReferences(node, string, (String)object);
                this.m_Project.setChildrenDirty(true);
            }
            object = iVersionableElement.getNode();
            this.removeElement((Node)object);
        }
    }

    @Override
    public ETList<IVersionableElement> getAllVersionedElements() {
        ETList eTList = null;
        if (this.m_Project != null) {
            this.loadAllExternalElements();
            Node node = this.m_Project.getNode();
            if (node != null) {
                eTList = new ElementCollector().retrieveElementCollection(node, "//*[@isVersioned='true']", IVersionableElement.class);
            }
        }
        return eTList;
    }

    @Override
    public boolean verifyInMemoryStatus(IVersionableElement iVersionableElement) {
        Node node;
        Node node2;
        boolean bl = false;
        if (iVersionableElement != null && (node2 = iVersionableElement.getNode()) != null && (node = this.verifyInMemoryStatus(node2)) != null) {
            bl = true;
            iVersionableElement.setNode(node);
        }
        return bl;
    }

    private Node verifyInMemoryStatus(Node node) {
        Node node2 = null;
        FactoryRetriever factoryRetriever = FactoryRetriever.instance();
        factoryRetriever.clearClonedStatus(node);
        Node node3 = this.getParentNode(node, true);
        Node node4 = null;
        if (node3 != null) {
            node4 = this.getModNode(node, node3, true);
        }
        if (node4 != null) {
            node2 = node4;
        } else {
            String string = XMLManip.getAttributeValue(node, "loadedVersion");
            if (string != null && (string.length() == 0 || string.equals("false"))) {
                this.loadExternalElement(node);
                String string2 = XMLManip.getAttributeValue(node, "xmi.id");
                node2 = this.findByID(string2);
            } else {
                String string3 = XMLManip.getAttributeValue(node, "isVersioned");
                if (string3 != null && (string3.length() == 0 || string3.equals("true"))) {
                    this.loadExternalElement(node);
                    String string4 = XMLManip.getAttributeValue(node, "xmi.id");
                    node2 = this.findByID(string4);
                }
            }
        }
        return node2;
    }

    @Override
    public IPickListManager getPickListManager() {
        return this.m_rawPickManager;
    }

    @Override
    public void setPickListManager(IPickListManager iPickListManager) {
        this.m_rawPickManager = iPickListManager;
        if (this.m_rawPickManager != null) {
            this.m_rawPickManager.setTypeManager(this);
        }
    }

    @Override
    public INamedElement getElementFromLibrariesByName(String string) {
        INamedElement iNamedElement = null;
        ETList<INamedElement> eTList = this.getElementsFromLibrariesByName(string);
        if (eTList != null && eTList.size() > 0) {
            iNamedElement = (INamedElement)eTList.get(0);
        }
        return iNamedElement;
    }

    @Override
    public ETList<INamedElement> getElementsFromLibrariesByName(String string) {
        IApplication iApplication;
        int n;
        ETList<String> eTList;
        ETList<INamedElement> eTList2 = null;
        if (this.m_Project != null && (eTList = this.m_Project.getReferencedLibraries()) != null && (n = eTList.size()) > 0 && (iApplication = this.getApplication()) != null) {
            int n2;
            ITypeManager iTypeManager;
            IProject iProject;
            String string2;
            for (int i = 0; i < n && ((string2 = (String)eTList.get(i)) == null || string2.length() <= 0 || (iProject = this.getRefLibProject(iApplication, string2)) == null || (iTypeManager = iProject.getTypeManager()) == null || (eTList2 = iTypeManager.getCachedTypesByName(string)) == null || (n2 = eTList2.size()) <= 0); ++i) {
            }
        }
        return eTList2;
    }

    @Override
    public void addToDeletedIds(String string) {
        if (string != null && string.length() > 0) {
            this.m_DeletedCache.add(string);
        }
    }

    @Override
    public void onElementPreCreate(String string, IResultCell iResultCell) {
    }

    @Override
    public void onElementCreated(IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onElementPreDelete(IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onElementDeleted(IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onElementPreDuplicated(IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onElementDuplicated(IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onPreNameModified(INamedElement iNamedElement, String string, IResultCell iResultCell) {
    }

    @Override
    public void onNameModified(INamedElement iNamedElement, IResultCell iResultCell) {
        if (this.processElement(iNamedElement)) {
            Node node = this.retrieveExternalElementNode(iNamedElement);
            if (node != null) {
                String string = iNamedElement.getName();
                XMLManip.setAttributeValue(node, "name", string);
            } else {
                node = iNamedElement.getNode();
                if (node != null) {
                    this.addExternalElement(node);
                }
            }
        }
    }

    private Node retrieveExternalElementNode(IVersionableElement iVersionableElement) {
        Element element;
        String string;
        String string2;
        Node node;
        ETPairT<String, Boolean> eTPairT;
        Element element2 = null;
        if (iVersionableElement != null && (eTPairT = UMLXMLManip.getVersionedURI(node = iVersionableElement.getNode())) != null && (string2 = eTPairT.getParamOne()) != null && string2.length() > 0 && this.m_Doc != null && (string = XMLManip.getAttributeValue(node, "xmi.id")) != null && !string.equals(string2) && (element = XMLManip.findElementByID((Branch)this.m_Doc, string)) != null) {
            element2 = element;
        }
        return element2;
    }

    @Override
    public void onPreVisibilityModified(INamedElement iNamedElement, int n, IResultCell iResultCell) {
    }

    @Override
    public void onVisibilityModified(INamedElement iNamedElement, IResultCell iResultCell) {
    }

    @Override
    public void onPreAliasNameModified(INamedElement iNamedElement, String string, IResultCell iResultCell) {
    }

    @Override
    public void onAliasNameModified(INamedElement iNamedElement, IResultCell iResultCell) {
    }

    @Override
    public void onPreNameCollision(INamedElement iNamedElement, String string, ETList<INamedElement> eTList, IResultCell iResultCell) {
    }

    @Override
    public void onNameCollision(INamedElement iNamedElement, ETList<INamedElement> eTList, IResultCell iResultCell) {
    }

    @Override
    public void onPreElementAddedToNamespace(INamespace iNamespace, INamedElement iNamedElement, IResultCell iResultCell) {
    }

    @Override
    public void onElementAddedToNamespace(INamespace iNamespace, INamedElement iNamedElement, IResultCell iResultCell) {
        Node node;
        if (iNamespace != null && iNamedElement != null && this.processElement(iNamedElement) && (node = this.retrieveExternalElementNode(iNamedElement)) != null && this.m_Doc != null) {
            Node node2 = iNamedElement.getNode();
            ETPairT<String, Boolean> eTPairT = UMLXMLManip.getVersionedURI(node2);
            String string = eTPairT.getParamOne();
            ETPairT<String, String> eTPairT2 = URILocator.uriparts(string);
            String string2 = eTPairT2.getParamOne();
            String string3 = eTPairT2.getParamTwo();
            this.setLocationValue(node, string2);
        }
    }

    private void setLocationValue(Node node, String string) {
        Node node2 = this.getLocationNode(node);
        if (node2 != null) {
            XMLManip.setAttributeValue(node2, "href", string);
        }
    }

    @Override
    public void onExternalElementPreLoaded(String string, IResultCell iResultCell) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExternalElementLoaded(IVersionableElement iVersionableElement, IResultCell iResultCell) {
        PreventReEntrance preventReEntrance = new PreventReEntrance();
        preventReEntrance.startBlocking(0);
        try {
            Node node;
            Node node2;
            if (!preventReEntrance.isBlocking() && this.isWatchedElement(iVersionableElement) && (node2 = iVersionableElement.getNode()) != null && (node = this.isTypePresent(node2)) == null) {
                this.addToTypes(iVersionableElement);
            }
        }
        finally {
            preventReEntrance.releaseBlock();
        }
    }

    @Override
    public void onPreInitialExtraction(String string, IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onInitialExtraction(IVersionableElement iVersionableElement, IResultCell iResultCell) {
        if (this.isWatchedElement(iVersionableElement)) {
            this.addToTypes(iVersionableElement);
        }
    }

    protected void finalize() {
        this.revokeEventSinks();
    }

    private IProject getProjectByID(String string) {
        IApplication iApplication;
        IProject iProject = null;
        ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
        if (iCoreProduct != null && (iApplication = iCoreProduct.getApplication()) != null) {
            iProject = iApplication.getProjectByID(string);
        }
        return iProject;
    }

    private String retrieveAbsolutePathFromProject(String string) {
        String string2;
        String string3 = "";
        if (this.m_Project != null && (string2 = this.m_Project.getFileName()) != null && string2.length() > 0 && string != null && string.length() > 0) {
            string3 = PathManip.retrieveAbsolutePath(string, string2);
        }
        return string3;
    }

    private String retrieveTypeHref(String string) {
        Node node;
        String string2 = string;
        String string3 = this.retrieveRawXMIID(string);
        Element element = XMLManip.findElementByID((Branch)this.m_Doc, string3);
        if (element != null && (node = this.getLocationNode((Node)element)) != null) {
            String string4 = XMLManip.getAttributeValue(node, "href");
            string4 = string4 + "#id( '";
            string4 = string4 + string;
            string2 = string4 = string4 + "' )";
        }
        return string2;
    }

    private Node getLocationNode(Node node) {
        Element element = null;
        String string = XMLManip.getAttributeValue(node, "location");
        if (string != null && string.length() > 0) {
            element = XMLManip.findElementByID((Branch)this.m_Doc, string);
        }
        return element;
    }

    private class State {
        private State m_MemberState = null;
        private boolean m_RecreatingTypeFile = false;
        private IProject m_Project = null;

        public State(State state, IProject iProject, boolean bl) {
            this.m_Project = iProject;
            this.m_RecreatingTypeFile = bl;
            this.m_MemberState = this;
        }

        public String projectFileName() {
            String string = "";
            if (this.m_Project != null) {
                string = this.m_Project.getFileName();
            }
            return string;
        }

        public String projectID() {
            String string = "";
            if (this.m_Project != null) {
                string = this.m_Project.getXMIID();
            }
            return string;
        }

        public boolean reCreating() {
            return this.m_RecreatingTypeFile;
        }
    }

    private class ImportInfo {
        private String m_Href = "";
        private String m_ProjLocation = "";
        private String m_ProjectID = "";

        private ImportInfo() {
        }

        public boolean isImported() {
            return this.m_ProjectID != null && this.m_ProjectID.length() > 0;
        }
    }
}

