/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.support.umlutils;

import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.modules.uml.core.support.Debug;

public class XslTransformer {
    private static Map CACHE = new Hashtable();
    private String xslFileName;
    private Transformer transformer;

    public XslTransformer(String string) throws TransformerConfigurationException {
        this.xslFileName = string;
        TemplateWrapper templateWrapper = (TemplateWrapper)CACHE.get(string);
        if (templateWrapper == null || templateWrapper.isStale()) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Templates templates = transformerFactory.newTemplates(new StreamSource(this.xslFileName));
            templateWrapper = new TemplateWrapper(templates, this.xslFileName);
            CACHE.put(string, templateWrapper);
        }
        this.transformer = templateWrapper.getStylesheet().newTransformer();
    }

    public void transform(Source source, Result result) throws TransformerException {
        if (Debug.isEnabled()) {
            // empty if block
        }
        this.transformer.transform(source, result);
    }

    class TemplateWrapper {
        Templates stylesheet;
        File xslFile;
        long timestamp;

        TemplateWrapper(Templates templates, String string) {
            this.stylesheet = templates;
            this.xslFile = new File(string);
            this.timestamp = this.xslFile.lastModified();
        }

        private boolean isStale() {
            return this.xslFile.lastModified() != this.timestamp;
        }

        Templates getStylesheet() {
            return this.stylesheet;
        }
    }
}

