/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.support.umlmessagingcore;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IConfigManager;
import org.netbeans.modules.uml.core.support.umlmessagingcore.IMessageData;
import org.netbeans.modules.uml.core.support.umlmessagingcore.IMessageDataFilter;
import org.netbeans.modules.uml.core.support.umlmessagingcore.IMessageFacilityFilter;
import org.netbeans.modules.uml.core.support.umlmessagingcore.IMessageService;
import org.netbeans.modules.uml.core.support.umlmessagingcore.MessageFacilityFilter;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDataFilter
implements IMessageDataFilter {
    private IMessageService m_MessageService;
    private ETList<IMessageFacilityFilter> m_Filters = new ETArrayList<IMessageFacilityFilter>();
    private String m_FileLocation;

    @Override
    public void initialize(String string, IMessageService iMessageService) {
        this.m_FileLocation = string;
        this.m_MessageService = iMessageService;
        try {
            File file = new File(this.m_FileLocation);
            if (file != null) {
                String string2;
                IConfigManager iConfigManager;
                ICoreProduct iCoreProduct;
                if (!file.isAbsolute() && (iCoreProduct = ProductRetriever.retrieveProduct()) != null && (iConfigManager = iCoreProduct.getConfigManager()) != null && (string2 = iConfigManager.getHomeLocation()) != null && string2.length() > 0) {
                    String string3;
                    this.m_FileLocation = string3 = new File(string2, this.m_FileLocation).toString();
                }
                this.reRead();
                this.save();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public ETList<IMessageFacilityFilter> getFilters() {
        return this.m_Filters;
    }

    @Override
    public boolean getIsDisplayed(IMessageData iMessageData) {
        boolean bl = false;
        try {
            if (iMessageData != null) {
                String string = iMessageData.getFacility();
                int n = iMessageData.getMessageType();
                bl = this.getIsDisplayed(n, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    @Override
    public void setIsDisplayed(IMessageData iMessageData, boolean bl) {
        try {
            if (iMessageData != null) {
                String string = iMessageData.getFacility();
                int n = iMessageData.getMessageType();
                this.setIsDisplayed(n, string, bl);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean getIsDisplayed(int n, String string) {
        boolean bl;
        IMessageFacilityFilter iMessageFacilityFilter = this.getFilter(string);
        if (iMessageFacilityFilter != null) {
            bl = iMessageFacilityFilter.getIsDisplayed(n);
        } else {
            iMessageFacilityFilter = new MessageFacilityFilter();
            iMessageFacilityFilter.setName(string);
            this.m_Filters.add(iMessageFacilityFilter);
            bl = true;
        }
        return bl;
    }

    protected IMessageFacilityFilter getFilter(String string) {
        Iterator iterator;
        IMessageFacilityFilter iMessageFacilityFilter = null;
        if (this.m_Filters != null && string != null && (iterator = this.m_Filters.iterator()) != null) {
            while (iterator.hasNext()) {
                IMessageFacilityFilter iMessageFacilityFilter2 = (IMessageFacilityFilter)iterator.next();
                if (iMessageFacilityFilter2 == null || !string.equals(iMessageFacilityFilter2.getName())) continue;
                iMessageFacilityFilter = iMessageFacilityFilter2;
                break;
            }
        }
        return iMessageFacilityFilter;
    }

    @Override
    public void setIsDisplayed(int n, String string, boolean bl) {
        IMessageFacilityFilter iMessageFacilityFilter = this.getFilter(string);
        if (iMessageFacilityFilter != null) {
            iMessageFacilityFilter.setIsDisplayed(n, bl);
        } else {
            iMessageFacilityFilter = new MessageFacilityFilter();
            iMessageFacilityFilter.setName(string);
            iMessageFacilityFilter.setIsDisplayed(n, bl);
            this.m_Filters.add(iMessageFacilityFilter);
        }
    }

    @Override
    public void save() {
        Document document = XMLManip.getDOMDocument();
        Element element = XMLManip.createElement(document, "FACILITYFILTERS");
        Iterator iterator = this.m_Filters.iterator();
        if (iterator != null && element != null) {
            while (iterator.hasNext()) {
                Element element2;
                IMessageFacilityFilter iMessageFacilityFilter = (IMessageFacilityFilter)iterator.next();
                if (iMessageFacilityFilter == null || (element2 = XMLManip.createElement(element, "FACILITY")) == null) continue;
                XMLManip.setAttributeValue(element2, "NAME", iMessageFacilityFilter.getName());
                XMLManip.setAttributeValue(element2, "MT_CRITICAL", Boolean.toString(iMessageFacilityFilter.getIsDisplayed(0)));
                XMLManip.setAttributeValue(element2, "MT_ERROR", Boolean.toString(iMessageFacilityFilter.getIsDisplayed(1)));
                XMLManip.setAttributeValue(element2, "MT_WARNING", Boolean.toString(iMessageFacilityFilter.getIsDisplayed(2)));
                XMLManip.setAttributeValue(element2, "MT_INFO", Boolean.toString(iMessageFacilityFilter.getIsDisplayed(3)));
                XMLManip.setAttributeValue(element2, "MT_DEBUG", Boolean.toString(iMessageFacilityFilter.getIsDisplayed(4)));
            }
        }
        XMLManip.save(document, this.m_FileLocation);
    }

    @Override
    public void reRead() {
        Node node;
        Document document = XMLManip.getDOMDocument(this.m_FileLocation);
        if (document != null && (node = XMLManip.selectSingleNode((Node)document, "FACILITYFILTERS")) != null) {
            int n = 0;
            List list = XMLManip.selectNodeList(node, "FACILITY");
            if (list != null && (n = list.size()) > 0) {
                Node node2 = null;
                for (int i = 0; i < n; ++i) {
                    node2 = (Node)list.get(i);
                    if (node2 == null) continue;
                    MessageFacilityFilter messageFacilityFilter = new MessageFacilityFilter();
                    Node node3 = XMLManip.getAttribute(node2, "NAME");
                    messageFacilityFilter.setName(node3 != null ? node3.getText() : null);
                    boolean bl = node3 != null ? Boolean.valueOf(node3.getText()) : false;
                    node3 = XMLManip.getAttribute(node2, "MT_CRITICAL");
                    messageFacilityFilter.setIsDisplayed(0, node3 != null ? bl : false);
                    node3 = XMLManip.getAttribute(node2, "MT_ERROR");
                    messageFacilityFilter.setIsDisplayed(1, node3 != null ? bl : false);
                    node3 = XMLManip.getAttribute(node2, "MT_WARNING");
                    messageFacilityFilter.setIsDisplayed(2, node3 != null ? bl : false);
                    node3 = XMLManip.getAttribute(node2, "MT_INFO");
                    messageFacilityFilter.setIsDisplayed(3, node3 != null ? bl : false);
                    node3 = XMLManip.getAttribute(node2, "MT_DEBUG");
                    messageFacilityFilter.setIsDisplayed(4, node3 != null ? bl : false);
                    this.m_Filters.add(messageFacilityFilter);
                }
            }
        }
    }
}

