/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.generativeframework.IExpansionVariable;
import org.netbeans.modules.uml.core.generativeframework.ITemplateManager;
import org.netbeans.modules.uml.core.generativeframework.IVariableFactory;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IConfigManager;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.CodeGenerationScript;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.CollectionType;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ICodeGenerationScript;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ILanguage;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ILanguageDataType;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ILanguageFilter;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ILanguageManager;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ILanguageParser;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ISyntaxToken;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.Language;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.LanguageDataType;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.LanguageFilter;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.LanguageSyntax;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.SyntaxToken;
import org.netbeans.modules.uml.core.support.umlsupport.IStrings;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlsupport.Strings;
import org.netbeans.modules.uml.core.support.umlsupport.URILocator;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageManager
implements ILanguageManager {
    private String m_ConfigLocation = "";
    private Hashtable<String, ILanguage> m_LanguageMap = new Hashtable();
    private IStrings m_LanguageNames = null;
    private Hashtable<String, String> m_ExtensionMap = new Hashtable();
    private Hashtable<String, ETList<ILanguageFilter>> m_FilterMap = new Hashtable();

    public LanguageManager() {
        this.initializeManager();
    }

    @Override
    public String retrieveContextForFile(String string, String string2) {
        String string3 = "";
        try {
            String string4 = this.getLanguageNameForFile(string);
            if (string4 != null && string4.length() > 0) {
                string3 = this.retrieveContextForLanguage(string4, string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    @Override
    public String getConfigLocation() {
        String string = "";
        try {
            if (this.m_ConfigLocation.length() == 0) {
                this.m_ConfigLocation = this.getConfigHome();
            }
            string = this.m_ConfigLocation;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public void setConfigLocation(String string) {
        this.m_ExtensionMap.clear();
        this.m_LanguageMap.clear();
        this.m_LanguageNames = null;
        this.m_ConfigLocation = string;
        this.initializeManager();
    }

    @Override
    public String retrieveContextForLanguage(String string, String string2) {
        String string3 = null;
        try {
            ILanguage iLanguage = this.getLanguage(string);
            if (iLanguage != null) {
                string3 = iLanguage.getContextCLSID(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    @Override
    public ILanguage getLanguage(String string) {
        ILanguage iLanguage = null;
        try {
            iLanguage = this.m_LanguageMap.size() > 0 ? (this.m_LanguageMap.containsKey(string) ? this.m_LanguageMap.get(string) : this.retrieveLanguage(string)) : this.retrieveLanguage(string);
            if (iLanguage == null) {
                Log.out("LM_E_INVALID_LANG_NAME");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iLanguage;
    }

    @Override
    public ILanguageParser retrieveParserForLanguage(String string, String string2) {
        ILanguageParser iLanguageParser = null;
        ILanguage iLanguage = this.getLanguage(string);
        if (iLanguage != null) {
            iLanguageParser = iLanguage.getParser(string2);
        }
        return iLanguageParser;
    }

    @Override
    public ILanguageParser getParserForFile(String string, String string2) {
        ILanguageParser iLanguageParser = null;
        String string3 = this.getLanguageNameForFile(string);
        if (string3 != null && string3.length() > 0) {
            iLanguageParser = this.retrieveParserForLanguage(string3, string2);
        }
        return iLanguageParser;
    }

    @Override
    public IStrings getSupportedLanguages() {
        return this.m_LanguageNames;
    }

    @Override
    public ILanguage getLanguageForFile(String string) {
        ILanguage iLanguage = null;
        String string2 = this.getLanguageNameForFile(string);
        if (string2 != null && string2.length() > 0) {
            iLanguage = this.getLanguage(string2);
        } else {
            Log.out("LM_E_INVALID_LANG_NAME");
        }
        return iLanguage;
    }

    @Override
    public ETList<ILanguage> getSupportedLanguages2() {
        ETArrayList eTArrayList = null;
        IStrings iStrings = this.getSupportedLanguages();
        if (iStrings != null) {
            int n = iStrings.getCount();
            eTArrayList = new ETArrayList();
            for (int i = 0; i < n; ++i) {
                String string = iStrings.item(i);
                ILanguage iLanguage = this.getLanguage(string);
                if (iLanguage == null) continue;
                eTArrayList.add(iLanguage);
            }
        }
        return eTArrayList;
    }

    @Override
    public ILanguageDataType getAttributeDefaultType(Object object) {
        ILanguageDataType iLanguageDataType = null;
        if (object != null && object instanceof IElement) {
            ILanguage iLanguage;
            IElement iElement = (IElement)object;
            ETList<ILanguage> eTList = iElement.getLanguages();
            if (eTList != null) {
                int n = eTList.size();
                for (int i = 0; i < n && iLanguageDataType == null; ++i) {
                    ILanguage iLanguage2 = (ILanguage)eTList.get(i);
                    iLanguageDataType = this.getAttributeDefaultType(iLanguage2);
                }
            } else {
                ILanguage iLanguage3 = this.getDefaultLanguage(iElement);
                if (iLanguage3 != null) {
                    iLanguageDataType = this.getAttributeDefaultType(iLanguage3);
                }
            }
            if (iLanguageDataType == null && (iLanguage = this.getLanguage("UML")) != null) {
                iLanguageDataType = this.getAttributeDefaultType(iLanguage);
            }
        }
        return iLanguageDataType;
    }

    private ILanguageDataType getAttributeDefaultType(ILanguage iLanguage) {
        ILanguageDataType iLanguageDataType = iLanguage.getAttributeDefaultType();
        return iLanguageDataType;
    }

    @Override
    public ILanguageDataType getOperationDefaultType(Object object) {
        ILanguageDataType iLanguageDataType = null;
        if (object != null && object instanceof IElement) {
            ILanguage iLanguage;
            IElement iElement = (IElement)object;
            ETList<ILanguage> eTList = iElement.getLanguages();
            if (eTList != null) {
                int n = eTList.size();
                for (int i = 0; i < n && iLanguageDataType == null; ++i) {
                    ILanguage iLanguage2 = (ILanguage)eTList.get(i);
                    iLanguageDataType = this.getOperationDefaultType(iLanguage2);
                }
            } else {
                ILanguage iLanguage3 = this.getDefaultLanguage(iElement);
                if (iLanguage3 != null) {
                    iLanguageDataType = this.getOperationDefaultType(iLanguage3);
                }
            }
            if (iLanguageDataType == null && (iLanguage = this.getLanguage("UML")) != null) {
                iLanguageDataType = this.getOperationDefaultType(iLanguage);
            }
        }
        return iLanguageDataType;
    }

    private ILanguageDataType getOperationDefaultType(ILanguage iLanguage) {
        ILanguageDataType iLanguageDataType = iLanguage.getOperationDefaultType();
        return iLanguageDataType;
    }

    @Override
    public ILanguage getDefaultLanguage(Object object) {
        IElement iElement;
        IProject iProject;
        ILanguage iLanguage = null;
        if (object != null && object instanceof IElement && (iProject = (iElement = (IElement)object).getProject()) != null) {
            String string = iProject.getDefaultLanguage();
            iLanguage = this.getLanguage(string);
        }
        return iLanguage;
    }

    @Override
    public IStrings getFileExtensionsForLanguage(String string) {
        Strings strings = new Strings();
        Enumeration<String> enumeration = this.m_ExtensionMap.elements();
        Enumeration<String> enumeration2 = this.m_ExtensionMap.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration2.nextElement();
            String string3 = enumeration.nextElement();
            if (!string.equals(string3)) continue;
            strings.add(string2);
        }
        return strings;
    }

    @Override
    public IStrings getFileExtensionsForLanguage(ILanguage iLanguage) {
        IStrings iStrings = null;
        if (iLanguage != null) {
            String string = iLanguage.getName();
            iStrings = this.getFileExtensionsForLanguage(string);
        }
        return iStrings;
    }

    @Override
    public String getSupportedLanguagesAsString() {
        String string = "";
        IStrings iStrings = this.getSupportedLanguages();
        if (iStrings != null) {
            int n = iStrings.getCount();
            String string2 = "|";
            for (int i = 0; i < n; ++i) {
                String string3 = iStrings.item(i);
                if (string3.length() <= 0) continue;
                if (string.length() > 0) {
                    string = string + string2;
                }
                string = string + string3;
            }
        }
        return string;
    }

    @Override
    public String getDefaultForLanguage(String string, String string2) {
        String string3 = "";
        ILanguage iLanguage = this.getLanguage(string);
        if (iLanguage != null) {
            string3 = iLanguage.getDefault(string2);
        }
        return string3;
    }

    @Override
    public String getDefaultSourceFileExtensionForLanguage(String string) {
        String string2 = "";
        ILanguage iLanguage = this.getLanguage(string);
        if (iLanguage != null) {
            string2 = iLanguage.getDefaultSourceFileExtension();
        }
        return string2;
    }

    @Override
    public ETList<ILanguage> getLanguagesWithCodeGenSupport() {
        ETArrayList eTArrayList = null;
        ETList<ILanguage> eTList = this.getSupportedLanguages2();
        if (eTList != null) {
            int n = eTList.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                ILanguage iLanguage = (ILanguage)eTList.get(i);
                ETList<ICodeGenerationScript> eTList2 = iLanguage.getCodeGenerationScripts();
                if (eTList2 == null || (n2 = eTList2.size()) <= 0) continue;
                if (eTArrayList == null) {
                    eTArrayList = new ETArrayList();
                }
                eTArrayList.add(iLanguage);
            }
        }
        return eTArrayList;
    }

    @Override
    public ETList<ILanguageFilter> getFileExtensionFilters(String string) {
        ETList<ILanguageFilter> eTList = new ETArrayList<ILanguageFilter>();
        Enumeration<String> enumeration = this.m_FilterMap.keys();
        while (enumeration.hasMoreElements()) {
            ETList<ILanguageFilter> eTList2;
            String string2 = enumeration.nextElement();
            if (!string.equals(string2) || (eTList2 = this.m_FilterMap.get(string2)) == null) continue;
            eTList = eTList2;
        }
        return eTList;
    }

    @Override
    public ETList<ILanguageFilter> getFileExtensionFilters(ILanguage iLanguage) {
        ETList<ILanguageFilter> eTList = new ETArrayList<ILanguageFilter>();
        if (iLanguage != null) {
            String string = iLanguage.getName();
            eTList = this.getFileExtensionFilters(string);
        }
        return eTList;
    }

    private void initializeManager() {
        try {
            Document document;
            String string = this.getActualConfigLocation();
            if (string != null && string.length() > 0 && (document = XMLManip.getDOMDocument(string)) != null) {
                this.loadSupportedLanguages(document);
                this.loadFileExtensions(document);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getActualConfigLocation() {
        String string = "";
        String string2 = this.getConfigLocation();
        if (string2 != null && string2.length() > 0) {
            string = string2 = string2 + "Languages.etc";
        }
        return string;
    }

    private ILanguage retrieveLanguage(String string) {
        ILanguage iLanguage = null;
        Node node = this.retrieveLanguageNode(string);
        if (node != null) {
            iLanguage = this.retrieveLanguageDetails(node);
            if (iLanguage != null) {
                this.m_LanguageMap.put(string, iLanguage);
            } else {
                Log.out("LM_E_INVALID_LANG_NAME");
            }
        }
        return iLanguage;
    }

    private Node retrieveLanguageNode(String string) {
        Document document;
        Node node = null;
        Document document2 = this.getConfigurationDocument();
        if (document2 != null && (node = this.findLanguage(document2, string)) == null && (document = this.locateReferenced(document2, string)) != null) {
            node = this.findLanguage(document, string);
        }
        return node;
    }

    private Node findLanguage(Document document, String string) {
        Node node = null;
        String string2 = "//Language[@type=\"";
        string2 = string2 + this.findLanguageName(string);
        string2 = string2 + "\"]";
        node = document.selectSingleNode(string2);
        return node;
    }

    private String findLanguageName(String string) {
        String string2 = string;
        int n = this.m_LanguageNames.getCount();
        for (int i = 0; i < n; ++i) {
            String string3 = this.m_LanguageNames.item(i);
            if (string3.length() <= 0 || !string3.toLowerCase().equals(string.toLowerCase())) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    private Document locateReferenced(Document document, String string) {
        Document document2 = null;
        String string2 = "//LanguageRef[@type=\"";
        string2 = string2 + this.findLanguageName(string);
        Node node = document.selectSingleNode(string2 = string2 + "\"]");
        if (node != null) {
            String string3 = XMLManip.getAttributeValue(node, "location");
            String string4 = this.getConfigLocation();
            if (string4 != null && string4.length() > 0) {
                String string5 = string4;
                if (string3 != null) {
                    string5 = string5 + string3;
                }
                if (string5 != null && string5.length() > 0) {
                    document2 = URILocator.retrieveDocument(string5);
                }
            }
        }
        return document2;
    }

    private Document getConfigurationDocument() {
        Document document = null;
        String string = this.getActualConfigLocation();
        if (string != null && string.length() > 0) {
            document = XMLManip.getDOMDocument(string);
        }
        return document;
    }

    private ILanguage retrieveLanguageDetails(Node node) {
        Language language = new Language();
        this.getLanguageName(node, language);
        this.getDataTypes(node, language);
        this.getLanguageSyntax(node, language);
        this.getCodeGenScripts(node, language);
        this.getExpansionOverrides(node, language);
        this.getParsers(node, language);
        this.getContexts(node, language);
        this.getLibraries(node, language);
        this.getFormatDefinitions(node, language);
        this.getDefaults(node, language);
        this.getSupportedFeatures(node, language);
        this.getCollectionTypes(node, language);
        return language;
    }

    private void getLanguageSyntax(Node node, ILanguage iLanguage) {
        ETArrayList<ISyntaxToken> eTArrayList = new ETArrayList<ISyntaxToken>();
        List list = node.selectNodes("Syntax/Token");
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Node node2 = (Node)list.get(i);
                ISyntaxToken iSyntaxToken = this.getSyntaxToken(node2);
                if (iSyntaxToken == null) continue;
                eTArrayList.add(iSyntaxToken);
            }
        }
        LanguageSyntax languageSyntax = new LanguageSyntax();
        languageSyntax.setSyntaxTokens(eTArrayList);
        iLanguage.setSyntax(languageSyntax);
    }

    private ISyntaxToken getSyntaxToken(Node node) {
        SyntaxToken syntaxToken = new SyntaxToken();
        String string = XMLManip.getAttributeValue(node, "name");
        syntaxToken.setName(string);
        String string2 = XMLManip.getAttributeValue(node, "kind");
        int n = 0;
        if (string2 != null && string2.equals("Operator")) {
            n = 1;
        } else if (string2 != null && string2.equals("Delimiter")) {
            n = 2;
        }
        syntaxToken.setKind(n);
        String string3 = XMLManip.getAttributeValue(node, "category");
        syntaxToken.setCategory(string3);
        String string4 = XMLManip.getAttributeValue(node, "type");
        syntaxToken.setType(string4);
        return syntaxToken;
    }

    private void getCodeGenScripts(Node node, ILanguage iLanguage) {
        String string;
        ETArrayList<ICodeGenerationScript> eTArrayList = new ETArrayList<ICodeGenerationScript>();
        List list = node.selectNodes("CodeGeneration/Script");
        if (list != null && (string = this.getConfigLocation()) != null && string.length() > 0) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Node node2 = (Node)list.get(i);
                ICodeGenerationScript iCodeGenerationScript = this.getScript(node2, string);
                if (iCodeGenerationScript == null) continue;
                iCodeGenerationScript.setLanguage(iLanguage);
                eTArrayList.add(iCodeGenerationScript);
            }
        }
        iLanguage.setCodeGenerationScripts(eTArrayList);
    }

    private ICodeGenerationScript getScript(Node node, String string) {
        CodeGenerationScript codeGenerationScript = new CodeGenerationScript();
        String string2 = XMLManip.getAttributeValue(node, "event");
        codeGenerationScript.setName(string2);
        String string3 = XMLManip.getAttributeValue(node, "location");
        String string4 = string + string3;
        codeGenerationScript.setFile(string4);
        return codeGenerationScript;
    }

    private void getExpansionOverrides(Node node, ILanguage iLanguage) {
        IVariableFactory iVariableFactory;
        ITemplateManager iTemplateManager;
        ICoreProduct iCoreProduct;
        int n;
        String string;
        List list = node.selectNodes("ExpansionVariables/ExpansionVar");
        if (list != null && (string = this.getConfigLocation()) != null && string.length() > 0 && (n = list.size()) > 0 && (iCoreProduct = ProductRetriever.retrieveProduct()) != null && (iTemplateManager = iCoreProduct.getTemplateManager()) != null && (iVariableFactory = iTemplateManager.getFactory()) != null) {
            ETArrayList<IExpansionVariable> eTArrayList = new ETArrayList<IExpansionVariable>();
            for (int i = 0; i < n; ++i) {
                Node node2 = (Node)list.get(i);
                IExpansionVariable iExpansionVariable = iVariableFactory.createVariable(node2);
                if (iExpansionVariable == null) continue;
                eTArrayList.add(iExpansionVariable);
            }
            iLanguage.setExpansionVariables(eTArrayList);
        }
    }

    private String getConfigHome() {
        IConfigManager iConfigManager;
        String string = "";
        ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
        if (iCoreProduct != null && (iConfigManager = iCoreProduct.getConfigManager()) != null) {
            string = iConfigManager.getDefaultConfigLocation();
        }
        return string;
    }

    private void getParsers(Node node, ILanguage iLanguage) {
        List list = node.selectNodes("Parsers/Parser");
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Node node2 = (Node)list.get(i);
                String string = XMLManip.getAttributeValue(node2, "name");
                String string2 = XMLManip.getAttributeValue(node2, "parser");
                iLanguage.addParser(string, string2);
            }
        }
    }

    private void getContexts(Node node, ILanguage iLanguage) {
        List list = node.selectNodes("Contexts/Context");
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Node node2 = (Node)list.get(i);
                String string = XMLManip.getAttributeValue(node2, "kind");
                String string2 = XMLManip.getAttributeValue(node2, "instantiationDirective");
                iLanguage.addContext(string, string2);
            }
        }
    }

    private void getLibraries(Node node, ILanguage iLanguage) {
        List list = node.selectNodes("Libraries/Library");
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Node node2 = (Node)list.get(i);
                String string = XMLManip.getAttributeValue(node2, "name");
                String string2 = XMLManip.getAttributeValue(node2, "path");
                String string3 = null;
                if (string2 != null && string2.length() > 0) {
                    if (string2.indexOf("\\") != -1) {
                        string3 = "\\";
                    } else if (string2.indexOf("/") != -1) {
                        string3 = "/";
                    }
                    if (string3 != null) {
                        string2 = string2.replace(string3, File.separator).trim();
                    }
                }
                String string4 = "modules" + File.separator + string2 + ".etd";
                String string5 = InstalledFileLocator.getDefault().locate(string4, "org.netbeans.modules.uml", false).getAbsolutePath();
                iLanguage.addLibrary(string, string5.substring(0, string5.length() - 4));
            }
        }
    }

    private void getFormatDefinitions(Node node, ILanguage iLanguage) {
        Node node2 = node.selectSingleNode("FormatDefinitions/PropertyDefinitions");
        if (node2 != null) {
            iLanguage.setFormatDefinitions(node2);
        }
    }

    private void loadSupportedLanguages(Document document) {
        if (this.m_LanguageNames == null) {
            this.m_LanguageNames = new Strings();
            this.retrieveLanguagesNames(document, "//Language", this.m_LanguageNames);
            this.retrieveLanguagesNames(document, "//LanguageRef", this.m_LanguageNames);
        }
    }

    private void retrieveLanguagesNames(Document document, String string, IStrings iStrings) {
        List list = document.selectNodes(string);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Node node = (Node)list.get(i);
                String string2 = XMLManip.getAttributeValue(node, "type");
                if (string2 == null || string2.length() <= 0) continue;
                iStrings.add(string2);
            }
        }
    }

    private void loadFileExtensions(Document document) {
        String string;
        String string2;
        int n;
        List list = document.selectNodes("//Extensions/Extension");
        if (list != null) {
            int n2 = list.size();
            for (n = 0; n < n2; ++n) {
                Node node = (Node)list.get(n);
                string2 = XMLManip.getAttributeValue(node, "type");
                string = XMLManip.getAttributeValue(node, "language");
                if (string2 == null || string2.length() <= 0) continue;
                this.m_ExtensionMap.put(string2, string);
            }
        }
        this.m_FilterMap.clear();
        List list2 = document.selectNodes("//Extensions/Filter");
        if (list2 != null) {
            n = list2.size();
            for (int i = 0; i < n; ++i) {
                string2 = (Node)list2.get(i);
                string = XMLManip.getAttributeValue((Node)string2, "name");
                String string3 = XMLManip.getAttributeValue((Node)string2, "language");
                String string4 = XMLManip.getAttributeValue((Node)string2, "value");
                ETList<Object> eTList = null;
                if (this.m_FilterMap.containsKey(string3)) {
                    eTList = this.m_FilterMap.get(string3);
                } else {
                    eTList = new ETArrayList();
                    this.m_FilterMap.put(string3, eTList);
                }
                LanguageFilter languageFilter = new LanguageFilter();
                languageFilter.setName(string);
                languageFilter.setFilter(string4);
                eTList.add(languageFilter);
            }
        }
    }

    private String getLanguageNameForFile(String string) {
        String string2 = "";
        String string3 = StringUtilities.getExtension(string);
        string2 = this.m_ExtensionMap.get(string3);
        return string2;
    }

    private void getDefaults(Node node, ILanguage iLanguage) {
        List list = node.selectNodes("Defaults/Default");
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Node node2 = (Node)list.get(i);
                String string = XMLManip.getAttributeValue(node2, "name");
                String string2 = XMLManip.getAttributeValue(node2, "value");
                iLanguage.setDefault(string, string2);
            }
        }
    }

    private void getSupportedFeatures(Node node, ILanguage iLanguage) {
        List list = node.selectNodes("SupportedFeatures/Feature");
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Node node2 = (Node)list.get(i);
                String string = XMLManip.getAttributeValue(node2, "name");
                String string2 = XMLManip.getAttributeValue(node2, "value");
                boolean bl = false;
                if (string2 != null && string2.toLowerCase().equals("true")) {
                    bl = true;
                }
                iLanguage.setFeatureSupported(string, bl);
            }
        }
    }

    private void getLanguageName(Node node, ILanguage iLanguage) {
        String string = XMLManip.getAttributeValue(node, "type");
        iLanguage.setName(string);
    }

    private void getCollectionTypes(Node node, ILanguage iLanguage) {
        String string = "Collections/Collection";
        ETArrayList<CollectionType> eTArrayList = new ETArrayList<CollectionType>();
        List list = node.selectNodes(string);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Node node2 = (Node)list.get(i);
                CollectionType collectionType = this.getCollectionType(node2);
                if (collectionType == null) continue;
                eTArrayList.add(collectionType);
            }
        }
        iLanguage.setCollectionTypes(eTArrayList);
    }

    private CollectionType getCollectionType(Node node) {
        CollectionType collectionType = new CollectionType();
        String string = XMLManip.getAttributeValue(node, "name");
        collectionType.setName(string);
        String string2 = XMLManip.getAttributeValue(node, "package");
        collectionType.setPackageName(string2);
        boolean bl = XMLManip.getAttributeBooleanValue(node, "userdefined");
        collectionType.setUserDefined(bl);
        boolean bl2 = XMLManip.getAttributeBooleanValue(node, "default", false);
        collectionType.setDefaultType(bl2);
        return collectionType;
    }

    private void getDataTypes(Node node, ILanguage iLanguage) {
        String string = "DataTypes/DataType";
        ETArrayList<ILanguageDataType> eTArrayList = new ETArrayList<ILanguageDataType>();
        List list = node.selectNodes(string);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                boolean bl;
                Node node2 = (Node)list.get(i);
                ILanguageDataType iLanguageDataType = this.getDataType(node2);
                if (iLanguageDataType == null) continue;
                eTArrayList.add(iLanguageDataType);
                boolean bl2 = iLanguageDataType.getIsDefaultAttributeType();
                if (bl2) {
                    iLanguage.setAttributeDefaultType(iLanguageDataType);
                }
                if (!(bl = iLanguageDataType.getIsOperationDefaultType())) continue;
                iLanguage.setOperationDefaultType(iLanguageDataType);
            }
        }
        iLanguage.setDataTypes(eTArrayList);
    }

    private ILanguageDataType getDataType(Node node) {
        String string;
        LanguageDataType languageDataType = new LanguageDataType();
        String string2 = XMLManip.getAttributeValue(node, "name");
        languageDataType.setName(string2);
        String string3 = XMLManip.getAttributeValue(node, "type");
        int n = 0;
        if (string3 != null && string3.equals("user-defined")) {
            n = 1;
        } else {
            string = XMLManip.getAttributeValue(node, "uml");
            if (string != null && string.length() > 0) {
                languageDataType.setUMLName(string);
            }
        }
        languageDataType.setKind(n);
        string = XMLManip.getAttributeValue(node, "default_value");
        languageDataType.setDefaultValue(string);
        String string4 = XMLManip.getAttributeValue(node, "scope");
        languageDataType.setScope(string4);
        boolean bl = XMLManip.getAttributeBooleanValue(node, "attributedefault");
        languageDataType.setIsDefaultAttributeType(bl);
        boolean bl2 = XMLManip.getAttributeBooleanValue(node, "operationdefault");
        languageDataType.setIsOperationDefaultType(bl2);
        return languageDataType;
    }
}

