/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.translation.statehandlers;

import org.dom4j.Node;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.IUMLParserEventDispatcher;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.translation.statehandlers.AttributeStateHandler;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.translation.statehandlers.OpReturnStateHandler;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.translation.statehandlers.ParameterStateHandler;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.translation.statehandlers.StateHandler;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.translation.statehandlers.ThrowsDeclarationStateHandler;
import org.netbeans.modules.uml.core.reverseengineering.parsingfacilities.translation.statehandlers.TypeElementStateHandler;
import org.netbeans.modules.uml.core.reverseengineering.reframework.OperationEvent;
import org.netbeans.modules.uml.core.reverseengineering.reframework.parsingframework.ITokenDescriptor;

public class OperationStateHandler
extends AttributeStateHandler {
    private int m_Kind;
    private boolean m_ForceAbstract;
    public static final int CONSTRUCTOR = 0;
    public static final int DESTRUCTOR = 1;
    public static final int OPERATION = 2;
    public static final int PROPERTY_GET = 3;
    public static final int PROPERTY_SET = 4;

    public OperationStateHandler(String string, String string2, int n, boolean bl) {
        super(string, string2);
        this.m_Kind = n;
        this.m_ForceAbstract = bl;
    }

    public OperationStateHandler(String string, String string2, int n) {
        this(string, string2, n, false);
    }

    public StateHandler createSubStateHandler(String string, String string2) {
        Node node;
        StateHandler stateHandler = null;
        if ("Parameters".equals(string) || "Method Body".equals(string) || "Constructor Body".equals(string)) {
            stateHandler = this;
        } else if ("Parameter".equals(string)) {
            stateHandler = new ParameterStateHandler("");
        } else if ("Type".equals(string)) {
            stateHandler = new OpReturnStateHandler(string2, "Type");
            if (stateHandler != null) {
                ((TypeElementStateHandler)stateHandler).setTypeState(true);
            }
        } else if ("Throws Declaration".equals(string)) {
            stateHandler = new ThrowsDeclarationStateHandler();
        } else if ("Class Declaration".equals(string)) {
            // empty if block
        }
        if (stateHandler == null) {
            stateHandler = super.createSubStateHandler(string, string2);
        } else if (stateHandler != null && stateHandler != this && (node = this.getDOMNode()) != null) {
            stateHandler.setDOMNode(node);
        }
        return stateHandler;
    }

    public String getFeatureName() {
        return "UML:Operation";
    }

    public void initialize() {
        super.initialize();
        this.setNodeAttribute("isAbstract", this.isForceAbstract());
        if (this.getOperationKind() == 0) {
            this.setNodeAttribute("isConstructor", true);
        } else if (this.getOperationKind() == 1) {
            this.setNodeAttribute("isDestructor", true);
        } else if (this.getOperationKind() == 3) {
            this.setNodeAttribute("isProperty", true);
            this.setNodeAttribute("isQuery", true);
        } else if (this.getOperationKind() == 4) {
            this.setNodeAttribute("isProperty", true);
            this.setNodeAttribute("isQuery", false);
        }
    }

    public boolean isForceAbstract() {
        return this.m_ForceAbstract;
    }

    public void processToken(ITokenDescriptor iTokenDescriptor, String string) {
        if (iTokenDescriptor == null) {
            return;
        }
        String string2 = iTokenDescriptor.getType();
        String string3 = iTokenDescriptor.getValue();
        if ("Method Body End".equals(string2) || "Statement Terminator".equals(string2)) {
            this.handleEndPostion(iTokenDescriptor);
        }
        if ("Method Body Start".equals(string2)) {
            this.handleBodyStart(iTokenDescriptor);
        }
        if ("Parameter End".equals(string2)) {
            long l = iTokenDescriptor.getLine();
            long l2 = iTokenDescriptor.getColumn();
            long l3 = iTokenDescriptor.getPosition();
            this.createTokenDescriptor("OpHeadEndPosition", l, l2, l3 + 1L, "", 0L);
        }
        if ("Is Query".equals(string2)) {
            this.setNodeAttribute("isQuery", string3);
        }
        if (string2.equals("Keyword") && string3.equals("Property")) {
            this.setNodeAttribute("isProperty", "true");
        }
        if ("Is Virtual".equals(string2)) {
            this.setNodeAttribute("isVirtual", string3);
        } else {
            TypeElementStateHandler.processToken(this, iTokenDescriptor, string);
        }
    }

    public void stateComplete(String string) {
        if (string.equals(this.getStateName())) {
            this.sendOnOperationFoundEvent();
        }
        super.stateComplete(string);
    }

    protected boolean isAbstractModifier(String string) {
        return "abstract".equals(string);
    }

    protected int getOperationKind() {
        return this.m_Kind;
    }

    protected void updateType() {
    }

    protected void sendOnOperationFoundEvent() {
        Node node;
        OperationEvent operationEvent = new OperationEvent();
        if (operationEvent != null && (node = this.getDOMNode()) != null) {
            operationEvent.setEventData(node);
            IUMLParserEventDispatcher iUMLParserEventDispatcher = this.getEventDispatcher();
            if (iUMLParserEventDispatcher != null) {
                iUMLParserEventDispatcher.fireOperationFound(operationEvent, null);
            }
        }
    }
}

